/* iod-telemetry RsrcMgrMetric.sql version 2022.01.12 csierra */
/* Notes:
*/
WITH
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric as (
        SELECT
        'RsrcMgrMetric.'||metric_name AS metric_name
            ,',"con_name":"'     || nvl(to_char(con_name    ),'null') || '"' AS metric_dimensions
            ,round(metric_value,1) AS metric_value
        FROM (
        SELECT /*+ MATERIALIZE NO_MERGE */
            c.name AS con_name, 
            r.con_id, 
            r.running_sessions_limit AS "RunningSessionsLimit", 
            r.avg_running_sessions AS "AvgRunningSessions", 
            NVL(ROUND(100 * r.avg_running_sessions / NULLIF(r.running_sessions_limit, 0), 1), 0) AS "CPUAllottedUtilPerc", 
            r.avg_waiting_sessions AS "AvgWaitingSessions", 
            GREATEST(r.running_sessions_limit - r.avg_running_sessions - r.avg_waiting_sessions, 0) AS "AvailHeadroomSessions",
            r.io_requests / (r.end_time - r.begin_time) / 24 / 3600 AS "IOPS",
            r.io_megabytes / (r.end_time - r.begin_time) / 24 / 3600 AS "MBPS"
        FROM v$rsrcmgrmetric r, v$containers c
        WHERE r.consumer_group_name = 'OTHER_GROUPS'
        AND r.end_time - r.begin_time > 0
        AND c.con_id = r.con_id
        AND ROWNUM >= 1 /* MATERIALIZE */
        ) UNPIVOT (metric_value FOR metric_name IN ("RunningSessionsLimit", "AvgRunningSessions", "CPUAllottedUtilPerc", "AvgWaitingSessions", "AvailHeadroomSessions", "IOPS", "MBPS"))
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
