create or replace PROCEDURE get_Schema(oName in varchar) IS
h1      NUMBER;         -- handle returned by OPEN for tables
TH     NUMBER;         -- handle returned by ADD_TRANSFORM for tables
doc     sys.ku$_ddls;   -- metadata is returned in sys.ku$_ddls,
                        --  a nested table of sys.ku$_ddl objects
ddl     CLOB;           -- creation DDL for an object
pi      sys.ku$_parsed_items;   -- parse items are returned in this object
                                -- which is contained in sys.ku$_ddl
objname VARCHAR2(300);   -- the parsed object name
objtype VARCHAR2(300);   -- the parsed object name
idxddls sys.ku$_ddls;   -- metadata is returned in sys.ku$_ddls,
idxname VARCHAR2(30);   --  a nested table of sys.ku$_ddl objects
seq number := 1;
FUNCTION ifelse (bool_in IN number) 
   RETURN boolean 
 IS 
     BEGIN 
       IF bool_in = 0 
       THEN 
         RETURN FALSE; 
      ELSE 
         RETURN TRUE; 
      END IF; 
     END; 

BEGIN
 delete my_metadata;
--  INSERT INTO my_metadata(seq, object_type, name, md)
--       VALUES (0,'START',null,null);
 commit;
  h1 := DBMS_METADATA.OPEN('SCHEMA_EXPORT');
 DBMS_METADATA.SET_FILTER(h1,'SCHEMA',USER);

-- set exclusion filters
-- INDEX
 DBMS_METADATA.SET_FILTER(h1, 'NAME_EXPR', 'NOT in (select constraint_name from user_constraints where constraint_type=''P'')' ,'INDEX');
 DBMS_METADATA.SET_FILTER(h1, 'NAME_EXPR', 'NOT LIKE ''%I_SNAP%''','INDEX' );
 DBMS_METADATA.SET_FILTER(h1, 'NAME_EXPR', 'NOT LIKE ''%C_SNAP%''' ,'INDEX');
 DBMS_METADATA.SET_FILTER(h1, 'NAME_EXPR', 'NOT LIKE ''%I_MLOG%''','INDEX' );
 DBMS_METADATA.SET_FILTER(h1, 'NAME_EXPR', 'NOT LIKE ''SYS_FBA%''' ,'INDEX');
 --DBMS_METADATA.SET_FILTER(h1, 'SYSTEM_GENERATED', FALSE ,'INDEX');
--VIEW
 DBMS_METADATA.SET_FILTER(h1, 'NAME_EXPR', '!=''DATABASECHANGELOG_DETAILS''','VIEW' );
--TABLE
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR','!=''MY_METADATA''','TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', 'NOT LIKE ''MLOG/Library/Java/JavaVirtualMachines/jdk1.8.0_311.jdk/Contents/Home/bin/java%''' ,'TABLE'); 
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', 'not in (select mview_name from user_mviews)' ,'TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''DATABASECHANGELOG_EXPORT''' ,'TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''EXP_SORT''' ,'TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''EXP_LOAD''' ,'TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''EXP_PROCESS''' ,'TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''EXP_CLEANUP''' ,'TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''DATABASECHANGELOG''' ,'TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''DATABASECHANGELOGLOCK''' ,'TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''DATABASECHANGELOG_ACTIONS''' ,'TABLE');
 DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''SYS_FBA%''' ,'TABLE');
-- PACKAGE SPEC
DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''SQLCL_LB_CAPTURE''' , 'PACKAGE_SPEC');
-- PACKAGE BODY
DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''SQLCL_LB_CAPTURE''' ,'PACKAGE_BODY');
-- TRIGGER
DBMS_METADATA.SET_FILTER( h1, 'NAME_EXPR', '!=''DATABASECHANGELOG_ACTIONS_TRG''' ,'TRIGGER');

 -- PARSE ITEMS
 DBMS_METADATA.SET_PARSE_ITEM(h1,'NAME');
 DBMS_METADATA.SET_PARSE_ITEM(h1,'OBJECT_TYPE');

-- Request that the metadata be transformed into creation DDL.
 TH := DBMS_METADATA.ADD_TRANSFORM(h1,'DDL');
 DBMS_METADATA.SET_TRANSFORM_PARAM( TH, 'PRETTY', TRUE );
 DBMS_METADATA.SET_TRANSFORM_PARAM( TH, 'SQLTERMINATOR', TRUE );
 DBMS_METADATA.SET_TRANSFORM_PARAM( TH, 'EMIT_SCHEMA', FALSE);
 DBMS_METADATA.SET_TRANSFORM_PARAM(TH, 'SEGMENT_ATTRIBUTES', FALSE, 'TABLE');
 DBMS_METADATA.SET_TRANSFORM_PARAM(TH, 'PARTITIONING', TRUE, 'TABLE');
 DBMS_METADATA.SET_TRANSFORM_PARAM(TH, 'TABLESPACE', FALSE, 'TABLE');
 DBMS_METADATA.SET_TRANSFORM_PARAM( TH, 'SIZE_BYTE_KEYWORD', FALSE, 'TABLE');
 DBMS_METADATA.SET_TRANSFORM_PARAM( TH, 'FORCE', FALSE, 'VIEW');
 DBMS_METADATA.SET_TRANSFORM_PARAM( TH, 'CONSTRAINTS_AS_ALTER', FALSE, 'TABLE');
 DBMS_METADATA.SET_TRANSFORM_PARAM( TH, 'CONSTRAINTS', TRUE, 'TABLE'); 
 DBMS_METADATA.SET_TRANSFORM_PARAM( TH, 'REF_CONSTRAINTS', TRUE, 'TABLE');

 LOOP
    doc := dbms_metadata.fetch_ddl(h1);
-- When there are no more objects to be retrieved, FETCH_DDL returns NULL.
   EXIT WHEN doc IS NULL;
--   dbms_output.put_line(' BEG '||doc.FIRST||' --');
   if doc.FIRST is not null then
---- Loop through the rows of the ku$_ddls nested table.
     for i IN doc.FIRST..doc.LAST LOOP
       ddl := doc(i).ddlText;
       pi := doc(i).parsedItems;
       -- Loop through the returned parse items.
       IF pi IS NOT NULL AND pi.COUNT > 0 THEN
         FOR j IN pi.FIRST..pi.LAST LOOP
         IF pi(j).item='NAME' THEN
           objname := pi(j).value;
--           dbms_output.put_line(objname);
         END IF;                                                                                                                                            
         IF pi(j).item='OBJECT_TYPE' THEN
           objtype := pi(j).value;
--           dbms_output.put_line(objtype);
         END IF;                                                                                                                                            
       END LOOP;
     END IF;
     -- Insert information about this object into our table.
     INSERT INTO SKUTZ.my_metadata(rank, seq, type, object_name, meta,file_name)
       VALUES (seq, seq, objtype, objname, ddl, decode(objname,null,null,objname||'_'||objtype||'.xml') );
       seq :=seq + 1;
     COMMIT;
   END LOOP;
  end if;
--  dbms_output.put_line(' END '||doc.LAST||' --');
 END LOOP;
  DBMS_METADATA.CLOSE(h1);
END;