//EMULATION_DATEADD   
FUNCTION dateadd(p_interval VARCHAR2, p_interval_val NUMBER, p_date DATE)
RETURN DATE
IS
	v_ucase_interval VARCHAR2(4);
BEGIN
    v_ucase_interval := UPPER(p_interval);
    IF v_ucase_interval = 'YYYY' THEN
      RETURN ADD_MONTHS(p_date, p_interval_val * 12);
    ELSIF v_ucase_interval = 'Q' THEN
      RETURN ADD_MONTHS(p_date, p_interval_val * 3);
    ELSIF v_ucase_interval = 'M' THEN
      RETURN ADD_MONTHS(p_date, p_interval_val);
    ELSIF v_ucase_interval = 'D' OR v_ucase_interval = 'Y' THEN
      RETURN p_date + p_interval_val;
    ELSIF v_ucase_interval = 'WW' THEN
      RETURN p_date + (p_interval_val);
    ELSIF v_ucase_interval = 'W' THEN
      RETURN p_date + (p_interval_val * 7);
    ELSIF v_ucase_interval = 'H' THEN
      RETURN p_date + (p_interval_val / 24);
    ELSIF v_ucase_interval = 'N' THEN
      RETURN p_date + (p_interval_val / 24 / 60);
    ELSIF v_ucase_interval = 'S' THEN
      RETURN p_date + (p_interval_val / 24 / 60 / 60);
    ELSE
      RETURN NULL;
    END IF;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END dateadd;
//\\
//EMULATION_DATEDIFF
FUNCTION datediff(p_interval VARCHAR2, 
                    p_date1 DATE, 
                    p_date2 DATE, 
                    p_first_day_of_week NUMBER DEFAULT 1,
                    p_week_of_year NUMBER DEFAULT 1)
RETURN NUMBER
IS
    v_ucase_interval VARCHAR2(4);
BEGIN
    v_ucase_interval := UPPER(p_interval);
    IF v_ucase_interval = 'YYYY' THEN
      -- number of year
      IF EXTRACT(YEAR FROM p_date2) - EXTRACT(YEAR FROM p_date1) = 1 AND
        EXTRACT(MONTH FROM p_date1) = 12 AND EXTRACT(MONTH FROM p_date2) = 1 AND
        EXTRACT(DAY FROM p_date1) = 31 AND EXTRACT(DAY FROM p_date2) = 1 THEN
        -- (Extract for DateDiff for MSAccess 2007) 
        -- When comparing December 31 to January 1 of the immediately succeeding year, 
        -- DateDiff for Year ("yyyy") returns 1, even though only a day has elapsed.
        RETURN 1;
      ELSE
        RETURN ROUND(MONTHS_BETWEEN(p_date1, p_date2) / 12);
      END IF;
    ELSIF v_ucase_interval = 'Q' THEN
      -- number of quarter
      RETURN ROUND(MONTHS_BETWEEN(p_date1, p_date2) / 3);
    ELSIF v_ucase_interval = 'M' THEN
      -- number of month
      RETURN ROUND(MONTHS_BETWEEN(p_date1, p_date2));
    ELSIF v_ucase_interval = 'D' OR v_ucase_interval = 'Y' THEN
      -- number of days
      RETURN ROUND(p_date2 - p_date1);
    ELSIF v_ucase_interval = 'W' THEN
      -- number of weeks
      RETURN ROUND((p_date2 - p_date1) / 7);
    ELSIF v_ucase_interval = 'WW' THEN
      -- number of calendat week
      RETURN TO_NUMBER(TO_CHAR(p_date2, 'IW')) - TO_NUMBER(TO_CHAR(p_date1, 'IW'));
    ELSIF v_ucase_interval = 'H' THEN
      -- number of hours
      RETURN ROUND((p_date2 - p_date1) * 24);
    ELSIF v_ucase_interval = 'N' THEN
      -- number of minutes
      RETURN ROUND((p_date2 - p_date1) * 24 * 60);
    ELSIF v_ucase_interval = 'S' THEN
      -- number of seconds
      RETURN ROUND((p_date2 - p_date1) * 24 * 60 * 60);
    END IF;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END datediff;
//\\
//EMULATION_DATEPART 
FUNCTION datepart(p_interval VARCHAR2, p_date DATE, p_first_day_of_week NUMBER DEFAULT 1, p_first_day_of_year NUMBER DEFAULT 1)
RETURN NUMBER
IS
BEGIN
    CASE UPPER(p_interval)
      WHEN 'YYYY' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'YYYY'));
      WHEN 'Q' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'Q'));
      WHEN 'M' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'MM'));
      WHEN 'D' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'DD'));
      WHEN 'Y' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'DDD'));
      WHEN 'W' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'D'));
      WHEN 'WW' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'WW'));
      WHEN 'H' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'HH'));
      WHEN 'N' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'MI'));
      WHEN 'S' THEN RETURN TO_NUMBER(TO_CHAR(p_date, 'SS'));
      ELSE raise_application_error(-20000, 'Invalid interval');
    END CASE;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END datepart;
//\\
//EMULATION_DATESERIAL
FUNCTION dateserial (p_year NUMBER, p_month NUMBER, p_day NUMBER)
RETURN DATE
IS
    v_century_year  PLS_INTEGER;
BEGIN
    IF p_year < 100 AND p_year >= 0 AND p_year <= 29 THEN
      v_century_year := 2000 + p_year;
    ELSIF p_year < 100 AND p_year >= 30 AND p_year <= 99 THEN
      v_century_year := 1900 + p_year;
    ELSE
      v_century_year := p_year;
    END IF;
    
    RETURN ADD_MONTHS(TO_DATE('01/01/' || v_century_year, 'DD/MM/YYYY'), p_month - 1) + p_day - 1;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END dateserial;
//\\  
//EMULATION_DAY_
FUNCTION day_(p_date DATE)
RETURN NUMBER
IS
BEGIN
  IF p_date IS NULL THEN
    RETURN NULL;
  END IF;
    
  RETURN TO_NUMBER(TO_CHAR(p_date, 'DD'));
EXCEPTION
  WHEN OTHERS THEN
    raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END day_;
//\\
//EMULATION_HOUR_
FUNCTION hour_(p_date DATE)
RETURN NUMBER
IS
BEGIN
    IF p_date IS NULL THEN
      RETURN NULL;
    END IF;
    
    RETURN TO_NUMBER(TO_CHAR(p_date, 'HH24'));
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END hour_;
//\\
//EMULATION_MINUTE_
FUNCTION minute_(p_date DATE)
RETURN NUMBER
IS
BEGIN
    IF p_date IS NULL THEN
      RETURN NULL;
    END IF;
    
    RETURN TO_NUMBER(TO_CHAR(p_date, 'MI'));
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END minute_;
//\\
//EMULATION_MONTH_
FUNCTION month_(p_date DATE)
RETURN NUMBER
IS
BEGIN
  IF p_date IS NULL THEN
    RETURN NULL;
  END IF;
    
  RETURN TO_NUMBER(TO_CHAR(p_date, 'MM'));
EXCEPTION
  WHEN OTHERS THEN
    raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END month_;
//\\
//EMULATION_MONTHNAME
FUNCTION monthname(p_month NUMBER, p_abbrev NUMBER DEFAULT 0)
RETURN VARCHAR2
IS
    v_date DATE;
BEGIN
    v_date := TO_DATE(p_month, 'MM');
    IF p_abbrev < 1 THEN
      RETURN TO_CHAR(v_date, 'MONTH');     
    ELSE
      RETURN TO_CHAR(v_date, 'MON');
    END IF;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END monthname;
//\\  
//EMULATION_SECOND_
FUNCTION second_(p_date DATE)
RETURN NUMBER
IS
BEGIN
    IF p_date IS NULL THEN
      RETURN NULL;
    END IF;
    
    RETURN TO_NUMBER(TO_CHAR(p_date, 'SS'));
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END second_;
//\\
//EMULATION_TIME_
FUNCTION time_
RETURN DATE
IS
BEGIN
    RETURN SYSDATE;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END time_;
//\\
//EMULATION_TIMER
FUNCTION timer
RETURN NUMBER
IS
    dsinterval INTERVAL DAY(0) TO SECOND;
BEGIN
    dsinterval := TO_DSINTERVAL('0 ' || TO_CHAR(SYSDATE, 'HH24:MI:SS'));
    RETURN EXTRACT(HOUR FROM dsinterval) * 3600 +
      EXTRACT(MINUTE FROM dsinterval) * 60 +
      EXTRACT(SECOND FROM dsinterval);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END timer;
//\\  
//EMULATION_TIMESERIAL
FUNCTION timeserial (p_hour NUMBER, p_minute NUMBER, p_second NUMBER)
RETURN DATE
IS
    v_date DATE;
BEGIN
    v_date := SYSDATE;
    v_date := to_date(TO_CHAR(v_DATE,'DD-MON-YYYY')||':'||p_hour||':'||p_minute||':'||p_second,
    'DD-MON-YYYY:HH24:MI:SS');
    RETURN v_date;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END timeserial;
//\\  
//EMULATION_WEEKDAY
FUNCTION weekday(p_date DATE, p_first_day_of_week NUMBER DEFAULT 1)
RETURN NUMBER
IS
BEGIN
    IF p_date IS NULL THEN
      RETURN NULL;
    END IF;
    
    RETURN TO_NUMBER(TO_CHAR(p_date,'D'));
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END weekday;
//\\  
//EMULATION_WEEKDAYNAME
FUNCTION weekdayname(p_day_of_week NUMBER, p_abbrev NUMBER DEFAULT 0, p_first_day_of_week NUMBER DEFAULT 1)
RETURN VARCHAR2
IS
    v_offset NUMBER DEFAULT 1;
BEGIN
    IF p_day_of_week < 1 AND p_day_of_week > 7 OR p_first_day_of_week < 0 AND p_first_day_of_week > 7 THEN
      raise_application_error('-20000','Parameters not in valid range');
    END IF;
    
      v_offset := p_day_of_week + (p_first_day_of_week - 1);
      IF v_offset < 0 THEN
        v_offset := 7 + v_offset;
      ELSIF v_offset > 7 THEN
       v_offset := v_offset - 7;
      END IF;
    DBMS_OUTPUT.PUT_LINE(v_offset);
    CASE v_offset
      WHEN 1 THEN 
        IF p_abbrev = -1 THEN -- true
          RETURN 'Sun';
        ELSE
          RETURN 'Sunday';
        END IF;
      WHEN 2 THEN 
        IF p_abbrev = -1 THEN -- true
          RETURN 'Mon';
        ELSE
          RETURN 'Monday';
        END IF;
      WHEN 3 THEN 
        IF p_abbrev = -1 THEN -- true
          RETURN 'Tue';
        ELSE
          RETURN 'Tuesday';
        END IF;
      WHEN 4 THEN 
        IF p_abbrev = -1 THEN -- true
          RETURN 'Wed';
        ELSE
          RETURN 'Wednesday';
        END IF;
      WHEN 5 THEN 
        IF p_abbrev = -1 THEN -- true
          RETURN 'Thur';
        ELSE
          RETURN 'Thursday';
        END IF;
      WHEN 6 THEN 
        IF p_abbrev = -1 THEN -- true
          RETURN 'Fri';
        ELSE
          RETURN 'Friday';
        END IF;
      WHEN 7 THEN 
        IF p_abbrev = -1 THEN -- true
          RETURN 'Sat';
        ELSE
          RETURN 'Saturday';
        END IF;
    END CASE;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END weekdayname;
//\\ 
//EMULATION_YEAR_
FUNCTION year_(p_date DATE)
RETURN NUMBER
IS
BEGIN
  IF p_date IS NULL THEN
    RETURN NULL;
  END IF;
    
  RETURN TO_NUMBER(TO_CHAR(p_date, 'YY'));
EXCEPTION
  WHEN OTHERS THEN
    raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END year_;
//\\
//EMULATION_ATN
FUNCTION atn(p_num NUMBER) 
  RETURN NUMBER
IS
BEGIN
    RETURN ATAN(p_num);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END atn;
//\\
//EMULATION_INT_  
FUNCTION int_(p_num NUMBER) 
RETURN NUMBER
IS
BEGIN
    IF p_num < 0 THEN
      RETURN FLOOR(p_num);
    ELSE  
      RETURN TRUNC(p_num);
    END IF;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END int_;
//\\
//EMULATION_FIX  
FUNCTION fix(p_num NUMBER)
RETURN NUMBER
IS
BEGIN
    IF p_num < 0 THEN
      RETURN CEIL(p_num);
    ELSE
      RETURN TRUNC(p_num);
    END IF;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END fix;
//\\
//EMULATION_PI
FUNCTION pi
RETURN NUMBER
IS
    pi NUMBER := 3.141592653589793116;
BEGIN
    RETURN pi;
END pi;
//\\ 
//EMULATION_RND
FUNCTION rnd(p_num NUMBER default 0)
RETURN NUMBER
IS
BEGIN
    IF p_num < 0 THEN
      DBMS_RANDOM.SEED(p_num);
    END IF;
    RETURN abs(1/DBMS_RANDOM.RANDOM);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END rnd;
//\\
//EMULATION_SGN  
FUNCTION sgn(p_num NUMBER)
RETURN NUMBER
IS
BEGIN
    RETURN SIGN(p_num);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END sgn;
//\\
//EMULATION_SQR  
FUNCTION sqr(p_num NUMBER)
RETURN NUMBER
IS
BEGIN
    RETURN SQRT(p_num);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END sqr;
//\\
//EMULATION_ASC_  
FUNCTION asc_(p_num VARCHAR2) 
RETURN NUMBER
IS
BEGIN
    RETURN ASCII(p_num);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END asc_;
//\\
//EMULATION_FORMAT_DATETIME  
FUNCTION format_datetime(p_date DATE, p_format NUMBER)
RETURN VARCHAR2
IS
BEGIN
    CASE p_format
      WHEN 0 THEN RETURN TO_CHAR(p_date, 'DD/MM/YYYY HH:MI:SS');
      WHEN 1 THEN RETURN TO_CHAR(p_date, 'DD-MON-YYYY');
      WHEN 2 THEN RETURN TO_CHAR(p_date, 'DD/MM/YYYY');
      WHEN 3 THEN RETURN TO_CHAR(p_date, 'HH:MI:SS');
      WHEN 4 THEN RETURN TO_CHAR(p_date, 'HH24:MI');
      ELSE RETURN TO_CHAR(p_date, 'DD/MM/YYYY HH:MI:SS');
    END CASE;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END format_datetime;
//\\
//EMULATION_FORMAT_NUMERIC_EXPR  
FUNCTION format_numeric_expr(p_expr VARCHAR2, 
                               p_percent BOOLEAN DEFAULT FALSE,
                               p_fractional_digits NUMBER DEFAULT -1, 
                               p_leading_digit NUMBER DEFAULT -2, 
                               p_use_paren_for_neg_num NUMBER DEFAULT -2,
                               p_group_digits NUMBER DEFAULT -2) 
RETURN VARCHAR2
IS
    v_value NUMBER;
    v_leading_digit VARCHAR(1) DEFAULT '';
    v_ret_value VARCHAR2(2000) DEFAULT '';
BEGIN
    v_value :=  CASE
                  WHEN NOT p_percent THEN TO_NUMBER(p_expr)
                  ELSE TO_NUMBER(p_expr) * 100
                END;

    IF p_fractional_digits >= 0 THEN
      v_value :=  TRUNC(v_value, p_fractional_digits);
    END IF;
    
    IF p_leading_digit = -1 AND v_value < 1 AND v_value > -1 THEN
      v_leading_digit := '0';
    END IF;
    
    v_ret_value := CASE 
                    WHEN v_value < 0 THEN
                      SUBSTR(TO_CHAR(v_value), 1, 1) || v_leading_digit || SUBSTR(TO_CHAR(v_value), 2)
                    ELSE
                      v_leading_digit || v_value
                   END;
    IF p_percent THEN
      v_ret_value := v_ret_value || '%';
    END IF;
      
    IF v_value < 0 AND p_use_paren_for_neg_num = -1 THEN
      v_ret_value := '(' || v_ret_value || ')';
    END IF;
    
    RETURN v_ret_value;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END format_numeric_expr;
//\\
//EMULATION_FORMAT_CURRENCY  
FUNCTION format_currency(p_expr VARCHAR2, 
                           p_fractional_digits NUMBER DEFAULT -1, 
                           p_leading_digit NUMBER DEFAULT -2, 
                           p_use_paren_for_neg_num NUMBER DEFAULT -2,
                           p_group_digits NUMBER DEFAULT -2)
RETURN VARCHAR2
IS
BEGIN
    RETURN SUBSTR(TO_CHAR('0', 'L9'), 1, 1) || 
      format_numeric_expr(p_expr, FALSE, p_fractional_digits, p_leading_digit, 
                          p_use_paren_for_neg_num, p_group_digits);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END format_currency;
//\\
//EMULATION_FORMAT_NUMBER  
FUNCTION format_number(p_expr VARCHAR2, 
                         p_fractional_digits NUMBER DEFAULT -1, 
                         p_leading_digit NUMBER DEFAULT -2, 
                         p_use_paren_for_neg_num NUMBER DEFAULT -2,
                         p_group_digits NUMBER DEFAULT -2) 
RETURN VARCHAR2
IS
BEGIN
	RETURN format_numeric_expr(p_expr, FALSE, p_fractional_digits, p_leading_digit, 
                          p_use_paren_for_neg_num, p_group_digits);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END format_number;
//\\
//EMULATION_PERCENT  
FUNCTION format_percent(p_expr VARCHAR2, 
                          p_fractional_digits NUMBER DEFAULT -1, 
                          p_leading_digit NUMBER DEFAULT -2, 
                          p_use_paren_for_neg_num NUMBER DEFAULT -2,
                          p_group_digits NUMBER DEFAULT -2) 
RETURN VARCHAR2
IS
    v_value NUMBER;
    v_leading_digit VARCHAR(1) DEFAULT '';
    v_ret_value VARCHAR2(2000) DEFAULT '';
BEGIN
    RETURN format_numeric_expr(p_expr, TRUE, p_fractional_digits, p_leading_digit, 
                          p_use_paren_for_neg_num, p_group_digits);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END format_percent;
//\\
//EMULATION_TO_BASE
FUNCTION to_base(p_dec NUMBER, p_base NUMBER) 
RETURN VARCHAR2
IS
    v_str VARCHAR2(255);
    v_num NUMBER;
    v_hex VARCHAR2(16) DEFAULT '0123456789ABCDEF';
BEGIN
    v_num := p_dec;
    
    IF p_dec IS NULL OR p_base IS NULL THEN
      RETURN NULL;
    END IF;

    IF TRUNC(p_dec) <> p_dec OR p_dec < 0 THEN
        RAISE PROGRAM_ERROR;
    END IF;
    
    LOOP
      v_str := SUBSTR(v_hex, MOD(v_num, p_base) + 1, 1) || v_str;
      v_num := TRUNC(v_num / p_base);
      
      EXIT WHEN v_num = 0;
    END LOOP;
    
    RETURN v_str;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END to_base;
//\\
//EMULATION_TO_DEC
FUNCTION to_dec(p_str VARCHAR2,
                  p_from_base NUMBER DEFAULT 16)
RETURN NUMBER
IS
    v_num NUMBER DEFAULT 0;
    v_hex VARCHAR2(16) DEFAULT '0123456789ABCDEF';
BEGIN
    IF p_str IS NULL OR p_from_base IS NULL THEN
      RETURN NULL;
    END IF;

    FOR i IN 1 .. LENGTH(p_str)
    LOOP
      v_num := v_num * p_from_base + INSTR(v_hex, UPPER(substr(p_str, i, 1))) - 1;
    END LOOP;

    RETURN v_num;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END to_dec;
//\\
//EMULATION_HEX
FUNCTION hex(p_num VARCHAR2)
RETURN VARCHAR2
IS
BEGIN
    RETURN to_base(p_num, 16);
  EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END hex;
//\\
//EMULATION_NZ  
FUNCTION nz(p_num VARCHAR2, p_null_replacement VARCHAR2)
RETURN VARCHAR2
IS
BEGIN
    RETURN NVL(p_num, p_null_replacement);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END nz;
//\\
//EMULATION_OCT
FUNCTION oct(p_num VARCHAR2)
RETURN VARCHAR2
IS
BEGIN
    RETURN to_base(p_num, 8);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END oct;
//\\
//EMULATION_STR  
FUNCTION str(p_num VARCHAR2)
RETURN VARCHAR2
IS
    v_temp PLS_INTEGER;
BEGIN
    v_temp := TO_NUMBER(p_num);
    IF v_temp < 0 THEN
      RETURN v_temp;
    ELSE
      RETURN ' ' || TO_CHAR(v_temp);
    END IF;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END str;
//\\
//EMULATION_VAL  
FUNCTION val(p_expr VARCHAR2)
RETURN NUMBER
IS
    v_temp VARCHAR2(2000);
    v_counter PLS_INTEGER DEFAULT 1;
    v_char CHAR(1);
    v_char_ascii PLS_INTEGER;
    v_ret_value VARCHAR2(2000) DEFAULT '';
    v_is_valid_numrep BOOLEAN DEFAULT TRUE;
BEGIN
    IF p_expr IS NULL THEN
      RETURN NULL;
    END IF;
    
    v_temp := REPLACE(p_expr, ' ', '');
          
    IF LENGTH(v_temp) > 2 AND SUBSTR(v_temp, 1, 1) = '&' AND SUBSTR(v_temp, 2, 1) = 'O' THEN
        v_counter := 3;
        -- Octal
        LOOP
            v_char := SUBSTR(v_temp, v_counter, 1);
            v_char_ascii := ASCII(v_char);
            IF (v_char_ascii > 47 AND v_char_ascii < 56) THEN
                v_ret_value := v_ret_value || v_char;
            ELSE
                v_is_valid_numrep := FALSE;
            END IF;
            EXIT WHEN v_counter = LENGTH(v_temp) OR NOT v_is_valid_numrep;
            v_counter := v_counter + 1;
         END LOOP;   
         IF (v_ret_value IS NULL) THEN
	     RETURN 0;
         END IF;
         RETURN to_dec(v_ret_value, 8);
    END IF;
    IF LENGTH(v_temp) > 2 AND SUBSTR(v_temp, 1, 1) = '&' AND SUBSTR(v_temp, 2, 1) = 'H' THEN
    -- Hexidecimal
        v_counter := 3;
        LOOP
            v_char := UPPER(SUBSTR(v_temp, v_counter, 1));
            v_char_ascii := ASCII(v_char);
            IF (v_char_ascii > 47 AND v_char_ascii < 58) OR (v_char_ascii > 64 AND v_char_ascii < 71) THEN
                v_ret_value := v_ret_value || v_char;
            ELSE
                v_is_valid_numrep := FALSE;
            END IF;
            EXIT WHEN v_counter = LENGTH(v_temp) OR NOT v_is_valid_numrep;
            v_counter := v_counter + 1;
        END LOOP;  
        IF (v_ret_value IS NULL) THEN
            RETURN 0;
        END IF;
        IF (v_ret_value = 'FFFF') THEN
           RETURN -1;
        ELSE
           RETURN to_dec(v_ret_value);
        END IF;
    END IF;
    -- Normal decimal
     
    LOOP
        v_char := SUBSTR(v_temp, v_counter, 1);
        v_char_ascii := ASCII(v_char);
        IF ((v_char_ascii > 47 AND v_char_ascii < 58) OR v_char_ascii = 46) THEN
            v_ret_value := v_ret_value || v_char;
        ELSE
            v_is_valid_numrep := FALSE;
        END IF;
        EXIT WHEN v_counter = LENGTH(v_temp) OR NOT v_is_valid_numrep;
        v_counter := v_counter + 1;
     END LOOP;
     IF (v_ret_value IS NULL) THEN
     	 RETURN 0;
     END IF;
     RETURN v_ret_value;
      
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END val;
//\\
//EMULATION_ISDATE  
FUNCTION isdate(p_expr VARCHAR2) 
RETURN NUMBER
IS
BEGIN
    IF TO_DATE(p_expr) IS NOT NULL THEN
      RETURN 0; -- pl/sql boolean true value
    ELSE
      RETURN 1; -- pl/sql boolean false value
    END IF;
EXCEPTION
    WHEN OTHERS THEN
      RETURN 1; -- pl/sql boolean false value
END isdate;
//\\
//EMULATION_ISNUMERIC  
FUNCTION isnumeric(p_expr VARCHAR2) 
RETURN NUMBER
IS
    v_num NUMBER;  
BEGIN
    IF SUBSTR(p_expr, 1, 1) = '$' THEN
      v_num := TO_NUMBER(SUBSTR(p_expr, 2));
    ELSE
      v_num := TO_NUMBER(p_expr);
    END IF;
    
    RETURN 0; -- pl/sql boolean true value
EXCEPTION
    WHEN OTHERS THEN
      RETURN 1; -- pl/sql boolean false value
END isnumeric;
//\\
//EMULATION_ISEMPTY  
FUNCTION isempty(p_expr VARCHAR2) 
RETURN NUMBER
IS
BEGIN
    RETURN 1; -- pl/sql boolean false value
END isempty;
//\\
//EMULATION_ISERROR
FUNCTION iserror(p_expr VARCHAR2)
RETURN NUMBER
IS
BEGIN
    RETURN 1; -- pl/sql boolean false value
END iserror;
//\\
//EMULATION_ISMISSING  
FUNCTION ismissing(p_expr VARCHAR2)
RETURN NUMBER
IS
BEGIN
    RETURN 1; -- pl/sql boolean false value
END ismissing;
//\\
//EMULATION_CHOOSE_
FUNCTION choose_(p_index NUMBER,
                   p_element_1 VARCHAR2,
                   p_element_2 VARCHAR2 DEFAULT NULL,
                   p_element_3 VARCHAR2 DEFAULT NULL,
                   p_element_4 VARCHAR2 DEFAULT NULL,
                   p_element_5 VARCHAR2 DEFAULT NULL,
                   p_element_6 VARCHAR2 DEFAULT NULL,
                   p_element_7 VARCHAR2 DEFAULT NULL,
                   p_element_8 VARCHAR2 DEFAULT NULL,
                   p_element_9 VARCHAR2 DEFAULT NULL,
                   p_element_10 VARCHAR2 DEFAULT NULL,
                   p_element_11 VARCHAR2 DEFAULT NULL,
                   p_element_12 VARCHAR2 DEFAULT NULL,
                   p_element_13 VARCHAR2 DEFAULT NULL,
                   p_element_14 VARCHAR2 DEFAULT NULL,
                   p_element_15 VARCHAR2 DEFAULT NULL,
                   p_element_16 VARCHAR2 DEFAULT NULL,
                   p_element_17 VARCHAR2 DEFAULT NULL,
                   p_element_18 VARCHAR2 DEFAULT NULL,
                   p_element_19 VARCHAR2 DEFAULT NULL,
                   p_element_20 VARCHAR2 DEFAULT NULL)
RETURN VARCHAR2
IS
    TYPE StringCollType IS TABLE OF VARCHAR2(4000);
    v_coll StringCollType;
BEGIN
    v_coll := new StringCollType();
    
    IF p_element_1 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_1;
    END IF;
    
    IF p_element_2 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_2;
    END IF;
    
    IF p_element_3 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_3;
    END IF;
    
    IF p_element_4 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_4;
    END IF;
    
    IF p_element_5 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_5;
    END IF;
    
    IF p_element_6 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_6;
    END IF;
    
    IF p_element_7 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_7;
    END IF;
    
    IF p_element_8 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_8;
    END IF;
    
    IF p_element_9 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_9;
    END IF;
    
    IF p_element_10 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_10;
    END IF;
    
    IF p_element_11 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_11;
    END IF;
    
    IF p_element_12 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_12;
    END IF;
    
    IF p_element_13 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_13;
    END IF;
    
    IF p_element_14 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_14;
    END IF;
    
    IF p_element_15 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_15;
    END IF;
    
    IF p_element_16 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_16;
    END IF;
    
    IF p_element_17 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_17;
    END IF;
    
    IF p_element_18 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_18;
    END IF;
    
    IF p_element_19 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_19;
    END IF;
    
    IF p_element_20 IS NOT NULL THEN
      v_coll.EXTEND(1);
      v_coll(v_coll.LAST) := p_element_20;
    END IF;
    
    IF p_index < 1 OR p_index > v_coll.COUNT THEN
      RETURN NULL;
    END IF;
    
    RETURN v_coll(ROUND(p_index));
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END choose_;
//\\
//EMULATION_INSTR_
FUNCTION instr_(p_string_1 VARCHAR2, p_string_2 VARCHAR2, p_compare NUMBER DEFAULT 1)
RETURN NUMBER
IS
BEGIN
    CASE
      -- zero-length strings or null strings
      WHEN p_string_1 IS NULL OR p_string_2 IS NULL THEN RETURN NULL;
      -- start position is beyond string being searched
      WHEN 1 > LENGTH(p_string_1) THEN RETURN 0;
      WHEN p_compare = 0 THEN RETURN INSTRB(p_string_1, p_string_2, 1);
      ELSE RETURN INSTR(p_string_1, p_string_2, 1);
    END CASE;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END instr_;
//\\
//EMULATION_INSTR1_
FUNCTION instr_(p_start NUMBER, p_string_1 VARCHAR2, p_string_2 VARCHAR2,  p_compare NUMBER DEFAULT 1)
RETURN NUMBER
IS
BEGIN
    CASE
      -- zero-length strings or null strings
      WHEN p_string_1 IS NULL OR p_string_2 IS NULL THEN RETURN NULL;
      -- start position is beyond string being searched
      WHEN p_start > LENGTH(p_string_1) THEN RETURN 0;
      WHEN p_compare = 0 THEN RETURN INSTRB(p_string_1, p_string_2, p_start);
      ELSE RETURN INSTR(p_string_1, p_string_2, p_start);
    END CASE;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END instr_;
//\\
//EMULATION_INSTRREV
FUNCTION instrrev(p_string_1 VARCHAR2, p_string_2 VARCHAR2, p_start NUMBER DEFAULT -1, p_compare NUMBER DEFAULT 0)
RETURN NUMBER
IS
    v_start_pos NUMBER DEFAULT -1;
BEGIN
    v_start_pos := CASE
                    WHEN p_start > 0 THEN (p_start - LENGTH(p_string_1) - 1)
                    ELSE p_start
                   END;
    RETURN instr_(v_start_pos, p_string_1, p_string_2, p_compare);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END instrrev;
//\\
//EMULATION_SUBSTR_FROM_END  
FUNCTION substr_from_end(p_string VARCHAR2, p_length NUMBER, p_end NUMBER DEFAULT 1)
RETURN VARCHAR2
IS
BEGIN
    CASE
      WHEN p_string IS NULL THEN RETURN NULL;
      WHEN p_length = 0 THEN RETURN '';
      WHEN ABS(p_length) > LENGTH(p_string) THEN RETURN p_string;
      ELSE RETURN SUBSTR(p_string, p_end, p_length);
    END CASE;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END substr_from_end;
//\\
//EMULATION_LEFT_
FUNCTION left_(p_string VARCHAR2, p_length NUMBER)
RETURN VARCHAR2
IS
BEGIN
    RETURN substr_from_end(p_string, p_length);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END left_;
//\\
//EMULATION_RIGHT_  
FUNCTION right_(p_string VARCHAR2, p_length NUMBER)
RETURN VARCHAR2
IS
BEGIN
    RETURN substr_from_end(p_string, p_length, -p_length); 
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END right_;
//\\
//EMULATION_REPLACE_
FUNCTION replace_(p_expr VARCHAR2, 
                    p_search_str VARCHAR2, 
                    p_replacement VARCHAR2,
                    p_start NUMBER DEFAULT 1, 
                    p_count NUMBER DEFAULT -1, 
                    p_compare NUMBER DEFAULT 1) 
RETURN VARCHAR2
IS
    v_pos NUMBER;
    v_length NUMBER;
    v_occurences NUMBER := 0;
    v_new_str VARCHAR2(4000);
BEGIN
    IF p_expr IS NULL THEN 
      RAISE PROGRAM_ERROR;
    ELSIF LENGTH(p_expr) = 0 OR p_start > LENGTH(p_expr) 
      THEN RETURN '';
    ELSIF p_search_str IS NULL OR LENGTH(p_search_str) = 0 OR p_count = 0 THEN 
      RETURN p_expr;
    END IF;
    
    v_pos := p_start;
    v_new_str := SUBSTR(p_expr, v_pos);
  
    LOOP
      v_pos := instr_(v_pos, v_new_str, p_search_str, p_compare);
      
      IF v_pos > 0 THEN
        v_length := CASE 
                      WHEN p_compare = 0 THEN LENGTHB(p_search_str)
                      ELSE LENGTH(p_search_str)
                    END;
        v_new_str := SUBSTR(v_new_str, 1, v_pos - 1) || p_replacement || SUBSTR(v_new_str, v_pos + v_length);
        v_occurences := v_occurences + 1;
      END IF;
      
      EXIT WHEN v_occurences = p_count OR v_pos = 0;
    END LOOP;
 
    RETURN SUBSTR(p_expr, 1, p_start - 1) || v_new_str;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END replace_;
//\\
//EMULATION_MID  
FUNCTION mid(p_string VARCHAR2, p_start NUMBER, p_length NUMBER DEFAULT NULL) 
RETURN VARCHAR2
IS
lengthtoend NUMBER := 0;
BEGIN
    IF p_length IS NULL
    THEN
      lengthtoend := LENGTH(p_STRING) - p_start+1;
      RETURN SUBSTR(p_string, p_start, lengthtoend);
    ELSE
      RETURN SUBSTR(p_string, p_start, p_length);
    END IF;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END mid;
//\\
//EMULATION_MIDB  
FUNCTION midb(p_string VARCHAR2, p_start NUMBER, p_length NUMBER) 
RETURN VARCHAR2
IS
BEGIN
    RETURN SUBSTRB(p_string, p_start, p_length);
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END midb;
//\\
//EMULATION_SPACE_  
FUNCTION space_(p_number NUMBER)
RETURN VARCHAR2
IS
BEGIN
    RETURN LPAD(' ', p_number, ' ');
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END space_;
//\\
//EMULATION_REPLACE_STRCOMP 
FUNCTION strcomp(p_first_string VARCHAR2, 
                   p_second_string VARCHAR2, 
                   p_compare NUMBER DEFAULT -1) 
RETURN VARCHAR2
IS
    v_temp_1  VARCHAR2(4000) DEFAULT '';
    v_temp_2  VARCHAR2(4000) DEFAULT '';
BEGIN
    IF p_first_string IS NULL or p_second_string IS NULL THEN
      RETURN NULL;
    END IF;
    
    IF LENGTH(p_first_string) > LENGTH(p_second_string) THEN
      RETURN 1;
    ELSIF LENGTH(p_first_string) < LENGTH(p_second_string) THEN
      RETURN -1;
    END IF;
    
    -- binary comparison
    IF p_compare = 0 THEN
      v_temp_1 := ASCIISTR(LTRIM(RTRIM(p_first_string)));
      v_temp_2 := ASCIISTR(LTRIM(RTRIM(p_second_string)));
    ELSE -- text comparison
      v_temp_1 := ASCIISTR(LTRIM(RTRIM(LOWER(p_first_string))));
      v_temp_2 := ASCIISTR(LTRIM(RTRIM(LOWER(p_second_string))));
    END IF;
    
    FOR i IN 1 .. LENGTH(v_temp_1) LOOP
      IF ASCII(SUBSTR(v_temp_1, i, 1)) > ASCII(SUBSTR(v_temp_2, i, 1)) THEN
        RETURN 1;
      ELSIF ASCII(SUBSTR(v_temp_1, i, 1)) < ASCII(SUBSTR(v_temp_2, i, 1)) THEN
        RETURN -1;
      END IF;
    END LOOP;
      
    RETURN 0;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END strcomp;
//\\
//EMULATION_REPLACE_STRCONV
FUNCTION strconv(p_string VARCHAR2, p_conversion NUMBER, p_locale_id NUMBER DEFAULT NULL) 
RETURN VARCHAR2
IS
BEGIN
    IF BITAND(p_conversion, 1) = 1 THEN
      -- convert to upper case
      RETURN UPPER(p_string);
    ELSIF BITAND(p_conversion, 2) = 2 THEN
      -- convert to lower case
      RETURN LOWER(p_string);
    ELSIF BITAND(p_conversion, 3) = 3 THEN
      RETURN INITCAP(p_string);
    ELSIF BITAND(p_conversion, 4) = 4 THEN
      -- convert single-byte to double-byte
      RETURN TO_MULTI_BYTE(p_string);
    ELSIF BITAND(p_conversion, 8) = 8 THEN
      -- convert double-byte to single-byte
      RETURN TO_SINGLE_BYTE(p_string);
    END IF;
    
    RETURN p_string;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END strconv;
//\\
//EMULATION_STRING_  
FUNCTION string_(p_length NUMBER, p_character VARCHAR2)
RETURN VARCHAR2
IS
    v_char CHAR(1) DEFAULT '';
BEGIN
    IF p_length IS NULL OR p_character IS NULL THEN
      RETURN NULL;
    END IF;
    
    BEGIN
      v_char := CHR(p_character);
    EXCEPTION
      WHEN OTHERS THEN
        v_char := SUBSTR(p_character, 1, 1);
    END;
    
    RETURN TRIM(LPAD(' ', p_length + 1 /* to compensate for the blank in first parameter */, v_char));
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END string_;
//\\
//EMULATION_STRREVERSE  
FUNCTION strreverse(p_expr VARCHAR2) 
RETURN VARCHAR2
IS
    v_string VARCHAR2(4000) DEFAULT '';
BEGIN
    IF p_expr IS NULL THEN
      RETURN NULL;
    END IF;
    
    IF LENGTH(TRIM(p_expr)) = 0 THEN
      RETURN '';
    END IF;
    
    FOR i IN 1 .. LENGTH(p_expr) LOOP
      v_string := v_string || SUBSTR(p_expr, -i, 1); 
    END LOOP;
    
    RETURN v_string;
EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20000, DBMS_UTILITY.FORMAT_ERROR_STACK);
END strreverse;
//\\  
