package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;

class KeyValuesFloat extends KeyValues<Float>
{
    public KeyValuesFloat(final float... values) {
        super(values);
        for (final float value : values) {
            this.values.add(value);
        }
    }
    
    @Override
    public Class<?> getType() {
        return Float.TYPE;
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int i0, final int i1, final float fraction) {
        float value;
        if (i0 == i1) {
            value = (float)this.values.get(i0);
        }
        else {
            final float v0 = (float)this.values.get(i0);
            final float v2 = (float)this.values.get(i1);
            value = v0 + (v2 - v0) * fraction;
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }
}