<?xml version="1.0"?>
<!-- 
NAME
    kuprsso.xsl
DESCRIPTION
    Templates for generating parse items for XMLTypes for schema objects
NOTES

MODIFIED	MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     11/14/02 - add missing support
    dgagne      12/05/02 - change base object for index statistics to index
    dgagne      11/21/02 - add directory for parse items
    lbarton     10/11/02 - new parse item: SYSTEM_GENERATED
    htseng      08/07/02 - verify all objects
    lbarton     08/07/02 - transportable export
    lbarton     07/23/02 - procedural objects/actions
    lbarton     06/17/02 - support table/index_stats
    lbarton     06/11/02 - (ref_)constraint OWNER -> OWNER_NAME
    htseng      07/01/02 - add pre/post table action support
    htseng      07/03/02 - add PRS_TYPE
    lbarton     04/29/02 - domain index support
    lbarton     04/22/02 - rls policy, etc
    lbarton     04/17/02 - new parse items
    lbarton     03/21/02 - tweak select_mode; bugfix
    lbarton     03/18/02 - lbarton_mdapi_dpumpinfra
    lbarton 	03/13/02 - bugfix
    lbarton	02/06/01 - Created

 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kuprscom.xsl"/>
 <!-- params for parse -->
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_ROW">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_TABLESPACE">0</xsl:param>
 <xsl:param name="PRS_TYPE_NUM">0</xsl:param>
 <xsl:param name="PRS_ENABLE">0</xsl:param>
 <xsl:param name="PRS_NESTED_COLUMNS">0</xsl:param>
 <xsl:param name="PRS_ROW_LEVEL_SECURITY">0</xsl:param>
 <xsl:param name="PRS_SECONDARY">0</xsl:param>
 <xsl:param name="PRS_BYTES_ALLOCATED">0</xsl:param>
 <xsl:param name="PRS_DP_PARALLEL">0</xsl:param>
 <xsl:param name="PRS_ET_PARALLEL">0</xsl:param>
 <xsl:param name="PRS_UNLOAD_METHOD">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_TYPE">0</xsl:param>
 <xsl:param name="PRS_PKG_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_PKG_NAME">0</xsl:param>
 <xsl:param name="PRS_SYSTEM_GENERATED">0</xsl:param>
 <xsl:template match="CLUSTER_T |DIMENSION_T |
FUNCTION_T |INDEXTYPE_T | JAVASRC_T | JAVACLASS_T | JAVARESRC_T | LIBRARY_T |
M_VIEW_T | OPERATOR_T | PACKAGE_T | PACKAGE_BODY_T | PROCEDURE_T |
SEQUENCE_T | SYNONYM_T | TYPE_T | TYPE_BODY_T | VIEW_T">
  <xsl:call-template name="ParseObjtype"/>
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseName"/>
 </xsl:template>
 <xsl:template match="M_VIEW_LOG_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">MATERIALIZED_VIEW_LOG</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema">
   <xsl:with-param name="SchemaNode" select="MVIEWLOG/MOWNER"/>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjName">
   <xsl:with-param name="NameNode" select="MVIEWLOG/MASTER"/>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjType">
   <xsl:with-param name="Objtype">TABLE</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="TABLE_T">
  <xsl:call-template name="ParseObjtype"/>
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseName"/>
  <xsl:choose>
   <xsl:when test="(PART_OBJ)">
    <xsl:call-template name="ParseTablespace">
     <xsl:with-param name="TablespaceNode" select="PART_OBJ/PARTOBJ/DEFTS_NAME"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="ParseTablespace"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$PRS_NESTED_COLUMNS=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ANESTED_COLUMNS</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:if test="(PROPERTY mod 8)>=4">Y</xsl:if>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_ROW_LEVEL_SECURITY=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AROW_LEVEL_SECURITY</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:if test="(FLAGS mod 4096)>=2048">Y</xsl:if>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_SECONDARY=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ASECONDARY</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:if test="(SCHEMA_OBJ/FLAGS mod 32)>=16">Y</xsl:if>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="BASE_OBJ">
   <xsl:call-template name="ParseBaseObjSchema"/>
   <xsl:call-template name="ParseBaseObjName"/>
   <xsl:call-template name="ParseBaseObjType"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="TABLE_DATA_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">TABLE_DATA</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
  <xsl:call-template name="ParseTablespace"/>
  <xsl:if test="$PRS_BYTES_ALLOCATED=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ABYTES_ALLOCATED</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="BYTES_ALLOC"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_DP_PARALLEL=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ADP_PARALLEL</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="SELECT_MODE/DP_PARALLEL"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_ET_PARALLEL=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AET_PARALLEL</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="SELECT_MODE/ET_PARALLEL"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_UNLOAD_METHOD=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AUNLOAD_METHOD</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="SELECT_MODE/PREFERRED_MODE"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_TYPE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ATYPE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="SCHEMA_OBJ/TYPE_NUM=2">
     <xsl:choose>
      <xsl:when test="(PROPERTY mod 16384)>=8192">
       <xsl:text>NESTED TABLE</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:text>TABLE</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>PARTITION</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_SYSTEM_GENERATED=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ASYSTEM_GENERATED</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:if test="(SCHEMA_OBJ/FLAGS mod 8)>=4">Y</xsl:if>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="SYSGRANT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">SYSTEM_GRANT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseGrantee"/>
 </xsl:template>
 <xsl:template match="ROGRANT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">ROLE_GRANT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseGrantee"/>
 </xsl:template>
 <xsl:template match="OBJGRANT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">OBJECT_GRANT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
  <xsl:call-template name="ParseGrantee"/>
  <xsl:call-template name="ParseGrantor"/>
 </xsl:template>
 <xsl:template match="AUDITOBJ_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">AUDIT_OBJ</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
  <xsl:call-template name="ParseGrantee">
   <xsl:with-param name="GranteeNode" select="USER_NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="PSW_HIST_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PASSWORD_HISTORY</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseGrantee">
   <xsl:with-param name="GranteeNode" select="NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="ASSOC_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">ASSOCIATION</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="COMMENT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">COMMENT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="CONTEXT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">CONTEXT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName"/>
 </xsl:template>
 <xsl:template match="DIRECTORY_T">
  <xsl:call-template name="ParseObjtype"/>
  <xsl:call-template name="ParseName"/>
 </xsl:template>
 <xsl:template match="PROFILE_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROFILE</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="PROFILE_NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="REFGROUP_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">REFRESH_GROUP</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="REFNAME"/>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema">
   <xsl:with-param name="SchemaNode" select="REFOWNER"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="XMLSCHEMA_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">XMLSCHEMA</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="URL"/>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema">
   <xsl:with-param name="SchemaNode" select="OWNER_NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="PWDVFC_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PASSWORD_VERIFY_FUNCTION</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="RLS_CONTEXT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">RLS_CONTEXT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="RLS_GROUP_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">RLS_GROUP</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="RLS_POLICY_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">RLS_POLICY</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="CONSTRAINT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">CONSTRAINT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema">
   <xsl:with-param name="SchemaNode" select="OWNER_NAME"/>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
  <xsl:if test="$PRS_SYSTEM_GENERATED=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ASYSTEM_GENERATED</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:if test="(FLAGS mod 16)>=8">Y</xsl:if>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="REF_CONSTRAINT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">REF_CONSTRAINT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema">
   <xsl:with-param name="SchemaNode" select="OWNER_NAME"/>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
  <xsl:if test="$PRS_SYSTEM_GENERATED=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ASYSTEM_GENERATED</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:if test="(FLAGS mod 16)>=8">Y</xsl:if>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="INDEX_T">
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseObjtype"/>
  <xsl:call-template name="ParseName"/>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
  <xsl:call-template name="ParseTablespace"/>
  <xsl:if test="$PRS_TYPE_NUM=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ATYPE_NUM</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="TYPE_NUM"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_SYSTEM_GENERATED=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ASYSTEM_GENERATED</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:if test="(SCHEMA_OBJ/FLAGS mod 8)>=4">Y</xsl:if>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="TRIGGER_T">
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseObjtype"/>
  <xsl:call-template name="ParseName"/>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
  <xsl:if test="$PRS_ENABLE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AENABLE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:choose>
    <xsl:when test="ENABLED=0">
     <xsl:text>DISABLE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>ENABLE</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="USER_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">USER</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="ROLE_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">ROLE</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="DEFROLE_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">DEFAULT_ROLE</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseGrantee">
   <xsl:with-param name="GranteeNode" select="USER_NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="TSQUOTA_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">TABLESPACE_QUOTA</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseGrantee">
   <xsl:with-param name="GranteeNode" select="USER_NAME"/>
  </xsl:call-template>
  <xsl:call-template name="ParseGrantor"/>
 </xsl:template>
 <xsl:template match="DBLINK_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">DB_LINK</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="TRLINK_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">TRUSTED_DB_LINK</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="TABLESPACE_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">TABLESPACE</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="ROLLBACK_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">ROLLBACK_SEGMENT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="RESOCOST_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">RESOURCE_COST</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="T_STAT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">TABLE_STATISTICS</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="I_STAT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">INDEX_STATISTICS</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema">
   <xsl:with-param name="SchemaNode" select="BASE_IND_OBJ/OWNER_NAME"/>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjName">
   <xsl:with-param name="NameNode" select="BASE_IND_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjType">
   <xsl:with-param name="TypeNode" select="BASE_IND_OBJ/TYPE_NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="PROCGRANT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROC_SYSTEM_GRANT</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="PROCAUDIT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROC_AUDIT</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="PROCOBJ_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROCOBJ</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseName"/>
 </xsl:template>
 <xsl:template match="PROCOBJG_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROCOBJ_GRANT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="PROCOBJA_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROCOBJ_AUDIT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="PROCDEPOBJ_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROCDEPOBJ</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseName"/>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="PROCDEPOBJG_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROCDEPOBJ_GRANT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="PROCDEPOBJA_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROCDEPOBJ_AUDIT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="PROCACTSYS_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROCACT_SYSTEM</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="$PRS_PKG_SCHEMA=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>APKG_SCHEMA</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="SCHEMA"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_PKG_NAME=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>APKG_NAME</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="PACKAGE"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="PROCACTSCHEMA_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROCACT_SCHEMA</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema">
   <xsl:with-param name="SchemaNode" select="USER_NAME"/>
  </xsl:call-template>
  <xsl:if test="$PRS_PKG_SCHEMA=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>APKG_SCHEMA</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="SCHEMA"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_PKG_NAME=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>APKG_NAME</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="PACKAGE"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="PROCACTINS_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROCACT_INSTANCE</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
  <xsl:if test="$PRS_PKG_SCHEMA=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>APKG_SCHEMA</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="PKG_SCHEMA"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:if test="$PRS_PKG_NAME=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>APKG_NAME</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:value-of select="PACKAGE"/>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="PRE_TABLE_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PRE_TABLE_ACTION</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="POST_TABLE_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">POST_TABLE_ACTION</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
  <xsl:call-template name="ParseBaseObjType"/>
 </xsl:template>
 <xsl:template match="AUDIT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">AUDIT</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjName">
   <xsl:with-param name="NameNode" select="AUDIT_OPTION"/>
  </xsl:call-template>
  <xsl:call-template name="ParseGrantee">
   <xsl:with-param name="GranteeNode" select="USER_NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="QUEUES_T">
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">AQ_QUEUE</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName"/>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
 </xsl:template>
 <xsl:template match="QUETAB_T">
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">AQ_QUEUE_TABLE</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName"/>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
 </xsl:template>
 <xsl:template match="QTRANS_T">
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">AQ_TRANSFORM</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseName"/>
 </xsl:template>
 <xsl:template match="FGA_POLICY_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">FGA_POLICY</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
 </xsl:template>
 <xsl:template match="JOB_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">JOB</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="MATERIALIZED_VIEW">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">MATERIALIZED_VIEW</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema">
   <xsl:with-param name="SchemaNode" select="MVIEW/SOWNER"/>
  </xsl:call-template>
  <xsl:call-template name="ParseName">
   <xsl:with-param name="NameNode" select="MVIEW/VNAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="MATERIALIZED_VIEW_LOG">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">MATERIALIZED_VIEW_LOG</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema">
   <xsl:with-param name="SchemaNode" select="MVIEWLOG/MOWNER"/>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjName">
   <xsl:with-param name="NameNode" select="MVIEWLOG/MASTER"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="MONITOR_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">MONITORING</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
 </xsl:template>
 <xsl:template match="PROXY_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PROXY</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseGrantee">
   <xsl:with-param name="GranteeNode" select="CLIENT_NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="RMGR_CONSUMER_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">RMGR_CONSUMER_GROUP</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseName"/>
 </xsl:template>
 <xsl:template match="RMGR_PLAN_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">RMGR_PLAN</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseSchema"/>
  <xsl:call-template name="ParseName"/>
 </xsl:template>
 <xsl:template match="RMGR_INIT_CONSUMER_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">RMGR_INITIAL_CONSUMER_GROUP</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseGrantee">
   <xsl:with-param name="GranteeNode" select="GRANTEE"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="RMGR_PLAN_DIRECT_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">RMGR_PLAN_DIRECTIVE</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="ParseBaseObjSchema"/>
  <xsl:call-template name="ParseBaseObjName"/>
 </xsl:template>
 <xsl:template match="PLUGTS_BLK_T">
  <xsl:call-template name="ParseObjtype">
   <xsl:with-param name="Objtype">PLUGTS_BLK</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
