/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.versionhistory;

import java.awt.Window;
import java.net.URL;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.util.VCSEditorUtils;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryController;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryNode;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryURLHelper;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryViewer;

public class VersionHistoryCommand
extends VCSCommand {
    public static final String VERSION_HISTORY_CMD = VersionHistoryCommand.class.getName();
    public static final int VERSION_HISTORY_CMD_ID = Ide.findOrCreateCmdID((String)VERSION_HISTORY_CMD);

    public static final IdeAction getVersionHistoryAction(String command, String vcsId) {
        int id = Ide.findOrCreateCmdID((String)command);
        IdeAction versionHistoryAction = IdeAction.find((int)id);
        if (versionHistoryAction != null) {
            return versionHistoryAction;
        }
        versionHistoryAction = IdeAction.findOrCreate((int)id, (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader(vcsId), command), (String)StringUtils.stripMnemonic((String)VCSArb.get("VERSION_HISTORY_TEXT")), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)StringUtils.getMnemonicKeyCode((String)VCSArb.get("VERSION_HISTORY_TEXT")), (Icon)OracleIcons.getIcon((String)"version_history.png"), null, (boolean)true);
        if (vcsId != null) {
            versionHistoryAction.addController((Controller)new VersionHistoryController(id, vcsId));
        }
        return versionHistoryAction;
    }

    public VersionHistoryCommand() {
        this(VERSION_HISTORY_CMD_ID);
    }

    protected VersionHistoryCommand(int cmdId) {
        super(cmdId, 1);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
        this.initializeCommandType(VCSCommandType.BOTH);
    }

    @Override
    protected URLFilter getURLFilter() {
        return VCSURLFilters.createFileProtocolFilter();
    }

    @Override
    public boolean isAvailable() {
        VCSExtension extension;
        VCSExtension _extension = (VCSExtension)this.getContext().getProperty("VCSController.VCS");
        if (!(_extension == null || (extension = VCSExtensionUtils.getActiveExtension(this.getContext())) != null && extension.getId().equals(_extension.getId()))) {
            return false;
        }
        return super.isAvailable();
    }

    @Override
    protected boolean isAvailableImpl() throws Exception {
        if (this.getContext().getSelection().length != 1) {
            return false;
        }
        Locatable[] locatables = this.getContextLocatables();
        return locatables.length > 0 && this.isAvailableImpl(this.getContextLocatables()[0]);
    }

    @Override
    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!super.isAvailableImpl(url)) {
            return false;
        }
        return VCSManager.getVCSManager().isVersioned(url);
    }

    @Override
    protected int doitImpl() throws Exception {
        this.context = ChangeListWindow.handleContext(this.context);
        Locatable[] locatables = this.getContextLocatables();
        if (locatables.length <= 0) {
            return -1;
        }
        this.show(locatables[0].getURL());
        return 0;
    }

    private void show(URL url) {
        try {
            URL versionHistoryUrl = VersionHistoryURLHelper.newHistoryURL(url);
            Node versionHistoryNode = NodeFactory.findOrCreate(VersionHistoryNode.class, (URL)versionHistoryUrl);
            Context detailedContext = Context.newIdeContext();
            detailedContext.setNode(versionHistoryNode);
            detailedContext.setElement((Element)versionHistoryNode);
            EditorManager.getEditorManager().openEditorInFrame(VersionHistoryViewer.class, detailedContext);
        }
        catch (InstantiationException ie) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ie);
        }
        catch (IllegalAccessException ille) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ille);
        }
    }

    public static final void closeVersionHistoryEditors() {
        VCSEditorUtils.closeEditorsForEditorType(VersionHistoryViewer.class);
    }
}

