/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changeset.cmd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetChangeList;
import oracle.jdeveloper.vcs.changeset.cmd.BaseChangeSetCommand;
import oracle.jdeveloper.vcs.changeset.cmd.CommentTemplatesConfiguration;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSHashURL;

public class NewChangeSetCommand
extends BaseChangeSetCommand {
    public NewChangeSetCommand() {
        super(ChangeSetChangeList.NEW_CHANGE_SET_COMMAND_ID, 1);
    }

    public int doit() throws Exception {
        ChangeSetAdapter adapter = this.getContextChangeSetAdapter();
        if (adapter == null) {
            return 1;
        }
        VCSCommentsCustomizer commentsCustomizer = new VCSCommentsCustomizer(adapter.getSystemId());
        CommentTemplatesConfiguration.configure(commentsCustomizer, adapter.getSystemId());
        commentsCustomizer.setSuppressDefaultTemplate(true);
        EditChangeSetPanelUI ui = new EditChangeSetPanelUI(commentsCustomizer);
        final JEWTDialog dialog = new JEWTDialog(IdeUtil.getMainWindow(), VCSArb.get("NEW_CHANGE_SET_TITLE"));
        dialog.setButtonMask(7);
        dialog.setContent((Component)ui);
        ui.attachToDialog(dialog);
        dialog.addVetoableChangeListener((VetoableChangeListener)new NameValidationListener(this.getContext(), ui));
        HelpSystem.getHelpSystem().registerTopic((JComponent)dialog.getContent(), "f1_scsnewchangelist_html");
        if (!dialog.runDialog()) {
            return 1;
        }
        String name = ui.getNameTextField().getText();
        String comment = null;
        comment = ui.getUseTitleCheckBox().isSelected() ? name : (String)commentsCustomizer.getOptions().get("setting_comments");
        if (comment == null) {
            comment = "";
        }
        URL[] urls = this.getContextURLs();
        Map<String, Collection<VCSHashURL>> changesets = adapter.getChangeSets(urls);
        for (Map.Entry<String, Collection<VCSHashURL>> entry : changesets.entrySet()) {
            adapter.removeFromChangeSet(VCSHashURL.convertToURLs(entry.getValue()).toArray(new URL[0]), entry.getKey());
        }
        adapter.addToChangeSet(urls, name);
        adapter.setChangeSetComments(name, comment);
        adapter.fireChangeSetsChanged();
        if (MessageDialog.optionalConfirm((String)"VCS.SetDefaultChangeSetConfirm", (Component)IdeUtil.getMainWindow(), (Object)VCSArb.format("CONFIRM_SET_DEFAULT_CHANGE_SET", name), (String)VCSArb.get("CONFIRM_SET_DEFAULT_CHANGE_SET_TITLE"), null)) {
            adapter.setDefaultChangeSet(name);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.dispose();
            }
        });
        return 0;
    }

    static final class EditChangeSetPanelUI
    extends JPanel {
        private VCSCommentsCustomizer _customizer;
        private JLabel _nameLabel;
        private JTextField _nameTextField;
        private JCheckBox _useTitleCheckBox;

        EditChangeSetPanelUI(VCSCommentsCustomizer commentsCustomizer) {
            super(new BorderLayout());
            this._customizer = commentsCustomizer;
            this.createComponents();
            this.resComponents();
            this.layoutComponents();
            this._useTitleCheckBox.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent ae) {
                    _customizer.setCommentsComponentsEnabled(!_useTitleCheckBox.isSelected());
                }
            });
        }

        private final void createComponents() {
            this._nameLabel = new JLabel();
            this._nameTextField = new JTextField();
            this._useTitleCheckBox = new JCheckBox();
        }

        private final void resComponents() {
            ResourceUtils.resLabel((JLabel)this._nameLabel, (Component)this._nameTextField, (String)VCSArb.get("CHANGE_SET_NAME"));
            ResourceUtils.resButton((AbstractButton)this._useTitleCheckBox, (String)VCSArb.get("CHANGE_SET_USE_TITLE"));
        }

        private final void layoutComponents() {
            LayoutBuilder builder = new LayoutBuilder();
            Insets insets = new Insets(2, 2, 2, 2);
            builder.add((Component)this._nameLabel, insets, 1, false, false);
            builder.add((Component)this._nameTextField, insets, 1, false, false);
            builder.nl();
            builder.add((Component)this._useTitleCheckBox, insets, 2, false, true);
            builder.nl();
            builder.addVGap();
            builder.nl();
            JPanel center = new JPanel();
            builder.addToPanel((Container)center);
            this._nameTextField.setColumns(50);
            this.add((Component)center, "Center");
            this.add(this._customizer.getComponent(), "South");
        }

        final VCSCommentsCustomizer getCustomizer() {
            return this._customizer;
        }

        final JTextField getNameTextField() {
            return this._nameTextField;
        }

        final JCheckBox getUseTitleCheckBox() {
            return this._useTitleCheckBox;
        }

        final void attachToDialog(final JEWTDialog dialog) {
            this._nameTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.documentUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.documentUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.documentUpdate(e);
                }

                private final void documentUpdate(DocumentEvent e) {
                    dialog.setOKButtonEnabled(e.getDocument().getLength() > 0);
                }
            });
            dialog.setOKButtonEnabled(this._nameTextField.getDocument().getLength() > 0);
        }
    }

    static final class NameValidationListener
    implements VetoableChangeListener {
        private final Context _context;
        private final EditChangeSetPanelUI _ui;
        private String _permissableName;

        NameValidationListener(Context context, EditChangeSetPanelUI ui) {
            this._context = context;
            this._ui = ui;
        }

        final void setPermissableName(String name) {
            this._permissableName = name;
        }

        @Override
        public final void vetoableChange(PropertyChangeEvent vce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)vce)) {
                return;
            }
            if (!(this._context.getView() instanceof ChangeListWindow)) {
                return;
            }
            ChangeListWindow window = (ChangeListWindow)this._context.getView();
            if (!(window.getContextChangeList() instanceof ChangeSetChangeList)) {
                return;
            }
            String name = this._ui.getNameTextField().getText();
            if (name.equals(this._permissableName)) {
                return;
            }
            if (!window.getContextChangeList().getCategoryCache().containsValue(name)) {
                return;
            }
            MessageDialog.error((Component)this._ui, (Object)VCSArb.format("ERROR_CHANGE_SET_EXISTS", name), (String)VCSArb.get("ERROR_CHANGE_SET_EXISTS_TITLE"), null);
            throw new PropertyVetoException("", vce);
        }
    }
}

