/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util.jsonproc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import oracle.spatial.util.jsonp.JsonParser;
import oracle.spatial.util.jsonproc.ArrayNode;
import oracle.spatial.util.jsonproc.JsonMappingException;
import oracle.spatial.util.jsonproc.JsonNode;
import oracle.spatial.util.jsonproc.JsonProcessingException;
import oracle.spatial.util.jsonproc.JsonToken;
import oracle.spatial.util.jsonproc.ObjectCodec;
import oracle.spatial.util.jsonproc.ObjectMapper;

public class JsonParser {
    private JsonToken currentToken;
    private String currentName;
    private boolean allowUnquotedFieldNames;
    private ObjectCodec codec;
    private oracle.spatial.util.jsonp.JsonParser lowLevelParser;

    public JsonParser(Reader reader) {
        this.lowLevelParser = new oracle.spatial.util.jsonp.JsonParser(reader);
    }

    public JsonParser(String string) {
        this(new StringReader(string));
    }

    public void setAllowUnquotedFieldNames(boolean bl) {
        this.allowUnquotedFieldNames = bl;
        this.lowLevelParser.setAllowUnquotedFieldNames(bl);
    }

    public JsonToken currentToken() {
        return this.currentToken;
    }

    public JsonToken getCurrentToken() {
        return this.currentToken();
    }

    public boolean hasCurrentToken() {
        return this.currentToken != null;
    }

    public ObjectCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this.codec = objectCodec;
    }

    public JsonLocation getCurrentLocation() {
        return new JsonLocation();
    }

    public boolean isClosed() {
        return !this.lowLevelParser.hasNext();
    }

    public String getCurrentName() {
        return this.currentName;
    }

    public JsonParser skipChildren() throws IOException {
        Stack<Boolean> stack = new Stack<Boolean>();
        boolean bl = true;
        while (bl) {
            switch (this.currentToken) {
                case START_ARRAY: {
                    stack.push(Boolean.FALSE);
                    break;
                }
                case START_OBJECT: {
                    stack.push(Boolean.TRUE);
                    break;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    stack.pop();
                }
            }
            if (stack.isEmpty()) {
                bl = false;
                continue;
            }
            this.nextToken();
        }
        return this;
    }

    public String getText() {
        return this.lowLevelParser.getString();
    }

    public boolean getValueAsBoolean() throws JsonParseException {
        try {
            return this.lowLevelParser.getBoolean();
        }
        catch (JsonParser.JsonParsingException jsonParsingException) {
            throw new JsonParseException(jsonParsingException.getMessage(), jsonParsingException);
        }
    }

    public boolean getValueAsBoolean(boolean bl) {
        try {
            return this.lowLevelParser.getBoolean();
        }
        catch (JsonParser.JsonParsingException jsonParsingException) {
            return bl;
        }
    }

    public double getValueAsDouble() throws JsonParseException {
        try {
            return this.lowLevelParser.getDouble();
        }
        catch (JsonParser.JsonParsingException jsonParsingException) {
            throw new JsonParseException(jsonParsingException.getMessage(), jsonParsingException);
        }
    }

    public double getValueAsDouble(double d) {
        try {
            return this.lowLevelParser.getDouble();
        }
        catch (JsonParser.JsonParsingException jsonParsingException) {
            return d;
        }
    }

    public long getLongValue() throws IOException {
        switch (this.currentToken) {
            case VALUE_NUMBER_FLOAT: {
                return (long)this.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return Long.parseLong(this.lowLevelParser.getString());
            }
        }
        throw new JsonParseException("Not a double value");
    }

    public double getDoubleValue() throws IOException {
        switch (this.currentToken) {
            case VALUE_NUMBER_FLOAT: {
                return Double.parseDouble(this.lowLevelParser.getString());
            }
            case VALUE_NUMBER_INT: {
                return this.getLongValue();
            }
        }
        throw new JsonParseException("Not a double value");
    }

    public int getIntValue() throws IOException {
        switch (this.currentToken) {
            case VALUE_NUMBER_INT: {
                return Integer.parseInt(this.lowLevelParser.getString());
            }
            case VALUE_NUMBER_FLOAT: {
                return (int)this.getDoubleValue();
            }
        }
        throw new JsonParseException("Not a double value");
    }

    public int getValueAsInt() throws JsonParseException {
        try {
            return this.lowLevelParser.getInt();
        }
        catch (JsonParser.JsonParsingException jsonParsingException) {
            throw new JsonParseException(jsonParsingException.getMessage(), jsonParsingException);
        }
    }

    public int getValueAsInt(int n) {
        try {
            return this.lowLevelParser.getInt();
        }
        catch (JsonParser.JsonParsingException jsonParsingException) {
            return n;
        }
    }

    public long getValueAsLong() throws JsonParseException {
        try {
            return this.lowLevelParser.getLong();
        }
        catch (JsonParser.JsonParsingException jsonParsingException) {
            throw new JsonParseException(jsonParsingException.getMessage(), jsonParsingException);
        }
    }

    public long getValueAsLong(long l) throws JsonParseException {
        try {
            return this.lowLevelParser.getLong();
        }
        catch (JsonParser.JsonParsingException jsonParsingException) {
            return l;
        }
    }

    public Number getNumberValue() throws IOException {
        switch (this.currentToken) {
            case VALUE_NUMBER_INT: {
                return this.getValueAsLong();
            }
            case VALUE_NUMBER_FLOAT: {
                return this.getValueAsDouble();
            }
        }
        throw new JsonParseException("current token is not numeric");
    }

    public String getValueAsString() {
        return this.lowLevelParser.getString();
    }

    public String getValueAsString(String string) {
        String string2 = this.lowLevelParser.getString();
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public <T> T readValueAs(Class<T> clazz) throws IOException, JsonProcessingException, JsonMappingException {
        JsonNode jsonNode = this.readValueAsTree();
        return new ObjectMapper().treeToValue(jsonNode, clazz);
    }

    public JsonNode readValueAsTree() throws IOException {
        try {
            Stack<JsonNode> stack = new Stack<JsonNode>();
            JsonNode jsonNode = new JsonNode(JsonNode.JsonNodeType.ARRAY, new Object[0]);
            JsonNode jsonNode2 = null;
            String string = null;
            block13: while (!this.isClosed()) {
                switch (this.nextToken()) {
                    case START_OBJECT: {
                        stack.push(jsonNode);
                        jsonNode2 = new JsonNode.ObjectNode();
                        if (jsonNode.isArray()) {
                            jsonNode.addArrayValue(jsonNode2);
                        } else {
                            jsonNode.addField(string, jsonNode2);
                        }
                        jsonNode = jsonNode2;
                        continue block13;
                    }
                    case END_ARRAY: 
                    case END_OBJECT: {
                        jsonNode = (JsonNode)stack.pop();
                        continue block13;
                    }
                    case START_ARRAY: {
                        jsonNode2 = new ArrayNode();
                        if (jsonNode.isArray()) {
                            jsonNode.addArrayValue(jsonNode2);
                        } else {
                            jsonNode.addField(string, jsonNode2);
                        }
                        stack.push(jsonNode);
                        jsonNode = jsonNode2;
                        continue block13;
                    }
                    case FIELD_NAME: {
                        string = this.lowLevelParser.getString();
                        continue block13;
                    }
                    case VALUE_NULL: {
                        if (jsonNode.isArray()) {
                            jsonNode.addArrayValue(JsonNode.NULL);
                            continue block13;
                        }
                        jsonNode.addField(string, JsonNode.NULL);
                        continue block13;
                    }
                    case VALUE_TRUE: {
                        if (jsonNode.isArray()) {
                            jsonNode.addArrayValue(JsonNode.BooleanNode.TRUE);
                            continue block13;
                        }
                        jsonNode.addField(string, JsonNode.BooleanNode.TRUE);
                        continue block13;
                    }
                    case VALUE_FALSE: {
                        if (jsonNode.isArray()) {
                            jsonNode.addArrayValue(JsonNode.BooleanNode.FALSE);
                        } else {
                            jsonNode.addField(string, JsonNode.BooleanNode.FALSE);
                            continue block13;
                        }
                    }
                    case VALUE_STRING: {
                        if (jsonNode.isArray()) {
                            jsonNode.addArrayValue(new JsonNode(JsonNode.JsonNodeType.STRING, this.getText()));
                            continue block13;
                        }
                        jsonNode.addField(string, new JsonNode(JsonNode.JsonNodeType.STRING, this.getText()));
                        continue block13;
                    }
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_NUMBER_INT: {
                        if (jsonNode.isArray()) {
                            jsonNode.addArrayValue(new JsonNode(JsonNode.JsonNodeType.NUMBER, this.getText()));
                            continue block13;
                        }
                        jsonNode.addField(string, new JsonNode(JsonNode.JsonNodeType.NUMBER, this.getText()));
                        continue block13;
                    }
                }
            }
            return jsonNode.get(0);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IOException(jsonProcessingException.getMessage(), jsonProcessingException);
        }
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        try {
            switch (this.lowLevelParser.next()) {
                case START_OBJECT: {
                    this.currentToken = JsonToken.START_OBJECT;
                    this.currentName = null;
                    break;
                }
                case END_OBJECT: {
                    this.currentToken = JsonToken.END_OBJECT;
                    break;
                }
                case START_ARRAY: {
                    this.currentToken = JsonToken.START_ARRAY;
                    this.currentName = null;
                    break;
                }
                case END_ARRAY: {
                    this.currentToken = JsonToken.END_ARRAY;
                    break;
                }
                case VALUE_STRING: {
                    this.currentToken = JsonToken.VALUE_STRING;
                    break;
                }
                case VALUE_TRUE: {
                    this.currentToken = JsonToken.VALUE_TRUE;
                    break;
                }
                case VALUE_FALSE: {
                    this.currentToken = JsonToken.VALUE_FALSE;
                    break;
                }
                case VALUE_NULL: {
                    this.currentToken = JsonToken.VALUE_NULL;
                    break;
                }
                case VALUE_NUMBER: {
                    if (this.lowLevelParser.isIntegralNumber()) {
                        this.currentToken = JsonToken.VALUE_NUMBER_INT;
                        break;
                    }
                    this.currentToken = JsonToken.VALUE_NUMBER_FLOAT;
                    break;
                }
                case KEY_NAME: {
                    this.currentToken = JsonToken.FIELD_NAME;
                    this.currentName = this.lowLevelParser.getString();
                }
            }
            return this.currentToken;
        }
        catch (JsonParser.JsonParsingException jsonParsingException) {
            throw new JsonParseException(jsonParsingException.getMessage(), jsonParsingException);
        }
    }

    public class JsonLocation {
        JsonParser.JsonLocation jsonLocation;

        private JsonLocation() {
            this.jsonLocation = JsonParser.this.lowLevelParser.getLocation();
        }

        public void getColumnNr() {
            this.jsonLocation.getColumnNumber();
        }

        public void getLineNr() {
            this.jsonLocation.getLineNumber();
        }

        public String toString() {
            return this.jsonLocation.toString();
        }
    }

    public static class JsonParseException
    extends JsonProcessingException {
        private JsonParseException(String string, Throwable throwable) {
            super(string, throwable);
        }

        private JsonParseException(String string) {
            super(string);
        }
    }

    public static enum Feature {
        ALLOW_UNQUOTED_FIELD_NAMES;

    }
}

