/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import oracle.spatial.util.ShapefileReaderJGeom;

public class DBFieldDesc {
    byte[] name = new byte[11];
    byte field_type;
    int field_offset;
    short field_len;
    byte decimal_cnt;
    byte[] unused1;
    byte work_area_id;
    byte[] unused2;
    byte set_field_flag;
    byte[] unused3;
    byte index_flag;
    static final int size = 32;

    public void fromBuffer(byte[] byArray) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
             DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
            int n;
            ShapefileReaderJGeom.swapBytes(byArray, 12, 4);
            for (n = 0; n < 11; ++n) {
                this.name[n] = dataInputStream.readByte();
            }
            this.field_type = dataInputStream.readByte();
            this.field_offset = dataInputStream.readInt();
            this.field_len = (short)(dataInputStream.readByte() & 0xFF);
            this.decimal_cnt = dataInputStream.readByte();
            for (n = 0; n < 2; ++n) {
                dataInputStream.readByte();
            }
            this.work_area_id = dataInputStream.readByte();
            for (n = 0; n < 2; ++n) {
                dataInputStream.readByte();
            }
            this.set_field_flag = dataInputStream.readByte();
            for (n = 0; n < 7; ++n) {
                dataInputStream.readByte();
            }
            this.index_flag = dataInputStream.readByte();
        }
    }

    public byte[] getName() {
        return this.name;
    }

    public byte getFieldType() {
        return this.field_type;
    }

    public int getFieldOffset() {
        return this.field_offset;
    }

    public short getFieldLength() {
        return this.field_len;
    }
}

