/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.db2v9;

import java.sql.Connection;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.DB2Capturer;
import oracle.dbtools.migration.workbench.plugin.DB2OnlineCapturer;
import oracle.dbtools.migration.workbench.plugin.DB2Plugin;

public class DB2v9Plugin
extends DB2Plugin {
    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.startsWith(this.getPlatformName()) && n >= 9) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    @Override
    public DB2Capturer getCapturer(MigrationStorer migrationStorer, Connection connection) {
        return new DB2Capturer(migrationStorer, connection){

            @Override
            protected DB2OnlineCapturer getOnlineCapturer(MigrationStorer migrationStorer, Connection connection) {
                return new DB2OnlineCapturer(migrationStorer, connection);
            }
        };
    }

    public String getPublishedVersion() {
        return "9";
    }

    public String getVersionNumber() {
        return this.getPublishedVersion();
    }

    @Override
    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        Object object = "";
        String string = mdColumn.getColumnType();
        String string2 = mdColumn2.getColumnName();
        if (string.equalsIgnoreCase("BLOB") || string.equalsIgnoreCase("CLOB") || string.equalsIgnoreCase("XML") || string.equalsIgnoreCase("DBCLOB")) {
            String string3 = this.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2);
            String string4 = System.getProperty("line.separator");
            object = " FILLER," + string4;
            object = (String)object + string2 + " LOBFILE(" + string3 + ") TERMINATED BY EOF";
            return object;
        }
        return super.formatSQLLoaderColumn(mdColumn, mdColumn2);
    }

    public String maybeQuoteSqlldrFieldReference(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = mdColumn.getColumnType();
        if (string.equalsIgnoreCase("BLOB") || string.equalsIgnoreCase("CLOB") || string.equalsIgnoreCase("XML") || string.equalsIgnoreCase("DBCLOB")) {
            return mdColumn2.getColumnName() + "_ref";
        }
        return super.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2);
    }

    @Override
    protected String getLobFileOption() {
        return "lobsinsepfiles";
    }
}

