/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.osgi.boot.api.IdeBootProperties;

public class ConfigurationAreaScanner {
    private Logger LOG = Logger.getLogger("oracle.ide.osgi.boot");
    private String m_middlewareHome;
    private String m_productHome;
    private Collection<String> m_dynamicClusters = new ArrayList<String>();
    private static ConfigurationAreaScanner INSTANCE = null;

    public static ConfigurationAreaScanner getScanner() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationAreaScanner();
        }
        return INSTANCE;
    }

    public ConfigurationAreaScanner(String mwHome, String productHome, Logger logger) {
        this.m_middlewareHome = mwHome;
        this.m_productHome = productHome;
        if (logger != null) {
            this.LOG = logger;
        }
        this.scanAndPopulateClusters(new File(this.m_middlewareHome), new File(this.m_productHome), this.m_dynamicClusters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigurationAreaScanner() {
        this.m_middlewareHome = IdeBootProperties.getMiddlewareHome();
        this.m_productHome = IdeBootProperties.getProductHome();
        String rescanProperty = IdeBootProperties.getOracleInstallRescan();
        String installTimeStampLocation = IdeBootProperties.getOracleInstallTimestampLocation();
        if (rescanProperty == null && installTimeStampLocation == null) {
            this.LOG.fine("neither oracle.install.timestamp.location nor oracle.install.rescan were passed in. Oracle installation rescanning will not happen.");
            return;
        }
        this.LOG.fine("Will do installation rescanning. oracle.install.rescan = " + rescanProperty + " , oracle.install.timestamp.location = " + installTimeStampLocation);
        boolean toScan = false;
        File installArtifactsDirectory = new File(IdeBootProperties.getSystemDirectory(), ".install-artifacts");
        String INSTALLED_PRODUCTS_FILE_NAME = "lastInstallation.txt";
        String LAST_INSTALL_TIMESTAMP_FILE_NAME = ".lastInstallation";
        String COMMENT_INSTALL_FILE = "# This file contains the list of directories that are contributing plugins";
        File lastRecordedInstallTimestampFile = new File(installArtifactsDirectory, ".lastInstallation");
        File installedProductsFile = new File(installArtifactsDirectory, "lastInstallation.txt");
        if ("false".equalsIgnoreCase(rescanProperty)) {
            toScan = false;
        } else if ("true".equalsIgnoreCase(rescanProperty)) {
            toScan = true;
        } else {
            if (installTimeStampLocation == null) {
                this.LOG.fine("The install scanning values were invalid");
                return;
            }
            File installTimeStampLocationFile = new File(this.m_middlewareHome, installTimeStampLocation);
            if (!installTimeStampLocationFile.exists()) {
                this.LOG.log(Level.FINE, installTimeStampLocationFile + " did not exist. Will not scan. In a non-FMW environment, like SQLDev's, this is expected.");
                return;
            }
            long installLocationLastModified = installTimeStampLocationFile.lastModified();
            if (!lastRecordedInstallTimestampFile.exists()) {
                try {
                    this.LOG.log(Level.FINE, "Installation timestamp file did not exist, will create it and set its timestamp to the installation's last modified timestamp");
                    if (installArtifactsDirectory.mkdirs() && lastRecordedInstallTimestampFile.createNewFile()) {
                        lastRecordedInstallTimestampFile.setLastModified(installLocationLastModified - 1L);
                    } else {
                        this.LOG.log(Level.SEVERE, "Failed to create a file to track the last-installed timestamps: " + lastRecordedInstallTimestampFile.getAbsolutePath());
                        toScan = true;
                    }
                }
                catch (IOException e) {
                    this.LOG.log(Level.SEVERE, "Failed to create a file to track the last-installed timestamps: " + lastRecordedInstallTimestampFile.getAbsolutePath(), e);
                    toScan = true;
                }
            }
            if (!toScan) {
                if (installLocationLastModified == lastRecordedInstallTimestampFile.lastModified()) {
                    this.LOG.log(Level.FINE, "Installation timestamps are equal, will not rescan because of timestamps");
                } else if (installLocationLastModified < lastRecordedInstallTimestampFile.lastModified()) {
                    this.LOG.log(Level.SEVERE, "Recorded last-modified timestamp of " + lastRecordedInstallTimestampFile + ", " + new Date(lastRecordedInstallTimestampFile.lastModified()) + ",  was greater than the installation's last modified: " + new Date(installLocationLastModified).toString() + " . Will rescan for new products and set both timestamps to the present.");
                    Date now = new Date();
                    lastRecordedInstallTimestampFile.setLastModified(now.getTime());
                    installTimeStampLocationFile.setLastModified(now.getTime());
                    toScan = true;
                } else {
                    this.LOG.log(Level.FINE, "Installation timestamp was greater than the recorded timestamps, so an installation must have happened. Will rescan because of timestamps, unless property oracle.install.rescan is set to false ");
                    lastRecordedInstallTimestampFile.setLastModified(installLocationLastModified);
                    toScan = true;
                }
            }
        }
        File mwHomeDir = new File(this.m_middlewareHome);
        File productHomeDir = new File(this.m_productHome);
        String consumingProductName = productHomeDir.getName();
        if (toScan) {
            Collection<String> mwhPluginProviders = this.scanAndPopulateClusters(mwHomeDir, productHomeDir, this.m_dynamicClusters);
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileOutputStream(installedProductsFile, false));
                out.append("# This file contains the list of directories that are contributing plugins\n");
                Iterator<String> iterator = mwhPluginProviders.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        out.close();
                        return;
                    }
                    String pluginProvider = iterator.next();
                    out.append(pluginProvider + "\n");
                }
            }
            catch (FileNotFoundException e) {
                this.LOG.severe(lastRecordedInstallTimestampFile + " not found although it was supposed to have been created!");
                return;
            }
        }
        try {
            ArrayList<File> pluginProviderDirs = new ArrayList<File>();
            BufferedReader br = new BufferedReader(new FileReader(installedProductsFile));
            String nextLine = br.readLine();
            while (nextLine != null) {
                if (!nextLine.startsWith("#")) {
                    pluginProviderDirs.add(new File(mwHomeDir, nextLine.trim()));
                }
                nextLine = br.readLine();
            }
            Iterator iterator = pluginProviderDirs.iterator();
            while (iterator.hasNext()) {
                File productDirectory = (File)iterator.next();
                File clusterDirectory = new File(productDirectory, "plugins" + File.separator + consumingProductName);
                if (clusterDirectory.exists()) {
                    this.m_dynamicClusters.add(clusterDirectory.getAbsolutePath());
                    continue;
                }
                this.LOG.severe(clusterDirectory + " was recorded as a JDev cluster directory but the directory didn't exist");
            }
            return;
        }
        catch (FileNotFoundException e) {
            this.LOG.severe(lastRecordedInstallTimestampFile + " not found although it was supposed to have been created. Some extensions may not be visible. Run with -J-Doracle.install.rescan=true to work around the issue");
            return;
        }
        catch (IOException e) {
            this.LOG.log(Level.SEVERE, "failed to read from " + lastRecordedInstallTimestampFile, e);
        }
    }

    private Collection<String> scanAndPopulateClusters(File mwHomeDir, File productHomeDir, Collection<String> dynamicClusters) {
        File[] directories;
        final String consumingProductName = productHomeDir.getName();
        ArrayList<String> mwhPluginProviders = new ArrayList<String>();
        for (File productDirectory : directories = mwHomeDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && new File(pathname, "plugins" + File.separator + consumingProductName).exists();
            }
        })) {
            File clusterDirectory = new File(productDirectory, "plugins" + File.separator + consumingProductName);
            dynamicClusters.add(clusterDirectory.getAbsolutePath());
            mwhPluginProviders.add(productDirectory.getName());
        }
        return mwhPluginProviders;
    }

    public Collection<String> getDynamicClusters() {
        return this.m_dynamicClusters;
    }

    public Collection<String> getConfigurationAreas() {
        ArrayList<String> configAreas = new ArrayList<String>();
        configAreas.add(IdeBootProperties.getOsgiConfigurationArea());
        for (String clusterDir : this.m_dynamicClusters) {
            File configurationDirectory = new File(clusterDir, "configuration");
            if (configurationDirectory.exists() && configurationDirectory.isDirectory()) {
                configAreas.add("file:" + configurationDirectory.getAbsolutePath());
                continue;
            }
            this.LOG.fine(clusterDir + " was discovered as an installation cluster, but did not contain a 'configuration' directory under it. If it is a directory not providing an OSGi bundles, this is a valid state, but if not sure the directory exists, and that it contains *bundles.info files in it, which advertise the jars that are to be included in this cluster");
        }
        return configAreas;
    }
}

