/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.table;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.table.DefaultTableCellRenderer;

public final class CellUtils {
    private static final EmptyBorder UNFOCUSED_BORDER = new EmptyBorder(1, 1, 1, 1);

    private CellUtils() {
    }

    public static JLabel createLabelRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            }
        };
    }

    public static JCheckBox createCheckBoxRenderer() {
        return CellUtils.initCheckBox(new JCheckBox(){

            @Override
            public void validate() {
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
            }

            @Override
            public void repaint(Rectangle r) {
            }

            @Override
            public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }
        });
    }

    public static JCheckBox initCheckBox(JCheckBox cb) {
        cb.setHorizontalAlignment(0);
        cb.setBorderPaintedFlat(true);
        cb.setBorderPainted(true);
        cb.setFocusPainted(false);
        String laf = UIManager.getLookAndFeel().getName();
        if ("Oracle Look and Feel".equals(laf)) {
            cb.setUI(new BasicCheckBoxUI());
        }
        return cb;
    }

    public static JRadioButton createRadioButtonRenderer() {
        return CellUtils.initRadioButton(new JRadioButton(){

            @Override
            public void validate() {
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
            }

            @Override
            public void repaint(Rectangle r) {
            }

            @Override
            public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }
        });
    }

    public static JRadioButton initRadioButton(JRadioButton rb) {
        rb.setHorizontalAlignment(0);
        rb.setBorderPainted(true);
        rb.setFocusPainted(false);
        rb.setUI(new BasicRadioButtonUI());
        return rb;
    }

    public static void setUpRenderer(JComponent renderer, JTable table, boolean isSelected, boolean hasFocus, boolean canEdit) {
        if (isSelected) {
            renderer.setForeground(table.getSelectionForeground());
            renderer.setBackground(table.getSelectionBackground());
        } else {
            renderer.setForeground(table.getForeground());
            renderer.setBackground(table.getBackground());
        }
        CellUtils.setOpaque(renderer, isSelected);
        if (hasFocus) {
            renderer.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (canEdit) {
                renderer.setForeground(UIManager.getColor("Table.focusCellForeground"));
                renderer.setBackground(UIManager.getColor("Table.focusCellBackground"));
                CellUtils.setOpaque(renderer, table.isOpaque());
            }
        } else {
            renderer.setBorder(UNFOCUSED_BORDER);
        }
        renderer.setFont(table.getFont());
    }

    public static void setUpEditor(JComponent editor, JTable table) {
        editor.setBorder(new LineBorder(table.getForeground()));
        CellUtils.setOpaque(editor, table.isOpaque());
        editor.setForeground(table.getForeground());
        editor.setBackground(table.getBackground());
        editor.setFont(table.getFont());
    }

    private static void setOpaque(JComponent component, boolean opaque) {
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setContentAreaFilled(opaque);
        } else {
            component.setOpaque(opaque);
        }
    }

    public static boolean processKeyBinding(Component component, KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (component instanceof JComponent) {
            try {
                Method m = JComponent.class.getDeclaredMethod("processKeyBinding", KeyStroke.class, KeyEvent.class, Integer.TYPE, Boolean.TYPE);
                m.setAccessible(true);
                Object[] args = new Object[]{ks, e, 0, pressed ? Boolean.TRUE : Boolean.FALSE};
                Object result = m.invoke((Object)component, args);
                if (Boolean.FALSE.equals(result)) {
                    args[2] = 1;
                    result = m.invoke((Object)component, args);
                }
                return Boolean.TRUE.equals(result);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }
}

