/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.ide.datatransfer;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.bm.ide.datatransfer.LazySelectorNode;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.bm.javatools.datatransfer.FlavorSelector;
import oracle.bm.javatools.datatransfer.SelectorNode;
import oracle.bm.javatools.util.MultivaluedMap;

public class LazySelector
implements FlavorSelector {
    private MetaClass<FlavorSelector> m_selectorClass;
    private FlavorSelector m_selector;
    private MultivaluedMap<Flavor, FlavorSelector> m_selectors = new MultivaluedMap();

    public LazySelector(MetaClass<FlavorSelector> selectorClass) {
        if (selectorClass == null) {
            throw new IllegalArgumentException("Missing selector class");
        }
        this.m_selectorClass = selectorClass;
    }

    @Override
    public void addSelector(Flavor flavor, FlavorSelector selector) {
        if (this.m_selector == null) {
            this.m_selectors.put(flavor, selector);
        } else {
            this.m_selector.addSelector(flavor, selector);
        }
    }

    @Override
    public <T> SelectorNode<T> createSelectorNode() {
        return this.m_selector == null ? new LazySelectorNode(this) : this.m_selector.createSelectorNode();
    }

    FlavorSelector getSelector() {
        if (this.m_selector == null) {
            try {
                this.m_selector = (FlavorSelector)this.m_selectorClass.newInstance();
                for (Map.Entry<Flavor, FlavorSelector> e : this.m_selectors.entries()) {
                    this.m_selector.addSelector(e.getKey(), e.getValue());
                }
                this.m_selectors = null;
            }
            catch (Exception e) {
                Logger.getLogger("oracle.bm.ide.datatransfer").log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.m_selector;
    }
}

