/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.net.URLPath;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.util.Maps;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryChange;
import oracle.jdeveloper.library.LibraryEvent;
import oracle.jdeveloper.library.LibraryEventSource;
import oracle.jdeveloper.library.LibraryListener;
import oracle.jdeveloper.library.UnresolvedLibrary;
import oracle.jdevimpl.library.AbstractLibraryEventSource;
import oracle.jdevimpl.library.LibraryChangeImpl;
import oracle.jdevimpl.library.LibraryContainer;
import oracle.jdevimpl.library.PropertyChangeEventProvider;

abstract class LibraryContainerEventSource
extends AbstractLibraryEventSource {
    private static final Map<LibraryContainer, LibraryContainerEventSource> INSTANCES = new Maps.CacheMap(Maps.CacheMap.WEAK);
    private final LibraryContainer container;
    private final LibraryListener libraryManagerListener = new LibraryManagerListener();
    private final Set<Object> addedAsExported = Collections.synchronizedSet(new HashSet());
    private final Set<Object> addedAsModule = Collections.synchronizedSet(new HashSet());
    private final Set<Object> broken = Collections.synchronizedSet(new HashSet());

    protected static LibraryContainerEventSource getCachedInstance(LibraryContainer container) {
        return INSTANCES.get(container);
    }

    protected static void putCachedInstance(LibraryContainer container, LibraryContainerEventSource source) {
        INSTANCES.put(container, source);
    }

    protected LibraryContainerEventSource(LibraryContainer container) {
        this.container = container;
    }

    protected LibraryContainer getLibraryContainer() {
        return this.container;
    }

    protected abstract Context getContext();

    @Override
    public void attach() {
        this.initBrokenReferences();
        this.attachLibraryManagerListener();
    }

    @Override
    public void detach() {
        this.broken.clear();
        this.detachLibraryManagerListener();
    }

    private void initBrokenReferences() {
        for (JLibrary library : this.container.getLibraryReferences()) {
            if (!(library instanceof UnresolvedLibrary)) continue;
            this.broken.add(library.getID());
        }
    }

    private void attachLibraryManagerListener() {
        this.getLibraryManagerEventSource().addLibraryListener(this.libraryManagerListener);
    }

    private void detachLibraryManagerListener() {
        this.getLibraryManagerEventSource().removeLibraryListener(this.libraryManagerListener);
    }

    private LibraryEventSource getLibraryManagerEventSource() {
        JLibraryManager libraryManager = JLibraryManager.getInstance();
        assert (libraryManager != null);
        LibraryEventSource source = (LibraryEventSource)AdapterManager.Factory.getAdapterManager().adapt((Object)libraryManager, LibraryEventSource.class);
        assert (source != null);
        return source;
    }

    private static boolean hasLibrary(Collection<JLibrary> libraries, Object id) {
        for (JLibrary library : libraries) {
            if (!id.equals(library.getID())) continue;
            return true;
        }
        return false;
    }

    private final class LibraryManagerListener
    implements LibraryListener {
        private LibraryManagerListener() {
        }

        @Override
        public void librariesChanged(LibraryEvent e) {
            ArrayList<LibraryChange> changes = new ArrayList<LibraryChange>();
            block0: for (LibraryChange change : e.getLibraryChanges()) {
                Object id = change.getID();
                for (JLibrary library : LibraryContainerEventSource.this.container.getLibraryReferences()) {
                    if (!id.equals(library.getID())) continue;
                    if (change.getType() == LibraryChange.Type.ADDED && LibraryContainerEventSource.this.broken.remove(id)) {
                        changes.add(new LibraryChangeImpl(LibraryChange.Type.FIXED, id));
                        continue block0;
                    }
                    if (change.getType() == LibraryChange.Type.REMOVED && LibraryContainerEventSource.this.broken.add(id)) {
                        changes.add(new LibraryChangeImpl(LibraryChange.Type.BROKEN, id));
                        continue block0;
                    }
                    if (LibraryContainerEventSource.this.broken.contains(id)) continue block0;
                    changes.add(change);
                    continue block0;
                }
            }
            if (!changes.isEmpty()) {
                LibraryContainerEventSource.this.fireLibraryEvent(new LibraryEvent(LibraryContainerEventSource.this.getContext(), changes));
            }
        }
    }

    protected static final class AsModuleListener
    extends AbstractReferenceListener {
        protected AsModuleListener() {
        }

        @Override
        public Collection<LibraryChange> getLibraryChanges(LibraryContainerEventSource source, Collection<Object> added, Collection<Object> removed) {
            LibraryContainer container = source.getLibraryContainer();
            Collection<JLibrary> libraries = container.getLibraryReferences();
            ArrayList<LibraryChange> changes = new ArrayList<LibraryChange>();
            for (Object id : added) {
                if (source.addedAsModule.contains(id)) continue;
                JLibrary library = container.resolveLibrary(id);
                PropertyChangeEvent event = new PropertyChangeEvent(library, "modulePathLibraries", false, true);
                PropertyChangeEventProvider provider = PropertyChangeEventProvider.get(event);
                changes.add(new LibraryChangeImpl(LibraryChange.Type.PROPERTIES_CHANGED, id, provider));
            }
            block1: for (Object id : removed) {
                source.addedAsModule.remove(id);
                for (JLibrary library : libraries) {
                    if (!id.equals(library.getID())) continue;
                    PropertyChangeEvent event = new PropertyChangeEvent(library, "modulePathLibraries", true, false);
                    PropertyChangeEventProvider provider = PropertyChangeEventProvider.get(event);
                    changes.add(new LibraryChangeImpl(LibraryChange.Type.PROPERTIES_CHANGED, id, provider));
                    continue block1;
                }
            }
            return changes;
        }
    }

    protected static final class ExportListener
    extends AbstractReferenceListener {
        protected ExportListener() {
        }

        @Override
        public Collection<LibraryChange> getLibraryChanges(LibraryContainerEventSource source, Collection<Object> added, Collection<Object> removed) {
            LibraryContainer container = source.getLibraryContainer();
            Collection<JLibrary> libraries = container.getLibraryReferences();
            ArrayList<LibraryChange> changes = new ArrayList<LibraryChange>();
            for (Object id : added) {
                if (source.addedAsExported.contains(id)) continue;
                JLibrary library = container.resolveLibrary(id);
                PropertyChangeEvent event = new PropertyChangeEvent(library, "exportedReferences", false, true);
                PropertyChangeEventProvider provider = PropertyChangeEventProvider.get(event);
                changes.add(new LibraryChangeImpl(LibraryChange.Type.PROPERTIES_CHANGED, id, provider));
            }
            block1: for (Object id : removed) {
                source.addedAsExported.remove(id);
                for (JLibrary library : libraries) {
                    if (!id.equals(library.getID())) continue;
                    PropertyChangeEvent event = new PropertyChangeEvent(library, "exportedReferences", true, false);
                    PropertyChangeEventProvider provider = PropertyChangeEventProvider.get(event);
                    changes.add(new LibraryChangeImpl(LibraryChange.Type.PROPERTIES_CHANGED, id, provider));
                    continue block1;
                }
            }
            return changes;
        }
    }

    protected static final class ReferenceListener
    extends AbstractReferenceListener {
        protected ReferenceListener() {
        }

        @Override
        public Collection<LibraryChange> getLibraryChanges(LibraryContainerEventSource source, Collection<Object> added, Collection<Object> removed) {
            LibraryContainer container = source.getLibraryContainer();
            Collection<JLibrary> exports = container.getExportedReferences();
            Collection<JLibrary> modulePathLibraries = container.getModulePathReferences();
            ArrayList<LibraryChange> changes = new ArrayList<LibraryChange>();
            for (Object id : added) {
                if (LibraryContainerEventSource.hasLibrary(exports, id)) {
                    source.addedAsExported.add(id);
                }
                if (LibraryContainerEventSource.hasLibrary(modulePathLibraries, id)) {
                    source.addedAsModule.add(id);
                }
                changes.add(new LibraryChangeImpl(LibraryChange.Type.ADDED, id));
            }
            for (Object id : removed) {
                source.broken.remove(id);
                source.addedAsExported.remove(id);
                source.addedAsModule.remove(id);
                changes.add(new LibraryChangeImpl(LibraryChange.Type.REMOVED, id));
            }
            return changes;
        }
    }

    private static abstract class AbstractReferenceListener
    extends LibraryContainerListener {
        private AbstractReferenceListener() {
        }

        protected abstract Collection<LibraryChange> getLibraryChanges(LibraryContainerEventSource var1, Collection<Object> var2, Collection<Object> var3);

        @Override
        protected Collection<LibraryChange> getLibraryChanges(LibraryContainerEventSource source, ChangeInfo[] details) {
            LinkedHashSet<Object> added = new LinkedHashSet<Object>();
            LinkedHashSet<Object> removed = new LinkedHashSet<Object>();
            for (ChangeInfo info : details) {
                this.processChange(info, added, removed);
            }
            this.reduce(added, removed);
            if (!added.isEmpty() || !removed.isEmpty()) {
                return this.getLibraryChanges(source, added, removed);
            }
            return Collections.emptySet();
        }

        private void processChange(ChangeInfo info, Set<Object> added, Set<Object> removed) {
            block8: {
                block6: {
                    HashStructure hash;
                    block7: {
                        if (1 != info.getChangeType()) break block6;
                        hash = info.getNewValueAsHashStructure();
                        if (hash == null) break block7;
                        added.add(this.getID(hash));
                        break block8;
                    }
                    ListStructure list = info.getNewValueAsListStructure();
                    if (list == null) break block8;
                    for (Object o : list) {
                        if (!(o instanceof HashStructure)) continue;
                        added.add(this.getID(hash));
                    }
                    break block8;
                }
                if (3 == info.getChangeType()) {
                    HashStructure hash = info.getOldValueAsHashStructure();
                    if (hash != null) {
                        removed.add(this.getID(hash));
                    } else {
                        ListStructure list = info.getOldValueAsListStructure();
                        if (list != null) {
                            for (Object o : list) {
                                if (!(o instanceof HashStructure)) continue;
                                removed.add(this.getID(hash));
                            }
                        }
                    }
                }
            }
        }

        private Object getID(HashStructure hash) {
            return hash.getObject("id");
        }

        private <T> void reduce(Set<T> one, Set<T> two) {
            LinkedHashSet<T> intersection = new LinkedHashSet<T>(one);
            intersection.retainAll(two);
            one.removeAll(intersection);
            two.removeAll(intersection);
        }
    }

    private static final class LibraryPathChange {
        private final URL[] newPath;
        private URL[] added;
        private URL[] removed;

        LibraryPathChange(URL[] newPath) {
            this.newPath = newPath;
        }

        public void added(int entryNum, URL url) {
            if (this.added == null) {
                this.added = new URL[entryNum + 1];
            } else if (entryNum >= this.added.length) {
                this.added = Arrays.copyOf(this.added, entryNum + 1);
            }
            this.added[entryNum] = url;
        }

        public void removed(int entryNum, URL url) {
            if (this.removed == null) {
                this.removed = new URL[entryNum + 1];
            } else if (entryNum >= this.removed.length) {
                this.removed = Arrays.copyOf(this.removed, entryNum + 1);
            }
            this.removed[entryNum] = url;
        }

        public URLPath getNewPath() {
            return new URLPath(this.newPath);
        }

        public URLPath getOldPath() {
            int i;
            int len = this.newPath.length;
            if (this.added != null) {
                len = Math.max(len, this.added.length);
            }
            if (this.removed != null) {
                len = Math.max(len, this.removed.length);
            }
            URL[] oldPath = Arrays.copyOf(this.newPath, len);
            if (this.added != null) {
                for (i = 0; i < this.added.length; ++i) {
                    if (this.added[i] == null) continue;
                    oldPath[i] = null;
                }
            }
            if (this.removed != null) {
                for (i = 0; i < this.removed.length; ++i) {
                    if (this.removed[i] == null) continue;
                    if (oldPath[i] != null) {
                        oldPath = Arrays.copyOf(oldPath, oldPath.length + 1);
                        System.arraycopy(oldPath, i, oldPath, i + 1, oldPath.length - i - 1);
                    }
                    oldPath[i] = this.removed[i];
                }
            }
            return new URLPath(oldPath);
        }
    }

    protected static final class DefinitionListener
    extends LibraryContainerListener {
        protected DefinitionListener() {
        }

        @Override
        public Collection<LibraryChange> getLibraryChanges(LibraryContainerEventSource source, ChangeInfo[] details) {
            LibraryContainer container = source.getLibraryContainer();
            List libList = container.getLibraryDefinitions().getLibraryList();
            MultiMap events = new MultiMap();
            HashMap<Integer, Map<String, LibraryPathChange>> pathChanges = new HashMap<Integer, Map<String, LibraryPathChange>>();
            for (ChangeInfo info : details) {
                Library library;
                int libNum;
                String[] split = info.getPropertyName().split("/");
                if (split.length == 5 && "deployedByDefault".equals(split[4])) {
                    Boolean newValue;
                    libNum = Integer.parseInt(split[3]);
                    library = (Library)libList.get(libNum);
                    if (!container.hasLibrary(library.getID())) continue;
                    Boolean oldValue = info.getOldValueAsBoolean();
                    if (oldValue == null) {
                        oldValue = Boolean.FALSE;
                    }
                    if ((newValue = info.getNewValueAsBoolean()) == null) {
                        newValue = Boolean.FALSE;
                    }
                    events.add((Object)libNum, (Object)new PropertyChangeEvent(library, "deployedByDefault", oldValue, newValue));
                    continue;
                }
                if (split.length != 6 || !this.isPathChange(split[4]) || info.getParentStructureType() != 1 || !container.hasLibrary((library = (Library)libList.get(libNum = Integer.parseInt(split[3]))).getID())) continue;
                LibraryPathChange paths = this.getLibraryPathChange(libNum, split[4], info, pathChanges);
                int entryNum = Integer.parseInt(split[5]);
                if (1 == info.getChangeType()) {
                    paths.added(entryNum, info.getNewValueAsURL());
                    continue;
                }
                if (3 != info.getChangeType()) continue;
                paths.removed(entryNum, info.getOldValueAsURL());
            }
            this.convertPathChangesToEvents(pathChanges, (MultiMap<Integer, PropertyChangeEvent>)events, libList);
            return this.getLibraryChanges((MultiMap<Integer, PropertyChangeEvent>)events, libList);
        }

        private boolean isPathChange(String property) {
            return "classPath".equals(property) || "sourcePath".equals(property) || "docPath".equals(property);
        }

        private LibraryPathChange getLibraryPathChange(int libNum, String property, ChangeInfo info, Map<Integer, Map<String, LibraryPathChange>> pathChanges) {
            LibraryPathChange paths;
            Map<String, LibraryPathChange> libMap = pathChanges.get(libNum);
            if (libMap == null) {
                libMap = new HashMap<String, LibraryPathChange>();
                pathChanges.put(libNum, libMap);
            }
            if ((paths = libMap.get(property)) == null) {
                ListStructure list = info.getParentAsListStructure();
                URL[] newPath = new URLPath(list).getEntries();
                paths = new LibraryPathChange(newPath);
                libMap.put(property, paths);
            }
            return paths;
        }

        private void convertPathChangesToEvents(Map<Integer, Map<String, LibraryPathChange>> pathChanges, MultiMap<Integer, PropertyChangeEvent> events, List libList) {
            if (!pathChanges.isEmpty()) {
                for (Map.Entry<Integer, Map<String, LibraryPathChange>> libEntry : pathChanges.entrySet()) {
                    int libNum = libEntry.getKey();
                    for (Map.Entry<String, LibraryPathChange> pathEntry : libEntry.getValue().entrySet()) {
                        String property = pathEntry.getKey();
                        LibraryPathChange pathChange = pathEntry.getValue();
                        Library library = (Library)libList.get(libNum);
                        events.add((Object)libNum, (Object)new PropertyChangeEvent(library, property, pathChange.getOldPath(), pathChange.getNewPath()));
                    }
                }
            }
        }

        private Collection<LibraryChange> getLibraryChanges(MultiMap<Integer, PropertyChangeEvent> events, List libList) {
            if (!events.isEmpty()) {
                ArrayList<LibraryChange> ret = new ArrayList<LibraryChange>();
                for (Map.Entry entry : events.entrySet()) {
                    PropertyChangeEventProvider provider = PropertyChangeEventProvider.get((Collection)entry.getValue());
                    Library library = (Library)libList.get((Integer)entry.getKey());
                    Object id = library.getID();
                    ret.add(new LibraryChangeImpl(LibraryChange.Type.PROPERTIES_CHANGED, id, provider));
                }
                return ret;
            }
            return Collections.emptySet();
        }
    }

    protected static abstract class LibraryContainerListener {
        protected LibraryContainerListener() {
        }

        protected abstract Collection<LibraryChange> getLibraryChanges(LibraryContainerEventSource var1, ChangeInfo[] var2);

        public void containerPropertiesChanged(LibraryContainerEventSource source, StructureChangeEvent event) {
            Collection<LibraryChange> changes = this.getLibraryChanges(source, event.getChangeDetails());
            if (!changes.isEmpty()) {
                source.fireLibraryEvent(new LibraryEvent(source.getContext(), changes));
            }
        }
    }
}

