/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryChange;
import oracle.jdeveloper.library.LibraryEvent;
import oracle.jdevimpl.library.AbstractLibraryEventSource;
import oracle.jdevimpl.library.LibraryChangeImpl;
import oracle.jdevimpl.library.PropertyChangeEventProvider;

public class JLibraryManagerEventSource
extends AbstractLibraryEventSource
implements Observer {
    public void update(Object observed, UpdateMessage change) {
        int messageId = change.getMessageID();
        if (messageId == UpdateMessage.PROPERTY_SET) {
            if (observed instanceof Library && !(observed instanceof JDK)) {
                Library library = (Library)observed;
                Object id = library.getID();
                LibraryChangeImpl libChange = new LibraryChangeImpl(LibraryChange.Type.PROPERTIES_CHANGED, id, PropertyChangeEventProvider.get(change));
                LibraryEvent event = new LibraryEvent(JLibraryManagerEventSource.getContext(), libChange);
                this.fireLibraryEvent(event);
            }
        } else if (messageId == UpdateMessage.CHILD_ADDED) {
            if (observed instanceof JLibraryManager) {
                ArrayList<LibraryChange> changes = new ArrayList<LibraryChange>();
                for (Object o : change.getAddObjects()) {
                    if (!(o instanceof Library) || o instanceof JDK) continue;
                    Library library = (Library)o;
                    Object id = library.getID();
                    changes.add(new LibraryChangeImpl(LibraryChange.Type.ADDED, id, PropertyChangeEventProvider.get(change)));
                }
                LibraryEvent event = new LibraryEvent(JLibraryManagerEventSource.getContext(), changes);
                this.fireLibraryEvent(event);
            }
        } else if (messageId == UpdateMessage.CHILD_REMOVED && observed instanceof JLibraryManager) {
            ArrayList<LibraryChange> changes = new ArrayList<LibraryChange>();
            for (Object o : change.getRemoveObjects()) {
                if (!(o instanceof Library) || o instanceof JDK) continue;
                Library library = (Library)o;
                Object id = library.getID();
                changes.add(new LibraryChangeImpl(LibraryChange.Type.REMOVED, id, PropertyChangeEventProvider.get(change)));
            }
            LibraryEvent event = new LibraryEvent(JLibraryManagerEventSource.getContext(), changes);
            this.fireLibraryEvent(event);
        }
    }

    @Override
    public void attach() {
        JLibraryManager.getInstance().attach(this);
    }

    @Override
    public void detach() {
        JLibraryManager.getInstance().detach(this);
    }

    private static Context getContext() {
        return new Context();
    }
}

