/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingWorker;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.java.locator.ModularizedJdkJrtfsLocator;
import oracle.jdeveloper.library.AddinLibraryList;
import oracle.jdeveloper.library.DerivedLibrary;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKAdapter;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.library.ProjectLibraryChangeEvent;
import oracle.jdeveloper.library.ProjectLibraryChangeListener;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdeveloper.resource.LibraryArb;
import oracle.jdevimpl.library.ApplicationContentLibraryProvider;
import oracle.jdevimpl.library.LibrariesHook;
import oracle.jdevimpl.library.ProjectChangeSink;

public final class JLibraryManager
implements Subject {
    @Deprecated
    public static final String LEGACY_LIBRARY_FILE = "library.ini";
    public static final String LIBRARY_LIST_FILE = "libraries.xml";
    public static final String LIBRARY_EXTENSION = ".library";
    public static final String JDK_EXTENSION = ".jdk";
    public static final int LIBRARY_ADDED = UpdateMessage.newMessageID((String)"JLibraryManager.LIBRARY_ADDED");
    public static final int LIBRARY_REMOVED = UpdateMessage.newMessageID((String)"JLibraryManager.LIBRARY_REMOVED");
    public static final String SETTINGS_KEY = "LibraryManagerOptions";
    private static final ConcurrentMap<URLKey, JLibraryList> LISTS = new ConcurrentHashMap<URLKey, JLibraryList>();
    private static boolean listsLoaded;
    private static final JLibraryManager _INSTANCE;
    private static JLibraryList _userLibs;
    private static AddinLibraryList _addinLibs;
    private static IdeSubject _delegate;
    private static ConcurrentMap<Class<?>, Class<? extends DerivedLibrary>> _dependableRegistry;
    private static JDK _defaultJDK;
    private static boolean _initializingDefaultJDK;
    private static ConcurrentMap<URLKey, URLKey> _checkedJDKs;
    private final List<DynamicLibraryProvider> _dynamicProviders = new CopyOnWriteArrayList<ApplicationContentLibraryProvider>(Collections.singleton(new ApplicationContentLibraryProvider()));
    private final ProjectChangeSink projectChangeSink = new ProjectChangeSink();

    private static synchronized void loadLibraryLists() {
        if (!listsLoaded) {
            URL[] urls;
            listsLoaded = true;
            ClientSetting settings = ClientSetting.findOrCreate((String)ProductInformation.getProductID());
            URLPath path = (URLPath)(settings != null ? settings.getData(SETTINGS_KEY) : null);
            if (path != null && (urls = path.getEntries()) != null) {
                for (URL url : urls) {
                    LISTS.put(URLKey.getInstance((URL)url), new JLibraryList(url));
                }
            }
            ExitCommand.addShutdownHook((ShutdownHook)new ShutdownHook(){

                public boolean canShutdown() {
                    return true;
                }

                public void shutdown() {
                    JLibraryManager.saveLibraryLists();
                }
            });
        }
    }

    private static void saveLibraryLists() {
        ClientSetting setting = ClientSetting.findOrCreate((String)ProductInformation.getProductID());
        if (setting != null) {
            URLPath path = new URLPath();
            JLibraryManager.loadLibraryLists();
            LISTS.forEach((key, list) -> path.add(list.getURL()));
            setting.putData(SETTINGS_KEY, (Copyable)path);
        }
    }

    private JLibraryManager() {
    }

    @Deprecated
    public void registerDynamicLibraryProvider(DynamicLibraryProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider is null");
        }
        this._dynamicProviders.add(provider);
    }

    @Deprecated
    public void unregisterDynamicLibraryProvider(DynamicLibraryProvider provider) {
        this._dynamicProviders.remove(provider);
    }

    public Collection<DynamicLibraryProvider> getDynamicLibraryProviders(String[] technologyKeys) {
        ArrayList<DynamicLibraryProvider> providers = new ArrayList<DynamicLibraryProvider>(LibrariesHook.getInstance().getDynamicLibraryProviders(technologyKeys));
        providers.addAll(this._dynamicProviders);
        return Collections.unmodifiableCollection(providers);
    }

    Class<? extends DerivedLibrary> getDerivedLibraryClass(Element source) {
        Object data;
        Object object = data = source != null ? source.getData() : null;
        if (data != null) {
            Class<?> dataClass = data.getClass();
            Class<? extends DerivedLibrary> hookClass = LibrariesHook.getInstance().getDerivedLibraryClass(dataClass);
            if (hookClass != null) {
                return hookClass;
            }
            for (Map.Entry entry : _dependableRegistry.entrySet()) {
                try {
                    Class key = (Class)entry.getKey();
                    if (!key.isAssignableFrom(dataClass)) continue;
                    return (Class)entry.getValue();
                }
                catch (IllegalStateException ise) {
                }
            }
        }
        return null;
    }

    public static JLibraryManager getInstance() {
        return _INSTANCE;
    }

    public static LibraryList[] getAllLibraryLists() {
        JLibraryManager.loadLibraryLists();
        ArrayList<LibraryList> lists = new ArrayList<LibraryList>();
        lists.add(JLibraryManager.getAddinLibraries());
        lists.add(JLibraryManager.getUserLibraries());
        LISTS.forEach((key, list) -> lists.add((LibraryList)list));
        return lists.toArray(new LibraryList[lists.size()]);
    }

    @Deprecated
    public static List getLibraries() {
        LibraryList[] libLists = JLibraryManager.getAllLibraryLists();
        ArrayList result = new ArrayList();
        for (int i = 0; i < libLists.length; ++i) {
            List list = libLists[i].getLibraryList();
            result.addAll(list);
        }
        return result;
    }

    @Deprecated
    public static List getJDKs() {
        LibraryList[] libLists = JLibraryManager.getAllLibraryLists();
        ArrayList result = new ArrayList();
        for (int i = 0; i < libLists.length; ++i) {
            List list = libLists[i].getJdkList();
            result.addAll(list);
        }
        return result;
    }

    public static synchronized JDK getDefaultJDK() {
        if (_defaultJDK == null) {
            _initializingDefaultJDK = true;
            _defaultJDK = JLibraryManager.findOrCreateDefaultJDK();
        }
        return _defaultJDK;
    }

    public static JLibrary createLibrary(Object id, MutableLibraryList list) {
        JLibrary lib = null;
        if (list != null && list.findLibrary(id) == null) {
            lib = list.addLibrary(null);
        }
        return lib;
    }

    public static JLibrary findLibrary(Object id) {
        JLibrary lib = JLibraryManager.getUserLibraries().findLibrary(id);
        if (lib == null && (lib = JLibraryManager.getAddinLibraries().findLibrary(id)) == null) {
            try {
                URL url = URLFactory.newURL((URL)JLibraryManager.getUserLibraries().getURL(), (String)(id.toString() + LIBRARY_EXTENSION));
                lib = JLibraryManager.getUserLibraries().findLibrary(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lib;
    }

    public static void removeLibrary(JLibrary lib, MutableLibraryList list) {
        if (lib != null && list != null && list.remove(lib)) {
            UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            msg.getRemoveObjects().add(lib);
            JLibraryManager.getInstance().notifyObservers(JLibraryManager.getInstance(), msg);
        }
    }

    public static JDK createJDK(Object id, URL javaExe, MutableLibraryList list) {
        JDK jdk = null;
        if (javaExe != null && list != null && list.findJDK(id) == null && (jdk = list.addJDK(null, javaExe)) != null) {
            UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_ADDED, null);
            msg.getAddObjects().add(jdk);
            JLibraryManager.getInstance().notifyObservers(JLibraryManager.getInstance(), msg);
        }
        return jdk;
    }

    public static JDK findJDK(Object id) {
        JDK jdk = JLibraryManager.getUserLibraries().findJDK(id);
        if (jdk == null && (jdk = JLibraryManager.getAddinLibraries().findJDK(id)) == null) {
            try {
                URL url = URLFactory.newURL((URL)JLibraryManager.getUserLibraries().getURL(), (String)(id.toString() + JDK_EXTENSION));
                jdk = JLibraryManager.getUserLibraries().findJDK(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jdk;
    }

    public static JDK findJDK(VersionNumber num, JDK[] jdks) {
        JDK previousVer = null;
        JDK nextVer = null;
        JDK result = null;
        if (num != null) {
            for (int i = 0; i < jdks.length; ++i) {
                VersionNumber jdkVer = jdks[i].getJavaVersion();
                if (jdkVer == null) continue;
                if (jdkVer.equals((Object)num)) {
                    result = jdks[i];
                    break;
                }
                if (jdkVer.isBefore(num, false)) {
                    if (previousVer != null && !previousVer.getJavaVersion().isBefore(jdkVer, false)) continue;
                    previousVer = jdks[i];
                    continue;
                }
                if (nextVer != null && !nextVer.getJavaVersion().isBefore(jdkVer, false)) continue;
                nextVer = jdks[i];
            }
            if (result == null && (result = JLibraryManager.getDefaultJDK()) == null) {
                result = nextVer != null ? nextVer : previousVer;
            }
        }
        return result;
    }

    public static JDK findJDKMatch(Object id, VersionNumber num) {
        JDK jdk = JLibraryManager.findJDK(id);
        if (jdk == null) {
            List list = JLibraryManager.getJDKs();
            JDK[] jdks = list.toArray(new JDK[list.size()]);
            jdk = JLibraryManager.findJDK(num, jdks);
        }
        return jdk;
    }

    public static void removeJDK(JDK jdk, MutableLibraryList list) {
        if (jdk != null && list != null && list.remove(jdk)) {
            UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            msg.getRemoveObjects().add(jdk);
            JLibraryManager.getInstance().notifyObservers(JLibraryManager.getInstance(), msg);
        }
    }

    public static JLibraryList addLibraryList(URL url) {
        JLibraryList list = null;
        if (url != null) {
            if (URLFileSystem.equals((URL)url, (URL)JLibraryManager.getUserLibraries().getURL())) {
                return JLibraryManager.getUserLibraries();
            }
            JLibraryManager.loadLibraryLists();
            list = new JLibraryList(url);
            JLibraryList oldList = LISTS.putIfAbsent(URLKey.getInstance((URL)url), list);
            return oldList == null ? list : oldList;
        }
        return null;
    }

    public static boolean removeLibraryList(LibraryList list) {
        if (list instanceof JLibraryList) {
            JLibraryManager.loadLibraryLists();
            URLKey key = URLKey.getInstance((URL)((JLibraryList)list).getURL());
            return LISTS.remove(key) != null;
        }
        return false;
    }

    public static synchronized JLibraryList getUserLibraries() {
        if (_userLibs == null) {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            URL dir = er.getSystemDirectory(Ide.getProductID());
            _userLibs = JLibraryManager._createLibraryList(dir);
            _userLibs.setListName(JLibraryList.USER_LIBRARIES);
            if (!_initializingDefaultJDK) {
                JLibraryManager.getDefaultJDK();
            }
        }
        return _userLibs;
    }

    public static AddinLibraryList getAddinLibraries() {
        return _addinLibs;
    }

    @Deprecated
    public static void registerDerivedLibrary(Class key, Class<? extends DerivedLibrary> cls) {
        _dependableRegistry.putIfAbsent(key, cls);
    }

    @Deprecated
    public static void unregisterDerivedLibrary(Class key) {
        _dependableRegistry.remove(key);
    }

    private static URL javaExecutableNoSuffix(URL exeURL) {
        return URLFactory.newFileURL((String)URLFileSystem.getPathNoExt((URL)exeURL));
    }

    static void checkJDK(Project project) {
        new CheckJdkWorker(project).execute();
    }

    private static JDK findOrCreateDefaultJDK() {
        String home = System.getProperty("java.home");
        String ver = System.getProperty("java.version");
        URL homeURL = URLFactory.newDirURL((String)home);
        URL binURL = URLFactory.newDirURL((URL)homeURL, (String)"bin");
        URL exeURL = URLFactory.newURL((URL)binURL, (String)"java.exe");
        if (!URLFileSystem.exists((URL)exeURL)) {
            exeURL = URLFactory.newURL((URL)binURL, (String)"java");
        }
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL temp = URLFactory.newURL((URL)er.getSystemDirectory(Ide.getProductID()), (String)(ver + JDK_EXTENSION));
        JDK usrJDK = JLibraryManager.getUserLibraries().findJDK(temp);
        if (usrJDK != null) {
            HashStructure hash;
            if (!exeURL.equals(usrJDK.getJavaExecutable()) && !JDKUtil.initJDK(usrJDK = new JDKAdapter(hash = HashStructure.newInstance()), exeURL)) {
                usrJDK = null;
            }
        } else {
            usrJDK = JLibraryManager.getUserLibraries().addJDK(ver, exeURL);
        }
        if (usrJDK != null) {
            VersionNumber version = usrJDK.getJavaVersion();
            if (version != null && version.isAfter("9", true)) {
                URL jrtfsJar = null;
                URL dir = usrJDK.getJavaExecutable();
                URL uRL = dir = dir != null ? URLFileSystem.getParent((URL)dir) : null;
                while (dir != null && !URLFileSystem.exists((URL)(jrtfsJar = URLFactory.newURL((URL)dir, (String)"lib/jrt-fs.jar")))) {
                    jrtfsJar = null;
                    dir = URLFileSystem.getParent((URL)dir);
                }
                if (jrtfsJar != null) {
                    ModularizedJdkJrtfsLocator locator = ModularizedJdkJrtfsLocator.getInstance((URL)jrtfsJar);
                    usrJDK.setClassPath(locator.getClassPath());
                    usrJDK.setExpandedClassPath(locator.getExpandedClassPath());
                }
            }
            return JLibraryManager.getAddinLibraries().loadJDK(LibraryArb.format(17, new String[]{ver}), usrJDK.getClassPath(), usrJDK.getSourcePath(), usrJDK.getDocPath(), usrJDK.getJavaExecutable(), usrJDK.getJavaVersion(), usrJDK.getSDKBinDir());
        }
        return null;
    }

    private static JLibraryList _createLibraryList(URL url) {
        return new JLibraryList(url);
    }

    public void attach(Observer observer) {
        _delegate.attach(observer);
    }

    public void detach(Observer observer) {
        _delegate.detach(observer);
    }

    public void notifyObservers(Object subject, UpdateMessage change) {
        _delegate.notifyObservers(subject, change);
    }

    public void addLibraryChangeListener(ProjectLibraryChangeListener libraryChangeListener) {
        this.projectChangeSink.addListener(libraryChangeListener);
    }

    public void removeLibraryChangeListener(ProjectLibraryChangeListener libraryChangeListener) {
        this.projectChangeSink.removeListener(libraryChangeListener);
    }

    public void projectLibrariesChanged(Project project, Set<URL> modifiedJars, Set<URL> addedJars, Set<URL> deletedJars) {
        ProjectLibraryChangeEvent libChangeEvent = new ProjectLibraryChangeEvent(project, modifiedJars, addedJars, deletedJars);
        this.projectChangeSink.fireLibraryChangeEvent(libChangeEvent);
    }

    static {
        _INSTANCE = new JLibraryManager();
        _addinLibs = new AddinLibraryList();
        _delegate = new IdeSubject();
        _dependableRegistry = new ConcurrentHashMap();
        _checkedJDKs = new ConcurrentHashMap<URLKey, URLKey>();
    }

    private static final class CheckJdkWorker
    extends SwingWorker<Void, Void> {
        private final Project project;
        private final URL exeURL;
        private volatile boolean invalid;

        public CheckJdkWorker(Project project) {
            this.project = project;
            JProjectLibraries libs = JProjectLibraries.getInstance((PropertyStorage)project);
            this.exeURL = libs.getJDK().getJavaExecutable();
        }

        @Override
        public Void doInBackground() {
            URLKey key;
            if (this.exeURL != null && _checkedJDKs.putIfAbsent(key = URLKey.getInstance((URL)this.exeURL), key) != null) {
                return null;
            }
            if (!(this.exeURL != null && URLFileSystem.isRegularFile((URL)this.exeURL) || this.exeURL != null && URLFileSystem.isRegularFile((URL)JLibraryManager.javaExecutableNoSuffix(this.exeURL)))) {
                this.invalid = true;
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.invalid) {
                String title = LibraryArb.getString(20);
                String message = LibraryArb.format(21, this.project.getShortLabel());
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)title, null)) {
                    Context context = Context.newIdeContext();
                    context.setProject(this.project);
                    String[] path = new String[]{JProjectArb.getString(122)};
                    ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)this.project, (String[])path);
                }
            }
        }
    }
}

