/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.Reorderable;
import oracle.javatools.ui.ReorderableBar;
import oracle.javatools.ui.table.ReorderableTable;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.InternalLibraryList;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.library.UnresolvedLibrary;
import oracle.jdeveloper.model.JLibraryModel;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.library.BooleanTableCellRenderer;
import oracle.jdevimpl.library.JDKPanel;
import oracle.jdevimpl.library.LibrariesPanel;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;
import oracle.jdevimpl.library.LibraryPanel;
import oracle.jdevimpl.library.PathEntryChooser;

public abstract class ClasspathPanel
extends ProjectSettingsTraversablePanel {
    private static final LocalChangeListener LISTENER = new LocalChangeListener();
    private static final LocalChangeListener2 LISTENER2 = new LocalChangeListener2();
    private static final String SHOW_EXTERNAL_LIBS_PROPERTY = "Libraries.showExternal";
    private static URL defaultDirectory;
    private GridBagLayout mainLayout = new GridBagLayout();
    private JLabel jdkPrompt = new JLabel();
    private JTextField jdkField = new JTextField();
    private JLabel libsPrompt = new JLabel();
    private JScrollPane libsScrollPane = new JScrollPane();
    private LibraryTableModel tableModel = new LibraryTableModel(this.getColumnNames(), 0);
    private JTable libTable = new JTable(this.tableModel);
    private JButton editJDKButton = new JButton();
    private JButton addPathButton = new JButton();
    private JButton addLibButton = new JButton();
    private JButton editLibButton = new JButton();
    private JButton removeLibButton = new JButton();
    private JButton shareLibButton = new JButton();
    private JCheckBox externalLibCheckbox = new JCheckBox();
    private int externalLibCount;
    private ExternalLibraryPosition externalLibPosition;
    private List<LibraryList> libLists;
    private ButtonHandler buttonHandler = new ButtonHandler();
    private ListHandler listHandler = new ListHandler();
    private TableColumn moduleColumn;
    private boolean showingModuleColumn;

    public static String getLibraryNameFromPath(URL path) {
        Object name = URLFileSystem.getFileName((URL)path);
        if (!URLFileSystem.isDirectory((URL)path) && ((String)name).lastIndexOf(46) != -1) {
            name = ((String)name).substring(0, ((String)name).lastIndexOf(46));
        }
        if (name != null && !Character.isUpperCase(((String)name).charAt(0))) {
            name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        return name;
    }

    private static synchronized void setDefaultDirectory(URL url) {
        defaultDirectory = url;
    }

    public ClasspathPanel() {
        try {
            TableColumnModel model = this.libTable.getColumnModel();
            JTableHeader header = this.libTable.getTableHeader();
            header.setReorderingAllowed(false);
            int index = 0;
            if (this.showExports()) {
                TableColumn column = model.getColumn(0);
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setHorizontalAlignment(0);
                column.setCellEditor(new DefaultCellEditor(jCheckBox));
                column.setCellRenderer(new BooleanCellRenderer());
                column.setHeaderRenderer(header.getDefaultRenderer());
                column.sizeWidthToFit();
                ++index;
            }
            this.moduleColumn = model.getColumn(index);
            JCheckBox moduleCheckBox = new JCheckBox();
            moduleCheckBox.setHorizontalAlignment(0);
            this.moduleColumn.setCellEditor(new DefaultCellEditor(moduleCheckBox));
            this.moduleColumn.setCellRenderer(new BooleanCellRenderer());
            this.moduleColumn.setHeaderRenderer(header.getDefaultRenderer());
            this.moduleColumn.sizeWidthToFit();
            this.showingModuleColumn = true;
            TableColumn column = model.getColumn(++index);
            column.setCellRenderer(new LibraryCellRenderer());
            this.setHelpID(this.getHelpTopicID());
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getColumnNames() {
        ArrayList<CallSite> names = new ArrayList<CallSite>(3);
        if (this.showExports()) {
            names.add((CallSite)((Object)(" " + ControlsArb.getString(12) + " ")));
        }
        names.add((CallSite)((Object)(" " + ControlsArb.getString(76) + " ")));
        names.add((CallSite)((Object)(" " + ControlsArb.getString(11) + " ")));
        return names.toArray(new String[names.size()]);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.jdkField.setEnabled(false);
        this.jdkField.setEditable(false);
        this.editJDKButton.addActionListener(this.buttonHandler);
        this.libTable.setColumnSelectionAllowed(false);
        this.libTable.setName("ClasspathEntries");
        this.libTable.setAutoResizeMode(3);
        this.libTable.getSelectionModel().addListSelectionListener(this.listHandler);
        this.libTable.addKeyListener(this.listHandler);
        this.addPathButton.addActionListener(this.buttonHandler);
        this.addLibButton.addActionListener(this.buttonHandler);
        this.editLibButton.addActionListener(this.buttonHandler);
        this.removeLibButton.addActionListener(this.buttonHandler);
        this.shareLibButton.addActionListener(this.buttonHandler);
        this.externalLibCheckbox.setSelected(Boolean.valueOf(Ide.getProperty((String)SHOW_EXTERNAL_LIBS_PROPERTY, (String)Boolean.toString(false))));
        this.externalLibCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ClasspathPanel.this.reload();
            }
        });
        this.libsScrollPane.getViewport().add((Component)this.libTable, null);
        this.libsScrollPane.getViewport().setBackground(this.libTable.getBackground());
        ReorderableLibraryTable reorderTable = new ReorderableLibraryTable(this.libTable);
        ReorderableBar reorderBar = new ReorderableBar((Reorderable)reorderTable, true);
        int row = 0;
        if (this.showJDK()) {
            this.add(this.jdkPrompt, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
            this.add(this.jdkField, new GridBagConstraints(0, row, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
            this.add(this.editJDKButton, new GridBagConstraints(2, row++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 10, 0), 0, 0));
        }
        this.add(this.libsPrompt, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        if (this.canHaveExternalLibraries()) {
            this.add(this.externalLibCheckbox, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 2, 0), 0, 0));
        }
        this.add(this.libsScrollPane, new GridBagConstraints(0, ++row, 1, 9, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)reorderBar, new GridBagConstraints(1, row, 1, 9, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.addLibButton, new GridBagConstraints(2, row++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.addPathButton, new GridBagConstraints(2, row++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.removeLibButton, new GridBagConstraints(2, row++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 10, 0), 0, 0));
        this.add(this.editLibButton, new GridBagConstraints(2, row++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.shareLibButton, new GridBagConstraints(2, row++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 10, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.jdkPrompt, (Component)this.editJDKButton, (String)JProjectArb.getString(153));
        ResourceUtils.resButton((AbstractButton)this.editJDKButton, (String)ControlsArb.getString(10));
        ResourceUtils.resLabel((JLabel)this.libsPrompt, (Component)this.libTable, (String)ControlsArb.getString(0));
        ResourceUtils.resButton((AbstractButton)this.addPathButton, (String)ControlsArb.getString(73));
        ResourceUtils.resButton((AbstractButton)this.addLibButton, (String)ControlsArb.getString(3));
        ResourceUtils.resButton((AbstractButton)this.editLibButton, (String)ControlsArb.getString(4));
        ResourceUtils.resButton((AbstractButton)this.removeLibButton, (String)ControlsArb.getString(5));
        ResourceUtils.resButton((AbstractButton)this.shareLibButton, (String)ControlsArb.getString(6));
        if (this.canHaveExternalLibraries()) {
            ResourceUtils.resButton((AbstractButton)this.externalLibCheckbox, (String)this.getExternalLibrariesLabel());
        }
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (ClasspathPanel.isDefaultProject((Namespace)tc)) {
            this.setHelpID("f1_idedprojsetlibrariesdpp_html");
        }
        if (this.canHaveExternalLibraries()) {
            this.externalLibPosition = this.getExternalLibraryPosition();
        }
        this.reload();
        this.listHandler.valueChanged(null);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.commit();
    }

    public void hideShareButton() {
        if (this.shareLibButton.getParent() != null) {
            this.remove(this.shareLibButton);
        }
    }

    protected String getHashAdapterDelegateKey() {
        return this.getDataKey();
    }

    protected boolean showExports() {
        return true;
    }

    protected boolean showAsModuleColumn() {
        return true;
    }

    protected boolean showJDK() {
        return true;
    }

    protected abstract String getHelpTopicID();

    protected abstract URL getDefaultDirectory();

    protected abstract InternalLibraryList getLibraryList();

    protected abstract InternalLibraryList newLibraryList();

    protected abstract JDK getJDK();

    protected abstract void setJDK(JDK var1);

    protected abstract List<JLibrary> getLibraries();

    protected abstract void setLibraries(List<JLibrary> var1);

    protected abstract List<JLibrary> getExports();

    protected abstract void setExports(List<JLibrary> var1);

    protected abstract List<JLibrary> getModulePathLibraries();

    protected abstract void setModulePathLibraries(List<JLibrary> var1);

    protected Collection<LibraryList> getBuiltInLibraryLists() {
        return Arrays.asList(JLibraryManager.getAllLibraryLists());
    }

    protected Component getDefaultFocusComponent() {
        return this.addLibButton;
    }

    private void reload() {
        Collection<LibraryList> builtInLists = this.getBuiltInLibraryLists();
        InternalLibraryList libList = this.getLibraryList();
        this.libLists = new ArrayList<LibraryList>(builtInLists.size() + 1);
        this.libLists.addAll(builtInLists);
        this.libLists.add(libList);
        JDK jdk = this.getJDK();
        if (jdk != null) {
            this.jdkField.setText(jdk.toString());
        }
        this.tableModel.setRowCount(0);
        boolean showModuleColumn = this.showAsModuleColumn();
        if (this.showingModuleColumn && !showModuleColumn) {
            this.libTable.getColumnModel().removeColumn(this.moduleColumn);
            this.showingModuleColumn = false;
        } else if (!this.showingModuleColumn && showModuleColumn) {
            TableColumnModel columnModel = this.libTable.getColumnModel();
            columnModel.addColumn(this.moduleColumn);
            columnModel.moveColumn(this.showExports() ? 2 : 1, this.showExports() ? 1 : 0);
            this.showingModuleColumn = true;
        }
        List<JLibrary> libs = this.getLibraries();
        List<JLibrary> exps = this.getExports();
        List<JLibrary> modulePathLibraries = this.getModulePathLibraries();
        if (libs != null) {
            for (JLibrary library : libs) {
                this.tableModel.addRow(this.createRow(library, exps, modulePathLibraries));
            }
        }
        if (this.canHaveExternalLibraries()) {
            Collection<JLibrary> externalLibs = this.getExternalLibraries();
            Collection<JLibrary> externalModulePathLibraries = this.getExternalModulePathLibraries();
            this.externalLibCount = this.externalLibCheckbox.isSelected() ? externalLibs.size() : 0;
            this.externalLibCheckbox.setEnabled(!externalLibs.isEmpty());
            if (!externalLibs.isEmpty() && this.externalLibCheckbox.isSelected()) {
                if (this.externalLibPosition == ExternalLibraryPosition.TOP) {
                    ArrayList<JLibrary> reversed = new ArrayList<JLibrary>(externalLibs);
                    Collections.reverse(reversed);
                    for (JLibrary externalLib : reversed) {
                        this.tableModel.insertRow(0, this.createRow(externalLib, null, externalModulePathLibraries));
                    }
                } else {
                    for (JLibrary externalLib : externalLibs) {
                        this.tableModel.addRow(this.createRow(externalLib, null, externalModulePathLibraries));
                    }
                }
            }
        } else {
            this.externalLibCount = 0;
        }
    }

    private Object[] createRow(JLibrary library, Collection<JLibrary> exports, Collection<JLibrary> modulePathLibraries) {
        ArrayList<Object> rowObjects = new ArrayList<Object>(3);
        boolean isExport = false;
        boolean isModulePathLibrary = false;
        if (exports != null && this.showExports()) {
            for (JLibrary export : exports) {
                if (!export.equals(library)) continue;
                isExport = true;
                break;
            }
        }
        if (modulePathLibraries != null) {
            for (JLibrary modulePathLibrary : modulePathLibraries) {
                if (!modulePathLibrary.equals(library)) continue;
                isModulePathLibrary = true;
                break;
            }
        }
        rowObjects.clear();
        if (this.showExports()) {
            rowObjects.add(isExport ? Boolean.TRUE : Boolean.FALSE);
        }
        rowObjects.add(isModulePathLibrary ? Boolean.TRUE : Boolean.FALSE);
        rowObjects.add(library);
        return rowObjects.toArray(new Object[rowObjects.size()]);
    }

    private void commit() throws TraversalException {
        int count = this.tableModel.getRowCount();
        ArrayList<JLibrary> libraries = new ArrayList<JLibrary>(count);
        ArrayList<JLibrary> exports = new ArrayList<JLibrary>(count);
        ArrayList<JLibrary> modulePathLibraries = new ArrayList<JLibrary>(count);
        boolean showExports = this.showExports();
        boolean externalLibsVisible = this.externalLibCheckbox.isSelected();
        int start = this.externalLibPosition == ExternalLibraryPosition.TOP && externalLibsVisible ? this.externalLibCount : 0;
        int end = this.externalLibPosition == ExternalLibraryPosition.TOP || !externalLibsVisible ? count : count - this.externalLibCount;
        for (int i = start; i < end; ++i) {
            int index = 0;
            boolean exported = false;
            boolean isModulePathLibrary = false;
            if (showExports) {
                exported = (Boolean)this.tableModel.getValueAt(i, index++);
            }
            isModulePathLibrary = (Boolean)this.tableModel.getValueAt(i, index++);
            JLibrary lib = (JLibrary)this.tableModel.getValueAt(i, index);
            if (exported) {
                exports.add(lib);
            }
            if (isModulePathLibrary) {
                modulePathLibraries.add(lib);
            }
            libraries.add(lib);
        }
        this.setExports(exports);
        this.setModulePathLibraries(modulePathLibraries);
        this.setLibraries(libraries);
        this.setExternalLibraryPosition(this.externalLibPosition);
        Ide.setProperty((String)SHOW_EXTERNAL_LIBS_PROPERTY, (String)Boolean.toString(this.externalLibCheckbox.isSelected()));
    }

    private void syncLibraryList(InternalLibraryList originals) {
        int row;
        JLibrary lib;
        List libs = originals != null ? originals.getLibraryList() : null;
        Iterator i = libs != null ? libs.iterator() : null;
        InternalLibraryList libList = this.getLibraryList();
        if (i != null && libList != null) {
            while (i.hasNext()) {
                lib = (JLibrary)i.next();
                if (libList.findLibrary(lib.getID()) != null || (row = this.findRow(lib)) < 0) continue;
                this.tableModel.removeRow(row);
            }
        }
        libs = libList != null ? libList.getLibraryList() : null;
        Iterator iterator = i = libs != null ? libs.iterator() : null;
        if (i != null && originals != null) {
            while (i.hasNext()) {
                lib = (JLibrary)i.next();
                if (originals.findLibrary(lib.getID()) != null || (row = this.findRowById(lib)) >= 0) continue;
                this.addLibrary(lib);
            }
        }
    }

    private int findRowById(Library lib) {
        Object id;
        Object object = id = lib != null ? lib.getID() : null;
        if (id != null) {
            for (int i = 0; i < this.libTable.getRowCount(); ++i) {
                if (!id.equals(((Library)this.tableModel.getValueAt(i, this.getLibraryColumn())).getID())) continue;
                return i;
            }
        }
        return -1;
    }

    private int getLibraryColumn() {
        return (this.showExports() ? 1 : 0) + 1;
    }

    private int findRow(Library lib) {
        Object id;
        Object object = id = lib != null ? lib.getID() : null;
        if (id != null) {
            int count = this.libTable.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (!((Library)this.tableModel.getValueAt(i, this.getLibraryColumn())).equivalent(lib)) continue;
                return i;
            }
        }
        return -1;
    }

    private void deleteSelection() {
        int count;
        int[] rows = this.libTable.getSelectedRows();
        InternalLibraryList libList = this.getLibraryList();
        if (rows != null) {
            int i;
            for (i = 0; i < rows.length; ++i) {
                for (int j = i + 1; j < rows.length; ++j) {
                    if (rows[j] >= rows[i]) continue;
                    int temp = rows[i];
                    rows[i] = rows[j];
                    rows[j] = temp;
                }
            }
            for (i = rows.length - 1; i >= 0; --i) {
                libList.remove((Library)this.tableModel.getValueAt(rows[i], this.getLibraryColumn()));
                this.tableModel.removeRow(rows[i]);
            }
        }
        if ((count = this.libTable.getRowCount()) != 0) {
            int lastDeletedRow = rows[rows.length - 1];
            int row = count > lastDeletedRow ? lastDeletedRow : count - 1;
            this.selectRow(row);
        }
    }

    private void selectRow(final int row) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClasspathPanel.this.libTable.setRowSelectionInterval(row, row);
                ClasspathPanel.this.libTable.scrollRectToVisible(ClasspathPanel.this.libTable.getCellRect(row, 0, true));
            }
        });
    }

    private void selectRows(final Library[] elems) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (elems == null) {
                    return;
                }
                ClasspathPanel.this.libTable.clearSelection();
                Rectangle rect = null;
                for (int i = 0; i < elems.length; ++i) {
                    int row = ClasspathPanel.this.findRow(elems[i]);
                    if (row < 0) continue;
                    ClasspathPanel.this.libTable.addRowSelectionInterval(row, row);
                    Rectangle cellRect = ClasspathPanel.this.libTable.getCellRect(row, 0, true);
                    rect = rect == null ? cellRect : rect.union(cellRect);
                }
                if (rect != null) {
                    ClasspathPanel.this.libTable.scrollRectToVisible(rect);
                }
                ClasspathPanel.this.libTable.requestFocus();
            }
        });
    }

    private boolean isExternalLibrary(int row) {
        if (this.externalLibCheckbox.isSelected()) {
            return this.externalLibPosition == ExternalLibraryPosition.TOP ? row < this.externalLibCount : row >= this.libTable.getRowCount() - this.externalLibCount;
        }
        return false;
    }

    private boolean containsExternalLibrary(int[] rows) {
        if (rows != null) {
            for (int i = 0; i < rows.length; ++i) {
                if (!this.isExternalLibrary(rows[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMixedSelection(int[] rows) {
        if (rows != null && rows.length > 2) {
            boolean external = this.isExternalLibrary(rows[0]);
            for (int i = 1; i < rows.length; ++i) {
                if (external == this.isExternalLibrary(rows[i])) continue;
                return true;
            }
        }
        return false;
    }

    private void addLibrary(Library library) {
        ArrayList<Object> rowObjects = new ArrayList<Object>(3);
        if (this.showExports()) {
            rowObjects.add(Boolean.TRUE);
        }
        rowObjects.add(this.libraryHasJmodModule(library) ? Boolean.TRUE : Boolean.FALSE);
        rowObjects.add(library);
        if (this.externalLibCheckbox.isSelected() && this.externalLibPosition == ExternalLibraryPosition.BOTTOM) {
            int insert = this.tableModel.getRowCount() - this.externalLibCount;
            this.tableModel.insertRow(insert, rowObjects.toArray(new Object[rowObjects.size()]));
        } else {
            this.tableModel.addRow(rowObjects.toArray(new Object[rowObjects.size()]));
        }
    }

    protected boolean canHaveExternalLibraries() {
        return false;
    }

    protected String getExternalLibrariesLabel() {
        return null;
    }

    protected Collection<JLibrary> getExternalLibraries() {
        return Collections.emptySet();
    }

    protected Collection<JLibrary> getExternalModulePathLibraries() {
        return Collections.emptySet();
    }

    protected ExternalLibraryPosition getExternalLibraryPosition() {
        return ExternalLibraryPosition.TOP;
    }

    protected void setExternalLibraryPosition(ExternalLibraryPosition position) {
    }

    private boolean libraryHasJmodModule(Library library) {
        URLPath classPath = library.getClassPath();
        for (URL pathEntry : classPath) {
            String path = URLFileSystem.getPath((URL)pathEntry);
            if (!path.endsWith(".jmod!/classes/") && !path.endsWith(".jmod!/")) continue;
            return true;
        }
        return false;
    }

    private final class LibraryTableModel
    extends DefaultTableModel {
        private LibraryTableModel(String[] columnNames, int rows) {
            super(columnNames, rows);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            Object library;
            if (ClasspathPanel.this.showExports() && column == 0) {
                return row < this.getRowCount() && !ClasspathPanel.this.isExternalLibrary(row);
            }
            if (ClasspathPanel.this.showAsModuleColumn() && column == (ClasspathPanel.this.showExports() ? 1 : 0) && (library = ClasspathPanel.this.tableModel.getValueAt(row, ClasspathPanel.this.getLibraryColumn())) instanceof Library) {
                return !ClasspathPanel.this.libraryHasJmodModule((Library)library);
            }
            return false;
        }
    }

    private final class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            InternalLibraryList libList = ClasspathPanel.this.getLibraryList();
            if (source == ClasspathPanel.this.editJDKButton) {
                int i;
                JDK jdk = ClasspathPanel.this.getJDK();
                JDKPanel panel = new JDKPanel();
                ListWrapper[] copies = new ListWrapper[ClasspathPanel.this.libLists.size()];
                boolean jdkInList = false;
                for (i = 0; i < ClasspathPanel.this.libLists.size(); ++i) {
                    copies[i] = new ListWrapper(ClasspathPanel.this.libLists.get(i));
                    if (!jdkInList) {
                        boolean bl = jdkInList = copies[i].findJDK(jdk.getID()) != null;
                    }
                    if (jdkInList || !(ClasspathPanel.this.libLists.get(i) instanceof InternalLibraryList)) continue;
                    copies[i].addJDK(jdk.getName(), jdk.getJavaExecutable());
                }
                panel.initPanel(copies, jdk);
                panel.setSelectionMode(1);
                ClasspathPanel.LISTENER._panel = panel;
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)ClasspathPanel.this), (Component)panel, null, (String)ControlsArb.getString(45), (int)7, (VetoableChangeListener)LISTENER, (DialogRunnerCallback)new SizeKeeperCallback("edit.jdk"))) {
                    copies = panel.getLibraryLists();
                    for (i = 0; i < copies.length; ++i) {
                        copies[i].commit(copies[i].getWrappedList() != libList);
                    }
                    Library[] sel = panel.getSelection();
                    if (sel != null && sel.length > 0) {
                        jdk = (JDK)sel[0];
                    }
                    ClasspathPanel.this.setJDK(jdk);
                    try {
                        ClasspathPanel.this.commit();
                    }
                    catch (Exception ex) {
                        Assert.printStackTrace((Throwable)ex);
                    }
                    ClasspathPanel.this.reload();
                }
            } else if (source == ClasspathPanel.this.addPathButton) {
                URLChooser chooser = PathEntryChooser.get(ClasspathPanel.this.getDefaultDirectory(), false, ClasspathPanel.this.showAsModuleColumn());
                int result = chooser.showOpenDialog((Component)((Object)ClasspathPanel.this), ControlsArb.getString(74));
                if (result == 0) {
                    URL[] paths = chooser.getSelectedURLs();
                    int n = paths.length;
                    URL[] classPaths = new URL[n];
                    for (int i = 0; i < n; ++i) {
                        URL url = paths[i];
                        classPaths[i] = paths[i];
                        String urlSuffix = URLFileSystem.getSuffix((URL)url);
                        if (!urlSuffix.equals(".jar") && !urlSuffix.equals(".zip") && !urlSuffix.equals(".jmod") || !URLFileSystem.exists((URL)url) || URLFileSystem.isDirectory((URL)url)) continue;
                        paths[i] = URLFactory.newJarURL((URL)url, (String)"");
                        classPaths[i] = paths[i];
                        if (!urlSuffix.equals(".jmod")) continue;
                        classPaths[i] = URLFactory.newJarURL((URL)url, (String)"classes/");
                    }
                    ArrayList<JLibrary> newLibs = new ArrayList<JLibrary>();
                    for (int i = 0; i < n; ++i) {
                        String name = ClasspathPanel.getLibraryNameFromPath(paths[i]);
                        JLibrary lib = libList.addLibrary(name);
                        if (lib == null) continue;
                        lib.setClassPath(new URLPath(classPaths[i]));
                        lib.setDeployedByDefault(Boolean.TRUE);
                        lib.setLocked(true);
                        ClasspathPanel.this.addLibrary(lib);
                        newLibs.add(lib);
                        ClasspathPanel.setDefaultDirectory(URLFileSystem.getParent((URL)paths[i]));
                    }
                    if (newLibs.size() > 0) {
                        Library[] elems = new JLibrary[newLibs.size()];
                        newLibs.toArray(elems);
                        ClasspathPanel.this.selectRows(elems);
                    }
                }
            } else if (source == ClasspathPanel.this.addLibButton) {
                LibrariesPanel panel = new LibrariesPanel();
                panel.makeDoubleClickCloseDialog();
                panel.setAllowJmodArchives(ClasspathPanel.this.showAsModuleColumn());
                ListWrapper[] copies = new ListWrapper[ClasspathPanel.this.libLists.size()];
                for (int i = 0; i < copies.length; ++i) {
                    copies[i] = new ListWrapper(ClasspathPanel.this.libLists.get(i));
                }
                panel.setSplit(false);
                int numExistingLibs = ClasspathPanel.this.tableModel.getRowCount();
                Set externalLibraries = ClasspathPanel.this.externalLibCheckbox.isSelected() ? Collections.emptySet() : ClasspathPanel.this.getExternalLibraries();
                ArrayList<JLibrary> exLibs = new ArrayList<JLibrary>(numExistingLibs + externalLibraries.size());
                if (numExistingLibs > 0) {
                    for (int i = 0; i < numExistingLibs; ++i) {
                        JLibrary existingLib = (JLibrary)ClasspathPanel.this.tableModel.getValueAt(i, ClasspathPanel.this.getLibraryColumn());
                        exLibs.add(existingLib);
                    }
                }
                exLibs.addAll(externalLibraries);
                if (!exLibs.isEmpty()) {
                    panel.setExistingLibraries(exLibs);
                }
                panel.initPanel(copies);
                ClasspathPanel.LISTENER._panel = panel;
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)ClasspathPanel.this), (Component)panel, null, (String)ControlsArb.getString(14), (int)7, (VetoableChangeListener)LISTENER, (DialogRunnerCallback)new SizeKeeperCallback("add.library"))) {
                    InternalLibraryList originals = ClasspathPanel.this.newLibraryList();
                    libList.copyTo(originals);
                    copies = panel.getLibraryLists();
                    for (int i = 0; i < copies.length; ++i) {
                        copies[i].commit(copies[i].getWrappedList() != libList);
                    }
                    Library[] elems = panel.getSelection();
                    if (elems != null) {
                        for (int i = 0; i < elems.length; ++i) {
                            if (ClasspathPanel.this.findRowById(elems[i]) >= 0) continue;
                            ClasspathPanel.this.addLibrary(elems[i]);
                        }
                    }
                    ClasspathPanel.this.syncLibraryList(originals);
                    try {
                        ClasspathPanel.this.commit();
                    }
                    catch (Exception x) {
                        Assert.printStackTrace((Throwable)x);
                    }
                    ClasspathPanel.this.reload();
                    ClasspathPanel.this.selectRows(elems);
                }
            } else if (source == ClasspathPanel.this.editLibButton) {
                JLibraryList list;
                int row = ClasspathPanel.this.libTable.getSelectedRow();
                JLibrary lib = row >= 0 ? (JLibrary)ClasspathPanel.this.tableModel.getValueAt(row, ClasspathPanel.this.getLibraryColumn()) : null;
                LibraryList wrapper = null;
                if (lib != null && lib instanceof UnresolvedLibrary) {
                    Object id = lib.getID();
                    list = JLibraryManager.getUserLibraries();
                    if (id instanceof URL) {
                        URL listURL = URLFileSystem.getParent((URL)((URL)id));
                        list = JLibraryManager.addLibraryList(listURL);
                        if (((String)(id = URLFileSystem.getFileName((URL)((URL)id)))).endsWith(".library")) {
                            id = ((String)id).substring(0, ((String)id).length() - ".library".length());
                        }
                    }
                    wrapper = new ListWrapper(list);
                    lib = ((ListWrapper)wrapper).addLibrary(id.toString());
                }
                LibraryEditPanel panel = new LibraryEditPanel(lib);
                list = wrapper != null ? wrapper : this.findOwningList(lib);
                panel.setListsVisible(false);
                panel.setLibraryList(list);
                LISTENER2.initialize(panel, lib, list);
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)ClasspathPanel.this), (Component)panel, null, (String)ControlsArb.getString(24), (int)7, (VetoableChangeListener)LISTENER2, (DialogRunnerCallback)new SizeKeeperCallback("edit.library"))) {
                    int existing = ClasspathPanel.this.findRowById(LISTENER2.getLibrary());
                    ClasspathPanel.this.tableModel.setValueAt(LISTENER2.getLibrary(), row, ClasspathPanel.this.getLibraryColumn());
                    if (existing >= 0 && existing != row) {
                        ClasspathPanel.this.tableModel.removeRow(existing);
                        if (row > existing) {
                            --row;
                        }
                    }
                    try {
                        ClasspathPanel.this.commit();
                    }
                    catch (Exception x) {
                        Assert.printStackTrace((Throwable)x);
                    }
                    ClasspathPanel.this.reload();
                    if (row >= 0) {
                        ClasspathPanel.this.selectRow(row);
                    }
                }
            } else if (source == ClasspathPanel.this.removeLibButton) {
                ClasspathPanel.this.deleteSelection();
            } else if (source == ClasspathPanel.this.shareLibButton) {
                JLibrary lib;
                int row = ClasspathPanel.this.libTable.getSelectedRow();
                JLibrary jLibrary = lib = row >= 0 ? (JLibrary)ClasspathPanel.this.tableModel.getValueAt(row, ClasspathPanel.this.getLibraryColumn()) : null;
                if (lib != null) {
                    URL url;
                    URLChooser chooser = DialogUtil.newURLChooser((URL)ClasspathPanel.this.getDefaultDirectory());
                    chooser.setSelectionMode(0);
                    chooser.setSelectionScope(0);
                    chooser.setShowJarsAsDirs(false);
                    chooser.clearChooseableURLFilters();
                    chooser.setURLFilter(JLibraryList.LIB_FILTER);
                    int result = chooser.showSaveDialog((Component)((Object)ClasspathPanel.this), ControlsArb.getString(17));
                    if (result == 0 && (url = chooser.getSelectedURL()) != null) {
                        JLibrary newLib;
                        JLibraryList list;
                        URL parent;
                        if (URLFileSystem.exists((URL)(url = URLFileSystem.ensureSuffix((URL)url, (String)".library")))) {
                            if (MessageDialog.confirm((Component)((Object)ClasspathPanel.this), (Object)ComponentArb.format((int)31, (Object[])new String[]{ComponentArb.getString((int)45), URLFileSystem.getPlatformPathName((URL)url)}), (String)ComponentArb.getString((int)26), null, (boolean)true)) {
                                if (URLFileSystem.isReadOnly((URL)url)) {
                                    MessageDialog.error((Component)((Object)ClasspathPanel.this), (Object)ComponentArb.format((int)30, (Object[])new String[]{URLFileSystem.getPlatformPathName((URL)url)}), (String)ComponentArb.getString((int)36), null);
                                    return;
                                }
                            } else {
                                return;
                            }
                        }
                        if ((parent = URLFileSystem.getParent((URL)url)) != null && (list = JLibraryManager.addLibraryList(parent)) != null && (newLib = list.addLibrary(null, url)) != null) {
                            newLib.setClassPath(lib.getClassPath());
                            newLib.setSourcePath(lib.getSourcePath());
                            newLib.setDocPath(lib.getDocPath());
                            newLib.setDeployedByDefault(lib.getDeployedByDefault());
                            libList.remove(lib);
                            ClasspathPanel.this.tableModel.setValueAt(newLib, row, ClasspathPanel.this.getLibraryColumn());
                            try {
                                ClasspathPanel.this.commit();
                            }
                            catch (Exception x) {
                                Assert.printStackTrace((Throwable)x);
                            }
                            ClasspathPanel.this.reload();
                            if (lib != null && (row = ClasspathPanel.this.findRow(newLib)) >= 0) {
                                ClasspathPanel.this.selectRow(row);
                            }
                        }
                    }
                }
            }
        }

        private LibraryList findOwningList(JLibrary lib) {
            Object id = lib.getID();
            InternalLibraryList libList = ClasspathPanel.this.getLibraryList();
            if (libList.findLibrary(id) != null) {
                return libList;
            }
            LibraryList[] lists = JLibraryManager.getAllLibraryLists();
            for (int i = 0; i < lists.length; ++i) {
                if (lists[i].findLibrary(id) == null) continue;
                if (lists[i] instanceof JLibraryList && id instanceof URL) {
                    URL listURL = URLFileSystem.getParent((URL)((URL)id));
                    return JLibraryManager.addLibraryList(listURL);
                }
                return lists[i];
            }
            return null;
        }
    }

    private final class ListHandler
    extends KeyAdapter
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] rows = ClasspathPanel.this.libTable.getSelectedRows();
            if (ClasspathPanel.this.containsExternalLibrary(rows)) {
                if (ClasspathPanel.this.externalLibPosition == ExternalLibraryPosition.TOP) {
                    ClasspathPanel.this.libTable.getSelectionModel().addSelectionInterval(0, ClasspathPanel.this.externalLibCount - 1);
                } else {
                    ClasspathPanel.this.libTable.getSelectionModel().addSelectionInterval(ClasspathPanel.this.libTable.getRowCount() - ClasspathPanel.this.externalLibCount, ClasspathPanel.this.libTable.getRowCount() - 1);
                }
            }
            if (e != null && e.getValueIsAdjusting()) {
                return;
            }
            rows = ClasspathPanel.this.libTable.getSelectedRows();
            if (rows == null || rows.length != 1) {
                ClasspathPanel.this.editLibButton.setEnabled(false);
                ClasspathPanel.this.shareLibButton.setEnabled(false);
                boolean hasExternalLib = false;
                if (ClasspathPanel.this.canHaveExternalLibraries() && ClasspathPanel.this.externalLibCount > 0 && rows != null) {
                    for (int i = 0; i < rows.length; ++i) {
                        if (!ClasspathPanel.this.isExternalLibrary(rows[i])) continue;
                        hasExternalLib = true;
                        break;
                    }
                }
                ClasspathPanel.this.removeLibButton.setEnabled(rows != null && rows.length > 0 && !hasExternalLib);
            } else {
                int row = ClasspathPanel.this.libTable.getSelectedRow();
                boolean isExternalLib = ClasspathPanel.this.isExternalLibrary(row);
                JLibrary lib = (JLibrary)ClasspathPanel.this.tableModel.getValueAt(row, ClasspathPanel.this.getLibraryColumn());
                if (lib != null && !lib.isLocked()) {
                    ResourceUtils.resButton((AbstractButton)ClasspathPanel.this.editLibButton, (String)ControlsArb.getString(4));
                } else {
                    ResourceUtils.resButton((AbstractButton)ClasspathPanel.this.editLibButton, (String)ControlsArb.getString(75));
                }
                ClasspathPanel.this.editLibButton.setEnabled(!isExternalLib);
                ClasspathPanel.this.removeLibButton.setEnabled(!isExternalLib);
                ClasspathPanel.this.shareLibButton.setEnabled(!isExternalLib && lib instanceof HashStructureAdapter);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u007f') {
                if (ClasspathPanel.this.removeLibButton.isEnabled()) {
                    ClasspathPanel.this.deleteSelection();
                }
                e.consume();
            }
        }
    }

    private final class BooleanCellRenderer
    extends BooleanTableCellRenderer {
        private BooleanCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (ClasspathPanel.this.isExternalLibrary(row)) {
                this.setValue(false);
                this.setEnabled(false);
            } else {
                Object library;
                this.setValue(value);
                boolean enable = true;
                if (column == (ClasspathPanel.this.showExports() ? 1 : 0) && (library = ClasspathPanel.this.tableModel.getValueAt(row, ClasspathPanel.this.getLibraryColumn())) instanceof Library) {
                    enable = !ClasspathPanel.this.libraryHasJmodModule((Library)library);
                }
                this.setEnabled(enable);
            }
            return c;
        }
    }

    private final class LibraryCellRenderer
    extends DefaultTableCellRenderer {
        private Color unselectedForeground;
        private Color unselectedBackground;

        private LibraryCellRenderer() {
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setDisabledIcon(null);
            this.setIcon(this.getIcon(value));
            if (value instanceof Library) {
                String libTooltip = ((Library)value).getToolTipText();
                if (!ModelUtil.hasLength((String)libTooltip)) {
                    libTooltip = LibraryArb.getString(86);
                    this.setText(libTooltip);
                }
                this.setToolTipText(libTooltip);
                this.setText(((Library)value).getName());
            }
            this.setEnabled(!ClasspathPanel.this.isExternalLibrary(row));
            return this;
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text") {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        private Icon getIcon(Object value) {
            if (value instanceof JLibrary) {
                Library lib = (Library)value;
                URLPath path = lib.getClassPath();
                if (!(path != null && path.size() != 0 || (path = lib.getSourcePath()) != null && path.size() != 0 || (path = lib.getDocPath()) != null && path.size() != 0)) {
                    super.setForeground(Color.red);
                    return LibraryArb.getIcon(67);
                }
                return lib.getIcon();
            }
            return null;
        }
    }

    private final class ReorderableLibraryTable
    extends ReorderableTable {
        ReorderableLibraryTable(JTable table) {
            super(table);
        }

        public boolean isSelectionTopMobile() {
            if (ClasspathPanel.this.externalLibCount > 0 && (ClasspathPanel.this.externalLibPosition == ExternalLibraryPosition.TOP || ClasspathPanel.this.isMixedSelection(this.getTable().getSelectedRows()))) {
                return false;
            }
            return super.isSelectionTopMobile();
        }

        public boolean isSelectionBottomMobile() {
            if (ClasspathPanel.this.externalLibCount > 0 && (ClasspathPanel.this.externalLibPosition == ExternalLibraryPosition.BOTTOM || ClasspathPanel.this.isMixedSelection(this.getTable().getSelectedRows()))) {
                return false;
            }
            return super.isSelectionBottomMobile();
        }

        public boolean isSelectionUpwardlyMobile() {
            if (ClasspathPanel.this.externalLibCount > 0 && ClasspathPanel.this.externalLibCheckbox.isSelected()) {
                int[] rows = this.getTable().getSelectedRows();
                if (ClasspathPanel.this.externalLibPosition == ExternalLibraryPosition.TOP ? rows != null && rows.length > 0 && rows[0] <= ClasspathPanel.this.externalLibCount : ClasspathPanel.this.containsExternalLibrary(rows)) {
                    return false;
                }
            }
            return super.isSelectionUpwardlyMobile();
        }

        public boolean isSelectionDownwardlyMobile() {
            if (ClasspathPanel.this.externalLibCount > 0 && ClasspathPanel.this.externalLibCheckbox.isSelected()) {
                int[] rows = this.getTable().getSelectedRows();
                if (ClasspathPanel.this.externalLibPosition == ExternalLibraryPosition.BOTTOM ? rows != null && rows.length > 0 && rows[rows.length - 1] >= this.getTable().getRowCount() - ClasspathPanel.this.externalLibCount - 1 : ClasspathPanel.this.containsExternalLibrary(rows)) {
                    return false;
                }
            }
            return super.isSelectionDownwardlyMobile();
        }

        public void moveSelectionTop() {
            if (ClasspathPanel.this.containsExternalLibrary(this.getTable().getSelectedRows())) {
                ClasspathPanel.this.externalLibPosition = ExternalLibraryPosition.TOP;
            }
            super.moveSelectionTop();
        }

        public void moveSelectionBottom() {
            if (ClasspathPanel.this.containsExternalLibrary(this.getTable().getSelectedRows())) {
                ClasspathPanel.this.externalLibPosition = ExternalLibraryPosition.BOTTOM;
            }
            super.moveSelectionBottom();
        }
    }

    protected static enum ExternalLibraryPosition {
        TOP,
        BOTTOM;

    }

    private static final class LocalChangeListener
    implements VetoableChangeListener {
        private LibraryPanel _panel;
        private boolean _vetoThrown;

        private LocalChangeListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            if (!this._panel.commitChanges()) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, e);
            }
        }
    }

    private static final class LocalChangeListener2
    implements VetoableChangeListener {
        private boolean _vetoThrown;
        private LibraryEditPanel _newPanel;
        private Library _lib;
        private LibraryList _list;

        private LocalChangeListener2() {
        }

        public void initialize(LibraryEditPanel panel, Library lib, LibraryList list) {
            this._newPanel = panel;
            this._lib = lib;
            this._list = list;
        }

        public Library getLibrary() {
            return this._lib;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            try {
                if (!(this._list instanceof MutableLibraryList)) {
                    return;
                }
                JLibraryModel model = new JLibraryModel((JLibrary)this._lib, (MutableLibraryList)this._list, (Component)this._newPanel);
                model.setName(this._newPanel.getLibraryName());
                model.setClassPath(this._newPanel.getClassPath());
                model.setSourcePath(this._newPanel.getSourcePath());
                model.setDocPath(this._newPanel.getDocPath());
                model.setDeployedByDefault(this._newPanel.isDeployByDefault());
                this._lib = model.commit();
                if (this._list instanceof ListWrapper) {
                    ((ListWrapper)this._list).commit(true);
                }
            }
            catch (Exception x) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, e);
            }
        }
    }
}

