/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.protocol;

import java.util.List;
import oracle.security.xmlsec.saml2.protocol.IDPList;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Scoping
extends XMLElement {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:protocol"};
    private static final String[] tagList = new String[]{"IDPList", "RequesterID"};

    public Scoping(Element element) throws DOMException {
        super(element);
    }

    public Scoping(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Scoping(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:protocol", "Scoping");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    public void setProxyCount(int count) {
        if (count < 0) {
            this.setAttribute("ProxyCount", Integer.toString(0));
        } else {
            this.setAttribute("ProxyCount", Integer.toString(count));
        }
    }

    public int getProxyCount() {
        int c = 0;
        try {
            if (this.hasAttribute("ProxyCount")) {
                c = Integer.parseInt(this.getAttribute("ProxyCount"));
            }
        }
        catch (NumberFormatException ex) {
            c = 0;
        }
        return c;
    }

    public void setIDPList(IDPList list) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:protocol", (String)"IDPList");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)list, (String[])nsList, (String[])tagList);
    }

    public IDPList getIDPList() {
        return (IDPList)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:protocol", "IDPList");
    }

    public void addRequesterID(String uri) {
        SAML2Utils.insertChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:protocol", "RequesterID", nsList, tagList, uri, false);
    }

    public List getRequesterIDs() {
        return SAML2Utils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:2.0:protocol", "RequesterID");
    }

    static {
        SAML2Initializer.initialize();
    }
}

