/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav.cmd;

import java.awt.datatransfer.StringSelection;
import oracle.ide.Ide;
import oracle.ide.IdeClipboard;
import oracle.ide.model.Node;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.jdeveloper.vcs.nav.ConnectionNodeDecorator;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public final class CopySVNURLCommand
extends VCSCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.copy-svnurl";

    public CopySVNURLCommand() {
        super(Ide.findCmdID((String)COMMAND_ID).intValue());
    }

    protected boolean isAvailableImpl() {
        Node node = this.getContext().getNode();
        return SVNUtil.getSVNRemoteNode(this.getContext()) != null || node != null && node instanceof ConnectionNodeDecorator;
    }

    protected int doitImpl() {
        SVNRemoteNode remoteNode = SVNUtil.getSVNRemoteNode(this.getContext());
        if (remoteNode != null) {
            this.setClipboard(SVNUtil.encodeWhiteSpace(remoteNode.getSVNUrl()));
            return 0;
        }
        Node node = this.getContext().getNode();
        SVNRepositoryNode repoNode = SVNUtil.getSVNRepositoryNode(node);
        if (repoNode != null) {
            this.setClipboard(SVNUtil.encodeWhiteSpace(repoNode.getSVNUrl()));
            return 0;
        }
        return 1;
    }

    private void setClipboard(String content) {
        StringSelection sel = new StringSelection(content);
        ClipboardStack.pushCurrentClipboard();
        IdeClipboard.getClipboard().setContents(sel, sel);
    }
}

