/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryEntry;
import oracle.jdeveloper.history.RestoreFromRevisionClass;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNRestoreFromRevisionClass
extends RestoreFromRevisionClass {
    public boolean canRestore(URL[] urls, String revision, HistoryEntry entry) throws Exception {
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(urls[0]);
        SVNRevision svnRev = SVNRevision.create((long)Long.parseLong(revision));
        try {
            Collection<VCSHashURL> rvFiles = this.getFilesOfRevision(urls, repos, svnRev);
            for (URL url : urls) {
                if (this.isMembersOf(rvFiles, url)) continue;
                SVNProfile.getQualifiedLogger(SVNRestoreFromRevisionClass.class.getName()).log(Level.WARNING, url.getPath() + " is not in revision " + svnRev);
                return false;
            }
        }
        catch (SVNException ex) {
            throw new Exception(ex.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restore(URL[] urls, String revision, HistoryEntry entry) throws Exception {
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(urls[0]);
        SVNRevision svnRev = SVNRevision.create((long)Long.parseLong(revision));
        try {
            SVNWCClient client = SVNUtil.getWCClient(repos);
            for (URL url : urls) {
                File file = new File(url.getPath());
                BufferedOutputStream bs = null;
                try {
                    bs = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url));
                    client.doGetFileContents(file, svnRev, svnRev, false, (OutputStream)bs);
                }
                finally {
                    try {
                        if (bs != null) {
                            bs.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (SVNException ex) {
            throw new Exception(ex.getMessage());
        }
        this.clear(urls);
        return true;
    }

    private void clear(URL[] urls) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        SVNURLInfoCache.getInstance().clear(urls);
        profile.getPolicyStatusCache().clear(urls);
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    private Collection<VCSHashURL> getFilesOfRevision(URL[] urls, SVNRepositoryInfo repos, final SVNRevision svnRev) throws SVNException {
        SVNLogClient lclient = SVNUtil.getLogClient(repos);
        final URL[] parent = VCSFileSystemUtils.getParentURLs((URL[])urls);
        File file = new File(parent[0].getPath());
        final ArrayList<VCSHashURL> rvFiles = new ArrayList<VCSHashURL>();
        lclient.doList(file, svnRev, svnRev, true, SVNDepth.INFINITY, -1, new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                if (dirEntry.getRevision() == svnRev.getNumber()) {
                    String path = dirEntry.getRelativePath();
                    rvFiles.add(new VCSHashURL(URLFactory.newURL((URL)parent[0], (String)path)));
                }
            }
        });
        return rvFiles;
    }

    private boolean isMembersOf(Collection<VCSHashURL> rvFiles, URL url) {
        for (VCSHashURL vcsURL : rvFiles) {
            if (!vcsURL.getExternalForm().equals(url.toExternalForm())) continue;
            return true;
        }
        return false;
    }
}

