/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Value;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;

final class DebugJDIDataPrimitiveInfo
extends DebugJDIDataInfo
implements DebugDataPrimitiveInfo {
    DebugJDIDataPrimitiveInfo(DebugJDI dj, DebugJDIClassInfo clazz, Value value, Object owner) {
        super(dj, clazz, value, owner);
    }

    @Override
    public String getValue() {
        this.throwIfExpired();
        if (this.value instanceof CharValue) {
            char[] buf = new char[]{'\'', ((CharValue)this.value).value(), '\''};
            return new String(buf);
        }
        return this.value.toString();
    }

    @Override
    public String getHexValue() {
        this.throwIfExpired();
        long l = 0L;
        int pad = 0;
        if (this.value instanceof BooleanValue) {
            if (((BooleanValue)this.value).value()) {
                return "01";
            }
            return "00";
        }
        if (this.value instanceof ByteValue) {
            l = ((ByteValue)this.value).value();
            pad = 2;
        } else if (this.value instanceof CharValue) {
            l = ((CharValue)this.value).value();
            pad = 4;
        } else if (this.value instanceof DoubleValue) {
            l = Double.doubleToLongBits(((DoubleValue)this.value).value());
            pad = 16;
        } else if (this.value instanceof FloatValue) {
            l = Float.floatToIntBits(((FloatValue)this.value).value());
            pad = 8;
        } else if (this.value instanceof IntegerValue) {
            l = ((IntegerValue)this.value).value();
            pad = 8;
        } else if (this.value instanceof LongValue) {
            l = ((LongValue)this.value).value();
            pad = 16;
        } else if (this.value instanceof ShortValue) {
            l = ((ShortValue)this.value).value();
            pad = 4;
        }
        String s = Long.toHexString(l).toUpperCase();
        return DebugShared.prepadOrTrunc((String)s, (char)'0', (int)pad);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DebugJDIDataPrimitiveInfo) {
            return super.equals(o);
        }
        return false;
    }
}

