/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.border.Border;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.list.DefaultCheckListCellRenderer;
import oracle.javatools.ui.table.RowHeader;
import oracle.javatools.ui.table.SimpleTableModel;
import oracle.javatools.ui.table.TableUIManager;

final class CheckRowHeaderRenderer
extends DefaultCheckListCellRenderer {
    private static final Border selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Colors.FLAT_EDITOR_BORDER), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 3, TableUIManager.HEADER_SEL), BorderFactory.createEmptyBorder(0, 4, 0, 1)));
    private static final Border unSelectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Colors.FLAT_EDITOR_BORDER), BorderFactory.createEmptyBorder(0, 4, 0, 4));
    private Collection checkedItems;
    private JTable table;

    CheckRowHeaderRenderer(JTable table, Collection checkedItems) {
        this.table = table;
        this.checkedItems = checkedItems;
    }

    protected SimpleTableModel getTableModel() {
        assert (this.table.getModel() instanceof SimpleTableModel) : "CheckRowHeader is currently only compatible with SimpleTableModels";
        return (SimpleTableModel)this.table.getModel();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        RowHeader rowHeader = (RowHeader)list;
        JTable table = rowHeader.getTable();
        JCheckBox checkBox = (JCheckBox)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        checkBox.setHorizontalAlignment(0);
        if (isSelected) {
            checkBox.setForeground(list.getForeground());
            checkBox.setBorder(selectedBorder);
        } else {
            checkBox.setForeground(list.getForeground());
            checkBox.setBorder(unSelectedBorder);
        }
        checkBox.setBackground(list.getBackground());
        this.setBorderPainted(true);
        checkBox.setPreferredSize(null);
        Dimension prefSize = checkBox.getPreferredSize();
        prefSize.height = table.getRowHeight(index);
        checkBox.setPreferredSize(prefSize);
        if (index > -1) {
            int viewIndex = table.convertRowIndexToModel(index);
            Object tableRowObject = this.getTableModel().getRow(viewIndex);
            checkBox.setSelected(this.checkedItems.contains(tableRowObject));
        }
        return checkBox;
    }
}

