/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.overview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.overview.Overview;
import oracle.javatools.ui.overview.OverviewComponent;
import oracle.javatools.ui.overview.OverviewHoverable;
import oracle.javatools.ui.overview.OverviewTipProvider;

public final class OverviewStatus {
    private StatusComponent gui;
    public static final Icon BUSY_ICON = OracleIcons.getIcon((String)"gutter/throbber_small.gif");
    public static final Color ERROR = Color.RED;
    public static final Color OK = Color.GREEN;
    public static final Color WARNING = Color.ORANGE;
    public static final Color INCOMPLETE = new Color(232, 113, 209);
    private Overview overview;
    private OverviewTipProvider provider = null;
    private StatusHover statusHover = new StatusHover();

    public OverviewStatus(Overview overview) {
        assert (overview != null);
        this.overview = overview;
        this.gui = new StatusComponent();
        this.gui.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                HoverableRegistry.registerComponent((Component)OverviewStatus.this.gui, (Hoverable)OverviewStatus.this.statusHover);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                HoverableRegistry.unregisterComponent((Component)OverviewStatus.this.gui, (Hoverable)OverviewStatus.this.statusHover);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public void setColor(Color color) {
        if (color == null) {
            color = OverviewComponent.DEFAULT_COLOR;
        }
        this.gui.setBackground(color);
    }

    public void setIcon(Icon icon) {
        this.gui.setIcon(icon);
    }

    public void setTipProvider(OverviewTipProvider provider) {
        this.provider = provider;
    }

    JComponent getGUI() {
        return this.gui;
    }

    private class StatusHover
    implements Hoverable {
        private StatusHover() {
        }

        public Hover hover(Point p, List<HoverFlavor> flavors) {
            if (OverviewStatus.this.overview == null || OverviewStatus.this.provider == null || !flavors.contains(OverviewHoverable.HOVER_FLAVOR)) {
                return null;
            }
            Rectangle r = new Rectangle(0, 0, OverviewStatus.this.gui.getWidth(), OverviewStatus.this.gui.getHeight());
            InfoTipHover hover = new InfoTipHover(null, InfoTipStyles.DEFAULT, (JComponent)OverviewStatus.this.gui, r, OverviewHoverable.HOVER_FLAVOR);
            JComponent content = OverviewStatus.this.provider.getTipContent(OverviewStatus.this.overview.getMarks(), hover);
            if (content == null) {
                return null;
            }
            hover.setOrientation(switch (OverviewStatus.this.provider.getOrientation()) {
                case OverviewTipProvider.Orientation.TOP_BOTTOM -> InfoTipOrientation.TOP_BOTTOM;
                case OverviewTipProvider.Orientation.LEFT_RIGHT -> InfoTipOrientation.LEFT_RIGHT;
                case OverviewTipProvider.Orientation.RIGHT_LEFT -> InfoTipOrientation.RIGHT_LEFT;
                case OverviewTipProvider.Orientation.BOTTOM_TOP -> InfoTipOrientation.BOTTOM_TOP;
                default -> InfoTipOrientation.LEFT_RIGHT;
            });
            hover.setContent(new BasicTemplate(content));
            hover.showHover();
            return hover;
        }
    }

    private class StatusComponent
    extends JLabel {
        private StatusComponent() {
            this.setBackground(OverviewComponent.DEFAULT_COLOR);
            this.setOpaque(false);
            int size = OverviewStatus.this.overview.getOverviewComponent().getBreadth();
            this.setPreferredSize(new Dimension(size, size));
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.getIcon() == null) {
                Color color = this.getBackground();
                g.setColor(color);
                g.fillRect(1, 1, OverviewStatus.this.overview.getOverviewComponent().getMarkBreadth(), OverviewStatus.this.overview.getOverviewComponent().getMarkBreadth());
                g.setColor(color.darker());
                if (!OverviewComponent.DEFAULT_COLOR.equals(color)) {
                    g.drawLine(1, 1 + OverviewStatus.this.overview.getOverviewComponent().getMarkBreadth(), 1 + OverviewStatus.this.overview.getOverviewComponent().getMarkBreadth(), 1 + OverviewStatus.this.overview.getOverviewComponent().getMarkBreadth());
                    g.drawLine(1 + OverviewStatus.this.overview.getOverviewComponent().getMarkBreadth(), 1, 1 + OverviewStatus.this.overview.getOverviewComponent().getMarkBreadth(), 1 + OverviewStatus.this.overview.getOverviewComponent().getMarkBreadth());
                }
            }
        }
    }
}

