/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import oracle.javatools.ui.search.PromptedTextField;

public class PromptedComboBoxEditor
extends BasicComboBoxEditor {
    public PromptedComboBoxEditor() {
    }

    public PromptedComboBoxEditor(String prompt) {
        this();
        this.getEditorComponent().setPrompt(prompt);
    }

    @Override
    protected JTextField createEditorComponent() {
        BorderlessPromptedTextField textField = new BorderlessPromptedTextField();
        ((JComponent)textField).setBorder(UIManager.getBorder("ComboBox.editorBorder"));
        return textField;
    }

    @Override
    public PromptedTextField getEditorComponent() {
        return (PromptedTextField)this.editor;
    }

    protected static class BorderlessPromptedTextField
    extends PromptedTextField {
        public BorderlessPromptedTextField() {
            this.setColumns(9);
            this.setText("");
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public void setBorder(Border b) {
            if (!(b instanceof BasicComboBoxEditor.UIResource)) {
                super.setBorder(b);
            }
        }
    }
}

