/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.combo.JCustomComboBox;
import oracle.javatools.ui.combo.TreeComboRenderer;
import oracle.javatools.ui.combo.TreeFixListComboModel;

public class JTreeFixListCombo
extends JCustomComboBox {
    private JTree tree;
    private JList fixList;
    private JScrollPane sp;
    private boolean fixListBelow = true;
    private Dimension minSize = new Dimension(160, 200);
    private Dimension maxSize = new Dimension(360, 400);

    public JTreeFixListCombo() {
        this.init();
    }

    public JTreeFixListCombo(TreeModel treeModel, ListModel fixedModel) {
        this.init();
        this.setModel(treeModel, fixedModel);
    }

    public void setModel(TreeModel treeModel, ListModel fixedModel) {
        TreeFixListComboModel tflcModel = new TreeFixListComboModel(this.tree, this.fixList, this.fixListBelow);
        this.tree.setModel(treeModel);
        this.fixList.setModel(fixedModel);
        super.setModel(tflcModel);
        this.expandAll();
    }

    public void setTreeComboRenderer(TreeComboRenderer renderer) {
        this.tree.setCellRenderer(renderer);
        this.setRenderer((ListCellRenderer)renderer);
    }

    public void setRenderer(ListCellRenderer aRenderer) {
        super.setRenderer(aRenderer);
        if (this.fixList != null) {
            this.fixList.setCellRenderer(aRenderer);
        }
    }

    private void expandAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    protected void updatePopupPreferredSize() {
        int prefW = this.tree.getPreferredSize().width;
        Dimension newD = new Dimension(prefW, this.tree.getRowHeight() * this.tree.getRowCount());
        newD.width = Math.max(Math.min(newD.width, this.maxSize.width), this.minSize.width);
        newD.height = Math.max(Math.min(newD.height, this.maxSize.height), this.minSize.height);
        newD.width = Math.max(newD.width, this.getWidth() - 4);
        this.sp.getViewport().setPreferredSize(newD);
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        this.updatePopupPreferredSize();
        Object selObj = this.getSelectedItem();
        ((TreeFixListComboModel)this.getModel()).setSelectedItem(selObj);
        super.firePopupMenuWillBecomeVisible();
    }

    private void init() {
        this.tree = new JTree();
        this.fixList = new JList();
        this.tree.addMouseListener(new TreeClickListener());
        this.tree.addMouseMotionListener(new TreeMouseListener());
        this.tree.setFocusable(false);
        this.fixList.addMouseListener(new ListClickListener());
        this.fixList.addMouseMotionListener(new ListMouseListener());
        this.fixList.setFocusable(false);
        this.fixList.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("List.foreground")));
        this.addKeyListener(new KeyExpandListener());
        JPanel panel = new JPanel(new BorderLayout());
        this.sp = new JScrollPane(this.tree, 20, 30);
        this.sp.setBorder(BorderFactory.createEmptyBorder());
        this.setPopupComponent(panel);
        this._addListsToPopup();
        ListMouseListener lml = new ListMouseListener();
        this.fixList.addMouseMotionListener(lml);
        ListClickListener lcl = new ListClickListener();
        this.fixList.addMouseListener(lcl);
        SingleSelectionListener slsl = new SingleSelectionListener();
        this.fixList.addListSelectionListener(slsl);
        this.tree.addTreeSelectionListener(slsl);
    }

    private void _addListsToPopup() {
        JComponent panel = this.getPopupComponent();
        if (this.fixListBelow) {
            panel.add((Component)this.sp, "North");
            panel.add((Component)this.fixList, "South");
        } else {
            panel.add((Component)this.fixList, "North");
            panel.add((Component)this.sp, "South");
        }
    }

    public boolean getFixListBelow() {
        return this.fixListBelow;
    }

    public void setFixListBelow(boolean fixListBelow) {
        if (fixListBelow == this.fixListBelow) {
            return;
        }
        this.fixListBelow = fixListBelow;
        this.getPopupComponent().removeAll();
        this._addListsToPopup();
        ((TreeFixListComboModel)this.getModel()).setFixListBelow(fixListBelow);
    }

    public void setMinimumPopupSize(Dimension minSize) {
        this.minSize = minSize;
    }

    public Dimension getMinimumPopupSize() {
        return this.minSize;
    }

    public void setMaximumPopupSize(Dimension maxSize) {
        this.maxSize = maxSize;
    }

    public Dimension getMaximumPopupSize() {
        return this.maxSize;
    }

    public JList getFixList() {
        return this.fixList;
    }

    public JTree getTree() {
        return this.tree;
    }

    private class TreeClickListener
    extends MouseAdapter {
        private TreeClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object obj;
            TreePath path = JTreeFixListCombo.this.tree.getPathForLocation(e.getX(), e.getY());
            if (path != null && (obj = path.getLastPathComponent()) != null) {
                JTreeFixListCombo.this.setSelectedItem(obj);
                JTreeFixListCombo.this.hidePopup();
            }
        }
    }

    private class TreeMouseListener
    extends MouseMotionAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TreePath path = JTreeFixListCombo.this.tree.getPathForLocation(e.getX(), e.getY());
            JTreeFixListCombo.this.tree.setSelectionPath(path);
        }
    }

    private class ListClickListener
    extends MouseAdapter {
        private ListClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (JTreeFixListCombo.this.fixListBelow) {
                index += JTreeFixListCombo.this.tree.getRowCount();
            }
            JTreeFixListCombo.this.setSelectedIndex(index);
            JTreeFixListCombo.this.hidePopup();
        }
    }

    private class ListMouseListener
    extends MouseMotionAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            list.setSelectedIndex(index);
        }
    }

    private class KeyExpandListener
    extends KeyAdapter {
        private KeyExpandListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath tp;
            if (e.getKeyCode() == 37) {
                tp = JTreeFixListCombo.this.tree.getSelectionPath();
                JTreeFixListCombo.this.tree.collapsePath(tp);
            }
            if (e.getKeyCode() == 39) {
                tp = JTreeFixListCombo.this.tree.getSelectionPath();
                JTreeFixListCombo.this.tree.expandPath(tp);
            }
        }
    }

    private class SingleSelectionListener
    implements ListSelectionListener,
    TreeSelectionListener {
        private SingleSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (JTreeFixListCombo.this.fixList.getSelectedIndex() >= 0) {
                JTreeFixListCombo.this.tree.clearSelection();
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (JTreeFixListCombo.this.tree.getSelectionPath() != null) {
                JTreeFixListCombo.this.fixList.clearSelection();
            }
        }
    }
}

