/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.calendar.CalendarModel;

final class TimeEditPanel
extends JPanel {
    private JSpinner timeSpinner;
    private JComboBox<ZoneId> timeZoneCombo;
    private CalendarModel model;

    public TimeEditPanel(CalendarModel model) {
        this.model = model;
        Date dateTime = model.getDateTime();
        this.timeSpinner = new JSpinner(new SpinnerDateModel(dateTime, null, null, 11));
        JFormattedTextField spinTF = ((JSpinner.DateEditor)this.timeSpinner.getEditor()).getTextField();
        Dimension prefSize = spinTF.getPreferredSize();
        spinTF.setPreferredSize(prefSize);
        this.updateTimeSpinnerFormat();
        Set<String> ids = ZoneId.getAvailableZoneIds();
        ZoneId[] zoneIds = (ZoneId[])ids.stream().map(ZoneId::of).sorted((o1, o2) -> o1.getDisplayName(TextStyle.FULL_STANDALONE, TimeEditPanel.getDefaultLocale()).compareTo(o2.getDisplayName(TextStyle.FULL_STANDALONE, TimeEditPanel.getDefaultLocale()))).toArray(ZoneId[]::new);
        DefaultComboBoxModel<ZoneId> comboModel = new DefaultComboBoxModel<ZoneId>(zoneIds);
        this.timeZoneCombo = new JComboBox<ZoneId>(comboModel);
        this.timeZoneCombo.setSelectedItem(model.getZoneId().getId());
        this.timeZoneCombo.setRenderer(new TimeZoneRenderer());
        this.timeZoneCombo.setBackground(UIManager.getColor("TextArea.background"));
        this.timeZoneCombo.setFont(UIManager.getFont("Label.font"));
        this.timeZoneCombo.setBorder(null);
        this.timeZoneCombo.setPrototypeDisplayValue(ZoneId.systemDefault());
        this.timeSpinner.setAlignmentX(0.5f);
        this.timeZoneCombo.setAlignmentX(0.5f);
        this.setOpaque(false);
        this.setLayout((LayoutManager)new MigLayout("nogrid, fillx, hidemode 2"));
        this.add((Component)this.timeSpinner, "al center");
        this.add(this.timeZoneCombo, "newLine, growx");
        this.updateDisplay();
        TimeChangeListener timeListener = new TimeChangeListener();
        this.timeSpinner.addChangeListener(timeListener);
        this.timeZoneCombo.addItemListener(timeListener);
        model.addPropertyChangeListener(evt -> this.updateDisplay());
    }

    public void updateDisplay() {
        Date dateTime = this.model.getDateTime();
        this.timeSpinner.setValue(dateTime);
        this.updateTimeSpinnerFormat();
        ZoneId id = this.model.getZoneId();
        ZoneId selId = (ZoneId)this.timeZoneCombo.getSelectedItem();
        if (!id.equals(selId)) {
            this.timeZoneCombo.setSelectedItem(id);
        }
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.updateTimeSpinnerFormat();
        this.repaint();
    }

    private void updateTimeSpinnerFormat() {
        JSpinner.DateEditor de = (JSpinner.DateEditor)this.timeSpinner.getEditor();
        de.getTextField().setHorizontalAlignment(0);
        DateFormat df = SimpleDateFormat.getTimeInstance(2, this.getLocale());
        df.setTimeZone(TimeZone.getTimeZone(this.model.getZoneId()));
        DateFormatter dfer = new DateFormatter(df);
        DefaultFormatterFactory ff = new DefaultFormatterFactory(dfer);
        de.getTextField().setFormatterFactory(ff);
    }

    public void setShowTimeZone(boolean showTimeZone) {
        this.timeZoneCombo.setVisible(showTimeZone);
    }

    public boolean getShowTimeZone() {
        return this.timeZoneCombo.isVisible();
    }

    public void setShowTime(boolean showTimeZone) {
        this.timeSpinner.setVisible(showTimeZone);
    }

    public boolean getShowTime() {
        return this.timeSpinner.isVisible();
    }

    private class TimeZoneRenderer
    extends DefaultListCellRenderer {
        private TimeZoneRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ZoneId zoneId = (ZoneId)value;
            String displayName = zoneId.getDisplayName(TextStyle.FULL_STANDALONE, TimeEditPanel.this.getLocale());
            Color faded = UIManager.getColor("Label.disabledForeground");
            if (index >= 0) {
                label.setText(String.format("<html>%s <font color=rgb(%s,%s,%s)>%s</font>", displayName, faded.getRed(), faded.getGreen(), faded.getBlue(), zoneId.getId()));
            } else {
                label.setText(displayName);
            }
            label.setHorizontalAlignment(index == -1 ? 0 : 10);
            label.setAlignmentX(index == -1 ? 0.5f : 0.0f);
            return label;
        }
    }

    private class TimeChangeListener
    implements ChangeListener,
    ItemListener {
        private TimeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Date time = (Date)TimeEditPanel.this.timeSpinner.getValue();
            Instant instant = time.toInstant();
            LocalTime localTime = LocalDateTime.ofInstant(instant, TimeEditPanel.this.model.getZoneId()).toLocalTime();
            TimeEditPanel.this.model.setTime(localTime);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ZoneId zoneId = (ZoneId)TimeEditPanel.this.timeZoneCombo.getSelectedItem();
            TimeEditPanel.this.model.setZoneId(zoneId);
            TimeEditPanel.this.updateDisplay();
        }
    }
}

