/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.View;

public final class StringUtils {
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock = new Object();
    private static char[] charsBuffer = new char[100];
    private static final int STRONG_BEARING_CACHE_SIZE = 10;
    private static BearingCacheEntry[] strongBearingCache = new BearingCacheEntry[10];
    private static int strongBearingCacheNextIndex = 0;
    private static Set<SoftReference<BearingCacheEntry>> softBearingCache = new HashSet<SoftReference<BearingCacheEntry>>();

    private StringUtils() {
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap, int ellipsesLocation) {
        int gap;
        horizontalAlignment = StringUtils.getAbsoluteAlignment(horizontalAlignment);
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        int lsb = 0;
        int rsb = 0;
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
            gap = 0;
        } else {
            gap = icon == null ? 0 : textIconGap;
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = Math.min(availTextWidth, (int)v.getPreferredSpan(0));
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                textR.width = SwingUtilities.computeStringWidth(fm, text);
                lsb = StringUtils.getLeftSideBearing(c, fm, text);
                if (lsb < 0) {
                    textR.width -= lsb;
                }
                if (textR.width > availTextWidth) {
                    text = StringUtils.clipString(c, fm, text, availTextWidth, ellipsesLocation);
                    textR.width = SwingUtilities.computeStringWidth(fm, text);
                }
                textR.height = fm.getHeight();
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        if (lsb < 0) {
            textR.x -= lsb;
            textR.width += lsb;
        }
        if (rsb > 0) {
            textR.width -= rsb;
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clipString(JComponent c, FontMetrics fm, String string, int availTextWidth, int clipLocation) {
        String clipString = "...";
        int stringLength = ((String)string).length();
        availTextWidth -= SwingUtilities.computeStringWidth(fm, clipString);
        Object object = charsBufferLock;
        synchronized (object) {
            if (charsBuffer == null || charsBuffer.length < stringLength) {
                charsBuffer = ((String)string).toCharArray();
            } else {
                ((String)string).getChars(0, stringLength, charsBuffer, 0);
            }
            int width = 0;
            switch (clipLocation) {
                case 10: {
                    for (int nChars = stringLength - 1; nChars >= 0; --nChars) {
                        if ((width += fm.charWidth(charsBuffer[nChars])) <= availTextWidth) continue;
                        string = ((String)string).substring(nChars + 1);
                        break;
                    }
                    string = clipString + (String)string;
                    break;
                }
                case 11: {
                    for (int nChars = 0; nChars < stringLength; ++nChars) {
                        if ((width += fm.charWidth(charsBuffer[nChars])) <= availTextWidth) continue;
                        string = ((String)string).substring(0, nChars);
                        break;
                    }
                    string = (String)string + clipString;
                    break;
                }
                case 0: {
                    boolean addLeft = true;
                    int leftCount = 0;
                    int rightCount = 0;
                    for (int nChars = 0; nChars < stringLength; ++nChars) {
                        int i;
                        int n = i = addLeft ? leftCount : stringLength - 1 - rightCount;
                        if ((width += fm.charWidth(charsBuffer[i])) > availTextWidth) break;
                        leftCount += addLeft ? 1 : 0;
                        rightCount += addLeft ? 0 : 1;
                        addLeft = !addLeft;
                    }
                    String leftString = leftCount == 0 ? "" : ((String)string).substring(0, leftCount);
                    String rightString = rightCount == 0 ? "" : ((String)string).substring(stringLength - rightCount);
                    string = leftString + clipString + rightString;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("StringUtils.clipString called with bad clipLocation: " + clipLocation);
                }
            }
        }
        return string;
    }

    private static int getAbsoluteAlignment(int alignment) {
        ComponentOrientation co = ComponentOrientation.getOrientation(Locale.getDefault());
        if (co.isLeftToRight()) {
            if (alignment == 10) {
                alignment = 2;
            } else if (alignment == 11) {
                alignment = 4;
            }
        } else if (alignment == 10) {
            alignment = 4;
        } else if (alignment == 11) {
            alignment = 2;
        }
        return alignment;
    }

    private static int getLeftSideBearing(JComponent c, FontMetrics fm, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return StringUtils.getLeftSideBearing(c, fm, string.charAt(0));
    }

    private static int getLeftSideBearing(JComponent c, FontMetrics fm, char firstChar) {
        return StringUtils.getBearing(c, fm, firstChar, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getBearing(JComponent comp, FontMetrics fm, char c, boolean isLeftBearing) {
        if (fm == null) {
            if (comp == null) {
                return 0;
            }
            fm = comp.getFontMetrics(comp.getFont());
        }
        Class<StringUtils> clazz = StringUtils.class;
        synchronized (StringUtils.class) {
            BearingCacheEntry entry = null;
            BearingCacheEntry searchKey = new BearingCacheEntry(fm);
            for (BearingCacheEntry cacheEntry : strongBearingCache) {
                if (!searchKey.equals(cacheEntry)) continue;
                entry = cacheEntry;
                break;
            }
            if (entry == null) {
                Iterator<SoftReference<BearingCacheEntry>> iter = softBearingCache.iterator();
                while (iter.hasNext()) {
                    BearingCacheEntry cacheEntry = iter.next().get();
                    if (cacheEntry == null) {
                        iter.remove();
                        continue;
                    }
                    if (!searchKey.equals(cacheEntry)) continue;
                    entry = cacheEntry;
                    StringUtils.putEntryInStrongCache(entry);
                    break;
                }
            }
            if (entry == null) {
                entry = searchKey;
                StringUtils.cacheEntry(entry);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return isLeftBearing ? entry.getLeftSideBearing(c) : entry.getRightSideBearing(c);
        }
    }

    private static synchronized void cacheEntry(BearingCacheEntry entry) {
        BearingCacheEntry oldestEntry = strongBearingCache[strongBearingCacheNextIndex];
        if (oldestEntry != null) {
            softBearingCache.add(new SoftReference<BearingCacheEntry>(oldestEntry));
        }
        StringUtils.putEntryInStrongCache(entry);
    }

    private static synchronized void putEntryInStrongCache(BearingCacheEntry entry) {
        StringUtils.strongBearingCache[StringUtils.strongBearingCacheNextIndex] = entry;
        strongBearingCacheNextIndex = (strongBearingCacheNextIndex + 1) % 10;
    }

    private static class BearingCacheEntry {
        private FontMetrics fontMetrics;
        private Font font;
        private FontRenderContext frc;
        private Map<Character, Short> cache;
        private static final char[] oneChar = new char[1];

        public BearingCacheEntry(FontMetrics fontMetrics) {
            this.fontMetrics = fontMetrics;
            this.font = fontMetrics.getFont();
            this.frc = fontMetrics.getFontRenderContext();
            this.cache = new HashMap<Character, Short>();
            assert (this.font != null && this.frc != null);
        }

        public int getLeftSideBearing(char aChar) {
            Short bearing = this.cache.get(Character.valueOf(aChar));
            if (bearing == null) {
                bearing = this.calcBearing(aChar);
                this.cache.put(Character.valueOf(aChar), bearing);
            }
            return ((0xFF00 & bearing) >>> 8) - 127;
        }

        public int getRightSideBearing(char aChar) {
            Short bearing = this.cache.get(Character.valueOf(aChar));
            if (bearing == null) {
                bearing = this.calcBearing(aChar);
                this.cache.put(Character.valueOf(aChar), bearing);
            }
            return (0xFF & bearing) - 127;
        }

        private short calcBearing(char aChar) {
            Object aaHint;
            BearingCacheEntry.oneChar[0] = aChar;
            GlyphVector gv = this.font.createGlyphVector(this.frc, oneChar);
            Rectangle pixelBounds = gv.getGlyphPixelBounds(0, this.frc, 0.0f, 0.0f);
            int lsb = pixelBounds.x;
            int rsb = pixelBounds.width - this.fontMetrics.charWidth(aChar);
            if (lsb < 0 && ((aaHint = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                ++lsb;
            }
            if (rsb > 0 && ((aaHint = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                --rsb;
            }
            if (lsb < -127 || lsb > 127) {
                lsb = 0;
            }
            if (rsb < -127 || rsb > 127) {
                rsb = 0;
            }
            int bearing = (lsb + 127 << 8) + (rsb + 127);
            return (short)bearing;
        }

        public boolean equals(Object entry) {
            if (entry == this) {
                return true;
            }
            if (!(entry instanceof BearingCacheEntry)) {
                return false;
            }
            BearingCacheEntry oEntry = (BearingCacheEntry)entry;
            return this.font.equals(oEntry.font) && this.frc.equals(oEntry.frc);
        }

        public int hashCode() {
            int result = 17;
            if (this.font != null) {
                result = 37 * result + this.font.hashCode();
            }
            if (this.frc != null) {
                result = 37 * result + this.frc.hashCode();
            }
            return result;
        }
    }
}

