/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.lang.ref.SoftReference;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.LayerUI;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.ui.internal.UICUtils;

public final class DropShadow {
    private static int SHADOW_DEPTH = 6;

    private DropShadow() {
    }

    public static JComponent createShadowedComponent(JComponent c) {
        JLayer<JComponent> layer = new JLayer<JComponent>(c, new ShadowLayerUI());
        return layer;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        JPanel comp = new JPanel(new FlowLayout());
        comp.setOpaque(false);
        comp.add(DropShadow.createShadowedComponent(new JButton("Hello!")));
        comp.add(DropShadow.createShadowedComponent(new JList<Object>(new Object[]{"One", "Two", "Three"})));
        comp.add(DropShadow.createShadowedComponent(new JTree()));
        UICUtils.runComponent(comp);
    }

    private static class ShadowLayerUI
    extends LayerUI {
        private SoftReference<BufferedImage> shadowImageRef = new SoftReference<Object>(null);

        private ShadowLayerUI() {
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Dimension d = super.getPreferredSize(c);
            d.width += SHADOW_DEPTH;
            d.height += SHADOW_DEPTH;
            return d;
        }

        public void doLayout(JLayer l) {
            super.doLayout(l);
            Object view = l.getView();
            if (view != null) {
                ((Component)view).setBounds(0, 0, Math.max(0, l.getWidth() - SHADOW_DEPTH), Math.max(0, l.getHeight() - SHADOW_DEPTH));
            }
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Graphics2D g2 = (Graphics2D)g.create();
            this.paintShadow(g2, new Rectangle(0, 0, c.getWidth() - SHADOW_DEPTH - 2, c.getHeight() - SHADOW_DEPTH - 2));
            g2.dispose();
            super.paint(g, c);
        }

        private Object[] getCachedImage(SoftReference<BufferedImage> imageRef, int width, int height) {
            BufferedImage image = imageRef.get();
            if (image != null && (image.getWidth() != width || image.getHeight() != height)) {
                image = null;
            }
            Object[] ret = new Object[2];
            ret[1] = imageRef;
            if (image == null) {
                image = new BufferedImage(width, height, 2);
                ret[1] = new SoftReference<BufferedImage>(image);
            } else {
                Graphics2D g2D = image.createGraphics();
                g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
                g2D.fill(rect);
            }
            ret[0] = image;
            return ret;
        }

        private void paintShadow(Graphics2D g2, Shape shape) {
            Rectangle shadowR = shape.getBounds();
            Object[] cacheImage = this.getCachedImage(this.shadowImageRef, shadowR.width + 2 * SHADOW_DEPTH, shadowR.height + 2 * SHADOW_DEPTH);
            BufferedImage shadowImage = (BufferedImage)cacheImage[0];
            this.shadowImageRef = (SoftReference)cacheImage[1];
            Graphics2D shadowG = shadowImage.createGraphics();
            shadowG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            shadowG.setColor(new Color(0, 0, 0));
            shadowG.translate(-shadowR.x + SHADOW_DEPTH, -shadowR.y + SHADOW_DEPTH);
            shadowG.fill(shape);
            shadowG.translate(shadowR.x - SHADOW_DEPTH, shadowR.y - SHADOW_DEPTH);
            float i = 0.04f;
            float[] elements = new float[]{i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i};
            Kernel myKernel = new Kernel(5, 5, elements);
            ConvolveOp simpleBlur = new ConvolveOp(myKernel);
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2.drawImage(shadowImage, simpleBlur, shadowR.x, shadowR.y);
            shadowG.dispose();
        }
    }
}

