/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.samlp;

import java.util.List;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.samlp.AttributeQuery;
import oracle.security.xmlsec.samlp.AuthenticationQuery;
import oracle.security.xmlsec.samlp.AuthorizationDecisionQuery;
import oracle.security.xmlsec.samlp.Query;
import oracle.security.xmlsec.samlp.RequestType;
import oracle.security.xmlsec.samlp.SAMLPUtils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Request
extends RequestType {
    private static final String[] nsURIs = new String[]{"urn:oasis:names:tc:SAML:1.0:protocol", "http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:protocol"};
    private static final String[] localNames = new String[]{"RespondWith", "Signature", "Query", "SubjectQuery", "AuthenticationQuery", "AttributeQuery", "AuthorizationDecisionQuery", "AssertionIDReference", "AssertionArtifact"};

    public Request(Element element) throws DOMException {
        super(element);
    }

    public Request(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Request(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:1.0:protocol", "Request");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public void setQuery(Query query) {
        this.removeChildElements(false, false);
        XMLUtils.insertChild((XMLElement)this, (XMLElement)query, (String[])nsURIs, (String[])localNames, (int)2);
    }

    public AuthenticationQuery getAuthenticationQuery() {
        return (AuthenticationQuery)SAMLPUtils.getChildElement(this, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery");
    }

    public AttributeQuery getAttributeQuery() {
        return (AttributeQuery)SAMLPUtils.getChildElement(this, "urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery");
    }

    public AuthorizationDecisionQuery getAuthorizationDecisionQuery() {
        return (AuthorizationDecisionQuery)SAMLPUtils.getChildElement(this, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery");
    }

    public void addAssertionIDReference(String value) {
        Element assertionIDRefElement = this.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
        assertionIDRefElement.setPrefix(XMLElement.getDefaultNSPrefix((String)"urn:oasis:names:tc:SAML:1.0:assertion"));
        this.appendChild(assertionIDRefElement);
        assertionIDRefElement.appendChild(this.getOwnerDocument().createTextNode(value));
        this.removeChildElements(true, false);
        XMLUtils.insertChild((Element)((Element)this.node), (Element)assertionIDRefElement, (String[])nsURIs, (String[])localNames, (int)7);
    }

    public List getAssertionIDReferences() {
        return SAMLPUtils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
    }

    public void addAssertionArtifact(String value) {
        Element assertionArtElement = this.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)assertionArtElement);
        assertionArtElement.appendChild(this.getOwnerDocument().createTextNode(value));
        this.removeChildElements(false, true);
        XMLUtils.insertChild((Element)((Element)this.node), (Element)assertionArtElement, (String[])nsURIs, (String[])localNames, (int)8);
    }

    public List getAssertionArtifacts() {
        return SAMLPUtils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact");
    }

    private void removeChildElements(boolean keepIDRef, boolean keepArtifact) {
        NodeList list = this.getChildElementsByTagName("*");
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            String name = node.getLocalName();
            if (name == null) {
                String tn = ((Element)node).getTagName();
                int j = tn.indexOf(":");
                String string = name = j == -1 ? tn : tn.substring(j + 1);
            }
            if ("RespondWith".equals(name) || "Signature".equals(name) || "AssertionIDReference".equals(name) && keepIDRef || "AssertionArtifact".equals(name) && keepArtifact) continue;
            this.removeChild(node);
        }
    }

    static {
        SAMLInitializer.initialize();
    }
}

