/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import oracle.dbtools.raptor.metrics.observable.DXRow;

abstract class ButtonCellHelper<C extends TableColumnBase<?, Object>, L extends IndexedCell<?>> {
    private final StringProperty enabledColumnProperty = new SimpleStringProperty((Object)this, "enabledColumn");
    private final StringProperty textProperty = new SimpleStringProperty((Object)this, "text");
    private final StringProperty imagePathProperty = new SimpleStringProperty((Object)this, "image");
    private final ObjectProperty<EventHandler<ActionEvent>> onActionProperty = new SimpleObjectProperty((Object)this, "onAction");

    ButtonCellHelper() {
    }

    StringProperty enabledColumnProperty() {
        return this.enabledColumnProperty;
    }

    StringProperty textProperty() {
        return this.textProperty;
    }

    StringProperty imagePathProperty() {
        return this.imagePathProperty;
    }

    ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onActionProperty;
    }

    Button createButton(ClassLoader classLoader) {
        ImageView imageView = null;
        String string = (String)this.imagePathProperty.get();
        if (string != null) {
            imageView = new ImageView(new Image(classLoader.getResourceAsStream(string)));
        }
        Button button = new Button((String)this.textProperty.get(), imageView);
        button.setPrefWidth(Double.MAX_VALUE);
        button.setPadding(new Insets(1.0));
        button.setOnAction(actionEvent -> {
            this.selectCell((IndexedCell)button.getParent());
            EventHandler eventHandler = (EventHandler)this.onActionProperty.get();
            if (eventHandler != null) {
                eventHandler.handle(actionEvent);
            }
        });
        return button;
    }

    void updateButtonTooltip(L l, Button button) {
        Tooltip tooltip = l.getTooltip();
        if (tooltip != null) {
            Tooltip tooltip2 = button.getTooltip();
            if (tooltip2 == null) {
                tooltip2 = new Tooltip();
                button.setTooltip(tooltip2);
            }
            tooltip2.setText(tooltip.getText());
        }
    }

    abstract void selectCell(L var1);

    boolean isEnabled(DXRow dXRow) {
        Boolean bl;
        ObjectProperty<Boolean> objectProperty;
        boolean bl2 = false;
        if (dXRow != null && (objectProperty = dXRow.get((String)this.enabledColumnProperty.get(), Boolean.class)) != null && (bl = (Boolean)objectProperty.get()) != null) {
            bl2 = bl;
        }
        return bl2;
    }
}

