/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.logging.Level;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import oracle.dbtools.raptor.metrics.engine.EngineObjectProperty;
import oracle.dbtools.raptor.metrics.engine.MetaProperty;
import oracle.dbtools.raptor.metrics.engine.TypeProperty;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

public abstract class InstanceProperty<T>
extends EngineObjectProperty<T> {
    private final TypeProperty<T> typeProperty;
    private ChangeListener<T> changeListener;

    protected InstanceProperty(TypeProperty<T> typeProperty) {
        this.typeProperty = typeProperty;
    }

    @Override
    public MetaProperty<T> getMeta() {
        return this.typeProperty.getMeta();
    }

    @Override
    PropertyValue<T> createPropertyValue() {
        return new PropertyValue<T>(this.getMeta(), this.get(), this.isOverridden());
    }

    @Override
    T getDefaultValue() {
        return this.typeProperty.get();
    }

    abstract boolean isAttachedToInstance();

    @Override
    EngineObjectProperty.ValueHolder createInitialValue() {
        MetaProperty<T> metaProperty = this.typeProperty.getMeta();
        boolean bl = false;
        Object t = this.getContext().getPropertyStore().get(metaProperty.getType(), this.getId(), metaProperty.getName(), null);
        if (t != null) {
            try {
                metaProperty.validate(t);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.getContext().getLogger().log(Level.WARNING, "persisted property value cannot be validated");
            }
        }
        EngineObjectProperty.ValueHolder valueHolder = bl ? new EngineObjectProperty.ValueHolder(new SimpleObjectProperty(t), true) : new EngineObjectProperty.ValueHolder(new SimpleObjectProperty(this.typeProperty.get()), false);
        if (this.isAttachedToInstance()) {
            this.changeListener = (observableValue, object, object2) -> {
                if (!valueHolder.overridden) {
                    valueHolder.property.set(object2);
                    if (this.getEngineObject() != null) {
                        this.getContext().getActivityListenerService().addEngineObjectChange(this.getEngineObject(), ChangeType.UPDATE);
                    }
                }
            };
            this.typeProperty.getObservable().addListener(this.changeListener);
        }
        return valueHolder;
    }

    void release() {
        if (this.changeListener != null) {
            this.typeProperty.getObservable().removeListener(this.changeListener);
        }
    }
}

