/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.AbstractEngineObject;
import oracle.dbtools.raptor.metrics.engine.AbstractTypeObject;
import oracle.dbtools.raptor.metrics.engine.ContainerInstanceObject;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.EngineObjectProperty;
import oracle.dbtools.raptor.metrics.engine.Handle;
import oracle.dbtools.raptor.metrics.engine.InstanceProperty;
import oracle.dbtools.raptor.metrics.engine.MergeSet;
import oracle.dbtools.raptor.metrics.engine.MetaProperty;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.TypeProperty;

public abstract class ContainerTypeObject
extends AbstractTypeObject {
    private Context context;
    private MergeSet mergeSet;
    private List<TypeProperty<?>> properties;

    protected ContainerTypeObject() {
    }

    protected ContainerTypeObject(ContainerTypeObject containerTypeObject) {
        super(containerTypeObject);
        this.context = containerTypeObject.context;
    }

    public List<TypeProperty<?>> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList();
            this.enumerateProperties(this.properties);
        }
        return this.properties;
    }

    public <T> TypeProperty<T> getProperty(Class<T> clazz, String string) {
        TypeProperty typeProperty2 = this.getProperties().stream().filter(typeProperty -> typeProperty.getMeta().getName().equals(string)).findFirst().orElse(null);
        if (typeProperty2 != null && !clazz.isAssignableFrom(typeProperty2.getMeta().getType())) {
            return null;
        }
        return (Property)typeProperty2;
    }

    public List<InstanceProperty<?>> getInstanceProperties(URI uRI) {
        ObjectManager objectManager = this.getContext().getObjectManager();
        ContainerInstanceObject containerInstanceObject = this.findInstance(objectManager, objectManager.createHandle(uRI));
        List<InstanceProperty<?>> list = containerInstanceObject != null ? containerInstanceObject.getProperties() : this.createInstanceProperties(uRI);
        return list;
    }

    @Override
    public <T> InstanceProperty<T> getInstanceProperty(URI uRI, Class<T> clazz, String string) {
        ObjectManager objectManager = this.getContext().getObjectManager();
        ContainerInstanceObject containerInstanceObject = this.findInstance(objectManager, objectManager.createHandle(uRI));
        InstanceProperty<T> instanceProperty = containerInstanceObject != null ? containerInstanceObject.getProperty((Class)clazz, string) : this.createInstanceProperty(uRI, clazz, string);
        return instanceProperty;
    }

    @Override
    protected Logger getLogger() {
        return this.context.getLogger();
    }

    protected abstract void enumerateProperties(List<TypeProperty<?>> var1);

    Context getContext() {
        return this.context;
    }

    MergeSet getMergeSet() {
        return this.mergeSet;
    }

    List<InstanceProperty<?>> createInstanceProperties(URI uRI) {
        ArrayList arrayList = new ArrayList();
        for (TypeProperty<?> typeProperty : this.getProperties()) {
            InstanceProperty<?> instanceProperty = this.createInstanceProperty(uRI, typeProperty);
            arrayList.add(instanceProperty);
        }
        return arrayList;
    }

    <T> InstanceProperty<T> createInstanceProperty(URI uRI, Class<T> clazz, String string) {
        EngineObjectProperty engineObjectProperty = this.getProperty((Class)clazz, string);
        return this.createInstanceProperty(uRI, (TypeProperty<T>)engineObjectProperty);
    }

    List<InstanceProperty<?>> createInstanceProperties(final ContainerInstanceObject containerInstanceObject) {
        ArrayList arrayList = new ArrayList();
        for (TypeProperty<?> typeProperty : this.getProperties()) {
            InstanceProperty instanceProperty = new InstanceProperty(typeProperty){

                @Override
                Context getContext() {
                    return ContainerTypeObject.this.getContext();
                }

                @Override
                AbstractEngineObject getEngineObject() {
                    return containerInstanceObject;
                }

                @Override
                URI getId() {
                    return containerInstanceObject.getId();
                }

                @Override
                boolean isAttachedToInstance() {
                    return true;
                }
            };
            arrayList.add(instanceProperty);
        }
        return arrayList;
    }

    @Override
    abstract ContainerInstanceObject findInstance(ObjectManager var1, Handle var2);

    void onMerge(Context context, MergeSet mergeSet) {
        this.context = context;
        this.mergeSet = mergeSet;
    }

    private <T> InstanceProperty<T> createInstanceProperty(final URI uRI, TypeProperty<T> typeProperty) {
        return new InstanceProperty<T>(typeProperty){

            @Override
            Context getContext() {
                return ContainerTypeObject.this.getContext();
            }

            @Override
            AbstractEngineObject getEngineObject() {
                return null;
            }

            @Override
            URI getId() {
                return uRI;
            }

            @Override
            boolean isAttachedToInstance() {
                return false;
            }
        };
    }

    protected class Property<T>
    extends TypeProperty<T> {
        protected Property(MetaProperty<T> metaProperty) {
            super(metaProperty);
        }

        protected Property(TypeProperty<T> typeProperty) {
            super(typeProperty);
        }

        @Override
        Context getContext() {
            return ContainerTypeObject.this.getContext();
        }

        @Override
        AbstractEngineObject getEngineObject() {
            return ContainerTypeObject.this;
        }

        @Override
        URI getId() {
            return ContainerTypeObject.this.getTypeId();
        }
    }
}

