/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import oracle.dbtools.raptor.metrics.control.MultiBarElement;

public class MultiBar
extends Region {
    private final ObservableList<MultiBarElement> elements = FXCollections.observableArrayList();
    private final ChangeListener<Number> elementValueListener = (observableValue, number, number2) -> this.requestLayout();

    public MultiBar() {
        this.getStyleClass().setAll((Object[])new String[]{"multibar"});
        this.elements.addListener(change -> {
            while (change.next()) {
                for (MultiBarElement multiBarElement : change.getAddedSubList()) {
                    multiBarElement.valueProperty().addListener(this.elementValueListener);
                }
                for (MultiBarElement multiBarElement : change.getRemoved()) {
                    multiBarElement.valueProperty().removeListener(this.elementValueListener);
                }
            }
            this.requestLayout();
        });
    }

    public ObservableList<MultiBarElement> getElements() {
        return this.elements;
    }

    protected void layoutChildren() {
        ObservableList observableList = this.getChildren();
        int n = this.elements.size();
        int n2 = observableList.size();
        if (n2 > n) {
            for (var4_4 = n; var4_4 < n2; ++var4_4) {
                observableList.remove(n);
            }
        } else if (n2 < n) {
            for (var4_4 = n2; var4_4 < n; ++var4_4) {
                Rectangle rectangle = new Rectangle();
                rectangle.getStyleClass().add((Object)"multibar-element");
                String string = ((MultiBarElement)this.elements.get(var4_4)).getStyleClass();
                if (string != null) {
                    rectangle.getStyleClass().add((Object)string);
                }
                observableList.add((Object)rectangle);
            }
        }
        double d = this.getHeight();
        double d2 = this.getWidth();
        double d3 = 1.0;
        for (int i = 0; i < n; ++i) {
            MultiBarElement multiBarElement = (MultiBarElement)this.elements.get(i);
            Rectangle rectangle = (Rectangle)observableList.get(i);
            double d4 = multiBarElement.getValue() * (d2 - 2.0);
            rectangle.setX(d3);
            rectangle.setY(1.0);
            rectangle.setWidth(d4);
            rectangle.setHeight(d - 2.0);
            d3 += d4;
        }
    }
}

