/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import oracle.dbtools.raptor.metrics.console.ItemView;
import oracle.dbtools.raptor.metrics.console.JobTypeView;
import oracle.dbtools.raptor.metrics.console.SourceView;
import oracle.dbtools.raptor.metrics.console.ViewObject;
import oracle.dbtools.raptor.metrics.console.ViewProperty;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.listener.JobChange;

public class JobView
extends ViewObject<JobChange> {
    private ObjectProperty<JobTypeView> jobTypeProperty;
    private ObjectProperty<SourceView> sourceProperty;
    private final ObservableSet<ItemView> itemsProperty = FXCollections.observableSet(new HashSet());
    private final BooleanProperty disabledProperty = new SimpleBooleanProperty((Object)this, "disabled", false);
    private final DoubleProperty lastElapsedTimeProperty = new SimpleDoubleProperty((Object)this, "lastElapsedTime", -1.0);
    private final StringProperty lastStatusProperty = new SimpleStringProperty((Object)this, "lastException");

    public JobTypeView getJobType() {
        return (JobTypeView)this.jobTypeProperty().get();
    }

    public ObservableObjectValue<JobTypeView> jobTypeProperty() {
        return this.jobTypeProperty;
    }

    public SourceView getSource() {
        return (SourceView)this.sourceProperty().get();
    }

    public ObservableObjectValue<SourceView> sourceProperty() {
        return this.sourceProperty;
    }

    public ObservableSet<ItemView> getItems() {
        return this.itemsProperty;
    }

    public boolean isDisabled() {
        return this.disabledProperty.get();
    }

    public ObservableBooleanValue disabledProperty() {
        return this.disabledProperty;
    }

    public double getLastElapsedTime() {
        return this.lastElapsedTimeProperty.get();
    }

    public ObservableDoubleValue lastElapsedTimeProperty() {
        return this.lastElapsedTimeProperty;
    }

    public String getLastStatus() {
        return (String)this.lastStatusProperty.get();
    }

    public ObservableStringValue lastStatusProperty() {
        return this.lastStatusProperty;
    }

    JobView() {
    }

    @Override
    void onAdd(ViewObject.Context context, JobChange jobChange) {
        super.onAdd(context, jobChange);
        this.jobTypeProperty = new SimpleObjectProperty((Object)this, "jobType", (Object)context.lookupObject(JobTypeView.class, jobChange.getTypeId()));
        this.sourceProperty = new SimpleObjectProperty((Object)this, "source", (Object)context.lookupObject(SourceView.class, jobChange.getSourceId()));
        ((SourceView)this.sourceProperty.get()).addJobView(this);
    }

    @Override
    void onUpdate(JobChange jobChange) {
        super.onUpdate(jobChange);
        boolean bl = false;
        List<ViewProperty<?>> list = this.getProperties();
        Optional<ViewProperty> optional = list.stream().filter(viewProperty -> viewProperty.getMeta().getName().equals("disabled")).findFirst();
        if (optional.isPresent()) {
            bl = (Boolean)optional.get().get();
        }
        this.disabledProperty.set(bl);
        this.lastElapsedTimeProperty.set((double)Math.round((double)jobChange.getLastRunElapsedTime() / 100000.0) / 10.0);
        DXException dXException = jobChange.getLastRunException();
        this.lastStatusProperty.set((Object)(dXException == null ? "Normal" : dXException.getMessage()));
    }

    @Override
    void onRemove() {
        super.onRemove();
        ((SourceView)this.sourceProperty.get()).removeJobView(this);
    }

    void addItemView(ItemView itemView) {
        this.itemsProperty.add((Object)itemView);
    }

    void removeItemView(ItemView itemView) {
        this.itemsProperty.remove((Object)itemView);
    }
}

