/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.actionobject.BackgroundTask;
import oracle.dbtools.raptor.metrics.panel.AbstractGenerationTemplate;
import oracle.dbtools.raptor.metrics.panel.AbstractTemplate;
import oracle.dbtools.raptor.metrics.panel.Action;
import oracle.dbtools.raptor.metrics.panel.GenerationResult;

public class GenerateFile
extends AbstractGenerationTemplate
implements Action {
    private final StringProperty filePathProperty = new SimpleStringProperty((Object)this, "filePath");
    private final ObjectProperty<Action> completionActionProperty = new SimpleObjectProperty((Object)this, "completionAction");

    public GenerateFile() {
        this.init(new Listener());
    }

    public String getFilePath() {
        return (String)this.filePathProperty.get();
    }

    public void setFilePath(String string) {
        this.filePathProperty.set((Object)string);
    }

    public StringProperty filePathProperty() {
        return this.filePathProperty;
    }

    public Action getCompletionAction() {
        return (Action)this.completionActionProperty.get();
    }

    public void setCompletionAction(Action action) {
        this.completionActionProperty.set((Object)action);
    }

    public ObjectProperty<Action> completionActionProperty() {
        return this.completionActionProperty;
    }

    @Override
    public Boolean get() {
        final String string = this.getFilePath();
        if (string == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "'FilePath' must be specified in invocation of GenerateFileAction");
            return false;
        }
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.indexOf(46);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final GenerationResult[] generationResultArray = new GenerationResult[]{null};
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("FilePath", string);
        hashMap.put("FileName", string2);
        this.generateText(hashMap, generationResult -> {
            generationResultArray[0] = generationResult;
            countDownLatch.countDown();
        });
        BackgroundTask backgroundTask = new BackgroundTask(){
            private volatile Thread taskThread;

            @Override
            protected boolean cancelTask() {
                if (this.taskThread != null) {
                    this.taskThread.interrupt();
                }
                return true;
            }

            @Override
            protected void doTask(BackgroundTask.Context context) {
                if (!context.isCancelled()) {
                    String string3;
                    String string2;
                    boolean bl;
                    this.taskThread = Thread.currentThread();
                    try {
                        countDownLatch.await();
                        bl = generationResultArray[0].isSuccessful();
                        if (bl) {
                            string2 = generationResultArray[0].getText();
                            string3 = null;
                        } else {
                            string2 = "";
                            string3 = generationResultArray[0].getText();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!context.isCancelled()) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unexpectedly interrupted waiting for generation to complete");
                        }
                        GenerateFile.this.cancelGeneration();
                        bl = false;
                        string2 = "";
                        string3 = MetricsResources.getString("METRICS_SQLMON_REPORT_INTERRUPTED");
                    }
                    try {
                        try (FileWriter fileWriter = new FileWriter(string);){
                            fileWriter.write(string2);
                            ((Writer)fileWriter).flush();
                        }
                        if (bl) {
                            context.setStatus(true, MetricsResources.format("METRICS_GENERATION_SUCCESS", string), () -> {
                                Action action = GenerateFile.this.getCompletionAction();
                                if (action != null) {
                                    action.get();
                                }
                            });
                        } else {
                            context.setStatus(false, MetricsResources.format("METRICS_GENERATION_FAILURE", string, string3));
                        }
                    }
                    catch (IOException iOException) {
                        context.setStatus(false, MetricsResources.format("METRICS_GENERATION_FAILURE", string, iOException.getLocalizedMessage()));
                    }
                }
            }
        };
        backgroundTask.enqueue();
        return true;
    }

    protected class Listener
    extends AbstractTemplate.Listener {
        protected Listener() {
            super(GenerateFile.this);
        }
    }
}

