/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;

public class Resources {
    private Resources() {
    }

    public static JLabel label(String string) {
        return Resources.label(string, null, 10);
    }

    public static JLabel label(String string, Icon icon) {
        return Resources.label(string, icon, 10);
    }

    public static JLabel label(String string, Icon icon, int horizontalAlignment) {
        JLabel label = new JLabel(Resources.text(string), icon, horizontalAlignment);
        label.setDisplayedMnemonic(Resources.key(string));
        label.setDisplayedMnemonicIndex(Resources.index(string));
        return label;
    }

    public static JLabel label(JLabel label, String string) {
        String text = Resources.text(string);
        int key = Resources.key(string);
        int index = Resources.index(string);
        if (text != null) {
            label.setText(text);
        }
        if (key != 0) {
            label.setDisplayedMnemonic(key);
        }
        if (index >= 0) {
            label.setDisplayedMnemonicIndex(index);
        }
        return label;
    }

    public static JLabel labelFor(Component component, String string) {
        return Resources.labelFor(component, string, null, 10);
    }

    public static JLabel labelFor(JComponent component, String string, String tip) {
        return Resources.labelFor(component, string, null, 10, tip);
    }

    public static JLabel labelFor(Component component, String string, Icon icon, int horizontalAlignment) {
        JLabel label = new JLabel(Resources.text(string), icon, horizontalAlignment);
        label.setDisplayedMnemonic(Resources.key(string));
        label.setDisplayedMnemonicIndex(Resources.index(string));
        label.setLabelFor(component);
        return label;
    }

    public static JLabel labelFor(JComponent component, String string, Icon icon, int horizontalAlignment, String tip) {
        JLabel label = Resources.labelFor(component, string, icon, horizontalAlignment);
        component.setToolTipText(Resources.text(tip));
        return label;
    }

    public static JButton button(String string) {
        return Resources.button(string, null, null);
    }

    public static JButton button(String string, String tip) {
        return Resources.button(string, null, tip);
    }

    public static JButton button(String string, Icon icon) {
        return Resources.button(string, icon, null);
    }

    public static JButton button(String string, Icon icon, String tip) {
        JButton button = new JButton(Resources.text(string), icon);
        button.setMnemonic(Resources.key(string));
        button.setDisplayedMnemonicIndex(Resources.index(string));
        button.setToolTipText(Resources.text(tip));
        return button;
    }

    public static JToggleButton toggleButton(String string) {
        return Resources.toggleButton(string, null, false, null);
    }

    public static JToggleButton toggleButton(String string, String tip) {
        return Resources.toggleButton(string, null, false, tip);
    }

    public static JToggleButton toggleButton(String string, boolean selected) {
        return Resources.toggleButton(string, null, selected, null);
    }

    public static JToggleButton toggleButton(String string, boolean selected, String tip) {
        return Resources.toggleButton(string, null, selected, tip);
    }

    public static JToggleButton toggleButton(String string, Icon icon) {
        return Resources.toggleButton(string, icon, false, null);
    }

    public static JToggleButton toggleButton(String string, Icon icon, String tip) {
        return Resources.toggleButton(string, icon, false, tip);
    }

    public static JToggleButton toggleButton(String string, Icon icon, boolean selected) {
        return Resources.toggleButton(string, icon, selected, null);
    }

    public static JToggleButton toggleButton(String string, Icon icon, boolean selected, String tip) {
        JToggleButton button = new JToggleButton(Resources.text(string), icon, selected);
        button.setMnemonic(Resources.key(string));
        button.setDisplayedMnemonicIndex(Resources.index(string));
        button.setToolTipText(Resources.text(tip));
        return button;
    }

    public static JCheckBox checkBox(String string) {
        return Resources.checkBox(string, null, false, null);
    }

    public static JCheckBox checkBox(String string, String tip) {
        return Resources.checkBox(string, null, false, tip);
    }

    public static JCheckBox checkBox(String string, boolean selected) {
        return Resources.checkBox(string, null, selected, null);
    }

    public static JCheckBox checkBox(String string, boolean selected, String tip) {
        return Resources.checkBox(string, null, selected, tip);
    }

    public static JCheckBox checkBox(String string, Icon icon, boolean selected) {
        return Resources.checkBox(string, icon, selected, null);
    }

    public static JCheckBox checkBox(String string, Icon icon, boolean selected, String tip) {
        JCheckBox checkBox = new JCheckBox(Resources.text(string), icon, selected);
        checkBox.setMnemonic(Resources.key(string));
        checkBox.setDisplayedMnemonicIndex(Resources.index(string));
        checkBox.setToolTipText(Resources.text(tip));
        return checkBox;
    }

    public static JMenuItem menuItem(String string) {
        return Resources.menuItem(string, null, null);
    }

    public static JMenuItem menuItem(String string, String tip) {
        return Resources.menuItem(string, null, tip);
    }

    public static JMenuItem menuItem(String string, Icon icon) {
        return Resources.menuItem(string, icon, null);
    }

    public static JMenuItem menuItem(String string, Icon icon, String tip) {
        JMenuItem menuItem = new JMenuItem(Resources.text(string), icon);
        menuItem.setMnemonic(Resources.key(string));
        menuItem.setDisplayedMnemonicIndex(Resources.index(string));
        menuItem.setToolTipText(Resources.text(tip));
        return menuItem;
    }

    public static <T extends AbstractButton> T button(T button, String string) {
        return Resources.button(button, string, null);
    }

    public static <T extends AbstractButton> T button(T button, Icon icon) {
        return Resources.button(button, null, icon, null);
    }

    public static <T extends AbstractButton> T button(T button, String string, String tip) {
        return Resources.button(button, string, null, tip);
    }

    public static <T extends AbstractButton> T button(T button, Icon icon, String tip) {
        return Resources.button(button, null, icon, tip);
    }

    public static <T extends AbstractButton> T button(T button, String string, Icon icon, String tip) {
        String text = Resources.text(string);
        int key = Resources.key(string);
        int index = Resources.index(string);
        tip = Resources.text(tip);
        if (text != null) {
            button.setText(text);
        }
        if (key != 0) {
            button.setMnemonic(key);
        }
        if (index >= 0) {
            button.setDisplayedMnemonicIndex(index);
        }
        if (icon != null) {
            button.setIcon(icon);
        }
        if (tip != null) {
            button.setToolTipText(tip);
        }
        return button;
    }

    public static <T extends Action> T action(T action, String string) {
        return Resources.action(action, string, null, null, null);
    }

    public static <T extends Action> T action(T action, String string, Icon icon) {
        return Resources.action(action, string, icon, null, null);
    }

    public static <T extends Action> T action(T action, String string, String tip) {
        return Resources.action(action, string, null, tip, null);
    }

    public static <T extends Action> T action(T action, Icon icon, String tip) {
        return Resources.action(action, null, icon, tip, null);
    }

    public static <T extends Action> T action(T action, String string, Icon icon, String tip) {
        return Resources.action(action, string, icon, tip, null);
    }

    public static <T extends Action> T action(T action, String string, Icon icon, boolean selected) {
        return Resources.action(action, string, icon, null, selected);
    }

    public static <T extends Action> T action(T action, Icon icon, String tip, boolean selected) {
        return Resources.action(action, null, icon, tip, selected);
    }

    public static <T extends Action> T action(T action, String string, boolean selected) {
        return Resources.action(action, string, null, null, selected);
    }

    public static <T extends Action> T action(T action, String string, Icon icon, String tip, Boolean selected) {
        String text = Resources.text(string);
        int key = Resources.key(string);
        int index = Resources.index(string);
        tip = Resources.text(tip);
        if (text != null) {
            action.putValue("Name", text);
        }
        if (key != 0) {
            action.putValue("MnemonicKey", key);
        }
        if (index >= 0) {
            action.putValue("SwingDisplayedMnemonicIndexKey", index);
        }
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
        if (tip != null) {
            action.putValue("ShortDescription", tip);
        }
        if (selected != null) {
            action.putValue("SwingSelectedKey", selected);
        }
        return action;
    }

    private static String text(String string) {
        if (string == null || ((String)string).isEmpty()) {
            return null;
        }
        int index = ((String)string).indexOf(38);
        if (index >= 0 && index < ((String)string).length() && ((String)(string = ((String)string).substring(0, index) + ((String)string).substring(index + 1))).isEmpty()) {
            return null;
        }
        if (((String)string).endsWith("...")) {
            string = ((String)string).substring(0, ((String)string).length() - 3) + "\u2026";
        }
        return string;
    }

    private static int key(String string) {
        if (string == null) {
            return 0;
        }
        int index = string.indexOf(38);
        if (index < 0 || index >= string.length()) {
            return 0;
        }
        return KeyEvent.getExtendedKeyCodeForChar(string.charAt(index + 1));
    }

    private static int index(String string) {
        if (string == null) {
            return -1;
        }
        int index = string.indexOf(38);
        if (index + 1 == string.length()) {
            return -1;
        }
        return index;
    }
}

