/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.controls.OverlayIcon;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.model.Located;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditListener;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdeveloper.audit.service.AuditModelListener;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Iteration;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.Suppression;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.service.ViolationHelper;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.AbstractAuditModel;
import oracle.jdevimpl.audit.core.DefaultAuditModelComparator;

public class DefaultAuditModel
extends AbstractAuditModel
implements AuditListener {
    private final Synchronizer synchronizer = new Synchronizer();
    private int locationsEntered;
    private int lastSerialNumber;
    private Profile profile;
    private List<Location> selection;
    private List<Metric> columns = new ArrayList<Metric>();
    private ConstructRow root = new RootRow(this);
    private List<AuditModelFilter> filters = new ArrayList<AuditModelFilter>();
    private ChangeListener filterListener = new FilterSorterListener();
    private DefaultAuditModelComparator comparator;
    private Map<Violation, List<Transform>> violationsTransformed = new HashMap<Violation, List<Transform>>();
    private static final Log LOG = new Log("model");
    private static final Log LOG_EVENT = new Log(new String[]{"model-event", "model"});
    private static final Log LOG_NOTIFY = new Log(new String[]{"model-notify", "model"});
    private static final Log COLUMNS = new Log("columns");
    private static final List<Row> NO_CHILDREN = Collections.emptyList();
    private static final int CONSTRUCT_SERIAL_NUMBER = 0;
    private ViolationHelper helper = new ViolationHelper();

    public DefaultAuditModel() {
        LOG.trace("audit model created");
        this.comparator = new DefaultAuditModelComparator();
        this.comparator.addChangeListener(this.filterListener);
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public List<Location> getLocations() {
        return this.selection;
    }

    @Override
    public int getColumnCount() {
        COLUMNS.trace("getColumnCount from {0}", this.columns);
        return this.columns.size() + 1;
    }

    @Override
    public Metric getColumn(int index) {
        COLUMNS.trace("getColumn {0} from {1}", index, this.columns);
        return index == 0 || this.columns.size() == 0 ? null : this.columns.get(index - 1);
    }

    @Override
    public int getColumnIndex(Metric column) {
        COLUMNS.trace("getColumnIndex {0} from {1}", (Object)column, this.columns);
        return column == null ? 0 : this.columns.indexOf(column) + 1;
    }

    @Override
    public void setSortColumn(int column) {
        this.comparator.setColumn(column);
    }

    @Override
    public int getSortColumn() {
        return this.comparator.getColumn();
    }

    @Override
    public int getSortDirection() {
        return this.comparator.getDirection();
    }

    @Override
    public void clear() {
        this.synchronizer.clear();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getParent(Object row) {
        return ((Row)row).getParent();
    }

    @Override
    public int getIndexOf(Object row) {
        return ((Row)row).getIndexOf();
    }

    @Override
    public boolean isLeaf(Object row) {
        return ((Row)row).isLeaf();
    }

    @Override
    public boolean hasChildren(Object row) {
        return ((Row)row).getChildCount() > 0;
    }

    @Override
    public int getChildCount(Object row) {
        return ((Row)row).getChildCount();
    }

    @Override
    public List<?> getChildren(Object row) {
        return ((Row)row).getChildren();
    }

    @Override
    public Comparator<Object> getChildComparator() {
        return this.comparator;
    }

    @Override
    public boolean isVisible(Object row) {
        return ((Row)row).isVisible();
    }

    @Override
    public void addFilter(AuditModelFilter filter) {
        LOG.trace("**** adding filter {0}", (Object)filter);
        filter.setModel(this);
        filter.addChangeListener(this.filterListener);
        this.filters.add(filter);
        this.refilter();
    }

    @Override
    public void removeFilter(AuditModelFilter filter) {
        LOG.trace("**** removing filter {0}", (Object)filter);
        filter.removeChangeListener(this.filterListener);
        filter.setModel(null);
        this.filters.remove(filter);
        this.refilter();
    }

    @Override
    public <T extends AuditModelFilter> T findFilter(Class<T> type) {
        for (AuditModelFilter filter : this.filters) {
            if (!type.isInstance(filter)) continue;
            return (T)((AuditModelFilter)type.cast(filter));
        }
        return null;
    }

    @Override
    public Object getVisibleParent(Object row) {
        return ((Row)row).getVisibleParent();
    }

    @Override
    public int getVisibleIndexOf(Object row) {
        return ((Row)row).getVisibleIndexOf();
    }

    @Override
    public boolean hasVisibleChildren(Object row) {
        return ((Row)row).hasVisibleChildren();
    }

    @Override
    public int getVisibleChildCount(Object row) {
        return ((Row)row).getVisibleChildCount();
    }

    @Override
    public List<?> getVisibleChildren(Object row) {
        return ((Row)row).getVisibleChildren();
    }

    @Override
    public Object iterateChildren(Object row, Iteration iteration) {
        List<Row> children = ((Row)row).getChildren();
        for (Row child : children) {
            if (this.isVisible(child)) {
                if (iteration.iteration(child)) continue;
                return child;
            }
            Object last = this.iterateChildren(child, iteration);
            if (last == null) continue;
            return last;
        }
        return null;
    }

    @Override
    public Violation iterateViolations(Object row, Iteration iteration) {
        if (this.isViolation(row)) {
            Violation violation;
            if (this.isVisible(row) && !iteration.iteration(violation = this.getViolation(row))) {
                return violation;
            }
        } else {
            List<Row> children = ((Row)row).getChildren();
            for (Row child : children) {
                Violation last = this.iterateViolations(child, iteration);
                if (last == null) continue;
                return last;
            }
        }
        return null;
    }

    @Override
    public Location getLocation(Object row) {
        return ((Row)row).getLocation();
    }

    @Override
    public Location getFocusLocation(Object row) {
        return ((Row)row).getFocusLocation();
    }

    @Override
    public boolean isViolation(Object row) {
        return row instanceof ViolationRow;
    }

    @Override
    public Violation getViolation(Object row) {
        return ((Row)row).getViolation();
    }

    public Class getType(Object row) {
        return ((Row)row).getType();
    }

    @Override
    public String getLabel(Object row) {
        return ((Row)row).getShortLabel();
    }

    @Override
    public String getSummary(Object row) {
        return ((Row)row).getSummary();
    }

    @Override
    public Icon getIcon(Object row) {
        return ((Row)row).getIcon();
    }

    @Override
    public Object getValue(Object row, int columnIndex) {
        return ((Row)row).getValue(columnIndex - 1);
    }

    @Override
    public void setValue(Object row, int columnIndex, Object value) {
        ((Row)row).setValue(columnIndex - 1, value);
    }

    @Override
    public int getCount(Object row, AuditModel.Count count) {
        switch (count) {
            case FILES: {
                return ((Row)row).getFileCount();
            }
            case ISSUES: {
                return ((Row)row).getIssueCount();
            }
            case OUT_OF_BANDS: {
                return ((Row)row).getOutOfBandCount();
            }
            case VISIBLE_FILES: {
                return ((Row)row).getVisibleFileCount();
            }
            case VISIBLE_ISSUES: {
                return ((Row)row).getVisibleIssueCount();
            }
            case VISIBLE_ERRORS: {
                return ((Row)row).getVisibleErrorCount();
            }
            case VISIBLE_WARNINGS: {
                return ((Row)row).getVisibleWarningCount();
            }
            case VISIBLE_INCOMPLETES: {
                return ((Row)row).getVisibleIncompleteCount();
            }
            case VISIBLE_ADVISORIES: {
                return ((Row)row).getVisibleAdvisoryCount();
            }
            case VISIBLE_OUT_OF_BANDS: {
                return ((Row)row).getVisibleOutOfBandCount();
            }
        }
        throw new IllegalArgumentException("unexpected Count enumeral " + count);
    }

    @Override
    public oracle.javatools.status.Severity getSeverity(Object row) {
        return ((Row)row).getSeverity();
    }

    @Override
    public boolean isOutOfBand(Object row, int columnIndex) {
        int metricIndex = columnIndex - 1;
        return this.columns.get(metricIndex).isOutOfBand(((Row)row).getValue(metricIndex));
    }

    @Override
    public boolean isOutOfBand(Object row) {
        return ((Row)row).getSelfOutOfBandCount() > 0;
    }

    @Override
    public List<Transform> getTransformsApplied(Violation violation) {
        List<Transform> list = this.violationsTransformed.get(violation);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public void setTransformDone(Transform transform, Violation violation) {
        List<Transform> list = this.violationsTransformed.get(violation);
        if (list == null) {
            list = new ArrayList<Transform>();
            this.violationsTransformed.put(violation, list);
        }
        list.add(transform);
        this.fireAppliedTransformsChanged(violation, list);
    }

    @Override
    public void setTransformUndone(Transform transform, Violation violation) {
        List<Transform> list = this.violationsTransformed.get(violation);
        if (list == null) {
            throw new IllegalStateException("transform not last applied");
        }
        int lastIndex = list.size() - 1;
        Transform lastTransform = list.remove(lastIndex);
        if (!transform.equals(lastTransform)) {
            throw new IllegalStateException("transform not last applied");
        }
        if (lastIndex == 0) {
            this.violationsTransformed.remove(violation);
        }
        this.fireAppliedTransformsChanged(violation, list);
    }

    private void setColumns(List<Metric> newColumns) {
        LOG.trace("setting columns to {0}", newColumns);
        for (Metric column : this.columns) {
            if (!(column instanceof AuditModelListener)) continue;
            this.removeAuditModelListener((AuditModelListener)((Object)column));
        }
        COLUMNS.trace("clearing columns {0}", this.columns);
        this.columns.clear();
        if (newColumns == null) {
            return;
        }
        COLUMNS.trace("setting columns {0}", newColumns);
        this.columns.addAll(newColumns);
        for (Metric column : this.columns) {
            if (!(column instanceof AuditModelListener)) continue;
            this.addAuditModelListener((AuditModelListener)((Object)column));
        }
    }

    @Override
    public void auditStarted(Auditor auditor, List<Metric> columns, List<Location> locations, Location root, Class<?> type) {
        this.locationsEntered = 0;
        this.lastSerialNumber = 0;
        this.synchronizer.auditStarted(auditor, columns, locations, this.createConstructRow(root, type));
    }

    @Override
    public void modelEntered(Auditor auditor, ModelAdapter model) {
        this.synchronizer.modelEntered(model);
    }

    @Override
    public void modelExited(Auditor auditor, ModelAdapter model) {
        this.synchronizer.modelExited(model);
    }

    @Override
    public void locationEntered(Auditor auditor, Location location, Class<?> type) {
        assert (location != null);
        if (this.locationsEntered++ == 0) {
            return;
        }
        ConstructRow row = this.createConstructRow(location, type);
        this.synchronizer.rowInserted(row);
    }

    @Override
    public void locationExited(Auditor auditor, Location location) {
    }

    @Override
    public void issueReported(Auditor auditor, Violation issue, int transformMask) {
        ViolationRow row = this.createViolationRow(issue, transformMask);
        this.synchronizer.rowInserted(row);
    }

    @Override
    public void valueReported(Auditor auditor, Location location, Metric metric, Object newValue) {
        this.synchronizer.valueReported(location, metric, newValue);
    }

    @Override
    public void phaseStarted(Auditor auditor, String phaseName) {
    }

    @Override
    public void auditStopped(Auditor auditor, boolean cancelled) {
        this.synchronizer.auditStopped(cancelled);
    }

    @Override
    public void auditorCleared(Auditor auditor) {
        this.clear();
    }

    public Row createDummyRow(AuditModel model, Object row) {
        return this.createConstructRow(model.getLocation(row), ConstructRow.class);
    }

    ConstructRow createConstructRow(Location location, Class type) {
        if (location.getModel().isFile()) {
            return new FileRow(this, location, type);
        }
        return new ContainerRow(this, location, type);
    }

    ViolationRow createViolationRow(Violation violation, int transformMask) {
        return new ViolationRow(this, violation, transformMask);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCount(this.root, AuditModel.Count.ISSUES));
        buffer.append(" issues, in ");
        buffer.append(this.getCount(this.root, AuditModel.Count.FILES));
        buffer.append(" documents: ");
        this.append(buffer, this.root, "  ");
        return buffer.toString();
    }

    private void append(StringBuffer buffer, Row row, String indent) {
        buffer.append('\n');
        buffer.append(indent);
        buffer.append(row.getLocation());
        for (Row child : row.getChildren()) {
            this.append(buffer, child, indent + "  ");
        }
    }

    private void resort() {
        this.root.resort();
        this.fireModelResorted();
    }

    private void refilter() {
        this.root.refilter(null);
    }

    private static boolean isAncestorOf(Row ancestor, Row descendant) {
        do {
            if (descendant != ancestor) continue;
            return true;
        } while ((descendant = descendant.parent) != null);
        return false;
    }

    private static int binarySearch(List<Row> rows, Row row, DefaultAuditModelComparator comparator) {
        DefaultAuditModel.assertSorted(rows, comparator);
        return Collections.binarySearch(rows, row, comparator);
    }

    private static void assertSorted(List<Row> rows, DefaultAuditModelComparator comparator) {
    }

    private class Synchronizer {
        private List<Metric> columns;
        private Segment segment;
        private static final int SEGMENT_SIZE = 128;
        private boolean asynchronous;
        private BlockingQueue<Segment> queue;
        private Timer timer;
        private static final int EVENT_PERIOD = 100;
        private static final int EVENT_TIME_BUDGET = 5;
        private static final int EVENT_PERIOD_FAST = 20;
        private static final int AUDITOR_QUEUE_LIMIT = 4;
        private static final int AUDITOR_SLEEP_INTERVAL = 20;
        private TimerAction timerAction;
        private final BlockingQueue<Segment> free = new ArrayBlockingQueue<Segment>(256);
        private int modelRows;
        private int modelValues;
        private int totalRows;
        private int totalValues;
        private int totalAllocations;
        private int totalBlocked;

        private Synchronizer() {
        }

        void auditStarted(final Auditor auditor, final List<Metric> columns, final List<Location> locations, final ConstructRow root) {
            LOG_EVENT.trace("handling audit started on {0}, columns {1}", (Object)root, columns);
            this.asynchronous = !SwingUtilities.isEventDispatchThread() && Ide.getIdeArgs().getCreateUI();
            this.columns = columns;
            this.segment = new Segment();
            this.queue = new LinkedBlockingQueue<Segment>();
            this.modelValues = 0;
            this.modelRows = 0;
            this.totalBlocked = 0;
            this.totalAllocations = 0;
            this.totalValues = 0;
            this.totalRows = 0;
            this.synchronize(new Runnable(){

                @Override
                public void run() {
                    DefaultAuditModel.this.profile = auditor.getProfile();
                    DefaultAuditModel.this.selection = locations;
                    DefaultAuditModel.this.setColumns(columns);
                    root.visible = true;
                    DefaultAuditModel.this.root = root;
                    DefaultAuditModel.this.comparator.setModel(DefaultAuditModel.this);
                    DefaultAuditModel.this.fireAuditStarted(columns, locations, root, root.getType());
                    LOG_EVENT.trace("fired audit started");
                }
            });
            if (this.asynchronous) {
                if (this.timer == null) {
                    this.timer = new Timer(100, null);
                }
                this.timerAction = new TimerAction(this.queue);
                this.timer.addActionListener(this.timerAction);
                this.timer.start();
            }
            LOG_EVENT.trace("completed handling audit started");
        }

        void modelEntered(ModelAdapter model) {
            this.totalRows += this.modelRows;
            this.totalValues += this.modelValues;
            this.modelValues = 0;
            this.modelRows = 0;
            if (model.isFile()) {
                LOG_EVENT.trace("model {0} entered, {1}", (Object)model, (Object)this);
            }
        }

        void rowInserted(Row row) {
            ++this.modelRows;
            assert (row != null);
            assert (!this.segment.isFull());
            this.segment.addRow(row);
            if (this.segment.isFull()) {
                this.flush();
            }
        }

        void valueReported(Location location, Metric metric, Object value) {
            ++this.modelValues;
            assert (!this.segment.isFull());
            this.segment.addValue(this.columns.indexOf(metric), location, value);
            if (this.segment.isFull()) {
                this.flush();
            }
        }

        void modelExited(ModelAdapter model) {
            if (model.isFile()) {
                this.maybeBlock(4);
                LOG_EVENT.trace("model {0} exited,  {1}", (Object)model, (Object)this);
            }
        }

        private void flush() {
            if (this.asynchronous) {
                LOG_EVENT.trace("flushing {0}", (Object)this);
                this.queue.add(this.segment);
                this.segment = (Segment)this.free.poll();
                if (this.segment == null) {
                    this.segment = new Segment();
                }
            } else {
                LOG_EVENT.trace("flushing and processing", (Object)this);
                this.segment.processAll();
            }
        }

        private void maybeBlock(int blockUntilThreshold) {
            if (!this.asynchronous || this.queue.size() <= blockUntilThreshold) {
                return;
            }
            long start = System.currentTimeMillis();
            do {
                LOG_EVENT.trace("blocking, {0}", (Object)this);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    CancellationException exception = new CancellationException("interrupted while throttling");
                    exception.initCause(e);
                    throw exception;
                }
            } while (this.queue.size() > blockUntilThreshold);
            int blocked = (int)(System.currentTimeMillis() - start);
            this.totalBlocked += blocked;
            LOG_EVENT.trace("end blocking after {0}ms", blocked);
        }

        void auditStopped(final boolean cancelled) {
            LOG_EVENT.trace("handling audit stopped, cancelled {0}, {1}", cancelled, (Object)this);
            if (!cancelled) {
                this.flush();
                this.maybeBlock(0);
            } else if (this.asynchronous) {
                this.queue.clear();
            }
            this.columns = null;
            this.totalRows += this.modelRows;
            this.totalValues += this.modelValues;
            if (this.asynchronous) {
                this.queue = null;
                this.timer.stop();
                this.timer.removeActionListener(this.timerAction);
            }
            this.synchronize(new Runnable(){

                @Override
                public void run() {
                    DefaultAuditModel.this.fireAuditStopped(cancelled);
                    LOG_EVENT.trace("fired audit stopped");
                }
            });
            LOG_EVENT.trace("completed handling audit stopped, {0}", (Object)this);
        }

        private void synchronize(Runnable task) {
            if (this.asynchronous) {
                SwingUtilities.invokeLater(task);
            } else {
                task.run();
            }
        }

        void clear() {
            this.columns = null;
            this.synchronize(new Runnable(){

                @Override
                public void run() {
                    DefaultAuditModel.this.profile = null;
                    DefaultAuditModel.this.selection = null;
                    DefaultAuditModel.this.root.clear();
                    DefaultAuditModel.this.setColumns(null);
                }
            });
        }

        public String toString() {
            int values;
            int rows;
            StringBuilder builder = new StringBuilder();
            if (this.columns != null) {
                if (this.asynchronous) {
                    builder.append("segment ").append(this.pad(this.segment.size, 3));
                    builder.append(", queue ").append(this.pad(this.queue.size(), 3));
                    builder.append(", free ").append(this.pad(this.free.size(), 3));
                } else {
                    builder.append("segment ").append(this.pad(this.segment.size, 3));
                }
            }
            if (this.columns != null) {
                builder.append(", ");
                rows = this.modelRows;
                values = this.modelValues;
            } else {
                builder.append("totals: ");
                rows = this.totalRows;
                values = this.totalValues;
            }
            if (this.asynchronous) {
                builder.append("allocated ").append(this.totalAllocations);
                builder.append(", blocked ").append(this.totalBlocked).append("ms");
                builder.append(", ");
            }
            builder.append("rows ").append(rows);
            builder.append(", values ").append(values);
            return builder.toString();
        }

        private String pad(int n, int width) {
            String text = String.valueOf(n);
            if (text.length() < width) {
                StringBuilder builder = new StringBuilder(" ");
                int i = width - text.length();
                while (--i > 0) {
                    builder.append(' ');
                }
                builder.append(text);
                return builder.toString();
            }
            return text;
        }

        private class Segment {
            private int size;
            private int[] indexes = new int[128];
            private Located[] rowsOrLocations = new Located[128];
            private Object[] values = new Object[128];

            private Segment() {
                ++Synchronizer.this.totalAllocations;
            }

            public boolean isEmpty() {
                return this.size == 0;
            }

            public boolean isFull() {
                return this.size == 128;
            }

            public void clear() {
                this.size = 0;
            }

            public void addRow(Row row) {
                this.indexes[this.size] = -1;
                this.rowsOrLocations[this.size] = row;
                this.values[this.size] = null;
                ++this.size;
            }

            public void addValue(int column, Location location, Object value) {
                this.indexes[this.size] = column;
                this.rowsOrLocations[this.size] = location;
                this.values[this.size] = value;
                ++this.size;
            }

            private void processAll() {
                for (int i = 0; i < this.size; ++i) {
                    try {
                        this.process(i);
                        continue;
                    }
                    catch (Throwable e) {
                        AuditLogger.error("exception while processing {0}: {1}", this.rowsOrLocations[i], e);
                        LOG_EVENT.trace("exception while processing {0}: {1}", (Object)this.rowsOrLocations[i], (Object)e);
                    }
                }
                this.size = 0;
            }

            private void process(int i) {
                int index = this.indexes[i];
                if (index < 0) {
                    Row child = (Row)this.rowsOrLocations[i];
                    Location childLocation = child.getLocation();
                    ConstructRow parent = this.getRow(childLocation);
                    assert (parent != child);
                    LOG.trace("processing {0} insertion into {1}", (Object)child, (Object)parent);
                    parent.insertChild(child);
                } else {
                    ConstructRow row = this.getRow(this.rowsOrLocations[i].getLocation());
                    Object value = this.values[i];
                    LOG.trace("processing {1} set value {0} to {2}", index, (Object)row, value);
                    row.setValue(index, value);
                }
            }

            private ConstructRow getRow(Location location) {
                ConstructRow row = DefaultAuditModel.this.root;
                block0: while (true) {
                    for (Row child : row.getChildren()) {
                        if (!(child instanceof ConstructRow) || !child.getLocation().contains(location)) continue;
                        row = (ConstructRow)child;
                        continue block0;
                    }
                    break;
                }
                LOG.trace("got {0} for {1}", (Object)row, (Object)location);
                return row;
            }

            public String toString() {
                return "Segment[" + this.size + "]";
            }
        }

        private class TimerAction
        implements ActionListener {
            private final BlockingQueue<Segment> queue;

            public TimerAction(BlockingQueue<Segment> queue) {
                this.queue = queue;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int count = 0;
                long start = System.currentTimeMillis();
                long interval = 0L;
                Segment segment = (Segment)this.queue.poll();
                while (segment != null) {
                    ++count;
                    segment.processAll();
                    Synchronizer.this.free.offer(segment);
                    interval = System.currentTimeMillis() - start;
                    if (interval > 5L && !this.queue.isEmpty()) {
                        Synchronizer.this.timer.setDelay(20);
                        LOG_EVENT.trace("timer deferred, processed {0} segments in {1}ms", (Object)count, (Object)interval);
                        return;
                    }
                    segment = (Segment)this.queue.poll();
                }
                Synchronizer.this.timer.setDelay(100);
                LOG_EVENT.trace("timer completed, processed {0} segments in {1}ms", (Object)count, (Object)interval);
            }
        }
    }

    private static final class RootRow
    extends ConstructRow {
        private RootRow(DefaultAuditModel model) {
            super(model, null, Void.TYPE);
            this.visible = true;
        }

        @Override
        Object getValue(int index) {
            return null;
        }

        @Override
        boolean isFile() {
            return false;
        }

        @Override
        int getFileCount() {
            return 0;
        }

        @Override
        int getVisibleFileCount() {
            return 0;
        }

        @Override
        public String getShortLabel() {
            return "";
        }

        @Override
        public String getSummary() {
            return "";
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        boolean reconcile(Changes changes) {
            return false;
        }

        @Override
        boolean propagateChangesToParentChanges(Changes changes, boolean show, boolean hide, Changes parentChanges) {
            return false;
        }

        @Override
        void refilter(Changes changes) {
        }

        @Override
        void resort() {
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof RootRow;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int compareTo(Row that) {
            return -1;
        }
    }

    private static abstract class ConstructRow
    extends Row {
        private List<Row> children = NO_CHILDREN;
        private List<Row> visibleCache = NO_CHILDREN;
        private int cacheSerial = -1;
        private int childrenSerial = 0;
        private Location location;
        private Class type;
        private int visibleChildren;
        private int issues;
        private int visibleErrors;
        private int visibleWarnings;
        private int visibleIncompletes;
        private int visibleAdvisories;
        private int childOutOfBands;
        private int visibleChildOutOfBands;

        ConstructRow(DefaultAuditModel model, Location location, Class type) {
            super(model);
            this.location = location;
            this.type = type;
        }

        void clear() {
            Changes selfChanges = this.beginChange(null);
            while (!this.children.isEmpty()) {
                this.children.get(0).removeFromParent(this, 0, selfChanges);
            }
            this.endChange(selfChanges, null);
        }

        void insertChild(Row child) {
            assert (child != null);
            assert (child != this);
            if (this.children == NO_CHILDREN) {
                Changes selfChanges = this.beginChange(null);
                this.children = new ArrayList<Row>(1);
                child.insertIntoParent(this, 0, selfChanges);
                this.endChange(selfChanges, null);
            } else if (child instanceof ConstructRow) {
                Row sibling;
                Changes selfChanges = this.beginChange(null);
                int index = -DefaultAuditModel.binarySearch(this.children, child, this.getModel().comparator) - 1;
                assert (index >= 0);
                ArrayList<Row> moving = null;
                while (index < this.children.size() && !(sibling = this.children.get(index)).hasChildren() && child.getLocation().contains(sibling.getLocation())) {
                    if (moving == null) {
                        moving = new ArrayList<Row>();
                    }
                    sibling.removeFromParent(this, index, selfChanges);
                    moving.add(sibling);
                }
                child.insertIntoParent(this, index, selfChanges);
                if (moving != null) {
                    selfChanges.restructure = true;
                    ConstructRow nestedParent = (ConstructRow)child;
                    nestedParent.children = new ArrayList<Row>(moving.size());
                    Changes nestedChanges = nestedParent.beginChange(selfChanges);
                    for (int i = 0; i < moving.size(); ++i) {
                        ((Row)moving.get(i)).insertIntoParent(nestedParent, i, nestedChanges);
                    }
                    nestedParent.endChange(nestedChanges, selfChanges);
                }
                this.endChange(selfChanges, null);
            } else {
                int index = -DefaultAuditModel.binarySearch(this.children, child, this.getModel().comparator) - 1;
                assert (index >= 0);
                Changes selfChanges = this.beginChange(null);
                child.insertIntoParent(this, index, selfChanges);
                this.endChange(selfChanges, null);
            }
        }

        void removeChild(Row child) {
            assert (child != null);
            assert (child != this);
            int index = DefaultAuditModel.binarySearch(this.children, child, this.getModel().comparator);
            assert (index >= 0);
            Changes selfChanges = this.beginChange(null);
            child.removeFromParent(this, index, selfChanges);
            this.endChange(selfChanges, null);
        }

        @Override
        void applyVisibilityIndependentChangesToSelf(Changes changes) {
            super.applyVisibilityIndependentChangesToSelf(changes);
            this.visibleChildren += changes.deltaVisibleChildren;
            this.issues += changes.deltaIssues;
            this.visibleErrors += changes.deltaVisibleErrors;
            this.visibleWarnings += changes.deltaVisibleWarnings;
            this.visibleIncompletes += changes.deltaVisibleIncompletes;
            this.visibleAdvisories += changes.deltaVisibleAdvisories;
            this.childOutOfBands += changes.deltaChildOutOfBands;
            this.visibleChildOutOfBands += changes.deltaVisibleChildOutOfBands;
            assert (this.visibleChildren >= 0);
            assert (this.issues >= 0);
            assert (this.visibleErrors >= 0);
            assert (this.visibleWarnings >= 0);
            assert (this.visibleIncompletes >= 0);
            assert (this.visibleAdvisories >= 0);
            assert (this.childOutOfBands >= 0);
            assert (this.visibleChildOutOfBands >= 0);
            ++this.childrenSerial;
        }

        @Override
        void propagateVisibilityChangeToParentChanges(Changes changes, boolean show, boolean hide, Changes parentChanges) {
            super.propagateVisibilityChangeToParentChanges(changes, show, hide, parentChanges);
            if (changes == null) {
                if (show) {
                    int oldValue = this.visibleChildren;
                    int newValue = 1;
                    parentChanges.deltaVisibleChildren += newValue - oldValue;
                } else if (hide) {
                    int oldValue = 1;
                    int newValue = this.visibleChildren;
                    parentChanges.deltaVisibleChildren += newValue - oldValue;
                }
            }
        }

        @Override
        boolean propagateChangesToParentChanges(Changes changes, boolean show, boolean hide, Changes parentChanges) {
            int deltaVisibleOutOfBands;
            int deltaOutOfBands;
            assert (changes.row == this);
            boolean propagated = false;
            if (show) {
                oldValue = this.visibleChildren - changes.deltaVisibleChildren;
                newValue = 1;
                parentChanges.deltaVisibleChildren += newValue - oldValue;
                propagated = true;
            } else if (hide) {
                oldValue = 1;
                newValue = this.visibleChildren;
                parentChanges.deltaVisibleChildren += newValue - oldValue;
                propagated = true;
            } else if (!this.visible && changes.deltaVisibleChildren != 0) {
                parentChanges.deltaVisibleChildren += changes.deltaVisibleChildren;
                propagated = true;
            }
            if (changes.deltaIssues != 0) {
                parentChanges.deltaIssues += changes.deltaIssues;
                propagated = true;
            }
            if (changes.deltaVisibleErrors != 0) {
                parentChanges.deltaVisibleErrors += changes.deltaVisibleErrors;
                propagated = true;
            }
            if (changes.deltaVisibleWarnings != 0) {
                parentChanges.deltaVisibleWarnings += changes.deltaVisibleWarnings;
                propagated = true;
            }
            if (changes.deltaVisibleIncompletes != 0) {
                parentChanges.deltaVisibleIncompletes += changes.deltaVisibleIncompletes;
                propagated = true;
            }
            if (changes.deltaVisibleAdvisories != 0) {
                parentChanges.deltaVisibleAdvisories += changes.deltaVisibleAdvisories;
                propagated = true;
            }
            if ((deltaOutOfBands = changes.deltaSelfOutOfBands + changes.deltaChildOutOfBands) != 0) {
                parentChanges.deltaChildOutOfBands += deltaOutOfBands;
                propagated = true;
            }
            if ((deltaVisibleOutOfBands = changes.deltaVisibleSelfOutOfBands + changes.deltaVisibleChildOutOfBands) != 0) {
                parentChanges.deltaVisibleChildOutOfBands += deltaVisibleOutOfBands;
                propagated = true;
            }
            return propagated;
        }

        @Override
        void fireCountChanges(Changes changes) {
            int deltaVisibleOutOfBands;
            int deltaOutOfBands;
            int deltaVisibleIssues;
            DefaultAuditModel model = this.getModel();
            if (changes.deltaIssues != 0) {
                model.fireCountChanged(this, AuditModel.Count.ISSUES, this.issues - changes.deltaIssues, this.issues);
            }
            if ((deltaVisibleIssues = changes.deltaVisibleErrors + changes.deltaVisibleWarnings + changes.deltaVisibleIncompletes + changes.deltaVisibleAdvisories) != 0) {
                int visibleIssues = this.visibleErrors + this.visibleWarnings + this.visibleIncompletes + this.visibleAdvisories;
                model.fireCountChanged(this, AuditModel.Count.VISIBLE_ISSUES, visibleIssues - deltaVisibleIssues, visibleIssues);
            }
            if (changes.deltaVisibleErrors != 0) {
                model.fireCountChanged(this, AuditModel.Count.VISIBLE_ERRORS, this.visibleErrors - changes.deltaVisibleErrors, this.visibleErrors);
            }
            if (changes.deltaVisibleWarnings != 0) {
                model.fireCountChanged(this, AuditModel.Count.VISIBLE_WARNINGS, this.visibleWarnings - changes.deltaVisibleWarnings, this.visibleWarnings);
            }
            if (changes.deltaVisibleIncompletes != 0) {
                model.fireCountChanged(this, AuditModel.Count.VISIBLE_INCOMPLETES, this.visibleIncompletes - changes.deltaVisibleIncompletes, this.visibleIncompletes);
            }
            if (changes.deltaVisibleAdvisories != 0) {
                model.fireCountChanged(this, AuditModel.Count.VISIBLE_ADVISORIES, this.visibleAdvisories - changes.deltaVisibleAdvisories, this.visibleAdvisories);
            }
            if ((deltaOutOfBands = changes.deltaSelfOutOfBands + changes.deltaChildOutOfBands) != 0) {
                int outOfBands = this.getOutOfBandCount();
                model.fireCountChanged(this, AuditModel.Count.OUT_OF_BANDS, outOfBands - deltaOutOfBands, outOfBands);
            }
            if ((deltaVisibleOutOfBands = changes.deltaVisibleSelfOutOfBands + changes.deltaVisibleChildOutOfBands) != 0) {
                int visibleOutOfBands = this.getVisibleOutOfBandCount();
                model.fireCountChanged(this, AuditModel.Count.VISIBLE_OUT_OF_BANDS, visibleOutOfBands - deltaVisibleOutOfBands, visibleOutOfBands);
            }
        }

        abstract boolean isFile();

        @Override
        int getChildCount() {
            return this.children.size();
        }

        @Override
        List<Row> getChildren() {
            return this.children;
        }

        @Override
        boolean hasChildren() {
            return !this.children.isEmpty();
        }

        @Override
        List<Row> getVisibleChildren() {
            if (this.visibleChildren > 0) {
                if (this.cacheSerial != this.childrenSerial) {
                    ArrayList<Row> children = new ArrayList<Row>(this.visibleChildren);
                    this.collectVisibleChildren(children);
                    assert (children.size() == this.visibleChildren) : "expected visible child count " + children.size() + ", actual " + this.visibleChildren;
                    this.cacheSerial = this.childrenSerial;
                    this.visibleCache = children;
                }
                return this.visibleCache;
            }
            return NO_CHILDREN;
        }

        @Override
        void collectVisibleChildren(List<Row> accumulator) {
            if (this.visibleChildren == 0) {
                return;
            }
            for (Row child : this.children) {
                if (child.visible) {
                    accumulator.add(child);
                    continue;
                }
                child.collectVisibleChildren(accumulator);
            }
        }

        @Override
        boolean hasVisibleChildren() {
            return this.visibleChildren > 0;
        }

        @Override
        int getVisibleChildCount() {
            return this.visibleChildren;
        }

        @Override
        int getVisibleRowCount() {
            return this.visible ? 1 : this.visibleChildren;
        }

        @Override
        int getIssueCount() {
            return this.issues;
        }

        @Override
        int getVisibleErrorCount() {
            return this.visibleErrors;
        }

        @Override
        int getVisibleWarningCount() {
            return this.visibleWarnings;
        }

        @Override
        int getVisibleIncompleteCount() {
            return this.visibleIncompletes;
        }

        @Override
        int getVisibleAdvisoryCount() {
            return this.visibleAdvisories;
        }

        @Override
        int getChildOutOfBandCount() {
            return this.childOutOfBands;
        }

        @Override
        int getVisibleChildOutOfBandCount() {
            return this.visibleChildOutOfBands;
        }

        @Override
        oracle.javatools.status.Severity getSeverity() {
            if (this.visibleErrors > 0) {
                return oracle.javatools.status.Severity.ERROR;
            }
            if (this.visibleWarnings > 0) {
                return oracle.javatools.status.Severity.WARNING;
            }
            if (this.visibleIncompletes > 0) {
                return oracle.javatools.status.Severity.INCOMPLETE;
            }
            if (this.visibleAdvisories > 0) {
                return oracle.javatools.status.Severity.ADVISORY;
            }
            return null;
        }

        @Override
        void refilter(Changes parentChanges) {
            LOG.trace("refiltering {0}", (Object)this);
            Changes selfChanges = this.beginChange(parentChanges);
            for (Row child : this.children) {
                child.refilter(selfChanges);
            }
            this.endChange(selfChanges, parentChanges);
            LOG.trace("completed refiltering {0}", (Object)this);
        }

        @Override
        void resort() {
            LOG.trace("resorting {0}", (Object)this);
            for (Row child : this.children) {
                child.resort();
            }
            Collections.sort(this.children, this.getModel().comparator);
            ++this.childrenSerial;
            LOG.trace("completed resorting {0}", (Object)this);
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        int getSerialNumber() {
            return 0;
        }

        @Override
        Location getFocusLocation() {
            return this.location;
        }

        @Override
        boolean isViolation() {
            return false;
        }

        @Override
        Violation getViolation() {
            return null;
        }

        @Override
        Class getType() {
            return this.type;
        }

        @Override
        public String getShortLabel() {
            Object label;
            ModelAdapter model = this.location.getModel();
            boolean locked = false;
            try {
                model.beginRead();
                locked = true;
                label = model.getLabel(this.location);
                if (PRESENT_ALL) {
                    label = this.diagnosticLabel(label);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw model.createModelAccessError(e);
            }
            finally {
                if (locked) {
                    model.endRead();
                }
            }
            return String.valueOf(label);
        }

        @Override
        public String getSummary() {
            ModelAdapter model = this.location.getModel();
            boolean locked = false;
            try {
                model.beginRead();
                locked = true;
                String string = String.valueOf(model.getSummary(model.getConstruct(this.location)));
                return string;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw model.createModelAccessError(e);
            }
            finally {
                if (locked) {
                    model.endRead();
                }
            }
        }

        @Override
        public Icon getIcon() {
            ModelAdapter model = this.location.getModel();
            boolean locked = false;
            try {
                model.beginRead();
                locked = true;
                Icon icon = model.getIcon(model.getConstruct(this.location));
                return icon;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw model.createModelAccessError(e);
            }
            finally {
                if (locked) {
                    model.endRead();
                }
            }
        }

        public String toString() {
            return "row " + this.type.getSimpleName() + " (" + this.location + ")";
        }
    }

    private class FilterSorterListener
    implements ChangeListener {
        private FilterSorterListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            Object source = event.getSource();
            LOG.trace("**** handling state changed from {0}", source);
            if (source == DefaultAuditModel.this.comparator) {
                DefaultAuditModel.this.resort();
            } else {
                DefaultAuditModel.this.refilter();
            }
            LOG.trace("**** completed handling state changed from {0}", source);
        }
    }

    private static abstract class Row
    implements Comparable<Row>,
    Located {
        private DefaultAuditModel model;
        private Object values;
        ConstructRow parent;
        boolean visible;
        private int selfOutOfBands;
        static final boolean PRESENT_ALL = Boolean.getBoolean("audit.present.all");

        Row(DefaultAuditModel model) {
            this.model = model;
        }

        final DefaultAuditModel getModel() {
            return this.model;
        }

        ConstructRow getParent() {
            return this.parent;
        }

        int getIndexOf() {
            if (this.parent == null) {
                return 0;
            }
            return DefaultAuditModel.binarySearch(this.parent.children, this, this.model.comparator);
        }

        boolean hasChildren() {
            return false;
        }

        int getChildCount() {
            return 0;
        }

        List<Row> getChildren() {
            return NO_CHILDREN;
        }

        boolean isLeaf() {
            return false;
        }

        boolean isVisible() {
            return this.visible;
        }

        ConstructRow getVisibleParent() {
            ConstructRow parent = this.parent;
            while (parent != null && !parent.visible) {
                parent = parent.parent;
            }
            return parent;
        }

        int getVisibleIndexOf() {
            if (this.parent == null) {
                return 0;
            }
            Row child = this;
            while (true) {
                ConstructRow parent = child.parent;
                if (parent.visible) break;
                child = parent;
            }
            int index = 0;
            for (Row sibling : child.parent.children) {
                if (sibling == child) break;
                index += sibling.getVisibleRowCount();
            }
            return index;
        }

        boolean hasVisibleChildren() {
            return false;
        }

        int getVisibleChildCount() {
            return 0;
        }

        abstract int getVisibleRowCount();

        List<Row> getVisibleChildren() {
            return NO_CHILDREN;
        }

        void collectVisibleChildren(List<Row> accumulator) {
        }

        void insertIntoParent(ConstructRow parent, int index, Changes parentChanges) {
            assert (parent != this);
            assert (parent != null);
            assert (!this.hasChildren());
            assert (!this.visible);
            assert (index <= parent.children.size());
            assert (index == parent.children.size() || parent.children.get(index) != this);
            Changes selfChanges = this.beginChange(parentChanges);
            this.parent = parent;
            parent.children.add(index, this);
            assert (DefaultAuditModel.binarySearch(parent.children, this, this.model.comparator) == index);
            parentChanges.insert(this, index);
            parentChanges.deltaFiles += this.getFileCount();
            parentChanges.deltaIssues += this.getIssueCount();
            parentChanges.deltaChildOutOfBands += this.getOutOfBandCount();
            this.endChange(selfChanges, parentChanges);
        }

        void removeFromParent(ConstructRow parent, int index, Changes parentChanges) {
            assert (parent != this);
            assert (parent != null);
            assert (this.parent == parent);
            assert (parent.children.get(index) == this);
            parentChanges.deltaVisibleChildren -= this.getVisibleRowCount();
            parentChanges.deltaVisibleFiles -= this.getVisibleFileCount();
            parentChanges.deltaVisibleErrors -= this.getVisibleErrorCount();
            parentChanges.deltaVisibleWarnings -= this.getVisibleWarningCount();
            parentChanges.deltaVisibleIncompletes -= this.getVisibleIncompleteCount();
            parentChanges.deltaVisibleAdvisories -= this.getVisibleAdvisoryCount();
            parentChanges.deltaVisibleChildOutOfBands -= this.getVisibleOutOfBandCount();
            if (this.visible) {
                this.visible = false;
                parentChanges.hide(Collections.singletonList(this), index);
            }
            parentChanges.deltaFiles -= this.getFileCount();
            parentChanges.deltaIssues -= this.getIssueCount();
            parentChanges.deltaChildOutOfBands -= this.getOutOfBandCount();
            parentChanges.remove(this, index);
            parent.children.remove(index);
            this.parent = null;
            LOG.trace("removed {0} from {1}", (Object)this, (Object)parent);
        }

        void moveInParent(ConstructRow parent, int oldIndex, int newIndex) {
            assert (parent != this);
            assert (parent != null);
            assert (this.parent == parent);
            assert (parent.children.get(oldIndex) == this);
            assert (newIndex <= parent.children.size());
            assert (newIndex == parent.children.size() || parent.children.get(newIndex) != this);
            LOG.trace("moving {0} in {1}", (Object)this, (Object)parent);
            Changes parentChanges = parent.beginChange(null);
            parent.children.remove(oldIndex);
            int adjustedNewIndex = oldIndex < newIndex ? newIndex - 1 : newIndex;
            parent.children.add(adjustedNewIndex, this);
            assert (DefaultAuditModel.binarySearch(parent.children, this, this.model.comparator) == adjustedNewIndex);
            parentChanges.move(this, oldIndex, newIndex);
            parent.endChange(parentChanges, null);
        }

        abstract int getFileCount();

        abstract int getIssueCount();

        abstract int getVisibleFileCount();

        int getVisibleIssueCount() {
            return this.getVisibleErrorCount() + this.getVisibleWarningCount() + this.getVisibleIncompleteCount() + this.getVisibleAdvisoryCount();
        }

        abstract int getVisibleErrorCount();

        abstract int getVisibleWarningCount();

        abstract int getVisibleIncompleteCount();

        abstract int getVisibleAdvisoryCount();

        int getOutOfBandCount() {
            return this.getSelfOutOfBandCount() + this.getChildOutOfBandCount();
        }

        int getSelfOutOfBandCount() {
            return this.selfOutOfBands;
        }

        abstract int getChildOutOfBandCount();

        int getVisibleOutOfBandCount() {
            return this.getVisibleSelfOutOfBandCount() + this.getVisibleChildOutOfBandCount();
        }

        int getVisibleSelfOutOfBandCount() {
            return this.visible ? this.getSelfOutOfBandCount() : 0;
        }

        abstract int getVisibleChildOutOfBandCount();

        abstract oracle.javatools.status.Severity getSeverity();

        boolean shouldBeVisible() {
            if (this.parent == null) {
                return true;
            }
            for (AuditModelFilter filter : this.model.filters) {
                boolean visible = filter.isVisible(this);
                if (visible) continue;
                return false;
            }
            return true;
        }

        abstract void refilter(Changes var1);

        abstract void resort();

        Object getValue(int index) {
            if (this.model.columns.size() > 1 && this.values != null) {
                return ((Object[])this.values)[index];
            }
            return this.values;
        }

        void setValue(int columnIndex, Object value) {
            this.setValue(columnIndex, this.getValue(columnIndex), value);
        }

        boolean setValue(int columnIndex, Object oldValue, Object newValue) {
            COLUMNS.trace("setValue {0} from {1}", columnIndex, this.getModel().columns);
            if (newValue == null ? oldValue != null : !newValue.equals(oldValue)) {
                if (this.parent != null) {
                    ConstructRow parent = this.parent;
                    DefaultAuditModelComparator comparator = this.model.comparator;
                    int oldIndex = DefaultAuditModel.binarySearch(parent.children, this, comparator);
                    assert (oldIndex >= 0);
                    if (this.model.columns.size() > 1) {
                        if (this.values == null) {
                            this.values = new Object[this.model.columns.size()];
                        }
                        ((Object[])this.values)[columnIndex] = newValue;
                    } else {
                        this.values = newValue;
                    }
                    this.model.fireValueChanged(this, columnIndex + 1, oldValue, newValue);
                    if (oldIndex > 0 && comparator.compare(parent.children.get(oldIndex - 1), this) > 0) {
                        fromIndex = 0;
                        int toIndex = oldIndex;
                        int newIndex = fromIndex + -DefaultAuditModel.binarySearch(parent.children.subList(fromIndex, toIndex), this, comparator) - 1;
                        this.moveInParent(parent, oldIndex, newIndex);
                    } else if (oldIndex < parent.children.size() - 1 && comparator.compare(this, parent.children.get(oldIndex + 1)) > 0) {
                        fromIndex = oldIndex + 2;
                        int toIndex = parent.children.size();
                        int newIndex = fromIndex + -DefaultAuditModel.binarySearch(parent.children.subList(fromIndex, toIndex), this, comparator) - 1;
                        this.moveInParent(parent, oldIndex, newIndex);
                    }
                    DefaultAuditModel.assertSorted(parent.children, comparator);
                } else {
                    if (this.model.columns.size() > 1) {
                        if (this.values == null) {
                            this.values = new Object[this.model.columns.size()];
                        }
                        ((Object[])this.values)[columnIndex] = newValue;
                    } else {
                        this.values = newValue;
                    }
                    this.model.fireValueChanged(this, columnIndex + 1, oldValue, newValue);
                }
                Metric metric = this.getModel().columns.get(columnIndex);
                boolean wasOutOfBand = metric.isOutOfBand(oldValue);
                boolean isOutOfBand = metric.isOutOfBand(newValue);
                if (wasOutOfBand != isOutOfBand) {
                    Changes selfChanges = this.beginChange(null);
                    selfChanges.deltaSelfOutOfBands = selfChanges.deltaSelfOutOfBands + (isOutOfBand ? 1 : -1);
                    this.endChange(selfChanges, null);
                }
                return true;
            }
            return false;
        }

        @Override
        public abstract Location getLocation();

        abstract Location getFocusLocation();

        abstract boolean isViolation();

        abstract Violation getViolation();

        abstract Class getType();

        abstract int getSerialNumber();

        abstract String getShortLabel();

        abstract String getSummary();

        abstract Icon getIcon();

        public boolean equals(Object object) {
            if (!(object instanceof Row)) {
                return false;
            }
            Row that = (Row)object;
            return this.getLocation().equals(that.getLocation()) && this.getSerialNumber() == that.getSerialNumber();
        }

        public int hashCode() {
            return this.getLocation().hashCode() * 37 + this.getSerialNumber();
        }

        @Override
        public int compareTo(Row that) {
            int comparison = this.getLocation().compareTo(that.getLocation());
            if (comparison == 0) {
                comparison = this.getSerialNumber() - that.getSerialNumber();
            }
            assert (this != that || comparison == 0);
            return comparison;
        }

        Changes beginChange(Changes parentChanges) {
            if (parentChanges != null && this.visible) {
                parentChanges.wasChildren.add(this);
            }
            return new Changes(this);
        }

        void endChange(Changes selfChanges, Changes parentChanges) {
            assert (selfChanges == null ? this instanceof ViolationRow : selfChanges.row == this);
            if (parentChanges != null) {
                this.reconcile(selfChanges, parentChanges);
            } else {
                ConstructRow parent;
                boolean changed;
                Changes rowChanges = selfChanges;
                Row row = rowChanges.row;
                while ((changed = row.reconcile(rowChanges, parentChanges = new Changes(parent = row.parent))) && parent != null) {
                    row = parent;
                    rowChanges = parentChanges;
                }
                row.notify(rowChanges, this.getVisibleParent(), row.getVisibleIndexOf(), false, true);
            }
        }

        boolean reconcile(Changes selfChanges, Changes parentChanges) {
            boolean changed;
            boolean hide;
            boolean show;
            boolean hadVisibleChildren = this.hasVisibleChildren();
            if (selfChanges != null) {
                assert (selfChanges.row == this);
                if (!selfChanges.wasVisible) {
                    parentChanges.wasChildren.addAll(selfChanges.wasChildren);
                }
                this.applyVisibilityIndependentChangesToSelf(selfChanges);
            }
            if (this.visible != this.shouldBeVisible()) {
                show = this.visible = !this.visible;
                hide = !this.visible;
                changed = true;
            } else {
                show = false;
                hide = false;
                changed = false;
            }
            if (selfChanges != null) {
                if (show) {
                    int oldSelfOutOfBands = this.selfOutOfBands - selfChanges.deltaSelfOutOfBands;
                    selfChanges.deltaVisibleSelfOutOfBands += oldSelfOutOfBands;
                } else if (hide) {
                    int oldSelfOutOfBands = this.selfOutOfBands - selfChanges.deltaSelfOutOfBands;
                    selfChanges.deltaVisibleSelfOutOfBands -= oldSelfOutOfBands;
                } else if (this.visible) {
                    selfChanges.deltaVisibleSelfOutOfBands += selfChanges.deltaSelfOutOfBands;
                }
            }
            this.propagateVisibilityChangeToParentChanges(selfChanges, show, hide, parentChanges);
            if (changed && hadVisibleChildren) {
                parentChanges.restructure = true;
            }
            if (selfChanges != null) {
                if (this.propagateChangesToParentChanges(selfChanges, show, hide, parentChanges)) {
                    changed = true;
                }
                if (selfChanges.hasChanged()) {
                    parentChanges.changeChild(selfChanges);
                }
            }
            return changed;
        }

        void applyVisibilityIndependentChangesToSelf(Changes changes) {
            this.selfOutOfBands += changes.deltaSelfOutOfBands;
            assert (this.selfOutOfBands >= 0);
        }

        void propagateVisibilityChangeToParentChanges(Changes changes, boolean show, boolean hide, Changes parentChanges) {
            if (show) {
                this.visible = true;
                int index = DefaultAuditModel.binarySearch(this.parent.children, this, this.model.comparator);
                assert (index >= 0);
                if (changes != null) {
                    parentChanges.hide(changes.wasChildren, index);
                }
                parentChanges.show(Collections.singletonList(this), index);
            } else if (hide) {
                this.visible = false;
                int index = DefaultAuditModel.binarySearch(this.parent.children, this, this.model.comparator);
                assert (index >= 0);
                parentChanges.hide(Collections.singletonList(this), index);
                if (this.hasVisibleChildren()) {
                    parentChanges.show(this.getVisibleChildren(), index);
                }
            }
        }

        abstract boolean propagateChangesToParentChanges(Changes var1, boolean var2, boolean var3, Changes var4);

        void notify(Changes changes, Object visibleParent, int visibleIndex, boolean nestedRestructure, boolean showHide) {
            assert (changes.row == this);
            assert (visibleIndex >= 0);
            if (this.visible) {
                visibleParent = this;
                visibleIndex = 0;
            }
            LOG_NOTIFY.trace("**** notify on {0} under {1} at {2}", (Object)changes.row, visibleParent, (Object)visibleIndex);
            LOG_NOTIFY.trace("children {0}", changes.row.getChildren());
            LOG_NOTIFY.trace("changes {0}", changes.childChanges);
            LOG_NOTIFY.trace("events {0}", changes.childEvents);
            if (!nestedRestructure && changes.restructure) {
                this.getModel().fireRowsRestructureBegin(this, visibleParent);
            }
            HashSet<Row> removed = new HashSet<Row>();
            HashSet<Row> shownOrHidden = new HashSet<Row>();
            int changeIndex = 0;
            List<Changes> childChanges = changes.childChanges;
            int changeCount = childChanges.size();
            int eventIndex = 0;
            List<ChildEvent> childEvents = changes.childEvents;
            int eventCount = childEvents.size();
            List<Row> children = this.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Row child = children.get(i);
                LOG_NOTIFY.trace("child {0}, index {1}, visible index {2}", (Object)child, (Object)i, (Object)visibleIndex);
                if (changeIndex < changeCount && child == childChanges.get((int)changeIndex).row) {
                    Changes childChange = childChanges.get(changeIndex);
                    ++changeIndex;
                    LOG_NOTIFY.trace("change {0}", (Object)childChange);
                    childChange.visibleIndex = visibleIndex;
                }
                int visibleRowCount = child.getVisibleRowCount();
                while (eventIndex < eventCount && i == childEvents.get((int)eventIndex).index) {
                    ChildEvent event = childEvents.get(eventIndex);
                    ++eventIndex;
                    LOG_NOTIFY.trace("change {0}", (Object)event);
                    switch (event.type) {
                        case INSERT: {
                            this.getModel().fireRowsInserted(event.rows, this, event.index);
                            visibleRowCount = 0;
                            break;
                        }
                        case SHOW: {
                            if (showHide) {
                                this.getModel().fireRowsShown(event.rows, visibleParent, visibleIndex);
                            }
                            shownOrHidden.addAll(event.rows);
                            visibleRowCount = event.rows.size();
                            break;
                        }
                        case HIDE: {
                            if (showHide) {
                                this.getModel().fireRowsHidden(event.rows, visibleParent, visibleIndex);
                            }
                            shownOrHidden.addAll(event.rows);
                            break;
                        }
                        case REMOVE: {
                            this.getModel().fireRowsRemoved(event.rows, this, event.index);
                            removed.addAll(event.rows);
                        }
                    }
                }
                visibleIndex += visibleRowCount;
            }
            assert (changeIndex == changeCount);
            block12: while (eventIndex < eventCount) {
                ChildEvent event = childEvents.get(eventIndex);
                ++eventIndex;
                LOG_NOTIFY.trace("change {0}", (Object)event);
                switch (event.type) {
                    case HIDE: {
                        if (showHide) {
                            this.getModel().fireRowsHidden(event.rows, visibleParent, visibleIndex);
                        }
                        shownOrHidden.addAll(event.rows);
                        continue block12;
                    }
                    case REMOVE: {
                        this.getModel().fireRowsRemoved(event.rows, this, event.index);
                        removed.addAll(event.rows);
                        continue block12;
                    }
                }
                assert (false) : "Unexpected trailing event " + event;
            }
            assert (eventIndex == eventCount);
            for (Changes childChange : childChanges) {
                Row row = childChange.row;
                if (removed.contains(row)) continue;
                row.notify(childChange, visibleParent, childChange.visibleIndex, nestedRestructure || changes.restructure, showHide && !shownOrHidden.contains(row));
            }
            this.fireCountChanges(changes);
            LOG_NOTIFY.trace("**** end notify on {0} under {1} at {2}", (Object)changes.row, visibleParent, (Object)visibleIndex);
            if (!nestedRestructure && changes.restructure) {
                this.getModel().fireRowsRestructureEnd(this, visibleParent);
            }
        }

        abstract void fireCountChanges(Changes var1);

        String diagnosticLabel(Object label) {
            return "[" + this.offset(this.getLocation().getOffset()) + ":" + this.offset(this.getLocation().getEndOffset()) + ") " + label + " (" + this.getType().getSimpleName() + ")";
        }

        private String offset(int offset) {
            return offset == Integer.MAX_VALUE ? Character.valueOf('\u221e').toString() : String.valueOf(offset);
        }
    }

    private static final class ViolationRow
    extends Row
    implements Violation {
        private final Rule rule;
        private final Location location;
        private long bits;
        private final Object[] objects;
        private int serialNumber;

        ViolationRow(DefaultAuditModel model, Violation violation, int transformMask) {
            super(model);
            this.rule = violation.getRule();
            if (this.rule == null) {
                throw new NullArgumentException("null rule in " + violation.getClass());
            }
            this.location = violation.getLocation();
            model.helper.pack(violation, transformMask);
            this.bits = model.helper.getBits();
            this.objects = model.helper.getObjects();
            this.serialNumber = ++model.lastSerialNumber;
        }

        public String getMessage() {
            return this.rule.message(this);
        }

        public String getHtmlMessage() {
            return this.rule.htmlMessage(this);
        }

        @Override
        public oracle.javatools.status.Severity getSeverity() {
            return this.rule.getSeverity().getIssueSeverity();
        }

        @Override
        public Object getConstruct() {
            try {
                Location location = this.getLocation();
                return location.getModel().getConstruct(location);
            }
            catch (ModelAccessError e) {
                return null;
            }
        }

        public int getOffset() {
            return this.getFocusLocation().getOffset();
        }

        public int getLength() {
            return this.getFocusLocation().getLength();
        }

        public boolean hasTransforms() {
            return this.getTransformCount() > 0;
        }

        public List<? extends Action> getTransforms() {
            Transformer transformer = AuditManager.getAuditManager().createTransformer();
            return transformer.createTransformActions(Collections.singletonList(this), this.getModel().getProfile(), null, null);
        }

        @Override
        public Rule getRule() {
            return this.rule;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public int getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public Location getFocusLocation() {
            return ViolationHelper.unpackFocusLocation(this.bits, this.objects, this.location);
        }

        @Override
        boolean isViolation() {
            return true;
        }

        @Override
        Violation getViolation() {
            return this;
        }

        @Override
        public String getVariation() {
            return ViolationHelper.unpackVariation(this.bits, this.rule);
        }

        @Override
        public int getParameterCount() {
            return ViolationHelper.unpackParameterCount(this.bits);
        }

        @Override
        public String getParameterName(int index) {
            return ViolationHelper.unpackParameterName(this.bits, this.objects, index);
        }

        @Override
        public Object getParameterValue(int index) {
            return ViolationHelper.unpackParameterValue(this.bits, this.objects, index);
        }

        @Override
        public Object getParameterValue(String name) {
            return ViolationHelper.unpackParameterValue(this.bits, this.objects, name);
        }

        @Override
        public int getTransformCount() {
            return ViolationHelper.unpackTransformCount(this.bits);
        }

        @Override
        public Transform getTransform(int index) {
            return ViolationHelper.unpackTransform(this.bits, this.rule, index);
        }

        @Override
        public Transform getDefaultTransform() {
            return ViolationHelper.unpackDefaultTransform(this.bits, this.rule);
        }

        @Override
        public int getSuppressionCount() {
            return ViolationHelper.unpackSuppressionCount(this.bits, this.objects);
        }

        @Override
        public Suppression getSuppression(int index) {
            return ViolationHelper.unpackSuppression(this.bits, this.objects, index);
        }

        @Override
        Class getType() {
            return Violation.class;
        }

        @Override
        boolean isLeaf() {
            return true;
        }

        @Override
        int getVisibleRowCount() {
            return this.visible ? 1 : 0;
        }

        @Override
        int getFileCount() {
            return this.getLocation().getModel().isFile() ? 1 : 0;
        }

        @Override
        int getIssueCount() {
            return 1;
        }

        @Override
        int getVisibleFileCount() {
            return this.visible ? this.getFileCount() : 0;
        }

        @Override
        int getVisibleErrorCount() {
            return this.visible && this.rule.getSeverity() == Severity.ERROR ? 1 : 0;
        }

        @Override
        int getVisibleWarningCount() {
            return this.visible && this.rule.getSeverity() == Severity.WARNING ? 1 : 0;
        }

        @Override
        int getVisibleIncompleteCount() {
            return this.visible && this.rule.getSeverity() == Severity.INCOMPLETE ? 1 : 0;
        }

        @Override
        int getVisibleAdvisoryCount() {
            return this.visible && this.rule.getSeverity() == Severity.ADVISORY ? 1 : 0;
        }

        @Override
        int getChildOutOfBandCount() {
            return 0;
        }

        @Override
        int getVisibleChildOutOfBandCount() {
            return 0;
        }

        @Override
        void propagateVisibilityChangeToParentChanges(Changes changes, boolean show, boolean hide, Changes parentChanges) {
            super.propagateVisibilityChangeToParentChanges(changes, show, hide, parentChanges);
            if (show) {
                ++parentChanges.deltaVisibleChildren;
                ++parentChanges.deltaVisibleFiles;
                if (this.rule.getSeverity() == Severity.ERROR) {
                    ++parentChanges.deltaVisibleErrors;
                } else if (this.rule.getSeverity() == Severity.WARNING) {
                    ++parentChanges.deltaVisibleWarnings;
                } else if (this.rule.getSeverity() == Severity.INCOMPLETE) {
                    ++parentChanges.deltaVisibleIncompletes;
                } else if (this.rule.getSeverity() == Severity.ADVISORY) {
                    ++parentChanges.deltaVisibleAdvisories;
                }
            } else if (hide) {
                --parentChanges.deltaVisibleChildren;
                --parentChanges.deltaVisibleFiles;
                if (this.rule.getSeverity() == Severity.ERROR) {
                    --parentChanges.deltaVisibleErrors;
                } else if (this.rule.getSeverity() == Severity.WARNING) {
                    --parentChanges.deltaVisibleWarnings;
                } else if (this.rule.getSeverity() == Severity.INCOMPLETE) {
                    --parentChanges.deltaVisibleIncompletes;
                } else if (this.rule.getSeverity() == Severity.ADVISORY) {
                    --parentChanges.deltaVisibleAdvisories;
                }
            }
        }

        @Override
        boolean propagateChangesToParentChanges(Changes changes, boolean show, boolean hide, Changes parentChanges) {
            boolean propagated = false;
            if (changes.deltaSelfOutOfBands != 0) {
                parentChanges.deltaChildOutOfBands += changes.deltaSelfOutOfBands;
                propagated = true;
            }
            if (changes.deltaVisibleSelfOutOfBands != 0) {
                parentChanges.deltaVisibleChildOutOfBands += changes.deltaVisibleSelfOutOfBands;
                propagated = true;
            }
            return propagated;
        }

        @Override
        void fireCountChanges(Changes changes) {
            if (changes.deltaSelfOutOfBands != 0) {
                int outOfBands = this.getOutOfBandCount();
                this.parent.getModel().fireCountChanged(this, AuditModel.Count.OUT_OF_BANDS, outOfBands - changes.deltaSelfOutOfBands, outOfBands);
            }
            if (changes.deltaVisibleSelfOutOfBands != 0) {
                int visibleOutOfBands = this.getVisibleOutOfBandCount();
                this.parent.getModel().fireCountChanged(this, AuditModel.Count.VISIBLE_OUT_OF_BANDS, visibleOutOfBands - changes.deltaVisibleSelfOutOfBands, visibleOutOfBands);
            }
        }

        @Override
        void refilter(Changes parentChanges) {
            LOG.trace("refiltering {0}", (Object)this);
            Changes selfChanges = this.beginChange(parentChanges);
            this.endChange(selfChanges, parentChanges);
            LOG.trace("completed refiltering {0}", (Object)this);
        }

        @Override
        void resort() {
        }

        @Override
        public String getShortLabel() {
            String message = this.rule.message(this);
            if (PRESENT_ALL) {
                message = this.diagnosticLabel(message);
            }
            return message;
        }

        public String getLongLabel() {
            return this.rule.message(this);
        }

        public String getMessageText() {
            return this.rule.message(this);
        }

        @Override
        public String getSummary() {
            if (this.isFixed()) {
                return this.rule.message(this) + " (resolved)";
            }
            return this.rule.message(this);
        }

        @Override
        public Icon getIcon() {
            Icon icon = this.rule.getSeverity().getIcon();
            if (this.isFixed()) {
                return new OverlayIcon(icon, OracleIcons.getIcon((String)"check.png"));
            }
            return icon;
        }

        private boolean isFixed() {
            return this.getModel().violationsTransformed.containsKey(this);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("issue '");
            buffer.append(" ");
            buffer.append(this.rule.id());
            buffer.append("' ['");
            int count = this.getParameterCount();
            for (int i = 0; i < count; ++i) {
                if (count > 0) {
                    buffer.append(',');
                }
                buffer.append(this.getParameterName(i));
                buffer.append('=');
                buffer.append(this.getParameterValue(i));
            }
            buffer.append(']');
            return buffer.toString();
        }
    }

    private static final class FileRow
    extends ConstructRow {
        FileRow(DefaultAuditModel model, Location location, Class type) {
            super(model, location, type);
        }

        @Override
        boolean isFile() {
            return true;
        }

        @Override
        int getFileCount() {
            return 1;
        }

        @Override
        int getVisibleFileCount() {
            return this.visible ? 1 : 0;
        }

        @Override
        void propagateVisibilityChangeToParentChanges(Changes changes, boolean show, boolean hide, Changes parentChanges) {
            super.propagateVisibilityChangeToParentChanges(changes, show, hide, parentChanges);
            if (changes == null) {
                if (show) {
                    ++parentChanges.deltaVisibleFiles;
                } else if (hide) {
                    --parentChanges.deltaVisibleFiles;
                }
            }
        }

        @Override
        boolean propagateChangesToParentChanges(Changes changes, boolean show, boolean hide, Changes parentChanges) {
            boolean propagated = super.propagateChangesToParentChanges(changes, show, hide, parentChanges);
            if (show) {
                ++parentChanges.deltaVisibleFiles;
                propagated = true;
            } else if (hide) {
                --parentChanges.deltaVisibleFiles;
                propagated = true;
            }
            return propagated;
        }
    }

    private static final class ContainerRow
    extends ConstructRow {
        private int files;
        private int visibleFiles;

        ContainerRow(DefaultAuditModel model, Location location, Class type) {
            super(model, location, type);
        }

        @Override
        boolean isFile() {
            return false;
        }

        @Override
        int getFileCount() {
            return this.files;
        }

        @Override
        int getVisibleFileCount() {
            return this.visibleFiles;
        }

        @Override
        void applyVisibilityIndependentChangesToSelf(Changes changes) {
            super.applyVisibilityIndependentChangesToSelf(changes);
            this.files += changes.deltaFiles;
            this.visibleFiles += changes.deltaVisibleFiles;
            assert (this.files >= 0);
            assert (this.visibleFiles >= 0);
        }

        @Override
        boolean propagateChangesToParentChanges(Changes changes, boolean show, boolean hide, Changes parentChanges) {
            boolean propagated = super.propagateChangesToParentChanges(changes, show, hide, parentChanges);
            if (changes.deltaFiles != 0) {
                parentChanges.deltaFiles += changes.deltaFiles;
                propagated = true;
            }
            if (changes.deltaVisibleFiles != 0) {
                parentChanges.deltaVisibleFiles += changes.deltaVisibleFiles;
                propagated = true;
            }
            return propagated;
        }

        @Override
        void fireCountChanges(Changes changes) {
            super.fireCountChanges(changes);
            if (changes.deltaFiles != 0) {
                this.getModel().fireCountChanged(this, AuditModel.Count.FILES, this.files - changes.deltaFiles, this.files);
            }
            if (changes.deltaVisibleFiles != 0) {
                this.getModel().fireCountChanged(this, AuditModel.Count.VISIBLE_FILES, this.visibleFiles - changes.deltaVisibleFiles, this.visibleFiles);
            }
        }
    }

    private static class Changes {
        Row row;
        boolean wasVisible;
        int oldVisibleRowCount;
        List<ChildEvent> childEvents = new ArrayList<ChildEvent>();
        List<Changes> childChanges = new ArrayList<Changes>();
        List<Row> wasChildren = new ArrayList<Row>();
        int visibleIndex;
        boolean restructure;
        int deltaVisibleChildren;
        int deltaFiles;
        int deltaIssues;
        int deltaVisibleFiles;
        int deltaVisibleErrors;
        int deltaVisibleWarnings;
        int deltaVisibleIncompletes;
        int deltaVisibleAdvisories;
        int deltaSelfOutOfBands;
        int deltaChildOutOfBands;
        int deltaVisibleSelfOutOfBands;
        int deltaVisibleChildOutOfBands;

        Changes(Row row) {
            this.row = row;
            if (row != null) {
                this.wasVisible = row.visible;
                this.oldVisibleRowCount = row.getVisibleRowCount();
            } else {
                this.wasVisible = false;
                this.oldVisibleRowCount = 1;
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder("Changes ");
            b.append(this.row);
            this.append(b, "children", this.deltaVisibleChildren);
            this.append(b, "files", this.deltaFiles);
            this.append(b, "vfiles", this.deltaVisibleFiles);
            this.append(b, "issues", this.deltaIssues);
            this.append(b, "errors", this.deltaVisibleErrors);
            this.append(b, "warnings", this.deltaVisibleWarnings);
            this.append(b, "incompletes", this.deltaVisibleIncompletes);
            this.append(b, "advisories", this.deltaVisibleAdvisories);
            this.append(b, "selfOOB", this.deltaSelfOutOfBands);
            this.append(b, "childOOB", this.deltaChildOutOfBands);
            this.append(b, "vselfOOB", this.deltaVisibleSelfOutOfBands);
            this.append(b, "vchildOOB", this.deltaVisibleChildOutOfBands);
            b.append("; ");
            this.append(b, "children", this.wasChildren.size());
            this.append(b, "events", this.childEvents.size());
            this.append(b, "changes", this.childChanges.size());
            return b.toString();
        }

        void append(StringBuilder builder, String label, int count) {
            if (count != 0) {
                builder.append(" ").append(label).append(" ").append(count);
            }
        }

        void changeChild(Changes changes) {
            this.childChanges.add(changes);
        }

        void hide(List<Row> rows, int index) {
            assert (this.row instanceof ConstructRow);
            assert (this.childEvents.isEmpty() || this.childEvents.get((int)(this.childEvents.size() - 1)).index <= index);
            if (rows.isEmpty()) {
                return;
            }
            assert (DefaultAuditModel.isAncestorOf(this.row.getChildren().get(index), rows.get(0)));
            int next = this.childEvents.size();
            int removes = 0;
            block4: while (next > 0) {
                ChildEvent predecessor = this.childEvents.get(next - 1);
                switch (predecessor.type) {
                    case REMOVE: {
                        --next;
                        removes += predecessor.rows.size();
                        continue block4;
                    }
                    case HIDE: {
                        if (predecessor.index + predecessor.rows.size() - removes != index) break block4;
                        predecessor.rows = this.merge(predecessor.rows, rows);
                        return;
                    }
                }
            }
            this.childEvents.add(new ChildEvent(ChildEventType.HIDE, rows, index));
        }

        void show(List<Row> rows, int index) {
            assert (this.row instanceof ConstructRow);
            assert (this.childEvents.isEmpty() || this.childEvents.get((int)(this.childEvents.size() - 1)).index <= index);
            if (rows.isEmpty()) {
                return;
            }
            assert (DefaultAuditModel.isAncestorOf(this.row.getChildren().get(index), rows.get(0)));
            if (!this.childEvents.isEmpty()) {
                ChildEvent predecessor = this.childEvents.get(this.childEvents.size() - 1);
                if (predecessor.type == ChildEventType.SHOW && predecessor.index + predecessor.rows.size() == index) {
                    predecessor.rows = this.merge(predecessor.rows, rows);
                    return;
                }
            }
            this.childEvents.add(new ChildEvent(ChildEventType.SHOW, rows, index));
        }

        void insert(Row child, int index) {
            assert (this.row instanceof ConstructRow);
            assert (this.row.getChildren().get(index) == child);
            assert (this.childEvents.isEmpty() || this.childEvents.get((int)(this.childEvents.size() - 1)).index <= index);
            block4: for (int next = this.childEvents.size(); next > 0; --next) {
                ChildEvent predecessor = this.childEvents.get(next - 1);
                switch (predecessor.type) {
                    case SHOW: {
                        continue block4;
                    }
                    case INSERT: {
                        if (predecessor.index + predecessor.rows.size() != index) break block4;
                        predecessor.rows = new ArrayList<Row>(predecessor.rows);
                        predecessor.rows.add(child);
                        return;
                    }
                }
            }
            this.childEvents.add(new ChildEvent(ChildEventType.INSERT, Collections.singletonList(child), index));
        }

        void remove(Row child, int index) {
            assert (this.row instanceof ConstructRow);
            assert (this.row.getChildren().get(index) == child);
            assert (this.childEvents.isEmpty() || this.childEvents.get((int)(this.childEvents.size() - 1)).index <= index);
            if (!this.childEvents.isEmpty()) {
                ChildEvent predecessor = this.childEvents.get(this.childEvents.size() - 1);
                if (predecessor.type == ChildEventType.REMOVE && predecessor.index == index) {
                    predecessor.rows = new ArrayList<Row>(predecessor.rows);
                    predecessor.rows.add(child);
                    return;
                }
            }
            this.childEvents.add(new ChildEvent(ChildEventType.REMOVE, Collections.singletonList(child), index));
        }

        void move(Row child, int oldIndex, int newIndex) {
            assert (oldIndex != newIndex);
            List<Row> visibleRows = child.visible ? Collections.singletonList(child) : child.getVisibleChildren();
            this.restructure = true;
            if (oldIndex < newIndex) {
                if (!visibleRows.isEmpty()) {
                    this.childEvents.add(new ChildEvent(ChildEventType.HIDE, visibleRows, oldIndex));
                }
                this.childEvents.add(new ChildEvent(ChildEventType.REMOVE, Collections.singletonList(child), oldIndex));
                this.childEvents.add(new ChildEvent(ChildEventType.INSERT, Collections.singletonList(child), --newIndex));
                this.childEvents.add(new ChildEvent(ChildEventType.SHOW, visibleRows, newIndex));
            } else {
                this.childEvents.add(new ChildEvent(ChildEventType.INSERT, Collections.singletonList(child), newIndex));
                this.childEvents.add(new ChildEvent(ChildEventType.SHOW, visibleRows, newIndex));
                ++oldIndex;
                if (!visibleRows.isEmpty()) {
                    this.childEvents.add(new ChildEvent(ChildEventType.HIDE, visibleRows, oldIndex));
                }
                this.childEvents.add(new ChildEvent(ChildEventType.REMOVE, Collections.singletonList(child), oldIndex));
            }
        }

        private List<Row> merge(List<Row> left, List<Row> right) {
            List<Row> merge;
            if (!right.isEmpty()) {
                merge = new ArrayList<Row>(left.size() + right.size());
                merge.addAll(left);
                merge.addAll(right);
            } else {
                merge = left;
            }
            return merge;
        }

        public boolean hasChanged() {
            return !this.childEvents.isEmpty() || !this.childChanges.isEmpty() || this.deltaVisibleChildren != 0 || this.deltaFiles != 0 || this.deltaIssues != 0 || this.deltaVisibleFiles != 0 || this.deltaVisibleErrors != 0 || this.deltaVisibleWarnings != 0 || this.deltaVisibleIncompletes != 0 || this.deltaVisibleAdvisories != 0 || this.deltaSelfOutOfBands != 0 || this.deltaChildOutOfBands != 0 || this.deltaVisibleSelfOutOfBands != 0 || this.deltaVisibleChildOutOfBands != 0;
        }
    }

    private static class ChildEvent {
        private ChildEventType type;
        private List<Row> rows;
        private int index;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append((Object)this.type);
            switch (this.type) {
                case INSERT: 
                case SHOW: 
                case HIDE: 
                case REMOVE: {
                    builder.append(" at ").append(this.index);
                    builder.append(": ").append(this.rows);
                }
            }
            return builder.toString();
        }

        private ChildEvent(ChildEventType type, List<Row> rows, int index) {
            this.type = type;
            this.rows = rows;
            this.index = index;
            assert (index >= 0);
        }
    }

    private static enum ChildEventType {
        INSERT,
        REMOVE,
        SHOW,
        HIDE;

    }
}

