/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import oracle.ide.performance.PerformanceLogger;

class BoundMethod<T>
implements Comparable<BoundMethod<?>> {
    private T target;
    private Method method;
    private int count;
    private int count1;
    private int count10;
    private int count100;
    private long longest;
    private long total;
    private static final long MILLISECONDS100 = TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS);
    private static final long MILLISECONDS10 = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS);
    private static final long MILLISECONDS1 = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);

    public BoundMethod(T target, Method method) {
        this.target = target;
        this.method = method;
    }

    public void accumulate(BoundMethod<?> method) {
        this.count += method.count;
        this.count1 += method.count1;
        this.count10 += method.count10;
        this.count100 += method.count100;
        this.total += method.total;
        this.longest = Math.max(this.longest, method.longest);
    }

    T getTarget() {
        return this.target;
    }

    Method getMethod() {
        return this.method;
    }

    public boolean equals(Object object) {
        if (object instanceof BoundMethod) {
            BoundMethod that = (BoundMethod)object;
            return this.target.equals(that.target) && this.method.equals(that.method);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode() * 37 + this.method.hashCode();
    }

    @Override
    public int compareTo(BoundMethod<?> that) {
        return -(this.total < that.total ? -1 : (this.total == that.total ? 0 : 1));
    }

    Object invoke(Object ... arguments) throws InvocationTargetException, IllegalAccessException {
        long start = System.nanoTime();
        Object result = this.method.invoke(this.target, arguments);
        long duration = System.nanoTime() - start;
        ++this.count;
        this.total += duration;
        if (duration > this.longest) {
            this.longest = duration;
        }
        if (duration > MILLISECONDS1) {
            if (duration < MILLISECONDS10) {
                ++this.count1;
            } else if (duration < MILLISECONDS100) {
                ++this.count10;
            } else {
                ++this.count100;
            }
        }
        if (PerformanceLogger.isAboveGlobalThreshold((long)duration)) {
            String className = this.target.getClass().getSimpleName();
            String constructName = this.method.getParameterTypes()[1].getSimpleName();
            PerformanceLogger.get().log("BoundMethod.invoke()", className + "." + this.method.getName() + "(" + constructName + ")", duration);
        }
        return result;
    }

    static String summarize(Iterable<BoundMethod<?>> methods) {
        HashMap summaries = new HashMap();
        for (BoundMethod<?> method : methods) {
            BoundMethod accumulator = (BoundMethod)summaries.get(method);
            if (accumulator == null) {
                accumulator = new BoundMethod(method.getTarget(), method.getMethod());
                summaries.put(accumulator, accumulator);
            }
            accumulator.accumulate(method);
        }
        ArrayList sortedMethods = new ArrayList(summaries.keySet());
        Collections.sort(sortedMethods);
        String EOL = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        int nameColumn = "  JboTransactionValidationMethodsAnalyzer.enter(SourceSimpleNameExpression)".length();
        int totalColumn = 11;
        int meanColumn = 9;
        int maxColumn = 9;
        int count0Column = 9;
        int count1Column = 9;
        int count10Column = 9;
        int count100Column = 8;
        builder.append("Method Statistics");
        for (int i = builder.length(); i < nameColumn; ++i) {
            builder.append(' ');
        }
        BoundMethod.append("Total", totalColumn, builder);
        BoundMethod.append("Mean", meanColumn, builder);
        BoundMethod.append("Max", maxColumn, builder);
        BoundMethod.append("0-1ms", count0Column, builder);
        BoundMethod.append("1-10ms", count1Column, builder);
        BoundMethod.append("10-100ms", count10Column, builder);
        BoundMethod.append(">100ms", count100Column, builder);
        builder.append("  Package");
        builder.append(EOL);
        for (BoundMethod method : sortedMethods) {
            if (method.count == 0 || method.total < MILLISECONDS1) continue;
            Class<?> analyzerClass = method.target.getClass();
            int nameStart = builder.length();
            builder.append("  ").append(analyzerClass.getSimpleName()).append(".");
            builder.append(method.method.getName()).append("(");
            builder.append(method.method.getParameterTypes()[1].getSimpleName());
            builder.append(")");
            for (int i = builder.length(); i < nameStart + nameColumn; ++i) {
                builder.append(' ');
            }
            long total = TimeUnit.MILLISECONDS.convert(method.total, TimeUnit.NANOSECONDS);
            BoundMethod.append(total + "ms", totalColumn, builder);
            long mean = TimeUnit.MILLISECONDS.convert(method.total / (long)method.count, TimeUnit.NANOSECONDS);
            BoundMethod.append(mean + "ms", meanColumn, builder);
            long max = TimeUnit.MILLISECONDS.convert(method.longest, TimeUnit.NANOSECONDS);
            BoundMethod.append(max + "ms", maxColumn, builder);
            BoundMethod.append(method.count - method.count100 - method.count10 - method.count1, count0Column, builder);
            BoundMethod.append(method.count1, count1Column, builder);
            BoundMethod.append(method.count10, count10Column, builder);
            BoundMethod.append(method.count100, count100Column, builder);
            builder.append("  ").append(analyzerClass.getPackage().getName());
            builder.append(EOL);
        }
        return builder.toString();
    }

    private static StringBuilder append(Object value, int width, StringBuilder builder) {
        builder.append(' ');
        String string = String.valueOf(value);
        for (int i = string.length(); i < width; ++i) {
            builder.append(' ');
        }
        builder.append(string);
        return builder;
    }
}

