/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabBar;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.LexiComparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.EwtComponent;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.button.PushButton;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.TabBarUI;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.tabBar.TabBarEvent;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabBar.TabBarListener;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;

public class TabBar
extends EwtComponent {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int START = 4;
    public static final int END = 5;
    private static final int _MINIMUM_TRUNCATION = 4;
    private Vector _tabs = new Vector();
    private TabBarItem _selectedItem;
    private int _orientation;
    private Color _itemBG;
    private Color _selectBG;
    private Color _selectFG;
    private ListenerManager _listeners;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private transient int _height;
    private transient int[] _widths;
    private transient PushButton _scrollButton;
    private transient Integer _minimumChars;
    private transient boolean _ignoreMouseDown;
    private static final int _SCROLL_BUTTON_OFFSET = 2;
    private static final String _PROPERTY_DONT_TRUNCATE = "DontTruncateTabs";

    public TabBar() {
        this.setOrientation(0);
        this.enableEvents(28L);
    }

    @Override
    public Object getUIClassID() {
        return "TabBarUI";
    }

    public final TabBarItem addItem(String string) {
        return this.addItem(string, null);
    }

    public final TabBarItem addItem(String string, TabBarItem tabBarItem) {
        TabBarItem tabBarItem2 = this.createItem(string);
        return this.addItem(tabBarItem2, tabBarItem);
    }

    public final TabBarItem addItem(TabBarItem tabBarItem) {
        return this.addItem(tabBarItem, null);
    }

    public TabBarItem addItem(TabBarItem tabBarItem, TabBarItem tabBarItem2) {
        if (tabBarItem == tabBarItem2) {
            throw new IllegalArgumentException();
        }
        if (tabBarItem.getParent() != null) {
            tabBarItem.getParent().removeItem(tabBarItem);
        }
        if (tabBarItem2 == null) {
            this._tabs.addElement(tabBarItem);
        } else {
            int n = this._tabs.indexOf(tabBarItem2);
            this._tabs.insertElementAt(tabBarItem, n);
        }
        tabBarItem.setParent(this);
        tabBarItem.setSize(0, 0);
        if (this.getSelectedItem() == null && tabBarItem.isVisible() && tabBarItem.isEnabled()) {
            tabBarItem.setSelected(true);
        }
        if (tabBarItem.isVisible()) {
            this.invalidateCanvas();
        }
        this.__fireVisibleDataChanged();
        return tabBarItem;
    }

    public TabBarItem getItem(int n) {
        if (n >= 0 && n < this.getItemCount()) {
            return (TabBarItem)this._tabs.elementAt(n);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getIndexOf(TabBarItem tabBarItem) {
        if (tabBarItem == null) {
            throw new IllegalArgumentException();
        }
        return this._tabs.indexOf(tabBarItem);
    }

    public TabBarItem getSelectedItem() {
        return this._selectedItem;
    }

    public int getItemCount() {
        if (this._tabs != null) {
            return this._tabs.size();
        }
        return 0;
    }

    public void removeItem(TabBarItem tabBarItem) {
        int n = this.getIndexOf(tabBarItem);
        int n2 = this.getItemCount();
        tabBarItem.setParent(null);
        if (tabBarItem == this.getSelectedItem() && !this._moveSelection(true)) {
            tabBarItem.setSelected(false);
            this.itemDeselected(tabBarItem);
        }
        this._tabs.removeElementAt(n);
        this.__fireVisibleDataChanged();
        this.invalidateCanvas();
    }

    public synchronized void removeAllItems() {
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            tabBarItem.setSelected(false);
        }
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            this.removeItem(this.getItem(i));
        }
    }

    public void showDropDownMenu() {
        this.getTabBarUI().showDropDownMenu(this, this._getScrollButton());
    }

    public void setOrientation(int n) {
        if (n == 4) {
            int n2 = n = this.getActualReadingDirection() == 1 ? 2 : 3;
        }
        if (n == 5) {
            int n3 = n = this.getActualReadingDirection() == 1 ? 3 : 2;
        }
        if (n != this._orientation) {
            this._orientation = n;
            this.invalidateCanvas();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.getItemCount() != 0) {
            this.invalidateCanvas();
        }
    }

    public void setItemBackground(Color color) {
        this._itemBG = color;
        this.repaintInterior();
    }

    public Color getItemBackground() {
        if (this._itemBG != null) {
            return this._itemBG;
        }
        return this.getBackground();
    }

    public void setSelectedBackground(Color color) {
        this._selectBG = color;
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            tabBarItem.repaint();
        }
    }

    public Color getSelectedBackground() {
        if (this._selectBG != null) {
            return this._selectBG;
        }
        return this.getItemBackground();
    }

    public void setSelectedForeground(Color color) {
        this._selectFG = color;
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            tabBarItem.repaint();
        }
    }

    public Color getSelectedForeground() {
        if (this._selectFG != null) {
            return this._selectFG;
        }
        return this.getForeground();
    }

    public void addTabBarListener(TabBarListener tabBarListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(tabBarListener);
    }

    public void removeTabBarListener(TabBarListener tabBarListener) {
        this._listeners.removeListener(tabBarListener);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this.requestFocus();
                this.processMouseDown(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    protected void processMouseDown(MouseEvent mouseEvent, int n, int n2) {
        TabBarItem tabBarItem;
        if (this._ignoreMouseDown) {
            return;
        }
        this._ignoreMouseDown = true;
        if (this.isEnabled() && InputEventUtils.isLeftMouseButton(mouseEvent) && (tabBarItem = this.getItemAt(n, n2)) != null) {
            Point point = this.convertOuterToCanvas(n, n2);
            if (!(this._isItemPainted(tabBarItem) || (tabBarItem = this._getNextItem(tabBarItem, false)) != null && tabBarItem.contains(n, n2))) {
                this._ignoreMouseDown = false;
                return;
            }
            tabBarItem.mousePressed(mouseEvent, point.x, point.y);
        }
        this._ignoreMouseDown = false;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        int n;
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        boolean bl = this.getOrientation() == 0 || this.getOrientation() == 1;
        int n2 = bl ? 37 : 38;
        int n3 = n = bl ? 39 : 40;
        if (keyEvent.getID() == 401) {
            boolean bl2;
            boolean bl3 = false;
            int n4 = keyEvent.getKeyCode();
            boolean bl4 = bl ? this.getActualReadingDirection() == 1 : (bl2 = true);
            if (n4 == n) {
                bl3 = this._moveSelection(bl2, false);
            } else if (n4 == n2) {
                bl3 = this._moveSelection(!bl2, false);
            }
            if (bl3) {
                keyEvent.consume();
            }
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TabBarEvent) {
            this.processTabBarEvent((TabBarEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processTabBarEvent(TabBarEvent tabBarEvent) {
        Object object;
        Object object2;
        if (tabBarEvent.getID() == 2001) {
            object2 = tabBarEvent.getItem();
            object = this.getSelectedItem();
            if (object != object2) {
                this._setSelectedItem((TabBarItem)object2);
                if (object != null) {
                    ((TabBarItem)object).setSelected(false);
                }
            }
        }
        if ((object2 = this._listeners) != null && (object = ((ListenerManager)object2).getListeners()) != null) {
            while (object.hasMoreElements()) {
                TabBarListener tabBarListener = (TabBarListener)object.nextElement();
                switch (tabBarEvent.getID()) {
                    case 2000: {
                        tabBarListener.tabBarSelectionChanging(tabBarEvent);
                        break;
                    }
                    case 2001: {
                        tabBarListener.tabBarSelectionChanged(tabBarEvent);
                        break;
                    }
                    case 2002: {
                        tabBarListener.tabBarLayoutChanged(tabBarEvent);
                        break;
                    }
                }
            }
        }
    }

    @Override
    protected float getInteriorAlignmentX() {
        return 0.5f;
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getItemCount();
        if (n == 0) {
            return;
        }
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem == null || !tabBarItem.isVisible()) {
            this._moveSelection(true);
        }
        TabBarUI tabBarUI = this.getTabBarUI();
        for (int i = n - 1; i >= 0; --i) {
            TabBarItem tabBarItem2 = this.getItem(i);
            Rectangle rectangle2 = tabBarItem2.getBounds();
            if (tabBarItem2.isSelected() || !this._isItemPainted(tabBarItem2)) continue;
            this._paintItem(graphics, tabBarUI, tabBarItem2, rectangle);
        }
        TabBarItem tabBarItem3 = this.getSelectedItem();
        if (tabBarItem3 != null) {
            graphics.setColor(this.getSelectedForeground());
            this._paintItem(graphics, tabBarUI, tabBarItem3, rectangle);
        }
    }

    @Override
    public void setCanvasSize(int n, int n2) {
        int n3;
        int n4;
        super.setCanvasSize(n, n2);
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            this.scrollIntoView(tabBarItem);
        }
        if ((n4 = this.getCanvasOrigin().x) < (n3 = this._getMaxCanvasX(n))) {
            this.setCanvasOrigin(n3, 0);
        } else {
            this.setCanvasOrigin(this.getHOffsetOfValue(this.getHValueOfOffset(n4)), 0);
        }
        this.processEvent(new TabBarEvent(this, 2002, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanvasOrigin(int n, int n2) {
        this.freezeRepaints();
        if (this._orientation == 0 || this._orientation == 1) {
            try {
                n -= this._doTemporaryHLayout(-n, this._getInnerWidth());
                super.setCanvasOrigin(n, n2);
                this._updateButtonImage();
            }
            finally {
                this.unfreezeRepaints();
            }
        }
        try {
            n2 -= this._doTemporaryVLayout(-n2, this._getInnerHeight());
            super.setCanvasOrigin(n, n2);
            this._updateButtonImage();
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    @Override
    protected Dimension layoutCanvas() {
        int n;
        int n2;
        Dimension dimension = this.getInnerSize();
        int n3 = this.getItemCount();
        if (n3 == 0) {
            return dimension;
        }
        TabBarUI tabBarUI = this.getTabBarUI();
        int n4 = this.getOrientation();
        int n5 = tabBarUI.getTabOverlap(this);
        ImmInsets immInsets = tabBarUI.getSelectedItemOutsets(this);
        Dimension dimension2 = this.getPreferredSize();
        ImmInsets immInsets2 = this.getBorderInsets();
        int n6 = dimension2.height - (immInsets2.top + immInsets2.bottom) - (immInsets.top + immInsets.bottom);
        int n7 = dimension2.width - (immInsets2.left + immInsets2.right) - (immInsets.left + immInsets.right);
        int[] nArray = new int[n3];
        boolean bl = this.getOrientation() == 0 || this.getOrientation() == 1 ? this._calculateTabWidths(nArray) : this._calculateTabHeights();
        int n8 = immInsets.left;
        int n9 = 0;
        PushButton pushButton = this._getScrollButton();
        Dimension dimension3 = ((Component)pushButton).getPreferredSize();
        if (this.getOrientation() == 0 || this.getOrientation() == 1) {
            if (dimension3.height > dimension2.height - 2) {
                dimension3.height = dimension2.height - 2;
            }
        } else if (dimension3.width > dimension2.width - 2) {
            dimension3.width = dimension2.width - 2;
        }
        if (n4 == 0) {
            n2 = this.getActualReadingDirection() == 1 ? immInsets2.left + dimension.width - dimension3.width : immInsets2.left + 2;
            n = immInsets2.top + dimension.height - (dimension3.height + 2);
        } else if (n4 == 1) {
            n2 = this.getActualReadingDirection() == 1 ? immInsets2.left + dimension.width - dimension3.width : immInsets2.left + 2;
            n = immInsets2.top + 2;
        } else if (n4 == 2) {
            n = immInsets2.top + dimension.height - dimension3.height;
            n2 = immInsets2.left + dimension.width - (dimension3.width + 2);
        } else {
            n = immInsets2.top + dimension.height - dimension3.height;
            n2 = immInsets2.left + 2;
        }
        if (bl) {
            pushButton.setBounds(n2, n, dimension3.width, dimension3.height);
            ((Component)pushButton).setVisible(true);
        } else {
            ((Component)pushButton).setVisible(false);
            pushButton.setBounds(n2, n, dimension3.width, dimension3.height);
        }
        if (this.getActualAlignment() != 1) {
            n8 = dimension.width - dimension2.width;
            n8 = this.getActualAlignment() == 3 ? (n8 /= 2) : (n8 += immInsets.left);
        }
        if (n4 == 0 || n4 == 1) {
            n9 = n4 == 0 ? dimension.height - n6 : 0;
            n8 = this._layoutItemsTopBottom(nArray, n9, n6);
            n9 = dimension.height;
            this._widths = nArray;
        } else {
            int n10 = this.getItemCount() == 0 ? 0 : n6 / this._getVisibleItemCount();
            n9 = this._layoutItemsLeftRight(n10, n8, n7);
            n8 = dimension.width;
            this._height = n10;
        }
        return new Dimension(n8, n9);
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.getItemCount();
        int n2 = this.getOrientation();
        int n3 = this.getTabBarUI().getTabOverlap(this);
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            TabBarItem tabBarItem = this.getItem(i);
            if (!tabBarItem.isVisible()) continue;
            Dimension dimension = tabBarItem.getPreferredSize();
            if (n2 == 0 || n2 == 1) {
                n4 += dimension.width - n3;
                if (n5 >= dimension.height) continue;
                n5 = dimension.height;
                continue;
            }
            n5 += dimension.height - n3;
            if (n4 >= dimension.width) continue;
            n4 = dimension.width;
        }
        if (n2 == 0 || n2 == 1) {
            if (n4 > 0) {
                n4 += n3;
            }
        } else if (n5 > 0) {
            n5 += n3;
        }
        return this._convertInnerToOuterSelectedSize(n4, n5);
    }

    @Override
    public synchronized Dimension getMinimumSize() {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = this.getItemCount();
        for (int i = 0; i < n3; ++i) {
            Dimension dimension = this.getItem(i).getPreferredSize();
            if (dimension.width < n) {
                n = dimension.width;
            }
            if (dimension.height <= n2) continue;
            n2 = dimension.height;
        }
        return this._convertInnerToOuterSelectedSize(n, n2);
    }

    @Override
    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.repaintInterior();
        }
    }

    @Override
    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            this.repaintInterior();
        }
    }

    public TabBarItem getItemAt(int n, int n2) {
        Point point = this.convertOuterToCanvas(n, n2);
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null && tabBarItem.contains(point.x, point.y)) {
            return tabBarItem;
        }
        int n3 = this.getItemCount();
        for (int i = 0; i < n3; ++i) {
            TabBarItem tabBarItem2 = this.getItem(i);
            if (tabBarItem2.isSelected() || !tabBarItem2.isVisible() || !tabBarItem2.contains(point.x, point.y)) continue;
            return tabBarItem2;
        }
        return null;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void handleHScroll(int n, int n2) throws ScrollableException {
        super.handleHScroll(n, n2);
        this.processEvent(new TabBarEvent(this, 2002, null));
    }

    @Override
    protected Object getPaintData(Object object) {
        if ("MinimumTabChars".equals(object)) {
            return this._minimumChars;
        }
        return super.getPaintData(object);
    }

    protected TabBarItem createItem(String string) {
        return new TabBarItem(string);
    }

    @Override
    protected int getHMaximum() {
        int n = this.getItemCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.getItem(i).isVisible()) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    protected int getVMaximum() {
        return this.getHMaximum();
    }

    @Override
    public int getHValueOfOffset(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.getItemCount();
        boolean bl = this.getActualReadingDirection() == 1;
        int n5 = n2 = bl ? 0 : n4 - 1;
        while (n2 >= 0 && n2 < n4) {
            TabBarItem tabBarItem = this.getItem(n2);
            if (tabBarItem.isVisible()) {
                Rectangle rectangle = tabBarItem.getSelectedBounds();
                if (rectangle.x >= -n) break;
                ++n3;
            }
            n2 = bl ? n2 + 1 : n2 - 1;
        }
        return n3;
    }

    @Override
    public int getVValueOfOffset(int n) {
        int n2 = 0;
        int n3 = this.getItemCount();
        for (int i = 0; i < n3; ++i) {
            TabBarItem tabBarItem = this.getItem(i);
            if (!tabBarItem.isVisible()) continue;
            Rectangle rectangle = tabBarItem.getSelectedBounds();
            if (rectangle.y >= -n) break;
            ++n2;
        }
        return n2;
    }

    @Override
    public int getHOffsetOfValue(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.getItemCount();
        int n5 = this.getCanvasSize().width;
        int n6 = -this._getMaxCanvasX(n5);
        int n7 = n5;
        boolean bl = this.getActualReadingDirection() == 1;
        int n8 = n2 = bl ? 0 : n4 - 1;
        while (n2 >= 0 && n2 < n4) {
            TabBarItem tabBarItem = this.getItem(n2);
            if (tabBarItem.isVisible()) {
                if (n3 == n) {
                    n7 = tabBarItem.getSelectedBounds().x;
                    break;
                }
                ++n3;
            }
            n2 = bl ? n2 + 1 : n2 - 1;
        }
        if (n7 > n6) {
            n7 = n6;
        }
        return -n7;
    }

    @Override
    public int getVOffsetOfValue(int n) {
        int n2 = 0;
        int n3 = this.getItemCount();
        int n4 = this.getCanvasSize().height;
        int n5 = -this._getMaxCanvasY(n4);
        int n6 = n4;
        for (int i = 0; i < n3; ++i) {
            TabBarItem tabBarItem = this.getItem(i);
            if (!tabBarItem.isVisible()) continue;
            if (n2 == n) {
                n6 = tabBarItem.getSelectedBounds().y;
                break;
            }
            ++n2;
        }
        if (n6 > n5) {
            n6 = n5;
        }
        return -n6;
    }

    @Override
    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        this._hAdjustable = adjustable;
    }

    @Override
    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        this._vAdjustable = adjustable;
    }

    @Override
    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    @Override
    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    @Override
    public boolean isHScrollable() {
        return this._orientation == 0 || this._orientation == 1;
    }

    @Override
    public boolean isVScrollable() {
        return this._orientation == 2 || this._orientation == 3;
    }

    protected final TabBarUI getTabBarUI() {
        return (TabBarUI)this.getUI();
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            tabBarItem.repaint();
        }
        super.processFocusEvent(focusEvent);
    }

    public void scrollIntoView(TabBarItem tabBarItem) {
        int n;
        boolean bl;
        int n2 = this._getInnerWidth();
        int n3 = this._getInnerHeight();
        boolean bl2 = bl = this._orientation == 0 || this._orientation == 1;
        if (bl ? n2 <= 0 : n3 <= 0) {
            return;
        }
        Point point = this.getCanvasOrigin();
        Rectangle rectangle = tabBarItem.getSelectedBounds();
        int n4 = this.getIndexOf(tabBarItem);
        if (!bl || this.getActualReadingDirection() == 1) {
            for (n = n4 - 1; n >= 0; --n) {
                if (this.getItem(n).isVisible()) continue;
                --n4;
            }
        } else {
            for (n = n4 + 1; n < this.getItemCount(); ++n) {
                if (this.getItem(n).isVisible()) continue;
                --n4;
            }
            n4 = this.getHMaximum() - n4 - 1;
        }
        if (bl) {
            if (rectangle.x < -point.x) {
                n = this.getHOffsetOfValue(n4);
                if (this._scrollButton.isVisible() && this.getActualReadingDirection() == 2) {
                    n += this._scrollButton.getSize().width + 2;
                }
                this.setCanvasOrigin(n, 0);
            } else if (rectangle.x + rectangle.width > -point.x + n2) {
                n = this.getHValueOfOffset(point.x);
                int n5 = this.getHMaximum();
                while (rectangle.x + rectangle.width > -this.getHOffsetOfValue(++n) + n2 && n < n5) {
                }
                this.setCanvasOrigin(this.getHOffsetOfValue(n), 0);
            }
        } else if (rectangle.y < -point.y) {
            this.setCanvasOrigin(0, this.getVOffsetOfValue(n4));
        } else if (rectangle.y + rectangle.height > -point.y + n3) {
            n = this.getVValueOfOffset(point.y);
            int n6 = this.getHMaximum();
            while (rectangle.y + rectangle.height > -this.getVOffsetOfValue(++n) + n3 && n < n6) {
            }
            this.setCanvasOrigin(0, this.getVOffsetOfValue(n));
        }
    }

    public void moveSelection(boolean bl) {
        boolean bl2 = this._moveSelection(bl, false);
    }

    @Override
    public void postProcessKey(KeyEvent keyEvent) {
        int n;
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (TabBar.hasMnemonicModifier(keyEvent) && (n = keyEvent.getKeyCode()) != 0) {
            int n2 = this.getItemCount();
            for (int i = 0; i < n2; ++i) {
                char c;
                TabBarItem tabBarItem = this.getItem(i);
                if (!tabBarItem.isItemEnabled() || !tabBarItem.isVisible() || (c = tabBarItem.getMnemonicChar()) == '\u0000' || Character.toUpperCase(c) != n) continue;
                this.requestFocus();
                tabBarItem.setSelected(true);
                keyEvent.consume();
                return;
            }
        }
        super.postProcessKey(keyEvent);
    }

    @Override
    protected int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x800 | 0x4000;
    }

    @Override
    protected int getRepaintFlags() {
        return super.getRepaintFlags() | 0x800 | 0x4000;
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    void __fireVisibleDataChanged() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }
    }

    Color getSelectedInactiveBackground() {
        return this.getUIDefaults().getColor("TabBar.inactiveSelectedItemBackground");
    }

    void itemDeselected(TabBarItem tabBarItem) {
        if (this.getSelectedItem() == tabBarItem) {
            this._setSelectedItem(null);
            this.processEvent(new TabBarEvent(this, 2001, null));
        }
    }

    private void _updateButtonImage() {
        PushButton pushButton = this._getScrollButton();
        if (pushButton.isVisible()) {
            if (this._orientation == 0 || this._orientation == 1) {
                pushButton.setImageSet(this.getTabBarUI().getScrollImageSet(this, this._atLeft(), this._atRight()));
            } else {
                pushButton.setImageSet(this.getTabBarUI().getScrollImageSet(this, this._atTop(), this._atBottom()));
            }
        }
    }

    private boolean _atLeft() {
        return this.getCanvasOrigin().x >= 0;
    }

    private boolean _atRight() {
        return this.getCanvasOrigin().x <= this._getMaxCanvasX(this.getCanvasSize().width);
    }

    private boolean _atTop() {
        return this.getCanvasOrigin().y >= 0;
    }

    private boolean _atBottom() {
        return this.getCanvasOrigin().y <= this._getMaxCanvasY(this.getCanvasSize().height);
    }

    private int _getMaxCanvasX(int n) {
        int n2 = this._getInnerWidth() - n;
        if (n2 > 0) {
            n2 = 0;
        }
        return n2;
    }

    private int _getMaxCanvasY(int n) {
        int n2 = this._getInnerHeight() - n;
        if (n2 > 0) {
            n2 = 0;
        }
        return n2;
    }

    private PushButton _getScrollButton() {
        if (this._scrollButton == null) {
            TabBarUI tabBarUI = this.getTabBarUI();
            this._scrollButton = tabBarUI.getScrollButton(this);
            this._scrollButton.setImageSet(tabBarUI.getScrollImageSet(this, true, false));
            this.add(this._scrollButton);
        }
        return this._scrollButton;
    }

    private void _paintItem(Graphics graphics, TabBarUI tabBarUI, TabBarItem tabBarItem, Rectangle rectangle) {
        if (!tabBarItem.isVisible()) {
            return;
        }
        Rectangle rectangle2 = tabBarItem.getBounds();
        if (rectangle2.intersects(rectangle)) {
            Painter painter = this._getTabPainter(tabBarUI, tabBarItem);
            painter.paint(tabBarItem, graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    private Painter _getTabPainter(TabBarUI tabBarUI, TabBarItem tabBarItem) {
        boolean bl;
        boolean bl2;
        Rectangle rectangle = tabBarItem.getBounds();
        if (this._orientation == 0 || this._orientation == 1) {
            rectangle.x += this.getCanvasOrigin().x;
            bl2 = rectangle.x == 0;
            bl = rectangle.x + rectangle.width >= this.getInnerSize().width;
        } else {
            rectangle.y += this.getCanvasOrigin().y;
            bl2 = rectangle.y == 0;
            bl = rectangle.y + rectangle.height >= this.getInnerSize().height;
        }
        return tabBarUI.getTabPainter(this, bl2, bl);
    }

    private synchronized TabBarItem _getFirstItem() {
        TabBarItem tabBarItem;
        TabBarItem tabBarItem2 = tabBarItem = (TabBarItem)this._tabs.firstElement();
        while (!tabBarItem.isVisible() && (tabBarItem = this._getNextItem(tabBarItem, false)) != null) {
        }
        return tabBarItem;
    }

    private synchronized TabBarItem _getLastItem() {
        TabBarItem tabBarItem;
        TabBarItem tabBarItem2 = tabBarItem = (TabBarItem)this._tabs.lastElement();
        while (!tabBarItem.isVisible() && (tabBarItem = this._getPrevItem(tabBarItem, false)) != null) {
        }
        return tabBarItem;
    }

    private synchronized TabBarItem _getNextItem(TabBarItem tabBarItem, boolean bl) {
        int n = this.getIndexOf(tabBarItem);
        if (++n == this.getItemCount()) {
            if (!bl) {
                return null;
            }
            n = 0;
        }
        return this.getItem(n);
    }

    private synchronized TabBarItem _getPrevItem(TabBarItem tabBarItem, boolean bl) {
        int n = this.getIndexOf(tabBarItem);
        if (n > 0) {
            --n;
        } else {
            if (!bl) {
                return null;
            }
            n = this.getItemCount() - 1;
        }
        return this.getItem(n);
    }

    private synchronized int _getSelectedIndex() {
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem != null) {
            return this.getIndexOf(tabBarItem);
        }
        return -1;
    }

    private void _setSelectedItem(TabBarItem tabBarItem) {
        TabBarItem tabBarItem2 = this._selectedItem;
        this._selectedItem = tabBarItem;
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null && tabBarItem2 != tabBarItem) {
            if (tabBarItem2 != null) {
                tabBarItem2.getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
            if (tabBarItem != null) {
                tabBarItem.getAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            }
            accessibleContext.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }
    }

    boolean _moveSelection(boolean bl) {
        return this._moveSelection(bl, true);
    }

    private boolean _moveSelection(boolean bl, boolean bl2) {
        TabBarItem tabBarItem = this.getSelectedItem();
        if (tabBarItem == null && (tabBarItem = this._getFirstItem()) == null) {
            return false;
        }
        TabBarItem tabBarItem2 = tabBarItem;
        while (!((tabBarItem2 = bl ? this._getNextItem(tabBarItem2, bl2) : this._getPrevItem(tabBarItem2, bl2)) == null || tabBarItem2 == tabBarItem || tabBarItem2.isEnabled() && tabBarItem2.isVisible())) {
        }
        if (tabBarItem2 != null && tabBarItem2 != tabBarItem) {
            tabBarItem2.setSelected(true);
            return true;
        }
        return false;
    }

    private Dimension _convertInnerToOuterSelectedSize(int n, int n2) {
        ImmInsets immInsets = this.getTabBarUI().getSelectedItemOutsets(this);
        return this.convertInnerToOuterSize(n += immInsets.left + immInsets.right, n2 += immInsets.top + immInsets.bottom);
    }

    private synchronized boolean _calculateTabWidths(int[] nArray) {
        Integer[] integerArray;
        Object object;
        int n;
        int n2 = this.getItemCount();
        if (n2 == 0) {
            return false;
        }
        int n3 = this.getInnerSize().width;
        int n4 = this.getTabBarUI().getTabOverlap(this);
        n3 -= n4;
        ImmInsets immInsets = this.getTabBarUI().getSelectedItemOutsets(this);
        n3 -= immInsets.left + immInsets.right;
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            object = this.getItem(n);
            if (object.isVisible()) {
                nArray[n] = this.getItem((int)n).getPreferredSize().width;
                n5 += nArray[n] - n4;
                continue;
            }
            nArray[n] = 0;
        }
        if (n5 <= n3) {
            if (n5 < n3) {
                object = new Integer[n2];
                int n6 = this._getSortedWidths((Integer[])object, nArray);
                if (n6 == 0) {
                    return false;
                }
                int n7 = 0;
                for (n = 0; n < n6; ++n) {
                    n7 += nArray[object[n]];
                }
                n7 = n7 * 3 / (2 * n6);
                int n8 = n4;
                boolean bl = false;
                int n9 = 0;
                for (n = n6 - 1; n >= 0; --n) {
                    int n10 = object[n];
                    if (bl) {
                        nArray[n10] = n9;
                        continue;
                    }
                    int n11 = nArray[n10];
                    if (n11 < n7 && n8 + (n11 - n4) * (n + 1) <= n3) {
                        bl = true;
                        n9 = n11;
                    }
                    n8 += n11;
                }
            }
            return false;
        }
        this._calculateMinimumChars();
        object = new int[n2];
        n5 = 0;
        for (n = 0; n < n2; ++n) {
            integerArray = this.getItem(n);
            if (integerArray.isVisible()) {
                object[n] = this.getItem((int)n).getMinimumSize().width;
                n5 += object[n] - n4;
                continue;
            }
            object[n] = (Integer)false;
        }
        if (n5 > n3) {
            System.arraycopy(object, 0, nArray, 0, n2);
            return true;
        }
        integerArray = new Integer[n2];
        int n12 = this._getSortedWidths(integerArray, nArray);
        n5 = 0;
        for (n = 0; n < n12; ++n) {
            int n13;
            int n14 = nArray[integerArray[n]];
            if (n5 + (n14 - n4) * (n13 = n12 - n) > n3) {
                int n15 = (n3 - n5) / n13;
                int n16 = n3 - n5 - n15 * n13;
                n15 += n4;
                for (int i = n; i < n12; ++i) {
                    int n17 = n15;
                    if (n16-- > 0) {
                        // empty if block
                    }
                    nArray[integerArray[i].intValue()] = ++n17;
                }
                break;
            }
            n5 += n14 - n4;
        }
        return false;
    }

    private synchronized boolean _calculateTabHeights() {
        int n = this.getItemCount();
        if (n == 0) {
            return false;
        }
        int n2 = this.getInnerSize().height;
        int n3 = this.getTabBarUI().getTabOverlap(this);
        n2 -= n3;
        ImmInsets immInsets = this.getTabBarUI().getSelectedItemOutsets(this);
        n2 -= immInsets.top + immInsets.bottom;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            TabBarItem tabBarItem = this.getItem(i);
            if (!tabBarItem.isVisible()) continue;
            n4 += this.getItem((int)i).getPreferredSize().height - n3;
        }
        return n4 > n2;
    }

    private int _getSortedWidths(Integer[] integerArray, int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!this.getItem(i).isVisible()) continue;
            integerArray[n++] = IntegerUtils.getInteger((int)i);
        }
        Sort.qSort((Object[])integerArray, (int)n, (Comparator)new SizeComp(nArray));
        return n;
    }

    private synchronized void _calculateMinimumChars() {
        Object object;
        int n;
        this._minimumChars = null;
        int n2 = this.getItemCount();
        if (n2 <= 1) {
            return;
        }
        if (Boolean.TRUE.equals(this.getClientProperty(_PROPERTY_DONT_TRUNCATE))) {
            return;
        }
        Object[] objectArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            object = this.getItem(n).getLabel();
            if (object == null) {
                return;
            }
            objectArray[n] = object;
        }
        Sort.qSort((Object[])objectArray, (int)n2, (Comparator)LexiComparator.getComparator());
        n = 4;
        object = objectArray[0];
        for (int i = 1; i < n2; ++i) {
            Object object2 = objectArray[i];
            int n3 = Math.min(((String)object).length(), ((String)object2).length());
            for (int j = 0; j < n3; ++j) {
                if (((String)object).charAt(j) == ((String)object2).charAt(j)) continue;
                if (j <= n) break;
                n = j;
                break;
            }
            object = object2;
        }
        this._minimumChars = IntegerUtils.getInteger((int)(n + 2));
    }

    private boolean _isItemPainted(TabBarItem tabBarItem) {
        Rectangle rectangle = tabBarItem.getSelectedBounds();
        if (this.getOrientation() == 0 || this.getOrientation() == 1) {
            int n = -this.getCanvasOrigin().x;
            int n2 = n + this._getInnerWidth() + this.getTabBarUI().getTabOverlap(this);
            return rectangle.x >= n && rectangle.x + rectangle.width <= n2;
        }
        int n = -this.getCanvasOrigin().y;
        int n3 = n + this._getInnerHeight() + this.getTabBarUI().getTabOverlap(this);
        return rectangle.y >= n && rectangle.y + rectangle.height <= n3;
    }

    private int _layoutItemsTopBottom(int[] nArray, int n, int n2) {
        PushButton pushButton;
        int n3;
        int n4;
        int n5 = this.getItemCount();
        if (this.getActualReadingDirection() == 2) {
            n4 = n5 - 1;
            n3 = -1;
        } else {
            n4 = 0;
            n3 = 1;
        }
        TabBarUI tabBarUI = this.getTabBarUI();
        int n6 = tabBarUI.getTabOverlap(this);
        int n7 = tabBarUI.getSelectedItemOutsets((LWComponent)this).left;
        int n8 = this.getActualAlignment();
        if (n8 != 1) {
            int n9;
            int n10 = n6;
            for (n9 = 0; n9 < n5; ++n9) {
                n10 += nArray[n9] - n6;
            }
            n9 = this._getInnerWidth();
            if (n10 < n9) {
                n7 = n9 - n10;
                if (n8 == 3) {
                    n7 /= 2;
                }
            }
        }
        if ((pushButton = this._getScrollButton()).isVisible() && pushButton.getLocation().x <= n7 && pushButton.getLocation().x + pushButton.getSize().width + 2 > n7) {
            n7 = pushButton.getSize().width + 2;
        }
        while (n4 >= 0 && n4 < n5) {
            TabBarItem tabBarItem = this.getItem(n4);
            if (tabBarItem.isVisible()) {
                int n11 = nArray[n4];
                tabBarItem.setSize(n11, n2);
                tabBarItem.setLocation(n7, n);
                n7 += n11 - n6;
            }
            n4 += n3;
        }
        n7 += n6;
        return n7 += tabBarUI.getSelectedItemOutsets((LWComponent)this).right;
    }

    private int _layoutItemsLeftRight(int n, int n2, int n3) {
        int n4 = this.getItemCount();
        TabBarUI tabBarUI = this.getTabBarUI();
        int n5 = tabBarUI.getTabOverlap(this);
        int n6 = tabBarUI.getSelectedItemOutsets((LWComponent)this).top;
        int n7 = this.getActualAlignment();
        int n8 = (n - n5) * n4;
        n8 += n5;
        int n9 = this._getInnerHeight();
        for (int i = 0; i < n4; ++i) {
            TabBarItem tabBarItem = this.getItem(i);
            if (!tabBarItem.isVisible()) continue;
            tabBarItem.setSize(n3, n);
            tabBarItem.setLocation(n2, n6);
            n6 += n - n5;
        }
        n6 += n5;
        return n6 += tabBarUI.getSelectedItemOutsets((LWComponent)this).right;
    }

    private int _getInnerWidth() {
        int n = this.getInnerSize().width;
        PushButton pushButton = this._getScrollButton();
        if (pushButton.isVisible()) {
            n -= pushButton.getSize().width;
        }
        return n;
    }

    private int _getInnerHeight() {
        int n = this.getInnerSize().height;
        PushButton pushButton = this._getScrollButton();
        if (pushButton.isVisible()) {
            n -= pushButton.getSize().height;
        }
        return n;
    }

    private int _getVisibleItemCount() {
        int n = 0;
        for (int i = 0; i < this._tabs.size(); ++i) {
            if (!((TabBarItem)this._tabs.elementAt(i)).isVisible()) continue;
            ++n;
        }
        return n;
    }

    private int _doTemporaryHLayout(int n, int n2) {
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        if (!this._getScrollButton().isVisible()) {
            return 0;
        }
        int n7 = this.getItemCount();
        int[] nArray = this._widths;
        if (n7 == 0 || nArray == null || nArray.length != n7) {
            return 0;
        }
        int[] nArray2 = new int[n7];
        System.arraycopy(nArray, 0, nArray2, 0, n7);
        boolean bl = this.getActualReadingDirection() == 1;
        ImmInsets immInsets = this.getTabBarUI().getSelectedItemOutsets(this);
        n2 -= immInsets.left + immInsets.right;
        int n8 = this.getTabBarUI().getTabOverlap(this);
        int n9 = n8 + immInsets.left;
        int n10 = 0;
        int n11 = n6 = bl ? 0 : n7 - 1;
        while (n6 >= 0 && n6 < n7) {
            n10 = n6;
            if (n9 >= n) break;
            n9 += nArray[n6] - n8;
            n6 = bl ? n6 + 1 : n6 - 1;
        }
        int n12 = n7 - 1;
        n9 = n8;
        n6 = n10;
        while (n6 >= 0 && n6 < n7) {
            n5 = n9 + nArray[n6] - n8;
            if (n5 > n2) {
                n12 = n6 - 1;
                break;
            }
            n9 = n5;
            n6 = bl ? n6 + 1 : n6 - 1;
        }
        if (bl && n12 < n7 - 1 || !bl && n12 > 0) {
            n5 = n2 - n9;
            n6 = n10;
            while (n5 > 0 && (bl && n6 <= n12 || !bl && n6 >= n12)) {
                int n13;
                object = this.getItem(n6);
                if (((TabBarItem)object).isVisible() && (n13 = nArray[n6]) < (n4 = ((TabBarItem)object).getPreferredSize().width)) {
                    n3 = Math.min(n5, n4 - n13);
                    nArray2[n6] = n13 + n3;
                    n5 -= n3;
                }
                n6 = bl ? n6 + 1 : n6 - 1;
            }
        }
        object = this.getPreferredSize();
        ImmInsets immInsets2 = this.getBorderInsets();
        n4 = ((Dimension)object).height - (immInsets2.top + immInsets2.bottom) - (immInsets.top + immInsets.bottom);
        n3 = ((Dimension)object).width - (immInsets2.left + immInsets2.right) - (immInsets.left + immInsets.right);
        n5 = this.getOrientation() == 0 ? this.getInnerSize().height - n4 : 0;
        int n14 = this.getItem((int)n10).getSelectedBounds().x;
        int n15 = this.getHValueOfOffset(-n14);
        int n16 = this.getHOffsetOfValue(n15);
        this._layoutItemsTopBottom(nArray2, n5, n4);
        return n16 - this.getHOffsetOfValue(n15);
    }

    private int _doTemporaryVLayout(int n, int n2) {
        int n3;
        int n4;
        int n5;
        Object object;
        int n6;
        int n7;
        int n8;
        if (!this._getScrollButton().isVisible()) {
            return 0;
        }
        int n9 = this.getItemCount();
        int n10 = n8 = this._height;
        if (n9 == 0 || n8 == 0) {
            return 0;
        }
        ImmInsets immInsets = this.getTabBarUI().getSelectedItemOutsets(this);
        n2 -= immInsets.top + immInsets.bottom;
        int n11 = this.getTabBarUI().getTabOverlap(this);
        int n12 = n11 + immInsets.top;
        int n13 = 0;
        int n14 = 0;
        while (n14 < n9) {
            n13 = n14++;
            if (n12 >= n) break;
            n12 += n8 - n11;
        }
        n14 = n9 - 1;
        n12 = n11;
        for (n7 = 0; n7 < n9; ++n7) {
            n6 = n12 + n8 - n11;
            if (n6 > n2) {
                n14 = n7 - 1;
                break;
            }
            n12 = n6;
        }
        if (n14 < n9 - 1) {
            n7 = n2 - n12;
            for (n6 = n13; n7 > 0 && n6 <= n14; ++n6) {
                object = this.getItem(n6);
                if (!((TabBarItem)object).isVisible() || (n5 = n8) >= (n4 = ((TabBarItem)object).getPreferredSize().height)) continue;
                n3 = Math.min(n7, n4 - n5);
                n10 = n5 + n3;
                n7 -= n3;
            }
        }
        Dimension dimension = this.getPreferredSize();
        object = this.getBorderInsets();
        n5 = dimension.width - (((ImmInsets)object).left + ((ImmInsets)object).right) - (immInsets.left + immInsets.right);
        n7 = this.getOrientation() == 2 ? this.getInnerSize().width - n5 : 0;
        n4 = this.getItem((int)n13).getSelectedBounds().y;
        n3 = this.getVValueOfOffset(-n4);
        int n15 = this.getVOffsetOfValue(n3);
        this._layoutItemsLeftRight(n8, n7, n5);
        return n15 - this.getVOffsetOfValue(n3);
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleSelection {
        public Access() {
            super(TabBar.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return TabBar.this.getItemCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= TabBar.this.getItemCount()) {
                return null;
            }
            return TabBar.this.getItem(n);
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            TabBarItem tabBarItem = TabBar.this.getItemAt(point.x, point.y);
            if (tabBarItem == null) {
                return TabBar.this.getSelectedItem();
            }
            return tabBarItem;
        }

        @Override
        public int getAccessibleSelectionCount() {
            return TabBar.this.getSelectedItem() == null ? 0 : 1;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            if (n == 0) {
                return TabBar.this.getSelectedItem();
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            return TabBar.this.getItem(n) == TabBar.this.getSelectedItem();
        }

        @Override
        public void addAccessibleSelection(int n) {
            TabBar.this.getItem(n).setSelected(true);
        }

        @Override
        public void removeAccessibleSelection(int n) {
        }

        @Override
        public void clearAccessibleSelection() {
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    private static class SizeComp
    implements Comparator {
        private int[] _sizes;

        public SizeComp(int[] nArray) {
            this._sizes = nArray;
        }

        public int compare(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            return this._sizes[n] - this._sizes[n2];
        }
    }
}

