/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.LookAndFeel;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.button.ContinuousButton;
import oracle.ewt.button.PulsingButtonEvent;
import oracle.ewt.button.PulsingButtonListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.SharedPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.ScrollBarUI;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;
import oracle.ewt.util.InputEventUtils;

public class LWScrollbar
extends LWComponent
implements Adjustable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int _value;
    private int _maximum;
    private int _minimum;
    private int _orientation;
    private int _unitIncrement = 1;
    private int _blockIncrement = 10;
    private int _visible;
    private ListenerManager _listeners;
    private ContinuousButton _incArrow;
    private ContinuousButton _decArrow;
    private Pulser _pulser;
    private int _barX;
    private int _barY;
    private int _barWidth;
    private int _barHeight;
    ContinuousButton _currentButton;
    int _pulseCount;
    private int _dragPos;
    private boolean _draggingThumb;
    private int _dragDelta;
    private int _dragStartPos;
    private int _dragStartValue;
    boolean _blockTracking;
    private boolean _blockGoingDown;
    private boolean _startPulsing;
    private Object _executionLock = new Object();
    private boolean _blockRerun;
    TaskScheduler _scheduler = TaskScheduler.getDefaultTaskScheduler();
    private static final int _MINIMUM_USABLE_THUMB_SIZE = 4;
    private static final int _PREFERRED_ALLEY_SIZE = 50;
    static final int _FIRST_PULSE_DELAY = 200;
    static final int _PULSE_DELAY = 15;

    public LWScrollbar() {
        this(1, 0, 10, 0, 100);
        if (this.getActualReadingDirection() == 2 && this.getOrientation() == 0) {
            this.setValues(90, 10, 0, 100);
        }
    }

    public LWScrollbar(int n) {
        this(n, 0, 10, 0, 100);
        if (this.getActualReadingDirection() == 2 && this.getOrientation() == 0) {
            this.setValues(90, 10, 0, 100);
        }
    }

    public LWScrollbar(int n, int n2, int n3, int n4, int n5) {
        super.setLayout(null);
        this.enableEvents(48L);
        this._orientation = 2;
        this.setOrientation(n);
        this.setValues(n2, n3, n4, n5);
    }

    @Override
    public Object getUIClassID() {
        return "ScrollBarUI";
    }

    @Override
    public int getOrientation() {
        return this._orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal scrollbar orientation");
        }
        boolean bl = false;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            if (n != this._orientation) {
                this._orientation = n;
                if (this._incArrow != null) {
                    ScrollBarUI scrollBarUI = this.getScrollBarUI();
                    this._incArrow.setPainter(scrollBarUI.getIncrementPainter(this));
                    this._decArrow.setPainter(scrollBarUI.getDecrementPainter(this));
                }
                bl = true;
            }
        }
        if (bl) {
            this.invalidate();
        }
    }

    @Override
    public int getValue() {
        return this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setValue(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            n5 = n;
            n4 = this._visible;
            n3 = this._minimum;
            n2 = this._maximum;
        }
        this.setValues(n5, n4, n3, n2);
    }

    @Override
    public int getMinimum() {
        return this._minimum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMinimum(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            n5 = this._value;
            n4 = this._visible;
            n3 = n;
            n2 = this._maximum;
        }
        this.setValues(n5, n4, n3, n2);
    }

    @Override
    public int getMaximum() {
        return this._maximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMaximum(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            n5 = this._value;
            n4 = this._visible;
            n3 = this._minimum;
            n2 = n;
        }
        this.setValues(n5, n4, n3, n2);
    }

    @Override
    public int getVisibleAmount() {
        return this._visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisibleAmount(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            n5 = this._value;
            n4 = n;
            n3 = this._minimum;
            n2 = this._maximum;
        }
        this.setValues(n5, n4, n3, n2);
    }

    @Override
    public synchronized void setUnitIncrement(int n) {
        this._unitIncrement = n;
    }

    @Override
    public int getUnitIncrement() {
        return this._unitIncrement;
    }

    @Override
    public synchronized void setBlockIncrement(int n) {
        this._blockIncrement = n;
    }

    @Override
    public int getBlockIncrement() {
        return this._blockIncrement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, int n3, int n4) {
        int n5 = this._value;
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            if (n == this._value && n2 == this._visible && n3 == this._minimum && n4 == this._maximum) {
                return;
            }
            this._setValuesInternal(n, n2, n3, n4);
        }
        if (n5 != n) {
            this._fireAccessValue(n5, n);
        }
        this._repaintChangedThumb();
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(adjustmentListener);
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this._listeners.removeListener(adjustmentListener);
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public Dimension getPreferredSize() {
        return this._getPreferredSize(50);
    }

    @Override
    public Dimension getMinimumSize() {
        return this._getPreferredSize(this._getMinimumThumbSize());
    }

    @Override
    public void enable() {
        if (this._incArrow != null) {
            this._incArrow.setEnabled(true);
            this._decArrow.setEnabled(true);
        }
        super.enable();
    }

    @Override
    public void disable() {
        if (this._incArrow != null) {
            this._incArrow.setEnabled(false);
            this._decArrow.setEnabled(false);
        }
        super.disable();
    }

    @Override
    public void doLayout() {
        this._ensureArrowsCreated();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this._incArrow.getMaximumSize();
        Dimension dimension3 = this._decArrow.getMaximumSize();
        if (this._orientation == 0) {
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            this._incArrow.setBounds(dimension.width - dimension3.width, 0, dimension3.width, dimension2.height);
            this._barX = dimension2.width;
            this._barY = 0;
            this._barWidth = dimension.width - dimension2.width - dimension3.width;
            this._barHeight = dimension2.height;
        } else {
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            this._incArrow.setBounds(0, dimension.height - dimension3.height, dimension2.width, dimension3.height);
            this._barX = 0;
            this._barY = dimension2.height;
            this._barWidth = dimension2.width;
            this._barHeight = dimension.height - dimension2.height - dimension3.height;
        }
        this._decArrow.setBounds(0, 0, dimension2.width, dimension2.height);
    }

    @Override
    public void setBackground(Color color) {
        if (this._incArrow != null) {
            this._incArrow.setBackground(color);
            this._decArrow.setBackground(color);
        }
        super.setBackground(color);
    }

    @Override
    public boolean isChildClipped(Component component) {
        return this.isClippedBySibling();
    }

    @Override
    public boolean isInteriorTransparent() {
        boolean bl = super.isInteriorTransparent();
        if (bl && this._incArrow != null) {
            return this._incArrow.isTransparent() || this._decArrow.isTransparent();
        }
        return false;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!SharedPainter.__isUnfreezing()) {
            this._allowRerun();
        }
        if (this._startPulsing && !SharedPainter.__isUnfreezing()) {
            this._startPulsing = false;
            Pulser pulser = this._pulser;
            if (pulser != null) {
                this._scheduler.schedule(pulser, 200);
            }
        }
    }

    @Override
    public void paintInterior(Graphics graphics) {
        ScrollBarUI scrollBarUI = this.getScrollBarUI();
        PaintContext paintContext = this.getPaintContext();
        scrollBarUI.getTrackPainter(this).paint(paintContext, graphics, this._barX, this._barY, this._barWidth, this._barHeight);
        Rectangle rectangle = this._getThumbBounds();
        if (rectangle != null) {
            graphics.setColor(this.getBackground());
            scrollBarUI.getThumbPainter(this).paint(this.getPaintContext(), graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this._blockTracking && this.isEnabled()) {
                graphics.setColor(this.getForeground());
                int n = this._barX;
                int n2 = this._barY;
                int n3 = this._barWidth;
                int n4 = this._barHeight;
                if (this._blockGoingDown) {
                    if (this._orientation == 0) {
                        n3 = rectangle.x - n;
                    } else {
                        n4 = rectangle.y - n2;
                    }
                } else if (this._orientation == 0) {
                    n = rectangle.x + rectangle.width;
                    n3 -= n - this._barX;
                } else {
                    n2 = rectangle.y + rectangle.height;
                    n4 -= n2 - this._barY;
                }
                scrollBarUI.getBlockTrackPainter(this).paint(paintContext, graphics, n, n2, n3, n4);
            }
        }
    }

    @Override
    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        if (componentUI != null && this._incArrow != null) {
            ScrollBarUI scrollBarUI = this.getScrollBarUI();
            this._incArrow.setPainter(scrollBarUI.getIncrementPainter(this));
            this._decArrow.setPainter(scrollBarUI.getDecrementPainter(this));
        }
    }

    @Override
    protected int getRepaintFlags() {
        ScrollBarUI scrollBarUI = this.getScrollBarUI();
        PaintContext paintContext = this.getPaintContext();
        return super.getRepaintFlags() | scrollBarUI.getThumbPainter(this).getRepaintFlags(paintContext) | scrollBarUI.getTrackPainter(this).getRepaintFlags(paintContext);
    }

    protected final ScrollBarUI getScrollBarUI() {
        return (ScrollBarUI)this.getUI();
    }

    @Override
    protected boolean interiorContains(int n, int n2, int n3, int n4) {
        if (n < this._barX || n2 < this._barY || n >= this._barX + this._barWidth || n2 >= this._barY + this._barHeight) {
            return this.pointIsInChild(n, n2);
        }
        return true;
    }

    @Override
    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                AdjustmentListener adjustmentListener = (AdjustmentListener)enumeration.nextElement();
                adjustmentListener.adjustmentValueChanged(adjustmentEvent);
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        this._allowRerun();
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!this.contains(n, n2)) break;
                    bl = this.processMousePressed(mouseEvent, n, n2);
                    break;
                }
                case 502: {
                    bl = this.processMouseReleased(mouseEvent, n, n2);
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this._allowRerun();
        super.processMouseMotionEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            switch (mouseEvent.getID()) {
                case 506: {
                    bl = this.processMouseDragged(mouseEvent, n, n2);
                }
            }
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    protected boolean processMousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this._draggingThumb || this._blockTracking) {
            return false;
        }
        if (this.isEnabled() && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            Rectangle rectangle = this._getThumbBounds();
            if (rectangle == null) {
                return false;
            }
            int n3 = this._orientation;
            if (rectangle.contains(n, n2)) {
                this._draggingThumb = true;
                if (n3 == 0) {
                    this._dragDelta = rectangle.x - n;
                    this._dragPos = n - this._barX;
                } else {
                    this._dragDelta = rectangle.y - n2;
                    this._dragPos = n2 - this._barY;
                }
                this._dragPos += this._dragDelta;
                this._dragStartPos = this._dragPos;
                this._dragStartValue = this._value;
                this._repaintChangedThumb();
            } else {
                this._blockTracking = true;
                this._dragPos = n3 == 0 ? n : n2;
                this._blockGoingDown = this._belowThumb(this._dragPos, rectangle);
                this._doPulse();
                this._startPulsing = true;
                this.repaint(this._barX, this._barY, 1, 1);
            }
        }
        return true;
    }

    protected boolean processMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        if (this._draggingThumb) {
            this.processMouseDragged(mouseEvent, n, n2);
            return true;
        }
        if (this._blockTracking) {
            this._scheduler.cancel(this._pulser);
            this._startPulsing = false;
            this._blockTracking = false;
            this._repaintChangedThumb();
            return true;
        }
        return false;
    }

    protected boolean processMouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this._draggingThumb) {
            int n3;
            boolean bl;
            boolean bl2 = bl = !this.isEnabled() || mouseEvent.getID() == 502;
            if (this._orientation == 0) {
                n3 = n - this._barX + this._dragDelta;
                if (n3 > this._barWidth) {
                    n3 = this._barWidth;
                }
            } else {
                n3 = n2 - this._barY + this._dragDelta;
                if (n3 > this._barHeight) {
                    n3 = this._barHeight;
                }
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 != this._dragPos || bl) {
                int n4;
                int n5;
                if (n3 == this._dragStartPos) {
                    n5 = this._dragStartValue;
                } else {
                    n4 = this._orientation == 0 ? this._barWidth : this._barHeight;
                    long l = this._maximum - this._minimum;
                    n5 = (int)(((long)n3 * l + (long)(n4 / 2)) / (long)n4);
                }
                n4 = this._value;
                if (n5 != n4) {
                    this._setValuesInternal(n5, this._visible, this._minimum, this._maximum);
                    this._fireAccessValue(n4, n5);
                    if (n4 != this._value) {
                        this.postAdjustmentEvent(5);
                    }
                }
                this._dragPos = n3;
                if (bl) {
                    this._draggingThumb = false;
                }
                this._repaintChangedThumb();
            }
            return true;
        }
        if (this._blockTracking) {
            this._dragPos = this._orientation == 0 ? n : n2;
            return true;
        }
        return false;
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",val=" + this._value + ",vis=" + this._visible + ",min=" + this._minimum + ",max=" + this._maximum + (this._orientation == 1 ? ",vert" : ",horz");
    }

    @Override
    protected int getPaintState() {
        int n = super.getPaintState();
        if (this._draggingThumb) {
            n |= 2;
        }
        return n;
    }

    protected void postAdjustmentEvent(int n) {
        this.processEvent(new AdjustmentEvent(this, 601, n, this._value));
    }

    void _doPulse() {
        int n;
        if (this._stopRerun()) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (this._blockTracking) {
            if (!this.isEnabled()) {
                return;
            }
            Rectangle rectangle = this._getThumbBounds();
            n = this._blockGoingDown;
            if (n != 0 && this._belowThumb(this._dragPos, rectangle) || n == 0 && this._aboveThumb(this._dragPos, rectangle)) {
                n2 = this._blockIncrement;
                if (n != 0) {
                    n3 = 3;
                    n2 = -n2;
                } else {
                    n3 = 4;
                }
            }
        } else {
            if (this._currentButton == null) {
                return;
            }
            n2 = this.getUnitIncrement();
            if (this._currentButton == this._decArrow) {
                n2 = -n2;
                n3 = 2;
            } else {
                n3 = 1;
            }
            this._currentButton.setDelay(this._pulseCount++ > 0 ? 15 : 200);
        }
        int n4 = this.getValue();
        n = n4 + n2;
        if (n < this._minimum) {
            n = this._minimum;
        } else if (n > this._maximum - this._visible) {
            n = this._maximum - this._visible;
        }
        if (n != n4) {
            this.setValue(n);
            this.postAdjustmentEvent(n3);
        }
    }

    boolean __isBusy() {
        return this._currentButton != null || this._draggingThumb || this._blockTracking;
    }

    private int _getMinimumThumbSize() {
        Painter painter = this.getScrollBarUI().getThumbPainter(this);
        Dimension dimension = painter.getMinimumSize(this.getPaintContext());
        if (this.getOrientation() == 0) {
            return dimension.width;
        }
        return dimension.height;
    }

    private Rectangle _getThumbBounds() {
        int n;
        int n2;
        int n3;
        long l;
        long l2 = l = this._orientation == 0 ? (long)this._barWidth : (long)this._barHeight;
        if (l < 4L) {
            return null;
        }
        int n4 = this._maximum - this._minimum;
        if (this._value < this._maximum - this._visible) {
            l = Math.max(0L, l - 1L);
        }
        if (this._draggingThumb) {
            n3 = this._dragPos;
        } else {
            n3 = this._value - this._minimum;
            n3 = (int)((l * (long)n3 + (long)(n4 - 1)) / (long)n4);
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = (int)((l * (long)this._visible + (long)(n4 - 1)) / (long)n4)) < (n = this._getMinimumThumbSize())) {
            n2 = n;
        }
        if ((long)(n3 + n2) > l) {
            n3 = (int)(l - (long)n2);
        }
        if (this._orientation == 0) {
            return new Rectangle(this._barX + n3, 0, n2, this._barHeight);
        }
        return new Rectangle(0, this._barY + n3, this._barWidth, n2);
    }

    private void _repaintChangedThumb() {
        if (this._blockTracking || this._draggingThumb || this._currentButton != null) {
            this.paintImmediate(this._barX, this._barY, this._barWidth, this._barHeight);
        } else {
            this.repaint(this._barX, this._barY, this._barWidth, this._barHeight);
        }
    }

    private synchronized void _setValuesInternal(int n, int n2, int n3, int n4) {
        if (n4 <= n3) {
            n4 = n3 + 1;
        }
        if (n2 > n4 - n3) {
            n2 = n4 - n3;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n < n3) {
            n = n3;
        }
        if (n > n4 - n2) {
            n = n4 - n2;
        }
        this._value = n;
        this._visible = n2;
        this._minimum = n3;
        this._maximum = n4;
    }

    private Dimension _getPreferredSize(int n) {
        this._ensureArrowsCreated();
        Dimension dimension = this._incArrow.getPreferredSize();
        Dimension dimension2 = this._decArrow.getPreferredSize();
        if (this._orientation == 0) {
            dimension.width += dimension2.width + n;
        } else {
            dimension.height += dimension2.height + n;
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _stopRerun() {
        boolean bl;
        Object object = this._executionLock;
        synchronized (object) {
            bl = this._blockRerun;
            this._blockRerun = true;
        }
        if (!bl) {
            this.repaint(this._barX, this._barY, 1, 1);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _allowRerun() {
        Object object = this._executionLock;
        synchronized (object) {
            this._blockRerun = false;
        }
    }

    private boolean _belowThumb(int n, Rectangle rectangle) {
        if (this._orientation == 0) {
            return n < rectangle.x;
        }
        return n < rectangle.y;
    }

    private boolean _aboveThumb(int n, Rectangle rectangle) {
        if (this._orientation == 0) {
            return n > rectangle.x + rectangle.width;
        }
        return n > rectangle.y + rectangle.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _ensureArrowsCreated() {
        if (this._incArrow != null) {
            return;
        }
        LWScrollbar lWScrollbar = this;
        synchronized (lWScrollbar) {
            if (this._incArrow != null) {
                return;
            }
            this._pulser = new Pulser();
            LookAndFeel lookAndFeel = this.getLookAndFeel();
            ContinuousButton continuousButton = new ContinuousButton(this._pulser);
            continuousButton.setLookAndFeel(lookAndFeel);
            continuousButton.addPulsingButtonListener(this._pulser);
            continuousButton.setFocusable(false);
            continuousButton.setEnabled(this.isEnabled());
            continuousButton.setBackground(this.getBackground());
            this._incArrow = continuousButton;
            ContinuousButton continuousButton2 = new ContinuousButton(this._pulser);
            continuousButton2.setLookAndFeel(lookAndFeel);
            continuousButton2.addPulsingButtonListener(this._pulser);
            continuousButton2.setFocusable(false);
            continuousButton2.setEnabled(this.isEnabled());
            continuousButton2.setBackground(this.getBackground());
            this._decArrow = continuousButton2;
            int n = this._orientation;
            this._orientation = 2;
            this.setOrientation(n);
        }
        this.add(this._incArrow);
        this.add(this._decArrow);
    }

    private void _fireAccessValue(int n, int n2) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleValue", IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)n2));
        }
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleValue {
        public Access() {
            super(LWScrollbar.this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return null;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (LWScrollbar.this.__isBusy()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (LWScrollbar.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger((int)LWScrollbar.this.getValue());
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            LWScrollbar.this.setValue(number.intValue());
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger((int)LWScrollbar.this.getMinimum());
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger((int)LWScrollbar.this.getMaximum());
        }
    }

    class Pulser
    implements PulsingButtonListener,
    Task,
    Runnable {
        Pulser() {
        }

        @Override
        public void run() {
            LWScrollbar.this._doPulse();
        }

        @Override
        public void runTask(TaskEvent taskEvent) {
            if (LWScrollbar.this._blockTracking) {
                LWScrollbar.this._doPulse();
                LWScrollbar.this._scheduler.schedule(this, 15);
            }
        }

        @Override
        public void pulseStartPulsing(PulsingButtonEvent pulsingButtonEvent) {
            LWScrollbar.this._currentButton = (ContinuousButton)pulsingButtonEvent.getSource();
            LWScrollbar.this._pulseCount = 0;
            LWScrollbar.this._currentButton.setDelay(200);
        }

        @Override
        public synchronized void pulseEndPulsing(PulsingButtonEvent pulsingButtonEvent) {
            LWScrollbar.this._currentButton = null;
        }
    }
}

