/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import oracle.ewt.lwAWT.LWComponent;

public class NamelessCardLayout
implements LayoutManager2 {
    private static NamelessCardLayout _sNamelessCardLayout;

    public static final LayoutManager2 getLayoutManager() {
        if (_sNamelessCardLayout == null) {
            _sNamelessCardLayout = new NamelessCardLayout();
        }
        return _sNamelessCardLayout;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height <= n3) continue;
            n3 = dimension.height;
        }
        return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getMinimumSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height <= n3) continue;
            n3 = dimension.height;
        }
        return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        Dimension dimension = container.getSize();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            component.setBounds(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flipToComponent(Component component) {
        Container container = component.getParent();
        if (container == null) {
            throw new IllegalArgumentException();
        }
        LWComponent lWComponent = null;
        if (container instanceof LWComponent) {
            lWComponent = (LWComponent)container;
            lWComponent.freezeRepaints();
        }
        try {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component2;
                    component2.setVisible((component2 = container.getComponent(i)) == component);
                }
            }
            container.validate();
        }
        finally {
            if (lWComponent != null) {
                lWComponent.unfreezeRepaints();
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private NamelessCardLayout() {
    }
}

