/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.SystemColor;
import java.util.Locale;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.oracle.OracleColorScheme;

class OracleCustomizableColorScheme
extends OracleColorScheme {
    private static final String DEFAULT_NAME = "Customizable";
    private static final String DEFAULT_DESC = "Oracle Customizable Color Scheme";
    private String mName = "Customizable";
    private String mDesc = "Oracle Customizable Color Scheme";
    private int mDesktopColor = -1;

    public OracleCustomizableColorScheme(int n) {
        super(DEFAULT_NAME, DEFAULT_DESC, SystemColor.control, SystemColor.textHighlight, false, n);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void initializeCommonColors(UIDefaults uIDefaults) {
        super.initializeCommonColors(uIDefaults);
        if (this.mDesktopColor != -1) {
            uIDefaults.put(LookAndFeel.DESKTOP, new Color(this.mDesktopColor));
        }
    }

    public void setName(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("Illegal name for custom color scheme.");
        }
        this.mName = string;
    }

    public String getDescription() {
        return this.mDesc;
    }

    @Override
    public String getDescription(Locale locale) {
        return this.getDescription();
    }

    public int getDesktopColor() {
        return this.mDesktopColor;
    }

    public void setDescription(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Illegal description for custom color scheme.");
        }
        this.mDesc = string;
    }

    public void setDesktopColor(int n) {
        this.mDesktopColor = n;
    }

    @Override
    void __setIntRamp(int[] nArray) {
        if (nArray == null || nArray.length < 9) {
            throw new IllegalArgumentException("Illegal color ramp for custom color scheme.");
        }
        super.__setIntRamp(nArray);
    }
}

