/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.util.InputEventUtils;

public class ComboBoxInputHandler
extends CellInputHandler {
    private static ExtendedCB _combobox;
    static boolean _dirty;
    private String[] _items;

    public void setItems(String[] stringArray) {
        if (this._items != null) {
            for (int i = 0; i < this._items.length; ++i) {
                this._items[i] = null;
            }
        }
        this._items = null;
        if (stringArray != null) {
            this._items = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this._items, 0, stringArray.length);
        }
    }

    public String[] getItems() {
        if (this._items == null) {
            return null;
        }
        String[] stringArray = new String[this._items.length];
        System.arraycopy(this._items, 0, stringArray, 0, this._items.length);
        return stringArray;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        Cell cell = grid.getFocusCell();
        if (cell.column == n && cell.row == n2 && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
        super.mousePressed(mouseEvent, grid, n, n2);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        keyEvent.consume();
        if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\u001b' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            return;
        }
        grid.startCellEdit(n, n2);
    }

    @Override
    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    @Override
    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (_combobox == null) {
            _combobox = new ExtendedCB();
            _combobox.addItemListener(new Dirty());
        }
        return _combobox;
    }

    @Override
    public boolean isDirty(Grid grid, int n, int n2) {
        return _dirty;
    }

    @Override
    public void startEdit(Grid grid, int n, int n2, Object object) {
        ComboBox comboBox = (ComboBox)this.getEditControl(grid, n, n2);
        comboBox.removeAll();
        String string = (String)object;
        if (this._items != null) {
            comboBox.setItems(this._items);
        } else if (string != null) {
            comboBox.addItem(string);
        }
        if (string != null) {
            comboBox.select(string);
        }
        _dirty = false;
    }

    @Override
    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        ComboBox comboBox = (ComboBox)this.getEditControl(grid, n, n2);
        String string = comboBox.getSelectedItem();
        return string;
    }

    private class ExtendedCB
    extends ComboBox
    implements KeyListener {
        public ExtendedCB() {
            this.getLWTextField().addKeyListener(this);
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            this._handleKey(keyEvent);
            super.processKeyEvent(keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this._handleKey(keyEvent);
        }

        private void _handleKey(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401 && this.isDropDownVisible() && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27)) {
                this.hideDropDown(keyEvent.getKeyCode() == 10);
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private static class Dirty
    implements ItemListener {
        private Dirty() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            _dirty = true;
        }
    }
}

