/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.awt.Image;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.dTree.DTreeDeferredParent;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dialog.directory.DirectoryItem;
import oracle.ewt.dialog.directory.DirectoryParentItemFactory;
import oracle.ewt.dialog.directory.DirectoryTree;
import oracle.ewt.dialog.directory.FileDataSource;
import oracle.ewt.dialog.directory.FileUtils;
import oracle.ewt.util.LocaleUtils;

class DirectoryParentItem
extends DTreeDeferredParent
implements DirectoryItem {
    public DirectoryParentItem(FileDataSource fileDataSource) {
        super(fileDataSource);
    }

    @Override
    public File createDirectory(String string) {
        FileDataSource fileDataSource = this.getFileDataSource();
        return fileDataSource.createDirectory(string);
    }

    @Override
    public File getDirectory() {
        DTreeDeferringParent dTreeDeferringParent = this.getDeferringParent();
        return (File)dTreeDeferringParent.getChildData(this.getIndex());
    }

    @Override
    public Image getIcon() {
        DirectoryTree directoryTree = (DirectoryTree)this.getTree();
        if (directoryTree != null) {
            return directoryTree.__getDirectoryIcon();
        }
        return null;
    }

    @Override
    public String getLabel() {
        File file = this.getDirectory();
        return FileUtils.getName(file);
    }

    @Override
    public DTreeItemFactory getItemFactory() {
        return DirectoryParentItemFactory.getInstance();
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public void setExpanded(boolean bl) {
        OneDDataSource oneDDataSource;
        if (bl && (oneDDataSource = this.getDataSource()) instanceof FileDataSource) {
            FileDataSource fileDataSource = (FileDataSource)oneDDataSource;
            fileDataSource.itemExpanding();
        }
        super.setExpanded(bl);
    }

    protected FileDataSource getFileDataSource() {
        OneDDataSource oneDDataSource = this.getDataSource();
        return (FileDataSource)oneDDataSource;
    }

    @Override
    public String getAccessibleType() {
        Locale locale = this.getTree().getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.access.resource.AccessibilityBundle", LocaleUtils.getTranslationLocale(locale));
        return resourceBundle.getString("DIRECTORY_DIALOG.FOLDER");
    }
}

