/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespace;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class CreateDatafileAction
extends ActionDialog {
    private static final String FILE_NAME = "FileName";
    private static final String DIRECTORY = "FileDirectory";
    private static final String TABLESPACE = "Tablespace";
    private static final String FILE_SIZE = "FileSize";
    private static final String REUSE = "Reuse";
    private static final String AUTO_EXTEND = "AutoExtend";
    private static final String INCREMENT = "Increment";
    private static final String UNLIMITED_MAX_SIZE = "UnlimitedMaxSize";
    private static final String MAX_SIZE = "MaxSize";

    protected String getTitle() {
        return DbaNavigatorResources.getString("ADD_DATAFILE_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(TABLESPACE, DbaNavigatorResources.getString("TABLESPACE_LABEL"), this.getDBObject().getObjectName());
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(FILE_NAME, DbaNavigatorResources.getString("FILE_NAME_LABEL"), DbaNavigatorResources.getString("ENTER_VALUE_PROMPT"));
        TextBoxActionControl textBoxActionControl3 = new TextBoxActionControl(DIRECTORY, DbaNavigatorResources.getString("DIRECTORY_LABEL"), DbaNavigatorResources.getString("ENTER_VALUE_PROMPT") + "/");
        FileSizeActionControl fileSizeActionControl = new FileSizeActionControl(FILE_SIZE, DbaNavigatorResources.getString("FILE_SIZE_LABEL"), 102400L);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(REUSE, DbaNavigatorResources.getString("REUSE_LABEL"), false);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(AUTO_EXTEND, DbaNavigatorResources.getString("AUTO_EXTEND_LABEL"), false);
        FileSizeActionControl fileSizeActionControl2 = new FileSizeActionControl(INCREMENT, DbaNavigatorResources.getString("INCREMENT_LABEL"), 102400L);
        final BooleanCheckBoxActionControl booleanCheckBoxActionControl3 = new BooleanCheckBoxActionControl(UNLIMITED_MAX_SIZE, DbaNavigatorResources.getString("UNLIMITED_MAX_SIZE_LABEL"), true);
        FileSizeActionControl fileSizeActionControl3 = new FileSizeActionControl(MAX_SIZE, DbaNavigatorResources.getString("MAX_SIZE_LABEL"), 1024000L);
        textBoxActionControl.enableUI(false);
        booleanCheckBoxActionControl3.enableUI(false);
        fileSizeActionControl2.enableUI(false);
        fileSizeActionControl3.enableUI(false);
        booleanCheckBoxActionControl2.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ActionControl val$autoExtend;
            final /* synthetic */ ActionControl val$increment;
            final /* synthetic */ BooleanCheckBoxActionControl val$unlimitedMaxSize;
            {
                this.val$autoExtend = actionControl;
                this.val$increment = actionControl2;
                this.val$unlimitedMaxSize = booleanCheckBoxActionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = Boolean.parseBoolean(this.val$autoExtend.getValue().get());
                this.val$increment.enableUI(bl);
                this.val$unlimitedMaxSize.enableUI(bl);
            }
        });
        booleanCheckBoxActionControl3.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ActionControl val$maxSize;
            {
                this.val$maxSize = actionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = !Boolean.parseBoolean(booleanCheckBoxActionControl3.getValue().get());
                this.val$maxSize.enableUI(bl);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl3);
        arrayList.add((ActionControl)fileSizeActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        arrayList.add((ActionControl)fileSizeActionControl2);
        arrayList.add((ActionControl)booleanCheckBoxActionControl3);
        arrayList.add((ActionControl)fileSizeActionControl3);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER TABLESPACE \"");
        stringBuffer.append(values.get(TABLESPACE));
        stringBuffer.append("\"\n    ADD DATAFILE '");
        stringBuffer.append(values.get(DIRECTORY));
        stringBuffer.append(values.get(FILE_NAME));
        stringBuffer.append("'\n    SIZE ");
        stringBuffer.append(values.get(FILE_SIZE, "SizeClause"));
        if (Boolean.parseBoolean(values.get(REUSE))) {
            stringBuffer.append("\n    REUSE");
        }
        if (Boolean.parseBoolean(values.get(AUTO_EXTEND))) {
            stringBuffer.append("\n    AUTOEXTEND ON NEXT ");
            stringBuffer.append(values.get(INCREMENT, "SizeClause"));
            stringBuffer.append(" MAXSIZE ");
            if (Boolean.parseBoolean(values.get(UNLIMITED_MAX_SIZE))) {
                stringBuffer.append("UNLIMITED");
            } else {
                stringBuffer.append(values.get(MAX_SIZE, "SizeClause"));
            }
        }
        return stringBuffer.toString();
    }
}

