/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class RelocatePdbAction
extends ActionDialog {
    private static final String PDB_NAME = "PdbName";
    private static final String PARALLEL = "ParallelName";
    private static final String ONLINE = "Online";
    private static final String OPEN = "Open";
    private static final String ROOT = "root";
    private static final String DB_LINK = "dbLink";
    private String link_query;
    private static final String HELP_ID = "f1_dba_relocate_pdbs_html";
    private ActionControl dbLink;
    private String maxParallel;
    private String objType;
    private String objName;
    private String conName;

    protected String getHelpId() {
        return HELP_ID;
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("RELOCATE_PDB");
    }

    private Operation getOperation() {
        if (this.getArgs() != null) {
            return Operation.valueOf(this.getArgs());
        }
        return null;
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.objType = this.getDBObject().getObjectFolderType();
        this.objName = this.getDBObject().getObjectName();
        this.conName = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select SYS_CONTEXT('USERENV', 'CON_NAME') NAME FROM DUAL");
        if (this.objType.equals("APPROOT")) {
            this.switchContainer(connection, this.objName);
            this.link_query = "select db_link from cdb_db_links where CON_ID = (select pdb_id from cdb_pdbs where pdb_name = :APPNAME)";
        } else {
            this.link_query = "select '' from dual union select db_link from dba_db_links";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("APPNAME", this.objName);
        this.maxParallel = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select value FROM v$parameter WHERE name = 'parallel_max_servers'");
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), new String[]{""});
        comboBoxActionControl.setEditable(false);
        this.dbLink = new SqlComboBoxActionControl(DB_LINK, DbaNavigatorResources.getString("RELOCATE_DB_LINK_NAME"), connection, this.link_query, hashMap, "");
        this.dbLink.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ActionControl val$pdbName;
            final /* synthetic */ Connection val$conn;
            {
                this.val$pdbName = actionControl;
                this.val$conn = connection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (((JComboBox)RelocatePdbAction.this.dbLink.getUI()).getSelectedItem().equals("")) {
                    this.val$pdbName.setEditable(false);
                    return;
                }
                this.val$pdbName.setEditable(true);
                JComboBox jComboBox = (JComboBox)this.val$pdbName.getUI();
                jComboBox.removeAllItems();
                jComboBox.addItem("");
                ResultSet resultSet = null;
                if (Connections.getInstance().lock(this.val$conn)) {
                    try {
                        if (RelocatePdbAction.this.objType.equals("APPROOT")) {
                            RelocatePdbAction.this.switchContainer(this.val$conn, RelocatePdbAction.this.objName);
                        }
                        resultSet = DBUtil.getInstance((Connection)this.val$conn).executeQuery("select pdb_name from cdb_pdbs@" + ((JComboBox)RelocatePdbAction.this.dbLink.getUI()).getSelectedItem() + " where pdb_name != 'PDB$SEED' ", (Map)null);
                        if (RelocatePdbAction.this.objType.equals("APPROOT")) {
                            RelocatePdbAction.this.switchContainer(this.val$conn, RelocatePdbAction.this.conName);
                        }
                    }
                    finally {
                        Connections.getInstance().unlock(this.val$conn);
                    }
                }
                if (resultSet != null) {
                    try {
                        while (resultSet.next()) {
                            jComboBox.addItem(resultSet.getString(1));
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        });
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(PARALLEL, DbaNavigatorResources.getString("RELOCATE_PARALLEL") + "  (0-" + this.maxParallel + ")  ", "0");
        ComboBoxActionControl comboBoxActionControl2 = new ComboBoxActionControl(ONLINE, DbaNavigatorResources.getString("RELOCATE_ONLINE"), new String[]{"Normal", "Maximum"}, "Normal");
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(OPEN, DbaNavigatorResources.getString("RELOCATE_OPEN"), false);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(ROOT, DbaNavigatorResources.getString("RELOCATE_ROOT"), false);
        if (this.getOperation() != null) {
            booleanCheckBoxActionControl2.set(true);
        }
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add(this.dbLink);
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)comboBoxActionControl2);
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        if (this.objType.equals("APPROOT")) {
            this.switchContainer(connection, this.conName);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchContainer(Connection connection, String string) {
        if (Connections.getInstance().lock(connection)) {
            try {
                String string2 = "ALTER SESSION SET CONTAINER = ?";
                try (CallableStatement callableStatement = connection.prepareCall(string2);){
                    callableStatement.setString(1, string);
                    callableStatement.execute();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "    ";
        stringBuffer.append("BEGIN\n");
        if (this.objType.equals("APPROOT")) {
            stringBuffer.append("\n" + string + "EXECUTE IMMEDIATE 'ALTER SESSION SET CONTAINER = " + this.objName + "';");
        }
        stringBuffer.append("\n" + string + "EXECUTE IMMEDIATE 'CREATE PLUGGABLE DATABASE ");
        stringBuffer.append(values.get(PDB_NAME));
        if (Boolean.parseBoolean(values.get(ROOT))) {
            stringBuffer.append(" AS APPLICATION CONTAINER");
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(values.get(PDB_NAME));
        stringBuffer.append("@");
        stringBuffer.append(values.get(DB_LINK));
        stringBuffer.append(" RELOCATE ");
        if (values.get(ONLINE).equals("Maximum")) {
            stringBuffer.append("AVAILABILITY MAX ");
        }
        if (Integer.valueOf(values.get(PARALLEL)) > 0 && Integer.valueOf(values.get(PARALLEL)) < Integer.valueOf(this.maxParallel)) {
            stringBuffer.append("PARALLEL " + values.get(PARALLEL));
        }
        stringBuffer.append("';\n");
        if (Boolean.parseBoolean(values.get(OPEN))) {
            stringBuffer.append(string + "EXECUTE IMMEDIATE 'ALTER PLUGGABLE DATABASE " + values.get(PDB_NAME) + " OPEN READ WRITE'; ");
        }
        stringBuffer.append("\nEND;");
        return stringBuffer.toString();
    }

    protected void onCommandComplete() {
    }

    private static enum Operation {
        APPPDB;

    }
}

