/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditLogDeletionPoliciesAction
extends ActionDialog {
    private static final String ARCHIVELOG_DELETION_POLICY = "ARCHIVELOG_DELETION_POLICY";
    private static final String ARCHIVELOG_BACKUP_COUNT = "ARCHIVELOG_BACKUP_COUNT";
    private static final String NONE = DbaNavigatorResources.getString("LOG_DELETION_POLICY_NONE");
    private static final String DELETE_AFTER_BACKUPS = DbaNavigatorResources.getString("LOG_DELETION_POLICY_AFTER_BACKUP");

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_LOG_DELETION_POLICIES_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        TextBoxActionControl textBoxActionControl;
        Object object2;
        String string = null;
        int n = 0;
        if (Connections.getInstance().lock(connection)) {
            block6: {
                object2 = null;
                try {
                    textBoxActionControl = new HashMap();
                    object = DBUtil.getInstance((Connection)connection);
                    object.setRaiseError(true);
                    object2 = object.executeOracleQuery(this.getQuery(connection, "getLogDeletionPolicies"), textBoxActionControl);
                    if (object2 == null) break block6;
                    while (object2.next()) {
                        string = object2.getString(ARCHIVELOG_DELETION_POLICY);
                        n = object2.getInt(ARCHIVELOG_BACKUP_COUNT);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object2);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)object2);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)object2);
            Connections.getInstance().unlock(connection);
        }
        object2 = new ComboBoxActionControl(ARCHIVELOG_DELETION_POLICY, DbaNavigatorResources.getString("DELETION_POLICY_LABEL"), new String[]{NONE, DELETE_AFTER_BACKUPS}, string);
        textBoxActionControl = new TextBoxActionControl(ARCHIVELOG_BACKUP_COUNT, DbaNavigatorResources.getString("ARCHIVELOG_BACKUP_COUNT_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        this.onChangePolicy((ActionControl)object2, (ActionControl)textBoxActionControl);
        object2.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ActionControl val$deletionPolicyCtl;
            final /* synthetic */ ActionControl val$backupCountCtl;
            {
                this.val$deletionPolicyCtl = actionControl;
                this.val$backupCountCtl = actionControl2;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditLogDeletionPoliciesAction.this.onChangePolicy(this.val$deletionPolicyCtl, this.val$backupCountCtl);
            }
        });
        object = new ArrayList();
        ((ArrayList)object).add(object2);
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(new SeperatorActionControl());
        ((ArrayList)object).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return object;
    }

    private void onChangePolicy(ActionControl actionControl, ActionControl actionControl2) {
        String string = actionControl.getValue().get();
        if (string.equals(NONE)) {
            actionControl2.enableUI(false);
        } else {
            actionControl2.enableUI(true);
        }
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = values.get(ARCHIVELOG_DELETION_POLICY);
        int n = Integer.parseInt(values.get(ARCHIVELOG_BACKUP_COUNT));
        stringBuffer.append("CONFIGURE ARCHIVELOG DELETION POLICY TO ");
        if (string.equals(NONE)) {
            stringBuffer.append("NONE");
        } else {
            stringBuffer.append("BACKED UP ");
            stringBuffer.append(n);
            stringBuffer.append(" TIMES TO 'SBT_TAPE'");
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }
}

