/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.pushdpopddirs.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class FileUtils {
    public static Path changeDirectory(ScriptRunnerContext ctx, String dirPath) throws IOException {
        try {
            Optional<Path> path = FileUtils.validatePath(ctx, dirPath);
            if (path.isPresent()) {
                Path validPath = path.get();
                ctx.putProperty("script.runner.cd_command", (Object)validPath.toString());
                ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), validPath.toString());
                return validPath;
            }
        }
        catch (IOException e) {
            throw new IOException("Directory not found or permission denied", e);
        }
        return null;
    }

    public static Optional<Path> validatePath(ScriptRunnerContext ctx, String dirPath) throws IOException {
        Path currentDir;
        Path newPath;
        if (dirPath == null) {
            return Optional.empty();
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            dirPath = dirPath.replace("/", "\\");
        }
        if (!System.getProperty("os.name").startsWith("Windows")) {
            dirPath = dirPath.replace("~", System.getProperty("user.home"));
        }
        if ((newPath = FileUtils.resolveNewPath(currentDir = Paths.get((String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString()), new String[0]), dirPath)) != null && Files.exists(newPath, new LinkOption[0]) && Files.isDirectory(newPath, new LinkOption[0])) {
            return Optional.of(newPath);
        }
        return Optional.empty();
    }

    private static Path resolveNewPath(Path currentDir, String dirPath) throws IOException {
        Path newPath;
        try {
            newPath = currentDir.resolve(dirPath).normalize();
            newPath = newPath.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        return newPath;
    }
}

