/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.rules;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleType;
import oracle.ide.extension.rules.RuleTypeParameter;
import oracle.ide.extension.rules.SimpleRule;

public class RuleTypeVisitor
extends ElementVisitor {
    public static final ElementName RULE_TYPE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "rule-type");
    public static final ElementName SUPPORTED_PARAMETERS_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "supported-parameters");
    public static final ElementName PARAM_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "param");
    public static final String ID_ATTR = "id";
    public static final String NAME_ATTR = "name";
    public static final String REQUIRED_ATTR = "required";
    public static final String CLASS_ATTR = "class";
    private static final String _KEY_RULE_TYPE = "key-ide-extension-rule-type";
    private final ElementVisitor _supportedParamsVisitor = new SupportedParametersVisitor();
    private final ElementVisitor _paramVisitor = new ParamVisitor();

    public void start(ElementStartContext context) {
        String id = this.getAttributeHelper(context, ID_ATTR, true, true);
        String className = this.getAttributeHelper(context, CLASS_ATTR, true, true);
        if (id != null && className != null) {
            Extension extension = (Extension)context.getScopeData().get("extension");
            MetaClass metaClass = new MetaClass(this.getMetaClassLoader((ElementContext)context), className);
            RuleType ruleType = new RuleType(id, (MetaClass<RuleFunction>)metaClass, extension);
            context.getScopeData().put(_KEY_RULE_TYPE, ruleType);
            context.registerChildVisitor(SUPPORTED_PARAMETERS_ELEMENT, this._supportedParamsVisitor);
        }
    }

    public void end(ElementEndContext context) {
        RuleType ruleType = (RuleType)context.getScopeData().get(_KEY_RULE_TYPE);
        if (ruleType != null) {
            RuleEngine engine = RuleEngine.getInstance();
            boolean registered = engine.registerRuleType(ruleType);
            if (registered) {
                SimpleRule rule = new SimpleRule(ruleType.getId(), ruleType.getExtension(), ruleType);
                boolean ruleRegistered = engine.registerRule(rule);
                if (!ruleRegistered) {
                    Rule duplicate = engine.getRule(rule.getId());
                    this.log((ElementContext)context, Level.SEVERE, "Duplicate rule id encountered.  The id '" + rule.getId() + "' is already registered in extension: " + duplicate.getExtension().getID());
                }
            } else {
                RuleType duplicate = engine.getRuleType(ruleType.getId());
                this.log((ElementContext)context, Level.SEVERE, "Duplicate rule-type id encountered.  The id '" + ruleType.getId() + "' is already registered in extension: " + duplicate.getExtension().getID());
            }
        }
    }

    private class SupportedParametersVisitor
    extends ElementVisitor {
        private SupportedParametersVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(PARAM_ELEMENT, RuleTypeVisitor.this._paramVisitor);
        }
    }

    private class ParamVisitor
    extends ElementVisitor {
        private ParamVisitor() {
        }

        public void start(ElementStartContext context) {
            String name = this.getAttributeHelper(context, RuleTypeVisitor.NAME_ATTR, true, true);
            if (name != null) {
                boolean required = false;
                String requiredValue = this.getAttributeHelper(context, RuleTypeVisitor.REQUIRED_ATTR, true, false);
                if ("true".equals(requiredValue)) {
                    required = true;
                }
                RuleTypeParameter param = new RuleTypeParameter(name, required);
                RuleType ruleType = (RuleType)context.getScopeData().get(RuleTypeVisitor._KEY_RULE_TYPE);
                boolean added = ruleType.addSupportedParameter(param);
                if (!added) {
                    this.log((ElementContext)context, Level.SEVERE, "Duplicate parameter name encountered.  A parameter with the name '" + param.getName() + "' is already defined on rule-type: " + ruleType.getId());
                }
            }
        }
    }
}

