/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.spi.LocationAdapter;
import oracle.ideimpl.extension.LayerBuilder;

abstract class LayerVisitor
extends ElementVisitor {
    public static final String XML_ATTR_PREFIX = "A.";
    public static final String POSITION = "position";
    public static final String LOCATION = "location";
    public static final String BUILDER = "layer-builder";
    private static final String SD_FILE_PREFIX = "SD_FILE_";
    private static final String SD_ATTRS_PREFIX = "SD_ATTRS_";
    private ElementName element;
    private LayerVisitor[] children;

    protected LayerVisitor(ElementName element, LayerVisitor ... children) {
        this.element = element;
        this.children = children;
    }

    protected final ElementName getElement() {
        return this.element;
    }

    protected void elementStart(ElementStartContext ctx) {
    }

    public final void start(ElementStartContext ctx) {
        if (this.children != null) {
            for (LayerVisitor v : this.children) {
                ctx.registerChildVisitor(v.getElement(), (ElementVisitor)v);
            }
        }
        this.elementStart(ctx);
    }

    protected void elementEnd(ElementEndContext ctx) {
    }

    protected LocationAdapter getLocationAdapter(ElementContext ctx) {
        LocationAdapter la = (LocationAdapter)ctx.getScopeData().get("xml.locator");
        return (LocationAdapter)ctx.getScopeData().get("xml.locator");
    }

    public final void end(ElementEndContext ctx) {
        this.elementEnd(ctx);
    }

    public LayerBuilder getBuilder(ElementContext ctx) {
        return (LayerBuilder)ctx.getScopeData().get(BUILDER);
    }

    public void createFile(String fid, ElementContext ctx, String fname) {
        LayerBuilder.File f = this.getBuilder(ctx).file(fname);
        ctx.getScopeData().put(SD_FILE_PREFIX + fid, f);
        ctx.getScopeData().put(SD_ATTRS_PREFIX + fid, new LinkedList());
    }

    public void createFolder(String fid, ElementContext ctx, String fname) {
        LayerBuilder.File f = this.getBuilder(ctx).folder(fname);
        ctx.getScopeData().put(SD_FILE_PREFIX + fid, f);
        ctx.getScopeData().put(SD_ATTRS_PREFIX + fid, new LinkedList());
    }

    protected void addAttributes(String fid, ElementStartContext ctx, String ... names) {
        List al = (List)ctx.getScopeData().get(SD_ATTRS_PREFIX + fid);
        for (String name : names) {
            String av = ctx.getAttributeValue(name);
            if (av == null) continue;
            al.add(new Attr(name, av));
        }
    }

    protected void addAttributes(String fid, ElementContext ctx, Attr ... attributes) {
        List al = (List)ctx.getScopeData().get(SD_ATTRS_PREFIX + fid);
        for (Attr attr : attributes) {
            if (attr.value == null && attr.kind != Attr.Kind.INT_VALUE) continue;
            al.add(attr);
        }
    }

    protected void attributeFile(String fid, ElementContext ctx, boolean write) {
        LayerBuilder.File f = (LayerBuilder.File)ctx.getScopeData().get(SD_FILE_PREFIX + fid);
        for (Attr attr : (List)ctx.getScopeData().get(SD_ATTRS_PREFIX + fid)) {
            attr.add(f);
        }
        if (write) {
            f.write();
        }
    }

    static class Attr {
        private Kind kind;
        private String name;
        private String value;
        private int intValue;

        public Attr(String name, String value) {
            this(Kind.STRING_VALUE, name, value);
        }

        public Attr(String name, int value) {
            this.kind = Kind.INT_VALUE;
            this.name = name;
            this.intValue = value;
        }

        public Attr(Kind kind, String name, String value) {
            this.kind = kind;
            this.name = name;
            this.value = value;
        }

        private void add(LayerBuilder.File file) {
            switch (this.kind) {
                case NEW_VALUE: {
                    file.newvalue(this.name, this.value);
                    break;
                }
                case METHOD_VALUE: {
                    file.methodvalue(this.name, this.value);
                    break;
                }
                case INT_VALUE: {
                    file.intvalue(this.name, this.intValue);
                    break;
                }
                case RAW_STRING_VALUE: {
                    file.stringvalue(this.name, this.value);
                    break;
                }
                default: {
                    file.stringvalue(LayerVisitor.XML_ATTR_PREFIX + this.name, this.value);
                }
            }
        }

        public static enum Kind {
            STRING_VALUE,
            NEW_VALUE,
            METHOD_VALUE,
            INT_VALUE,
            RAW_STRING_VALUE;

        }
    }

    static class GenericElementVisitor
    extends LayerVisitor {
        private int i = 0;
        protected String path;
        protected Stack<Integer> dPath = new Stack();
        private Stack<String> nsPath = new Stack();

        GenericElementVisitor(String path) {
            super(null, new LayerVisitor[0]);
            this.path = path;
        }

        @Override
        public void elementStart(ElementStartContext ctx) {
            if (this.dPath.isEmpty()) {
                this.initFolder(ctx);
            }
            ElementName el = ctx.getElementName();
            ++this.i;
            this.dPath.push(this.i);
            String lastURI = this.nsPath.isEmpty() ? null : this.nsPath.peek();
            this.nsPath.push(el.getNamespaceURI());
            String path = this.getPath((ElementContext)ctx);
            LayerBuilder.File fldr = this.getBuilder((ElementContext)ctx).folder(path);
            ctx.getScopeData().put("fldr-" + path, fldr);
            fldr.stringvalue("#T", ctx.getElementName().getLocalName());
            if (lastURI == null || !lastURI.equals(ctx.getElementName().getNamespaceURI())) {
                fldr.stringvalue("#U", ctx.getElementName().getNamespaceURI());
            }
            fldr.intvalue(LayerVisitor.POSITION, this.i);
            fldr.intvalue(LayerVisitor.LOCATION, this.getLocationAdapter((ElementContext)ctx).getLineNumber());
            for (String an : ctx.getAttributeNames()) {
                fldr.stringvalue(LayerVisitor.XML_ATTR_PREFIX + an, ctx.getAttributeValue(an));
            }
        }

        @Override
        public void elementEnd(ElementEndContext ctx) {
            LayerBuilder.File fldr = (LayerBuilder.File)ctx.getScopeData().get("fldr-" + this.getPath((ElementContext)ctx));
            String text = ctx.getText();
            if (text != null) {
                String textTrim = text.trim();
                fldr.stringvalue("#C", textTrim.length() == 0 ? textTrim : text);
            }
            fldr.write();
            this.dPath.pop();
            this.nsPath.pop();
        }

        protected String getPath(ElementContext ctx) {
            StringBuilder sb = new StringBuilder(this.path);
            for (Integer l : this.dPath) {
                sb.append("/" + l);
            }
            return sb.toString();
        }

        protected void initFolder(ElementStartContext ctx) {
        }
    }

    static class GenericElementVisitorFactory
    implements ElementVisitorFactory {
        GenericElementVisitor gev;

        GenericElementVisitorFactory(String path) {
            this.gev = new GenericElementVisitor(path);
        }

        public ElementVisitor getVisitor(ElementName name) {
            return this.gev;
        }
    }
}

